/*
 * Copyright (C) 1989 by The Regents of the University of California.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

/*
 * dl.h - exports for XWIP descriptor lists
 *
 * list elements: 
 *	typedef struct _TYPE {
 *	  struct _TYPE *next;
 *	  int des;
 *	  DATA data;
 *	} TYPE;
 *
 * lists:
 * 	typedef DL TYPEList;
 *
 * functions:
 * 	#define TYPEListCreate(LP) DLCreate(LP, sizeof(TYPE))
 * 	#define TYPEListDestroy DLDestroy
 * 	#define TYPEListAdd DLAdd
 * 	#define TYPEListLookup DLLookup
 * 	#define TYPEListRemove DLRemove
 */

typedef struct _DLHeader {	/* first part of each list element */
  struct _DLHeader *next;
  int des;
  union {
    int key;
    char *ptr;
  } data;
} DLHeader;

typedef struct {		/* points to first element */
  DLHeader *list;
  unsigned size;
  int first;
} DL;

#define DL_Ok		(0)	/* return values */
#define DL_BadValue	(-2)		
#define DL_Error	(-1)	/* some other error */

extern void DLCreate();		/* operations on DLs */
extern void DLDestroy();
extern DLAdd();
extern DLLookup();
extern DLSearch();
extern DLFind();
extern void DLRemove();

/*
 * eof
 */
