/*
 * Copyright (C) 1989 by The Regents of the University of California.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

/*
 * color.c 
 *
 * pxCreateColormap
 * pxDestroyColormap
 * pxMoveToNewColormap
 *
 * pxLoadedColormaps
 * pxLoadColormap
 * pxUnloadColormap
 *
 * pxParseColor
 * pxQueryColor
 * pxGetColors
 *
 * pxRequestColor
 * pxRequestNamedColor
 * pxFreeColors
 *
 * pxAllocColorCells
 * pxAllocColorPlanes
 * pxSetColors
 * pxSetNamedColor
 */

#include <stdio.h>
#include <X11/Xlib.h>

#include "dl.h"
#include "conn.h"
#include "ff.h"

/*
 * pxCreateColormap(+Connection, +Screen, +Visual, +AllocAll, -Colormap, 0)
 *	integer: Connection, Screen , Visual, AllocAll, Colormap
 */
FFInteger
pxCreateColormap(pc, ps, pv, pa, pcm)
     FFInteger pc, ps, pv, pa, *pcm;
{
  PxConnection *pcp;
  PxScreen *psp;
  PxVisual *pvp;

  PX_ErrorInit("xCreateColormap/5");
  *pcm = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;
  if (DLLookup(pxScreenList, (int)ps, (DLHeader **)&psp))
    PX_Error(no_such_screen);
  if (DLLookup(pxVisualList, (int)pv, (DLHeader **)&pvp))
    PX_Error(no_such_visual);

  *pcm = XCreateColormap(pcp->xDisplay, psp->xScreen->root, pvp->xVisual, pa);
  return FF_Ok;
}

/*
 * pxDestroyColormap(+Connection, +Colormap, 0)
 *	integer: Connection, Colormap
 */
FFInteger
pxDestroyColormap(pc, pcm)
     FFInteger pc, pcm;
{
  PxConnection *pcp;

  PX_ErrorInit("xDestroyColormap/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XFreeColormap(pcp->xDisplay, pcm);
  return FF_Ok;
}

/*
 * pxMoveToNewColormap(+Connection, +Current, -New, 0)
 *	integer: Connection, Current, New
 */
FFInteger
pxMoveToNewColormap(pc, pcurr, pn)
     FFInteger pc, pcurr, *pn;
{
  PxConnection *pcp;

  PX_ErrorInit("xMoveToNewColormap/3");
  *pn = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  *pn = XCopyColormapAndFree(pcp->xDisplay, pcurr);
  return FF_Ok;
}

/*
 * pxLoadedColormaps(+Connection, +Screen, -Next, 0)
 *	integer: Connection, Screen, Next
 */
FFInteger
pxLoadedColormaps(pc, ps, pn)
     FFInteger pc, ps, *pn;
{
  PxConnection *pcp;
  PxScreen *psp;

  PX_ErrorInit("xLoadedColormaps/3");
  *pn = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;
  if (DLLookup(pxScreenList, (int)ps, (DLHeader **)&psp))
    PX_Error(no_such_screen);

  pxVector32 = (PxVector32 *)XListInstalledColormaps(pcp->xDisplay,
						     psp->xScreen->root,
						     &pxElements);
  if (pxElements) {
    pxMallocBlock = (char *)pxVector32;
    pxType = PX_Vector32;
    *pn = PX_Cont;
  } else 
    *pn = PX_End;
  return FF_Ok;
}

/*
 * pxLoadColormap(+Connection +Colormap, 0)
 *	integer: Connection, Colormap
 */
FFInteger
pxLoadColormap(pc, pcm)
     FFInteger pc, pcm;
{
  PxConnection *pcp;

  PX_ErrorInit("xLoadColormap/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XInstallColormap(pcp->xDisplay, pcm);
  return FF_Ok;
}

/*
 * pxUnloadColormap(+Connection, +Colormap, 0)
 *	integer: Connection, Colormap
 */
FFInteger
pxUnloadColormap(pc, pcm)
     FFInteger pc, pcm;
{
  PxConnection *pcp;

  PX_ErrorInit("xUnloadColormap/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XUninstallColormap(pcp->xDisplay, pcm);
  return FF_Ok;
}

/*
 * pxParseColor(+Connection, +Colormap, +Specification, -ExactRed, -ExactGreen,
 *	-ExactBlue, 0)
 *
 * 	integer: Connection, Colormap, ExactRed, ExactGreen, ExactBlue
 *	string: Specification
 */
FFInteger
pxParseColor(pc, pcm, ps, per, peg, peb)
     FFInteger pc, pcm, *per, *peg, *peb;
     FFString ps;
{
  PxConnection *pcp;
  XColor exact;

  PX_ErrorInit("xParseColor/4");
  *per = *peg = *peb = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  if (!XParseColor(pcp->xDisplay, pcm, ps, &exact))
    PX_Error("bad specification");
  *per = exact.red;
  *peg = exact.green;
  *peb = exact.blue;
  return FF_Ok;
}

/*
 * pxQueryColor(+Connection, +Colormap, +Name, -ActualRed, -ActualGreen,
 *	-ActualBlue, -ExactRed, -ExactGreen, -ExactBlue, 0)
 *
 *	integer: Connection, Colormap, ActualRed, ActualGreen, ActualBlue,
 *		ExactRed, ExactGreen, ExactBlue
 *	string: Name
 */
FFInteger
pxQueryColor(pc, pcm, pn, par, pag, pab, per, peg, peb)
     FFInteger pc, pcm, *par, *pag, *pab, *per, *peg, *peb;
     FFString pn;
{
  PxConnection *pcp;
  XColor actual, exact;
  
  PX_ErrorInit("xQueryColor/5");
  *par = *pag = *pab = *per = *peg = *peb = PX_Invalid;
  
  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  if (!XLookupColor(pcp->xDisplay, pcm, pn, &actual, &exact))
    PX_Error("no such color");
  *par = actual.red;
  *pag = actual.green;
  *pab = actual.blue;
  *per = exact.red;
  *peg = exact.green;
  *peb = exact.blue;
  return FF_Ok;
}

/*
 * pxGetColors(+Connection, +Colormap, 0)
 *	integer: Connection, Colormap
 */
FFInteger
pxGetColors(pc, pcm)
     FFInteger pc, pcm;
{
  PxConnection *pcp;

  PX_ErrorInit("xGetColors/3");
  
  if (PXLookupConnection(pc, &pcp))
    return PXVectorFree();

  XQueryColors(pcp->xDisplay, pcm, pxMallocBlock, pxElements);
  if (PX_ServerError(pcp))
    return PXVectorFree();
  pxColor = (XColor *)pxMallocBlock;
  return FF_Ok;
}

/*
 * pxRequestColor(+Connection, +Colormap, +Red, +Green, +Blue, -Pixel,
 *	-ActualRed, -ActualGreen, -ActualBlue, 0)
 *
 *	integer: Connection, Colormap, Red, Green, Blue, Pixel, ActualRed, 
 *		ActualGreen, ActualBlue
 */
FFInteger
pxRequestColor(pc, pcm, pr, pg, pb, pp, par, pag, pab)
     FFInteger pc, pcm, pr, pg, pb, *pp, *par, *pag, *pab;
{
  PxConnection *pcp;
  XColor xc;

  PX_ErrorInit("xRequestColor/4");
  *pp = *par = *pag = *pab = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  xc.red = (unsigned short)pr;
  xc.green = (unsigned short)pg;
  xc.blue = (unsigned short)pb;
  if (!XAllocColor(pcp->xDisplay, pcm, &xc))
    return FF_Fail;
  *pp = xc.pixel;
  *par = xc.red;
  *pag = xc.green;
  *pab = xc.blue;
  return FF_Ok;
}

/*
 * pxRequestNamedColor(+Connection, +Colormap, +Name, -Pixel, -ActualRed,
 *	-ActualGreen, -ActualBlue, -ExactRed, -ExactGreen, -ExactBlue, 0)
 *
 *	integer: Connection, Colormap, Pixel, ActualRed, ActualGreen, ActualBlue
 *		ExactRed, ExactGreen, ExactBlue
 *	string: Name
 */
FFInteger
pxRequestNamedColor(pc, pcm, pn, pp, par, pag, pab, per, peg, peb)
     FFInteger pc, pcm, *pp, *par, *pag, *pab, *per, *peg, *peb;
     FFString pn;
{
  PxConnection *pcp;
  XColor exact, actual;

  PX_ErrorInit("xRequestNamedColor/4");
  *pp = *per = *peg = *peb = *par = *pag = *pab = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  if (!XAllocNamedColor(pcp->xDisplay, pcm, pn, &actual, &exact))
    return FF_Fail;
  *pp = actual.pixel;
  *par = actual.red;
  *pag = actual.green;
  *pab = actual.blue;
  *per = exact.red;
  *peg = exact.green;
  *peb = exact.blue;
  return FF_Ok;
}

/*
 * pxFreeColors(+Connection, +Colormap, +PlaneMask, 0)
 *	integer: Connection, Colormap, PlaneMask
 */
FFInteger
pxFreeColors(pc, pcm, ppm)
     FFInteger pc, pcm, ppm;
{
  PxConnection *pcp;

  PX_ErrorInit("xFreeColors/4");
  
  if (PXLookupConnection(pc, &pcp))
    return PXVectorFree();

  XFreeColors(pcp->xDisplay, pcm, pxMallocBlock, pxElements, ppm);
  (void)PXVectorFree();
  return FF_Ok;
}

/*
 * pxAllocColorCells(+Connection, +Colormap, +Contiguous, +Planes, +Colors, 0)
 *	integer: Connection, Colormap, Contiguous, Planes, Colors
 */
FFInteger
pxAllocColorCells(pc, pcm, pcont, pp, pcol)
     FFInteger pc, pcm, pcont, pp, pcol;
{
  PxConnection *pcp;
  unsigned long *pixels = ((unsigned long *)pxMallocBlock) + pp;

  PX_ErrorInit("xAllocColorCells/7");

  if (PXLookupConnection(pc, &pcp))
    return PXVectorFree();

  if (!XAllocColorCells(pcp->xDisplay, pcm, pcont,
			pxMallocBlock, pp, pixels, pcol))
    return PXVectorFree();
  return FF_Ok;
}

/*
 * pxAllocColorPlanes(+Connection, +Colormap, +Contiguous, +Colors, +Reds,
 *	+Greens, +Blues, -RedMask, -GreenMask, -BlueMask, 0)
 *
 *	integer: Connection, Colormap, Contiguous, Colors, Reds, Greens, Blues,
 *		RedMask, GreenMask, BlueMask
 */
FFInteger
pxAllocColorPlanes(pc, pcm, pcont, pcol, pr, pg, pb, prm, pgm, pbm)
     FFInteger pc, pcm, pcont, pcol, pr, pg, pb, *prm, *pgm, *pbm;
{
  PxConnection *pcp;

  PX_ErrorInit("xAllocColorPlanes/11");
  *prm = *pgm = *pbm = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return PXVectorFree();
  
  if (!XAllocColorPlanes(pcp->xDisplay, pcm, pcont, pxMallocBlock,
			 pcol, pr, pg, pb, prm, pgm, pbm))
    return PXVectorFree();
  return FF_Ok;
}

/*
 * pxSetColors(+Connection, +Colormap, 0)
 *	integer: Connection, Colormap
 */
FFInteger
pxSetColors(pc, pcm)
     FFInteger pc, pcm;
{
  PxConnection *pcp;

  PX_ErrorInit("xSetColors/3");
  
  if (PXLookupConnection(pc, &pcp))
    return PXVectorFree();

  XStoreColors(pcp->xDisplay, pcm, pxMallocBlock, pxElements);
  (void)PXVectorFree();
  return FF_Ok;
}

/*
 * pxSetNamedColor(+Connection, +Colormap, +Name, +Pixel, +Flags, 0)
 *	integer: Connection, Colormap, Pixel, Flags
 *	string: Name
 */
FFInteger
pxSetNamedColor(pc, pcm, pn, pp, pf)
     FFInteger pc, pcm, pp, pf;
     FFString pn;
{
  PxConnection *pcp;
  
  PX_ErrorInit("xSetNamedColor/5");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XStoreNamedColor(pcp->xDisplay, pcm, pn, pp, pf);
  return FF_Ok;
}

/* 
 * eof
 */
