;;  $Id: pce-representation.lisp,v 1.3 1993/01/11 16:28:58 anjo Exp $
;;  
;;  File	pce-representation.lisp
;;  Part of	PCE/Lisp interface
;;  Author	Anjo Anjewierden, anjo@swi.psy.uva.nl
;;  Purpose	Definition of PCE/Lisp related structures
;;  Works with	PCE 4.5
;;  
;;  Notice	Copyright (c) 1992  University of Amsterdam
;;  
;;  History	25/02/92  (Created)
;;  		05/01/93  (Last Modified)


;;  ------------------------------------------------------
;;  Directives
;;  ------------------------------------------------------

(in-package "PCE")


(export '(pce-object			; defstruct
	  pce-assoc			; defstruct
	  pce-reference			; defstruct
	  pce-object-id			; Object -> Id
	  pce-special-p			; Object -> t | nil
	  pce-object-p			; Object -> t | nil
	  pce-assoc-p			; Object -> t | nil
	  pce-reference-p		; Object -> t | nil
	  pce-register			; Structure -> Structure
	  pce-unregister		; Structure -> 
	  pce-equal			; Object x Object -> {T | NIL}
	  ))


(defvar *pce-arg1* nil)
(defvar *pce-arg2* nil)
(defvar *pce-arg3* nil)
(defvar *pce-arg4* nil)
(defvar *pce-arg5* nil)
(defvar *pce-arg6* nil)
(defvar *pce-arg7* nil)
(defvar *pce-arg8* nil)
(defvar *pce-arg9* nil)
(defvar *pce-arg10* nil)
(defvar *pce-block* nil)
(defvar *pce-default* nil)
(defvar *pce-event* nil)
(defvar *pce-nil* nil)
(defvar *pce-on* nil)
(defvar *pce-off* nil)
(defvar *pce-receiver* nil)
(defvar *pce-pce* nil)


;;  ------------------------------------------------------
;;  Manual object registration
;;  ------------------------------------------------------

;;! pce-register structure ==> structure
;;
;;  Register ^structure^ (some defstruct) to be corresponding to the id
;;  stored in it.  This allows application defined PCE objects to be
;;  associated with a unique Lisp defstruct.  The defstruct must
;;  include the pce-reference defstruct.  Typical
;;  usage is:
;;<
;;	(defstruct (coloured-object (:include pce-reference))
;;	  colour)
;;>
;;  and then define a function like:
;;<
;;	(defun new-coloured-object (obj colour)
;;	  (pce-register (make-coloured-object
;;			 :id (pce-object-id id)
;;			 :colour colour)))
;;>
;;  to create coloured-objects given a PCE object and register them.
;;  The advantage of having registered objects is that they compare
;;  eq/# and take less memory.
;;
;;  Note that pce-unregister/# must be used when the object is destroyed.

(defun pce-register (structure)
  (pce-send structure :lock-object *pce-on*)	; As from PCE 4.1
  (setf (gethash (pce-object-id structure) *pce-object-refs*) structure))


;;! pce-unregister structure
;;
;;  Removes ^structure^ from the PCE object hash-table.  To be used
;;  after an object is freed.

(defun pce-unregister (structure)
  (remhash (pce-object-id structure) *pce-object-refs*))


;;  pce-make-special id
;;
;;  Initialise the hash-table with all special PCE objects.
;;  Lisp constants are defined for reference in this package.

(defun pce-make-special (id)
  (setf (gethash (intern (string id) "PCE") *pce-object-assocs*)
	(#+LUCID with-static-area
	 #+LISPWORKS system:in-static-area
	 (make-pce-special :id (intern (string id) "PCE")))))


(defun pce-print-object-name-table ()
  (maphash #'(lambda(key value)
	       (format t "~A -> ~A~%" key (pce-object-id value)))
	   *pce-object-assocs*)
  (maphash #'(lambda(key value)
	       (format t "~A -> ~A~%" key (pce-object-id value)))
	   *pce-object-refs*))


;;  ------------------------------------------------------
;;  Equality of objects
;;  ------------------------------------------------------

;;!  pce-equal a b ==> { t | nil }
;;
;;  Succeeds if ^a^ and ^b^ represent the same object.  This is
;;  necessary when the objects are not registered with pce-register/#.

(defun pce-equal (a b)
  (when (and a b)
	(eql (pce-object-id a) (pce-object-id b))))
