;;  $Id: install-lucid.lisp,v 1.2 1993/01/07 10:38:15 anjo Exp $
;;  
;;  File	install-lucid.lisp
;;  Part of	PCE/Lisp interface
;;  Author	Anjo Anjewierden, anjo@swi.psy.uva.nl
;;  Purpose	Installation of PCE/Lisp for Lucid Common Lisp
;;  Works with	PCE 4.5,  SCL 3.0,  SCL 4.0
;;  
;;  Notice	Copyright (c) 1992, 1993  University of Amsterdam
;;  
;;  History	25/02/91  (Created)
;;		24/05/91  (Added PCE Postscript header file)
;;		26/08/91  (Modified for PCE-4)
;;		16/10/91  (Added to *features* for version control)
;;  		05/01/93  (Last Modified)


;;  ------------------------------------------------------
;;  Description
;;  ------------------------------------------------------
;;
;;  This file contains the installation and initialisation functions
;;  specific to Lucid Common Lisp (LCL).  The current interface
;;  between PCE/Lisp does not cooperate with LCL multi-tasking
;;  facilities, so these are turned off.  The only solution to this
;;  problem is that Lucid provides a cleaner interface between LCL and
;;  event-driven applications.  The current implementation uses a
;;  number of "hacks" suggested by Lucid.
;
;;  The following functions are available for PCE/LCL installation.
;
;;  PCE::COMPILE-PCE
;;  	Used to compile the Lisp source files.  This only needs to be
;;      done once.
;;  PCE::INSTALL-PCE
;;  	Generates a PCE/Lisp image.  The file "load.lisp" contains
;;      several Lisp variables that must be customised first.
;;  PCE::FAST-BOOT-PCE
;;      Loads PCE and then runs it.  Only used for PCE/Lisp development.
;;  PCE::DUMMY-BOOT-PCE
;;      Loads PCE only.  Only used for PCE/Lisp development.
;;
;;  A typical sequence would be:
;;
;;  -   Edit the file "load.lisp" and customise for the local environment.
;;      See under "Customisation".
;;  -	Start Lisp.
;;  -	Load the load file, i.e. (load "load").
;;  -	Compile the PCE/Lisp source code, i.e. (pce::compile-pce).
;;  -	Quit Lisp.
;;  -	Start Lisp.
;;  -	Load the load file, i.e. (load "load").
;;  -	Generate the PCE/Lisp image, i.e. (pce::install-pce).
;;  -	Quit Lisp.


;;  ------------------------------------------------------
;;  Directives
;;  ------------------------------------------------------

(in-package "PCE")


;;  ------------------------------------------------------
;;  Loading and initialisation
;;  ------------------------------------------------------

;;! install-pce
;;
;;  Generate a PCE/Lisp image.  First loads the SCL production
;;  compiler, the patches that fix a number of SunView related
;;  bugs and the PCE object code along with the C part of PCE/SCL
;;  interface.  The image is saved in the file specified with
;;  *pce-saved-state* (see file "load.lisp").

(defun install-pce ()
  (load-patches :directory (string-append *host-directory* "patches"))
  (mt-off)                              ; multi-tasking off
  (load-pce)                            ; load PCE image
  (mt-on)                               ; multi-tasking on
  (saved-state-pce *pce-saved-state*))  ; save to disk


;;! fast-boot-pce
;;
;;  Loads the PCE object code and initialises PCE without creating a
;;  saved image.  Only used to test the PCE/Lisp interface.

(defun fast-boot-pce ()
  (mt-off)                              ; multi-tasking off
  (load-pce)                            ; load PCE image
  (init-pce))                           ; initialise PCE


;;! dummy-boot-pce
;;
;;  Loads the PCE object code without creating a saved image.
;;  Used to test initialsation of the PCE/Lisp interface.

(defun dummy-boot-pce ()
  (mt-off)                              ; multi-tasking off
  (load-pce))


(defun compile-pce ()
  (dolist (file *pce-lisp-sources*)
	  (compile-file file)))


(defun load-pce ()
  (let ((old-action *redefinition-action*))
    (setf *redefinition-action* nil)	; redefinition of C-functions
    (load-foreign-files "host-lucid.o")
    (setf *redefinition-action* old-action) ; redefinition of C-functions
    (load-foreign-files *pce-image*)
    (format t "Checking whether all symbols defined are loaded~%")
    (let ((undefined (foreign-undefined-symbol-names)))
      (if (or (equal '("--DYNAMIC") undefined)
	      (null undefined))
	  (format t "... OK!~%")
	(format t "Undefined foreign symbols:~%    ~A~%" undefined)))))


(defun saved-state-pce (name)
  (in-package "USER")
  (use-package "PCE")
  (disksave name
            :restart-function #'init-pce        ; entry point - initialises PCE
            :full-gc t))                        ; get rid of garbage


;;! init-pce
;;
;;  Initialisation of the PCE/Lisp interface.  The only real work
;;  is renaming predefined PCE objects from lower case to upper case,
;;  and associating Lisp variables with ``special'' objects.

(defun init-pce ()
  (initialise-pce)
  (mt-off))
