;;  $Id: demo-programs.lisp,v 1.1 1993/01/07 10:38:07 anjo Exp $
;;  
;;  File	demo-programs.lisp
;;  Part of	PCE/Lisp documentation
;;  Author	Anjo Anjewierden, anjo@swi.psy.uva.nl
;;  Purpose	Source code for demonstration programs
;;  Works with	PCE 4.4,  Lisp
;;  
;;  Notice	Copyright (c) 1992  University of Amsterdam
;;  
;;  History	07/12/92  (Created)
;;  		07/12/92  (Last Modified)


(in-package "USER")


(defun hello-world-1 ()
  (pce-send @display :inform "Hello world!"))


(defun hello-world-2 ()
  (let ((view (pce-view "Hello world example")))
    (pce-send view :open)	    ; Open window on display
    (pce-send view :append "Hello world!")
    view))


(defun hello-world-3 ()
  (let ((pict (pce-picture "Hello world example"))
        (text (pce-text "Hello world!")))
    (pce-send pict :open)	    ; Open window on display
    (pce-send pict :display text (pce-point 100 100))
    pict))


(defun name-and-telephone ()
  (let ((dialog (pce-dialog "Please enter name and phone")))
    (pce-send-list dialog
		   :append
		   (list (pce-text-item :name)
		         (pce-text-item :phone)
			 (pce-button :ok)
			 (pce-button :cancel)))
    (pce-send dialog :open)
    dialog))


(defun ask-name (name)
  (format t "You have entered ``~A'' as your name~%" name)
  t)


(defun name-dialog ()
  (let ((dialog (pce-dialog "Please enter your name"))
	(item (pce-text-item :name "" (pce-funcall 'ask-name @arg1))))
    (pce-send dialog :append item)
    (pce-send dialog :open)
    dialog))


(defun ask-name-2 (dialog name)
  (format t "You have entered ``~A'' as your name~%" name)
  (pce-send dialog :free)
  t)


(defun name-dialog-2 ()
  (let* ((dialog (pce-dialog "Please enter your name"))
	 (item (pce-text-item :name ""
			      (pce-funcall 'ask-name-2 dialog @arg1))))
    (pce-send dialog :append item)
    (pce-send dialog :open)
    dialog))


(defun ask-password ()
  (let* ((dialog (pce-dialog "Please enter name and password"))
	 (name (pce-text-item :name ""))
	 (password (pce-text-item :password ""))
	 (ok (pce-button :ok
	 		 (pce-funcall 'check-password
			       (pce-? name :selection)
			       (pce-? password :selection)))))
    (pce-send-list dialog :append
		   (list name password ok))
    (pce-send dialog :open)))


(defun check-password (login-name password)
  (format t "Validated ``~A'' with password ``~A''~%" login-name password)
  (string= login-name "anjo"))


(defun ask-password-2 ()
  (let* ((dialog (pce-dialog "Please enter name and password"))
	 (name (pce-text-item :name ""))
	 (password (pce-text-item :password ""))
	 (ok (pce-button :ok
		      (pce-block
			       (pce-funcall 'check-password
					(pce-? name :selection)
					(pce-? password :selection))
			       (pce-message dialog :free)))))
    (pce-send-list dialog :append (list name password ok))
    (pce-send dialog :open)
    dialog))


(defpcegetmethod :box :square		; Class and behaviour
  :documentation "Get size of a square" ; Documentation
  :arguments ()				; No arguments
  :returns :int				; Type of return value
  :body '((!get-self :width)))		; Code to execute


(defpcesendmethod :box :square		; Class and behaviour
  :documentation "Set size of a square" ; Documentation
  :arguments '((size :int))		; Argument name and type
  :body '((!send-self :width size)
	  (!send-self :height size)))


(defpceclass :square
  :super :box
  :locals '((:size :int)))


(defpcesendmethod :square :initialise
  :documentation "Create square from a size"
  :arguments '((size :int))
  :body '((!store :size size)
          (!send-super :initialise size size)))
