/************************************************************************
*									*
*			       Ytoolkit					*
*									*
*						April 90 Ze' Paulo Leal	*
*									*
************************************************************************/



:- module(ytoolkit,[
	toolkit_version/2,
	mky/0,

	select_widget_name/2,
	gen_name/1,

	new_widget/3,
	current_widget/3,
	change_widget/3,
	kill_widget/3,

	sub_widget/2,
	set_widget/3,

	add_class/1,
	super_class/1,

	focus/1,
	current_focus/1,
	defocus/0,
	loop/0,
	inner_loop/0,
	exit_loop/0,
	exit_inner_loop/0,	
%	slow_loop/0,
%	slow_exit_loop/0,
%	fast_exit_loop/0,
	refresh/1,
	event_flush/0,
	user_event_flush/0,
	user_event/1,
	wait_for/2,
	send_event/2,

	set_attr/3,
	unset_attr/2,
	get_attr/3,
	call_back/2,			% info 

	set_attr/2,
	unset_attr/1,
	get_attr/2,
	call_back/1,			% info

	redraw/0,
	redraw/1,
	clear_widget/0,
	clear_widget/1,
	draw/1, draw/2,	draw/3,
	undraw/1, undraw/2, undraw/3,
	drawn/2, drawn/3,
%	text_write/1,
%	text_nl/0,			% layout tools

	current_font/2

]).


:- meta_predicate super_class(:).
:- meta_predicate new_widget(?,:,?).
:- meta_predicate 
	draw(:), 	undraw(:), 
	draw(?,:), 	undraw(?,:), 
	draw(?,?,:),	undraw(?,?,:).
:- meta_predicate try(:).


:- ensure_loaded(library(edipo)).
:- engine(Engine), ensure_loaded(library(Engine)).
:- ensure_loaded([
	library(manip),
	library(dispatch),
	library(tools),
	library(utils)]).


toolkit_version(1.1,(93/5/19)).

top(Class) :- new_widget(Class,[],Class), loop.

% ------------------------------------------------------
%							|
%							|
% these predicates where previously defined in other 
% files but had to be moved because file to file 
% compilation does not support multifile declarations
% and they where declared in this file/module as 
% meta_predicates (Yap is so straightforward :-)

super_class(Class:Super) :- '$super_class'(Class:Super).

new_widget(Classes,Attrs,Name) :- '$new_widget'(Classes,Attrs,Name).

draw(T)		:- '$draw'(T).
draw(W,T)	:- '$draw'(W,T).
draw(W,GC,T)	:- '$draw'(W,GC,T).

undraw(T)	:- '$undraw'(T).
undraw(W,T)	:- '$undraw'(W,T).
undraw(W,GC,T)	:- '$undraw'(W,GC,T).

% execute once if defined
try(X) :- X, fail.
try(_).

%							|
%							|
% ------------------------------------------------------


%-----------------------------------------------------------------------


mky :-	
	engine(Eng),
	name(Eng,Chars),
	append("ytoolkit.",Chars,CharsFile),
	name(File,CharsFile),
	(Eng=quintus -> save_program(File); save(File)),
	toolkit_version(Version,Date),
	format('~n[ YToolkit version ~w, last change ~w ]~n~n',[Version,Date]).

