	
:- module(select_menu,[change_select_menu/2]).

/* 
selected:	holds the selected value
items		list of selection menu items
*/

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).
:- ensure_loaded(library('behaviors/editable')).


/* inherit from popup */

:- ensure_loaded(popup).

default(A,B) :- popup:default(A,B).

layout :- popup:layout.

sub_widgets(A) :- popup:sub_widgets(A).

behavior(A,B) :- popup:behavior(A,B).
behavior(A,B) :- editable(A,B).

/* my defs. */

behavior(createNotify,Name) :-
	(get_attr(Name,selected,Label) -> otherwise; Label=''),
	source_module(TM),
	(get_attr(Name,editable,true) ->
		name(Label,SC),	set_line(Name,SC),
		set_attr(Name,callback(F),TM:expand_menu(F,Name))
	;
		set_attr(Name,text,Label)
	),
	popup:layout,
	get_attr(Name,items,L),
	mk_menu(L,Name,Menu),
	set_attr(Name,menu,Menu).

change_select_menu(Name,L) :-
	mk_menu(L,Name,Menu),
	change_menu(Name,Menu).

mk_menu(L,Name,Menu) :-
	source_module(TM),
	mk_menu_list(L,TM,Name,ML),
	Menu=..[menu|ML].


mk_menu_list([],_TM,_Name,[]).
mk_menu_list([Label|R],TM,Name,[item(Label,TM:do_select(Name,Label))|IR]):-
	mk_menu_list(R,TM,Name,IR).


do_select(Name,Label) :-
	set_attr(Name,selected,Label),
	(get_attr(Name,editable,true) ->
		name(Label,SC),	set_line(Name,SC)
	;
		set_attr(Name,text,Label)
	),
	clear_widget(Name),
	popup:layout.


expand_menu([],Name) :-
	get_attr(Name,selected,DelLabel),
	get_attr(Name,items,L),
	delete(L,DelLabel,L1),
	set_attr(Name,items,L1),
	mk_menu(L1,Name,Menu),
	change_menu(Name,Menu).
expand_menu(F,Name) :-
	name(Label,F),
	get_attr(Name,items,L),
	set_attr(Name,items,[Label|L]),
	mk_menu([Label|L],Name,Menu),
	change_menu(Name,Menu).


delete([Label|R],Label,R):- !.
delete([U|R],Label,[U|R1]):- 
	delete(R,Label,R1).
