
:- module(list,[]).
:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).

:- ytoolkit:super_class(list:scrollwindow).


default(item_height,20).

sub_widgets(N) :- make_items(N).

make_items(N) :-
	get_attr(N,back,B),
	get_attr(N,item_height,IH),
	findall(item(I,C),get_attr(N,item(I),C),L),
	mk_items(L,B,1,IH,H,0,W),
	(H>0, W>0 ->
	    change_widget(_,[height=H,width=W],B);
	    change_widget(_,[height=1],B)
	).


mk_items([],_,H,_,H,W,W).
mk_items([item(I,C)|R],P,Y,IH,H,CW,W) :-
	writebox(I,IW,_),
	(IW > CW -> NW=IW; NW=CW),
	new_widget(item,[
    		parent=P,
		x=0,y=Y,height=IH,
		width=10000,		% infinitely wide
		text=I,callback=C
	],_),
	NY is Y+IH,
	mk_items(R,P,NY,IH,H,NW,W).

change_attr(item(I),Name,C) :-
	current_widget(_,[item_height=IH,back=B,height=FH],Name),
	current_widget(_,[height=H],B),
	new_widget(item,[
    		parent=B,
		x=0,y=H,height=IH,
		width=10000,		% infinitely wide
		text=I,callback=C
	],_),
	NH is H+IH,	change_widget(_,[height=NH],B),
	(FH >= NH -> otherwise; NY is FH-NH,change_widget(_,[y=NY],B)).
change_attr(item_height,Name,_) :-
	(current_widget(_,[parent=Name],W),
	kill_widget(_,[],W),
	fail;true),
	make_items(Name).

	    
