


:- module(button,[]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).
:- ensure_loaded(library('behaviors/pressable')).

default(width,80).
default(height,25).
default(border,1).
default(text,text).
default(callback,true).
default(line_width,2).
default(join,bevel). 	% but it doesn't work as it should
default(sep,2).
default(font,F) :- current_font(['9x15bold','*bold*'],F).

layout :- 
	get_attr(sep,S), S2 is S<<1,
	draw(rectangle(S,S,width-S2,height-S2)),
	(get_attr(text,Text) ->
		writebox(Text,W,H),
%draw(using([X is (width-W)/2,Y is (height-H)/2+H],writeterm(X,Y,Text)))
		draw(writeterm((width-W)/2,(height-H)/2+H,Text))

	; true),
	(get_attr(icon,I) ->
		(get_attr(icon_width,IW) -> otherwise; IW=16),
		(get_attr(icon_width,IH) -> otherwise; IH=16),
		draw(using([X is (width-IW)>>1,Y is (height-IH)>>1],
			putimage(I,to_window(0,0,X,Y,IW,IH))))
	; true).

behavior(Event,Window) :- pressable(Event,Window).

change_attr(text,Name,_) :- clear_widget(Name), layout.
change_attr(icon,Name,_) :- clear_widget(Name), layout.
change_attr(sep,Name,_) :- clear_widget(Name), layout.
