


:- module(tests,[
	button_test/0,
	field_test/0,
	scroll_test/0,
	scrollbar_test/0,
	popup_test/0,
	select_test/0,
	showtext_test/0,
	dialog_box_test/0
	]).

:- ensure_loaded(library(ytoolkit)).


%---------------------------------------

popup_test :-
	new_widget(no_class,[],popup_teste),
	new_widget(popup,[
		parent=popup_teste,
		x=10,
		y=10,
%		width=100,
%		height=100,
		text=testing,
		menu=menu(
			item(ola,(write('ola mundo'), nl)),
			item(hello,(write('hello world'), nl)),
			item(':-)  ',(write('/\/\/\'), nl)),
			item(hugh,(write('!?*#@'), nl))
			)
	],_),	
	loop.

button_test :-
	new_widget(no_class,[],button_teste),
	new_widget(button,[parent=button_teste],_),
	new_widget(button,[
		parent=button_teste,
		y=100,
		width=200,
		text='Dont Press This Button',
		callback=ytoolkit:kill_widget(button,[],B)
	],B),
	loop.

%---------------------------------------

field_test :-
	Top=field_teste,
	new_widget(no_class,[width=600,height=420],Top),
	fielf_test_font('9x15',50,Top),
	fielf_test_font('7x13',100,Top),
	fielf_test_font('6x10',150,Top),
	new_widget(scrollwindow,[
		parent=Top
		,x=20
		,y=200
		,width=Top~width-40
		,height=200
	],SW),
	current_widget(_,[back=Back],SW),
	change_widget(field,[],Back),
	loop.


fielf_test_font(Font,Y,P) :-
	new_widget(field,[
		x=20
		,y=Y
		,width=P~width-220
		,font=Font
		,parent=P
		]
	,F),
	new_widget(button,[
		x=P~width-180
		,y=Y
		,parent=P
		,text='Print'
		,callback=(
				field:get_field(F,S)		
				,ytoolkit:draw(P,writestring(10,10,S))
				,ytoolkit:send_event(expose(0),P)
			)
		]
	,_),
	new_widget(button,[
		x=P~width-90
		,y=Y
		,parent=P
		,text='Clear'
		,callback=field:set_field(F,[])
		]
	,_).

%---------------------------------------

scrollbar_test :-
	P = scrollbar_teste,
	new_widget(no_class,[
		bkg_pixmap=["#   ","   #","  # ","   #"]
	],P),
	new_widget(no_class,[
		parent=P
		,x=50
		,y=60
		,width=200
		,height=100
		,border=3
		,px=20
		,py=20
	],Q),
	getimage(yap,from_file('yap.icon')),
	draw(Q,using([],putimage(yap,to_window(0,0,20,20,100,100)))),
	new_widget(scrollbar_y,[
		parent=P
		,x= -1
		,height=P~height-15
		,callback(Pos,Part,Total)=move(py,Q,Pos,Part,Total)
	],_),
	new_widget(scrollbar_x,[
		parent=P
		,x=15
		,y=P~height-15
		,callback(Pos,Part,Total)=move(px,Q,Pos,Part,Total)
	],_),
	loop.

move(py,P,Pos,_Part,Total) :- 
	get_attr(P,px,X),
	Y is Pos/Total*80,
	set_attr(P,py,Y),
	clear_widget(P),
	draw(P,using([],putimage(yap,to_window(0,0,X,Y,100,100)))).
move(px,P,Pos,_Part,Total) :- 
	get_attr(P,py,Y),
	X is Pos/Total*200,
	set_attr(P,px,X),
	clear_widget(P),
	draw(P,using([],putimage(yap,to_window(0,0,X,Y,100,100)))).

%---------------------------------------

scroll_test :-
	P = scrollwindow_teste,
	new_widget(scrollwindow,[back=scr],P),
	change_widget(_,[height=1000],scr),
	draw(scr,frectangle(100,100,100,100)),
	loop.

%---------------------------------------

dialog_box_test :-
	Top=dialog_box_teste,
	new_widget(no_class,[],Top),
	new_widget(button,[
		parent=Top,
		x=50,
		y=10,
		width=100,
		text='Dialog',
		callback=dialog(Top)
	],_),	
	new_widget(button,[
		parent=Top,
		x=200,
		y=10,
		width=100,
		text='Exit',
		callback=ytoolkit:exit_loop
	],_),
	loop.
	
dialog(Top) :-
	new_widget(dialog_box,[
		parent=Top,
		x=10,
		y=100,
		width=Top~width-20,
		height=Top~height-110
	],D),
	new_widget(label,[
		parent=D,
		x=50,
		y=D~height/2,
		width=100,
		text='Waiting...'
	],_),
	new_widget(button,[
		parent=D,
		x=D~width-120,
		y=D~height/2,
		text='Ok',
		callback=ytoolkit:exit_inner_loop
	],_),
	inner_loop,
	kill_widget(_,_,D).	

%---------------------------------------

showtext_test :-
	Top='Show Text Test',
	new_widget(_,[width=400,height=300],Top),
	draw(Top,writeterm(10,30,'Input:')),
	new_widget(field,[parent=Top,
	    x=60,
	    y=10,
	    width=Top~width-70]
	,F),
	focus(F),
	new_widget(showtext,[
	    parent=Top,
	    x=10,
	    y=50,
	    width=Top~width-140,
	    height=Top~height-60,

	    line(2)='hello world',
	    line(1)='hello world again'],

	T),
	new_widget(button,[
	    parent=Top,
	    x=Top~width-120,
	    y=50,
	    width=80,
	    text='Add',
	    callback=add_line(F,T)
	],B1),
	new_widget(button,[
	    parent=Top,
	    x=Top~width-120,
	    y=B1~y+50,
	    width=80,
	    text='First',
	    callback=change_line(F,T)
	],B2),
	new_widget(button,[
	    parent=Top,
	    x=Top~width-120,
	    y=B2~y+50,
	    width=80,
	    text='Font',
	    callback=change_font(F,T)
	],B3),
	new_widget(button,[
	    parent=Top,
	    x=Top~width-120,
	    y=B3~y+50,
	    width=80,
	    text='Quit',
	    callback=ytoolkit:exit_loop
	],_B4),
	loop.

add_line(F,T) :- 
	current_widget(_,[chars=C],F), C \== [],
	change_widget(_,[chars=""],F),
	name(L,C),
	current_widget(_,[lines=N],T),
	M is N+1,
	change_widget(_,[line(M)=L],T).

change_line(F,T) :- 
	current_widget(_,[chars=C],F), C \== [],
	change_widget(_,[chars=""],F),
	name(L,C),
	change_widget(_,[line(1)=L],T).

change_font(F,T) :- 
	current_widget(_,[chars=C],F), C \== [],
	change_widget(_,[chars=""],F),
	name(L,C),
	current_font([L],LL),LL=L,
	change_widget(_,[line_font=L],T).


%---------------------------------------

select_test :-
	Top=select_teste,
	new_widget(no_class,[],Top),
	new_widget(select_menu,[
		parent=Top
		,y=100
		,editable=true
		,selected=oli
		,items=[ola,ole,oli]
	],_),
	loop.

%---------------------------------------

:- format('~n available tests are: ~n~n',[]),
	current_predicate(N,N),
		format('~t?- ~w. ~n',[N]),
	fail; nl.




