
:- module(x_scrollable,[x_scrollable/2]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).

x_scrollable(createNotify,Name) :-
	get_window_attr(Name,width,W),
	set_attr(Name,w,W),
	set_attr(Name,pos,0).
x_scrollable(configureNotify(_,_,W,_,_),Name) :-
	get_attr(Name,w,OW),
	get_attr(Name,pos,Pos0),
	get_attr(Name,part,P),

	Pos is integer(Pos0/OW*W),
	Ew is integer(P*W),

	set_attr(Name,w,W),
	set_attr(Name,pos,Pos),
	clear,
	frectangle(Pos,1,Ew,13).


x_scrollable(expose(0),Name) :-
	get_attr(Name,pos,Pos),
	get_attr(Name,part,P),
	get_attr(Name,w,W),
	Ew is integer(P*W),
	clear,
	frectangle(Pos,1,Ew,13).

x_scrollable(buttonPress(3,_,_),Name) :-
	get_attr(Name,part,P),
	get_attr(Name,pos,Pos0),
	get_attr(Name,w,W),
	Ew is integer(P*W),
	TPos is Pos0+Ew,
	(TPos+Ew<W -> Pos=TPos ; Pos is W-Ew),
	set_attr(Name,pos,Pos),
	clear,
	frectangle(Pos,1,Ew,13),
	call_back(Name,callback(Pos,P,W)).
x_scrollable(buttonPress(2,X,_),Name) :-
	position(Name,X,Pos,P,W),
	call_back(Name,callback(Pos,P,W)).
x_scrollable(buttonPress(1,_,_),Name) :-
	get_attr(Name,part,P),
	get_attr(Name,pos,Pos0),
	get_attr(Name,w,W),
	Ew is integer(P*W),
	TPos is Pos0-Ew,
	(TPos>0 -> Pos=TPos ; Pos=0),
	set_attr(Name,pos,Pos),
	clear,
	frectangle(Pos,1,Ew,13),
	call_back(Name,callback(Pos,P,W)).

x_scrollable(motionNotify(X,Y),Name) :-
	get_attr(Name,moving,true),
	position(Name,X,_,_,_).

x_scrollable(buttonRelease(2,_,_),Name) :-
	unset_attr(Name,moving).

position(Name,X,Pos,P,W) :-
	get_attr(Name,part,P),
	get_attr(Name,w,W),
	Ew is integer(P*W),
	TPos is X-Ew>>1,
	(TPos+Ew=<W, TPos>=0 -> 
		Pos=TPos
	;
		(TPos+Ew>W -> Pos is W-Ew; otherwise),
		(TPos<0 -> Pos=0; otherwise)
	),
	set_attr(Name,pos,Pos),
	clear,
	set_attr(Name,moving,true),
	frectangle(Pos,1,Ew,13).

