/************************************************************************
*									*
*			       Ytoolkit					*
*									*
*						April 90 Ze' Paulo Leal	*
*									*
************************************************************************/



:- module(pressable,[pressable/2]).


:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).


% ---- pressable ---------------------------------------
%							|
%							|
pressable(buttonPress(_,_,_),Name) :-
	\+ get_attr(Name,is_pressed,true),
	set_attr(Name,is_pressed,true),
	window(Name,[bkg_pixel=black]),
	gc(Name,[foreground=white,background=black,function=invert]),
	send_event(expose(0),Name).
pressable(buttonRelease(B,_,_),Name) :-
	get_attr(Name,is_pressed,true),
	set_attr(Name,is_pressed,false),
	(call_back(Name,callback(B)) -> true ; true),
	(call_back(Name,callback) -> true ; true),
	current_window(Name,[]),	% callback can kill me!
	window(Name,[bkg_pixel=white]), 
	gc(Name,[foreground=black,background=white,function=copy]),
	send_event(expose(0),Name).
pressable(leaveNotify,Name) :-
	get_attr(Name,is_pressed,true),
	set_attr(Name,is_pressed,false),
	window(Name,[bkg_pixel=white]),
	gc(Name,[foreground=black,background=white,function=copy]),
	send_event(expose(0),Name).
%							|
%							|
%-------------------------------------------------------
