
:- module(moveable,[moveable/2]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).

/* note * when used with resizeable, moveable must be executed first
		to avoid unpleasent side-efects
ex.
		behavior(A,B) :- moveable(A,B).
		behavior(A,B) :- resizeable(A,B).
*/


moveable(buttonPress(_,PX,PY),Name) :- 
	current_window(Name,[x=OX,y=OY,width=W,height=H]),
	PX >=0, PX<W,
	PY >=0,	PY<H,
	set_attr(Name,'$pos',(OX,OY)),
	while_moving(Name,X,Y,move(Name,PX,PY,X,Y)),
	reconfigure(Name).

move(Name,PX,PY,X,Y) :-
	get_attr(Name,'$pos',(OX,OY)),%	current_window(Name,[x=OX,y=OY]),
	NX is OX + (X-PX), 
	NY is OY + (Y-PY),
	(NX \== OX; NY \== OY),
	window(Name,[x=NX,y=NY]),
	set_attr(Name,'$pos',(NX,NY)).


% :- meta_predicate while_moving(?,?,?,:).

while_moving(W,X,Y,C) :-
	gc('$moving',[function=invert]),
	repeat,
	event(W,E),
	recall(E,X,Y,W,C), !.


recall(motionNotify(X,Y),X,Y,W,Call) :-
	(Call -> otherwise; true),
	wait_for_change(W).
recall(buttonRelease(_,X,Y),X,Y,_W,Call) :-
	(Call -> otherwise; true).



wait_for_change(Name) :- 
	repeat,
	event(W,E),
	wait_for_change(E,W,Name,Status), ! ,
	Status = true.

wait_for_change(configureNotify(_,_,_,_,_),W,W,fail).
wait_for_change(buttonRelease(_,_,_),W,W,true).


reconfigure(Name) :-
	current_window(Name,[x=X,y=Y,width=W,height=H,border=B]),
	send_event(configureNotify(X,Y,W,H,B),Name).

