%-----------------------------------------------------------------------%
%									%
%			Edipo - sicstus/quintus version			%
%									%
%						August 90		%
%						Ze' Paulo Leal		%
%						Universidade do Porto	%
%									%
%-----------------------------------------------------------------------%
%									%
%	file :		edipo.pl					%
%	purpose : 	main file of the edipo package			%
%	creation	90/08/01					%
%	last changes :	93/05/14					%
%	bugs :								%
%	coments :							%
%									%
%-----------------------------------------------------------------------%


/*  to be used with  modules */

:- module(edipo,[
window/2,working_window/1,
current_window/2,
get_window_attr/3,
destroy/0,clear/0,map/0,unmap/0,raise/0,lower/0,
create_mapped/0,create_unmapped/0,
color/0, color_planes/1, color_on/0, color_off/0,
gc/2, working_gc/1,
working_envir/1, working_envir/2,
dup_gc/1,
edipo_attr/2,
event/2,events/2,
do_flush/0, dont_flush/0, flush/0,
line/4,
rectangle/4,	crectangle/4,	frectangle/4,
circle/3,	fcircle/3,	arc/6,	farc/6,
poly/1,		fpoly/1,
bell/1,
writestring/3,	writeterm/3,	writebox/3, stringbox/3,
font_list/2,
engine/1
]). 

:- ensure_loaded([library(callx),
	library(init),
	library(window),
	library(gc),
	library(attr),
	library(draw),
	library(text),
	library(event),
	library(bitmap)]).


% this is an criteria to decide which engine is beeing used.
engine(quintus) :- prolog_flag(quintus_directory,_), !.
engine(sicstus) :- prolog_flag(_,_), !.
engine(yap).


make_edipo :- 
	engine(E),
	(E==quintus ->   
	    save_program('edipo.quintus')
	;
	    save('edipo.sicstus')
	),
	write('Edipo - the uncompleXed interface to X windows'), nl,
	write('Copyright (C) 1991 Centro de Informatica da Universidade do Porto'), nl.
