
:- module(widget,[]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library('behaviors/moveable')).
:- ensure_loaded(library('behaviors/resizeable')).

default(border,2).
default(border_pixmap,["# "," #"]).

/* inherit the hard way */

default(A,B) :- get_attr(super,S), S:default(A,B).

sub_widgets(A) :- get_attr(super,S), S:sub_widgets(A).

layout :- get_attr(super,S), S:layout.

change_attr(A,B,C) :- get_attr(super,S), S:change_attr(A,B,C).

current_attr(A,B,C) :- get_attr(super,S), S:current_attr(A,B,C).


behavior(buttonPress(_,_,_),Name) :-
	change_widget(_,[border_pixel=black],Name),
	current_widget(_,[parent=P],Name),
	(current_widget(_,[selected_widget=S],P), S \== Name -> 
		change_widget(_,[border_pixmap=["# "," #"]],S); true),
	change_widget(_,[selected_widget=Name],P).
	

behavior(A,B) :- moveable(A,B), !.
behavior(A,B) :- resizeable(A,B), !.


behavior(A,B) :- 
%	\+ ytoolkit:user_event(A), 
	get_attr(super,S), 
	S:behavior(A,B).


