%-----------------------------------------------------------------------%
%									%
%		Ydraw: Ytoolkit drawing demo				%
%									%
%									%
%						Feb 91 Ze' Paulo Leal	%
%									%
%-----------------------------------------------------------------------%
%	file: 	  command_yd.yap					%
%	changed:	91/02/22					%
%	bugs: 								%
%									%
%-----------------------------------------------------------------------%

:- module(commands_yb,[]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library('widgets/popup')).

:- add_class(dialog).
:- add_class(dialog_attr).

default(x,3).
default(y,3).
default(width,401).
default(height,H1) :- popup:default(height,H), H1 is H+1.
default(border,1).
default(border_pixel,black).

sub_widgets(Name) :-
	get_attr(Name,paper,B),
	get_attr(Name,top,YD),
	new_widget(popup,[
		parent=YD,
		x=5,
		y=5,
		border=0,
		text='Control',
		menu=menu(
			item(' New',do_ydraw_top_level(YD)),
			item(' Open... ',
				dialog(YD,open_as_ydraw(YD,B,File),File)),
			item(' Revert',open_ydraw(YD,B)),
			item(' Save as... ',
				dialog(YD,save_as_ydraw(YD,B,File),File)),
			item(' Save',save_ydraw(YD,B)),
			item(' Close',kill_widget(_,_,YD)),
			item('_________',true),
			item(' Execute ',
				dialog(YD,exec(YD,CommLine),CommLine)),
%			item(' Quit',ytoolkit:(exit_loop,kill_widget(_,[],YD))),
			item(' Stop',(write('exiting...'),nl,exit_loop))
		)
	],_),
	new_widget(popup,[
		parent=YD,
		x=105,
		y=5,
		border=0,
		text='Edit',
		menu=menu(
			item(' Undo '	,my_undo(B)),
			item(' Delete '	,delete(B)),
			item(' Copy '	,copy(B)),
			item(' Paste '	,paste(B)),
			item(' Delete '	,delete(B)),
			item(' Delete all '	,clear(B))
		)
	],_),
	new_widget(popup,[
		parent=YD,
		x=205,
		y=5,
		border=0,
		text='Font',
		menu=menu(
			item(' 9x15 ',set_font(B,P,1,'9x15')),
			item(' 9x15bold ',set_font(B,P,2,'9x15bold')),
			item(' 8x18 ',set_font(B,P,3,'8x13')),
			item(' 6x13 ',set_font(B,P,4,'6x13'))
		)
	],P),
	toggle_menu_item(P,1),
	new_widget(popup,[
		parent=YD,
		x=305,
		y=5,
		border=0,
		text='Class',
		menu=menu(
			item(' Atributes ',change_widget(YD,B)),
			item(' New Sub-widget ',
				dialog(YD,make_widget(YD,B,Class),Class)),
			item(' Modify Sub-widget ',
			change_sub_widget(YD,B)),
			item(' Remove Sub-widget ',
				remove_sub_widget(YD,B)),
			item(' Define Behavior ',
				change_widget(YD,B))
		)
	],_).

%---------------------------------------%
%					%
%	Command Predicates		%
%					%
%---------------------------------------%

exec(Top,CommLine) :-
	name(CommLine,Chars), term(Goal,Chars,Vars),
	(call(Goal) -> show_vars(Vars,Mess); Mess='No solution'),
	(Mess = [] -> otherwise;
		new_widget(message,[
			parent=Top,
			x=150,
			y=150,
			width=350,
			text=Mess
		],_)
	).

show_vars([],[]).
show_vars([[C|V]|R],[N=V|S]) :- name(N,C), show_vars(R,S).


save_as_ydraw(Top,Paper,FileName) :-
	set_attr(Top,file,FileName),
	save_ydraw(Top,Paper).

save_ydraw(Top,Paper) :-
	(get_attr(Top,file,F) -> 
		tell(F), name(F,FC), file_name(MC,FC,[]), name(Mod,MC),
		write((:-module(Mod,[]))), write(.), nl,nl,
		write((:-ensure_loaded(library(ytoolkit)))), write(.), nl, nl,

		make_defaults(Paper),
		make_layout(Paper),
		make_sub_widget(Paper),
		told
	;
		dialog(Top,save_as_ydraw(Top,Paper,File),File)
	).

make_defaults(Paper) :-
	in(A,[width,height]),
		current_widget(_,[A=V],Paper),
		write(default(A,V)), write(.), nl,
	fail.
make_defaults(_) :- nl.

make_layout(Paper) :-
	write('layout :- '), nl,
	findall(draw(D),recorded(Paper,paper_drawing(D),_),LD),
	put_list(LD,'	'),
	write(.), nl,nl.

make_sub_widget(Paper) :-
	write('sub_widgets(Name) :- '), nl,
	(current_widget(widget,[parent=Paper,super=Class],Name),
		attrs_of_widget(Name,Class,Attr),
		put(9), format('new_widget(~w,[~n',[Class]),
		put(9),put(9), write('parent=Name,'), nl,
		put_list(Attr,'		'), nl,
		put(9),format('],_),~n',[]),
	fail;true),
	put(9), write(true), write(.), nl,nl.
	
attrs_of_widget(Name,Class,Attrs) :-
	findall(A=V,attr_of_wd(Name,Class,A,V),ManyAttrs),
	first(ManyAttrs,[],Attrs).

attr_of_wd(Name,_,A,V) :- CA=[x=_,y=_,width=_,height=_,border=_],
	current_window(Name,CA),
	in(A=V,CA).
attr_of_wd(Name,Class,A,V) :- 
	Class:default(A,D), get_attr(Name,A,V), V \== D.


in(X,[X|_]).
in(X,[_|R]) :- in(X,R).

first([],L,L).
first([A=V|R],SF,AL) :-
	(in(A=_,SF) ->
		first(R,SF,AL)
	;
		first(R,[A=V|SF],AL)
	).

put_list([],T) :- write(T), write(true).
put_list([A|R],T) :- put_rest(R,T), write(T), writeq(A).

put_rest([],_).
put_rest([A|R],T) :- write(T), writeq(A), write(','), nl, put_rest(R,T).



%---------- D.C.G. of file names (to get module names out of them)

file_name(Mod) --> { ! }, start, list_of_dirs, file(Mod).

start --> "/".
start --> "~".
start --> [].

list_of_dirs --> dir, ext,  "/", list_of_dirs.
list_of_dirs --> [].

dir --> char(_), dir.
dir --> [].

file([C|R]) --> char(C), rest(R), ext.

rest([C|R]) --> char(C), rest(R).
rest([]) --> [].

ext --> ".", dir.
ext --> [].

char(C) --> [C], { C>="a", C =< "z" }.
char(C) --> [C], { C>="A", C =< "Z" }.
char(C) --> [C], { C>="0", C =< "9" }.
char(C) --> "_", { C is "_" }.

%----------------------------------------------

open_as_ydraw(Top,Paper,FileName) :-
	set_attr(Top,file,FileName),
	open_ydraw(Top,Paper).

open_ydraw(Top,Paper) :-
	clear(Paper),
	get_attr(Top,file,FileName),
	name(FileName,FC), file_name(MC,FC,[]), name(Mod,MC),
%	ytoolkit:add_class(Mod),
	(see(FileName) ->
		repeat,
			read(T),
			process_pic(T,Mod,Paper),
		T=end_of_file, !,
		seen,
		send_event(expose(0),Paper)
	;
		new_widget(message,[
			parent=Top,
			x=150,
			y=150,
			width=350,
			text='Cannot open file '(FileName)],_)
	).

process_pic(end_of_file,_,_).
process_pic(default(Attr,Val),_,Paper) :- change_widget(_,[Attr=Val],Paper).
process_pic((default(Attr,Val) :- Goal),Module,Paper) :-
	Module:Goal,
	change_widget(_,[Attr=Val],Paper).
process_pic((layout :- Layout),Module,Paper) :- 
	make_pic(Layout,Module,Paper).
process_pic((sub_widgets(Paper) :- Widgets),Module,Paper) :- 
	make_pic(Widgets,Module,Paper).


make_pic(true,_,_) :- !.
make_pic((A,B),Module,Paper) :- !, 
	make_pic(A,Module,Paper), 
	make_pic(B,Module,Paper).
make_pic(draw(D),_,Paper) :- !, recorda(Paper,paper_drawing(D),_).
make_pic(draw(Paper,D),_,Paper) :- !, recorda(Paper,paper_drawing(D),_).
make_pic(new_widget(A,B,C),_Module,_Paper) :- !, 
	new_widget(widget,[super=A|B],C).
make_pic(G,_,_Paper) :- system_predicate(_,G), !,G.
make_pic(G,M,_Paper) :- call((call(M:G) -> true; ytoolkit:G)).
			% current_predicate(_,M:G), M:G.

/* Widget commands */

remove_sub_widget(_Top,Paper) :-
	current_widget(paper,[selected_widget=S],Paper),
	current_widget(_,[super=_Class],S),
	kill_widget(widget,[],S).

change_sub_widget(Top,Paper) :-
	current_widget(paper,[selected_widget=S],Paper),
	current_widget(Class,[],S),
	findall(A=V,get_widget_attr(Class,S,A,V),Fields),
	dialog_attr(Top,Fields,ch_widget(Val,S),Val).

change_widget(Top,Paper) :-
	findall(A=V,get_widget_attr(paper,Paper,A,V),Fields),
	dialog_attr(Top,Fields,ch_widget(Val,Paper),Val).

get_widget_attr(Class,S,A,V) :- 
	Class:default(A,_), get_attr(S,A,V).

make_widget(Top,Paper,Class) :-
	(add_class(Class) -> 
		findall(A=V,Class:default(A,V),Attrs),
		new_widget(widget,[parent=Paper,super=Class|Attrs],New),
		change_widget(_,[selected_widget=New],Paper)
	;
		new_widget(message,[
			parent=Top,
			x=150,
			y=250,
			width=450,
			text='Cannot load class '(Class)],_)
	).

ch_widget(Attrs,Widget) :-
	change_widget(_,Attrs,Widget).

/* edit tools */

my_undo(B) :-
	recorded(B,_Obj,Ref), !,erase(Ref),
	send_event(expose(0),B).

clear(B) :- 
	recorded(B,paper_drawing(_),Ref),
	erase(Ref),
	fail.
clear(B) :- 
	clear_widget(B),
	current_widget(_,[parent=B],W), 
		kill_widget(_,[],W),
	fail;true.

delete(_B) :- 
	current_widget(graph_obj,[],Selected),
	kill_widget(_,[],Selected).
copy(B) :- 
	ClipInfo=[
		x=_,
		y=_,
		parent=_,
		width=_,
		height=_,
		obj=_
		],
	current_widget(graph_obj,ClipInfo,_Selected),
	change_widget(_,[clip_info=ClipInfo],B).
paste(B) :-
	tools_yd:deselect(B),
	current_widget(_,[clip_info=[x=X,y=Y|ClipInfo]],B),
	new_widget(graph_obj,[x=X+10,y=Y+10|ClipInfo],_).





set_font(B,P,N,F) :- 
	current_widget(_,[current_font_item=I],B),
	toggle_menu_item(P,I), \+ I=N,
	toggle_menu_item(P,N),
	change_widget(_,[
		current_font_item=N,
		current_font=F,
		font=F			% to affect writebox/3
	],B),
	(current_widget(field,[],Field) ->
		writebox(1,_,H1), HH is H1+7,
		change_widget(field,[font=F,height=HH],Field)
	;
		otherwise
	).




%---------------------------------------%
%					%
% 		Dialog Boxes		%
%					%
%---------------------------------------%
	
one_field(save_as_ydraw(_,_,_),'Save in File').
one_field(open_as_ydraw(_,_,_),'Open File').
one_field(exec(_,_),'Goal to execute').

one_field(make_widget(_,_,_),'Widget Class').


dialog(Top,Command,Value) :-
	\+ ytoolkit:current_widget(dialog,[parent=Top],_),
	one_field(Command,Text),
	new_widget(dialog,[
		parent=Top,
		x=100,
		y=100,
		text=Text,
		callback(Value)=Command
	],_).


n_fields(_,'Attributes').

dialog_attr(Top,Fields,Command,Value) :-
	n_fields(_,Text),
	new_widget(dialog_attr,[
		parent=Top,
		x=100,
		y=10,
		text=Text,
		fields=Fields,
		callback(Value)=Command
	],_).
