:- (otherwise -> true ; asserta(otherwise)).

/* top level */

:- recorda(color,white).
%:- recorda(level,heuristic).
:- recorda(level,minimax(1)).
:- recorda(execution,repeat_fail).

go :- 
	recorded(color,C),
	recorded(level,A),
	recorded(execution,Exec),
	make_matrix(8,8,T0),
	change_matrix(T0,4,4,white,T1),
	change_matrix(T1,4,5,black,T2),
	change_matrix(T2,5,4,black,T3),
	change_matrix(T3,5,5,white,T4),
	go_exec(Exec,T4,C,A).

go_exec(recursive,T,C,A) :- go_rec(T,C,A).
go_exec(repeat_fail,T,C,A) :- 
	(recorded(table,_,R),erase(R),fail;true), % debugging
	go_repf(T,C,A).

go_rec(T,C,A) :-
	a_move(T,C,A,NT),
	go_rec(NT,C,A).

go_repf(T,C,A) :-
	recorda(table,T,_), 
	recorded(table,PT,R), 
		(a_move(PT,C,A,NT) -> true),
		recordz(table,NT,_), 
		erase(R), 
	fail.



a_move(T,C,A,MT) :-
	show_move(T),
	read_move(I,J),
	(make_move(T,I,J,C,NT) -> 
		otherwise
	; 	
		message('Invalid move'), fail
	),
	show_move(NT),
	message('Tinking ...'),
	other(C,O),
	(choose_position(A,NT,O,MT) ->
		otherwise
	;
		message('no move available')
	).

	
read_move(I,J) :- 
	repeat, 
	write('Your move '),
	read(T),
	(T=abort -> abort; T=(I,J), check(I,J)).

check(I,J) :- 
	(	(integer(I), 1=<I, I=<8, integer(J), 1=<J, J=<8) ->
		otherwise
	;
 		message('Wrong syntax'), 
		message('	enter "LINE, COLUMN."  to make a move'),
		message('	or "abort." to exit.'),
		fail
	).

show_move(T) :-	
	vspace(7), 
	show_matrix(T),
	static_evaluation(T,V,B,P),
	nl, Diff is B-P,
	write((static_value=V,white=B,black=P,diff=Diff)), 
	vspace(7).
	

message(M) :- write(M), nl.

vspace(N) :- (N=0 -> true; nl, M is N-1, vspace(M)).


/*** reversi operations ***/


choose_position(naive,T,C,NT) :- choose_naive(T,C,NT).
choose_position(heuristic,T,C,NT) :- choose_heuristic(T,C,NT).
choose_position(minimax(L),T,C,NT) :- choose_minimax(T,L,C,NT).

% generation of new positions using minimax (without alfa-beta)

choose_minimax(T,L,C,NT) :-
	gen_ord_pos(T,C,[(FV,_,FT)|R]),
	(C=white -> 
		min(FT,FV,L,V),
		max(R,L,FT,V,NT)
	;
		max(FT,FV,L,V),
		min(R,L,FT,V,NT)
	).


min(VT,V,L,M) :-
	(L=0 -> 
		M=V
	;
		K is L-1,
		gen_ord_pos(VT,white,[(GV,_,GT)|R]),
		max(GT,GV,K,VV),
		min(R,K,G,VV,M)
	).

max([],_,M,_,M).
max([(FV,_,FT)|R],L,GT,GV,M) :-
	min(FT,FV,L,V),
	(V @> GV ->
		max(R,L,FT,V,M)
	;
		max(R,L,GT,GV,M)
	).
		

max(VT,V,L,M) :-
	(L=0 -> 
		M=V
	;
		K is L-1,
		gen_ord_pos(VT,black,[(GV,_,GT)|R]),
		min(GT,GV,K,VV),
		max(R,K,GT,VV,M)
	).

min([],_,M,_,M).
min([(FV,_,FT)|R],L,GT,GV,M) :-
	max(FT,FV,L,V),
	(V @< GV ->
		min(R,L,FT,V,M)
	;
		min(R,L,GT,GV,M)
	).




% generation of new positions using heuristic (best static evaluation)

choose_heuristic(T,C,NT) :-
	gen_ord_pos(VT,C,[(_,_,NT)|_]).

gen_ord_pos(T,C,SE) :-
	gen_positions(T,C,L),
	eval_positions(L,EL),
	sort(EL,ASE),
	(C=black -> SE=ASE; reverse(ASE,SE,[])).

reverse([],L,L).
reverse([H|T],R,D) :-
	reverse(T,R,[H|D]).

eval_positions([],[]).
eval_positions([E|R],[(V,D,E)|VR]) :-
	static_evaluation(E,V,B,P), D is B-P,
	eval_positions(R,VR).

% naive generation of new positions (pick randomly a valid move)

choose_naive(T,C,NT) :-
	gen_positions(T,C,L),
	choose(L,NT).
	
%choose(L,C) :- len(L,N), K is integer(random*N+1),	nth(K,L,C).
choose(L,C) :- 
	len(L,N), 
	my_random(R),
	K is floor(R*N+1),	
	nth(K,L,C).

my_random(MR) :- 
	call((R is random, 
	(R>0 -> A=R ;A is -R), 
	F is floor(A),
	MR is (F mod 100)/100 )).

len([],0).
len([_|R],M) :- len(R,N), M is N+1.

nth(N,[E|R],S) :- (N=1 -> S=E; M is N-1, nth(M,R,S)).


gen_positions(Tab,C,L) :-
	findall(T,(gen(I),gen(J),make_move(Tab,I,J,C,T)),L).

gen(1).
gen(I) :- gen(J), I is J+1, (J<8 -> otherwise; !, fail).


% validation of moves and creation of a new table from T 
% with a pice of color C in the position (I,J)

make_move(T,I,J,C,NT) :- 
	matrix(T,I,J,empty),
	findall(dir(DI,DJ,LI,LJ),dir(DI,DJ,LI,LJ),LD),
	move_all_dir(LD,T,I,J,C,WT,CC),
	CC\=0,
	change_matrix(WT,I,J,C,NT).

move_all_dir([],T,_,_,_,T,0).
move_all_dir([dir(DI,DJ,LI,LJ)|R],T,I,J,C,NT,CC) :-
	(move_dir(DI,DJ,LI,LJ,T,I,J,C,WT,C1) -> 
		otherwise
	;
		C1=0,
		WT=T
	),
	move_all_dir(R,WT,I,J,C,NT,C2),
	CC is C1+C2.
	
move_dir(DI,DJ,LI,LJ,T,I,J,C,NT,CC) :-
	NI is I+DI, NI\=LI,
	NJ is J+DJ, NJ\=LJ,
	matrix(T,NI,NJ,P),
	(P=C -> NT=T, CC=0
	;
		P \= empty,
		change_matrix(T,NI,NJ,C,WT),
		move_dir(DI,DJ,LI,LJ,WT,NI,NJ,C,NT,CD),
		CC is CD+1
	).

dir(-1,-1,0,0).	dir(-1,0,0,9).	dir(-1,1,0,9).
dir( 0,-1,9,0).			dir( 0,1,9,0).
dir( 1,-1,9,0).	dir( 1,0,9,9).	dir( 1,1,9,9).

other(black,white).
other(white,black).


% static evaluation V of a position T
% being B yhe number of white pieces and P the number of black pieces.

static_evaluation(T,V,B,P) :- static_evaluation(T,1,V,B,P).

static_evaluation([],_I,0,0,0).
static_evaluation([R|C],I,V,B,P) :- 
	static_evaluation(R,I,1,RV,RB,RP),
	NI is I+1,
	static_evaluation(C,NI,CV,CB,CP),
	V is RV+CV,
	B is RB+CB,
	P is RP+CP.

static_evaluation([],_I,_J,0,0,0).
static_evaluation([E|C],I,J,V,B,P) :- 
	piece_value(E,EV,EB,EP),
	pos_value(I,J,PV),
	NJ is J+1,
	static_evaluation(C,I,NJ,CV,CB,CP),
	V is CV+EV*PV,
	B is EB+CB,
	P is EP+CP.

piece_value(empty, 0,0,0).
piece_value(black,-1,0,1).
piece_value(white, 1,1,0).

pos_value(I,J,PV) :-
	(I<5 -> LI=I; LI is 9-I),
	(J<5 -> LJ=J; LJ is 9-J),
	(LI<LJ -> M=LI ; M=LJ),
	level_value(M,MV,DV),
	(LI=LJ -> PV=DV; PV=MV).

level_value(1,8,10).
level_value(2,2,1).
level_value(3,4,6).
level_value(4,3,3).


/*** matrix operations ***/

make_matrix(I,J,T) :- 
	(I=0 -> T=[]
	;
		T=[R|C],
		make_matrix(J,R),
		NI is I-1,
		make_matrix(NI,J,C)
	).
make_matrix(J,T) :- 
	(J=0 -> T=[]
	;
		T=[ empty |C],
		NJ is J-1,
		make_matrix(NJ,C)
	).


show_matrix([C|R]) :- 
	show_columns(C),
	show_matrix([C|R],1),
	show_columns(C).

show_columns(R) :- tab(21), show_columns(R,1).

show_columns([],_) :- nl.
show_columns([_|R],I) :- 
	tab(1), write(I),
	NI is I+1,
	show_columns(R,NI).

show_matrix([],_).
show_matrix([E|T],I) :- 
	tab(20),
	write(I),
	show_matrix_line(E),
	write(I), nl,
	NI is I+1,
	show_matrix(T,NI).
show_matrix_line([]) :- write('|').
show_matrix_line([E|T]) :- write('|'), show(E), show_matrix_line(T).

show(empty) :- write(.).
show(white) :- write(o).
show(black) :- write(x).


matrix([E|T],I,J,P) :- (I=1 -> matrix(E,J,P) ; NI is I-1, matrix(T,NI,J,P)).
matrix([E|T],J,P) :- (J=1 -> P=E ; NJ is J-1, matrix(T,NJ,P)).


change_matrix([E|T],I,J,P,[NE|NT]) :- 
	(I=1 -> 
		change_matrix(E,J,P,NE),
		NT=T
	; 	
		NE=E,
		NI is I-1, 
		change_matrix(T,NI,J,P,NT)
	).
change_matrix([E|T],J,P,[NE|NT]) :- 
	(J=1 -> 
		NE=P,
		NT=T
	; 	
		NE=E,
		NJ is J-1, 
		change_matrix(T,NJ,P,NT)
	).


