
:- module(message,[]).

:- ensure_loaded(library(ytoolkit)).

:- add_class(label).
:- add_class(button).

:- ytoolkit:super_class(message:dialog_box).

default(width,300).
default(height,100).
default(font,Font) :-
	current_font([
			'9x15',
			'-*-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*',
			'*15*'],Font).



sub_widgets(Self) :-
	get_attr(Self,message,M),
	draw(writeterm(20,50,M)),
	new_widget(label,[
    		parent=Self,
		x=20,
		y=20,
		width=Self~width-40,
		text=M
	    ],_),
	W=80,
	new_widget(button,[
		parent=Self
		,x=(Self~width-W)/2
		,y=60
	     	,width=W
		,text='Ok'
		,callback=cont(Self)
		],_).	

% callback

cont(Self) :- kill_widget(_,[],Self).
