
:- ensure_loaded(library(edipo)).

:- write('try this 		?-flags. '), nl.


flags :-
	all_flags,
	flags_help,
	redraw_flags.		% interaction


flag(C) :- flag(C,[]).

all_flags :- 
	window(flags,[width=600,bkg_pixel=antiqueWhite]),
% 1. line
	flag(portugal,	[x=10, 	y=10,parent=flags]),
	flag(spain,	[x=210,	y=10,parent=flags]),
	flag(france,	[x=410,	y=10,parent=flags]),
% 2. line
	flag(germany,	[x=10, 	y=160,parent=flags]),
	flag(uk,	[x=210,	y=160,parent=flags]),
	flag(eec,	[x=410,	y=160,parent=flags]).


redraw_flags :-
	repeat,
	event(Flag,Event),
	process(Event,Flag),
	fail.
process(expose(0),help) :- show_help.
process(expose(0),Flag) :- flag(Flag).
process(buttonPress(_,_,_),help) :- !, abort.
process(buttonPress(_,_,_),Flag) :-
	window(Flag,[]), clear,
	gc(black,[foreground=black,font='9x15']),
	writebox(Flag,W,H),
	X is (150-W)>>1,
	Y is (100+H)>>1,
	writeterm(X,Y,Flag).
process(buttonRelease(_,_,_),Flag) :- flag(Flag).

/* flags */



flag(portugal,A) :- 
	my_flag(portugal,A),
	gc(red,[foreground=green]), 	frectangle(0,0,60,100),
	gc(red,[foreground=red]), 	frectangle(60,0,90,100),
	gc(yellow,[foreground=yellow,line_width=3]), 
	circle(60,50,20).
	


flag(germany,A) :-
	my_flag(germany,A),
	gc(red,[foreground=black]), 	frectangle(0,0,150,33),
	gc(red,[foreground=red]),	frectangle(0,33,150,33),
	gc(red,[foreground=yellow]), 	frectangle(0,67,150,33).


flag(france,A) :-
	my_flag(france,A),
	gc(red,[foreground=blue]),	frectangle(0,0,50,100),
	gc(red,[foreground=white]),	frectangle(50,0,50,100),
	gc(red,[foreground=red]),	frectangle(100,0,50,100).

flag(spain,A) :-
	my_flag(spain,A),
	gc(red,[foreground=red]),	frectangle(0,0,50,100),
	gc(red,[foreground=yellow]),	frectangle(50,0,50,100),
	gc(red,[foreground=red]),	frectangle(100,0,50,100).


flag(uk,A) :-
	my_flag(uk,A),
	gc(blue,[foreground=blue]),	frectangle(0,0,150,100),
	gc(white,[foreground=white,line_width=13]),
	cross,
	gc(red,[foreground=red,line_width=5]),
	cross.

flag(eec,A) :-
	my_flag(eec,A),
	gc(blue,[foreground=blue]),	frectangle(0,0,150,100),
	gc(yellow,[foreground=yellow,fill_rule=winding]), 
	pi(PI),
	B is 2*PI/12, n_stars(12,35,0,B).
/*
flag(,A) :-
	my_flag(brasil,A),
	gc(blue,[foreground=green]),	frectangle(0,0,150,100),
	gc(yellow,[foreground=yellow]),	fpoly([20+50,75+10,130+50,75+90]),
	gc(yellow,[foreground=blue]),	my_circle(75,50,30).
*/

cross :-
	line(0,50,150,50),
	line(75,0,75,100),
	line(0,0,150,100),
	line(0,100,150,0).

my_circle(X,Y,R) :-
	XB is X-R,
	YB is Y-R,
	W  is 2*R,
	H  is 2*R,
	A is 360*64,
	farc(XB,YB,W,H,0,A).

n_stars(0,_,_,_) :- !.
n_stars(N,L,D,A) :-
	S=15,
	cos(D,CD),
	X is 75-(S/2)+L*CD,
	sin(D,SD),
	Y is 50+L*SD,
	star(X,Y,5,S),
	DD is D+A,
	M is N-1,
	n_stars(M,L,DD,A).


my_flag(Name,A) :- current_window(Name,[]), !, window(Name,A).
my_flag(Name,A) :- window(Name,[width=150,height=100|A]),
		repeat,
		event(Name,visibilityNotify(unobscured)), !.


/* shapes */

pi(3.14159).

star(X,Y,N,S) :-
	pi(PI),
	A is 4*PI/N,
	do_poly(N,X,Y,0,A,S,L),
	fpoly(L).

reg_poly(X,Y,N,S) :-
	pi(PI),
	A is 2*PI/N,
	do_poly(N,X,Y,0,A,S,L),
	fpoly(L).

do_poly(0,_,_,_,_,_,[]) :- !.
do_poly(N,X,Y,D,A,S,[(IX,IY)|R]) :-
	IX is integer(X),
	IY is integer(Y),
	cos(D,CD),
	XX is X+S*CD,
	sin(D,SD),
	YY is Y+S*SD,
	DD is D+A,
	M is N-1,
	do_poly(M,XX,YY,DD,A,S,R).


/* help */

flags_help :-
	current_window(help,[]), !, window(help,[]).
flags_help :-
	window(help,[width=400,height=200]),
	repeat,
	event(help,visibilityNotify(unobscured)), !,
	show_help.


show_help:-
	window(help,[]),
	has_color(R),
	show_help([
' Some EEC flags ',
' ',
'   Click on a flag to see the country name',
'   Click on this window to return to Prolog top level'
| R ]).

has_color(M) :-
	(color -> M=[];
	    M = ['       You do not have a color screen ',
	    '       so colors are approximated to black and white']
	).

:- (edipo:engine(quintus) -> 
	ensure_loaded(library(math))
    ;
	asserta((cos(X,Y) :- Y is cos(X))),
	asserta((sin(X,Y) :- Y is sin(X)))
    ).



show_help(L) :- 
	SEP=10,
	writebox(' ',_,CH), 
	H is CH+SEP, 
	show_help(L,H,H).

show_help([],_,_).
show_help([W|R],Y,H) :-
	writeterm(10,Y,W),
	NY is Y+H,
	show_help(R,NY,H).
