
:- module(label,[]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).

default(width,80).
default(height,35).
default(text,text).
default(align,center).	% { center, left, right }
default(font,F) :-  current_font(['9x15','*15*'],F).

layout :- 
	get_attr(text,Text),
	writebox(Text,W,H),
	get_attr(align,Al),
	draw_align(Al,Text,W,H).

draw_align(left,Text,_,H)  :-
	draw(writeterm(0,(height-H)/2+H,Text)).
draw_align(center,Text,W,H)  :-
	draw(writeterm((width-W)/2,(height-H)/2+H,Text)).
draw_align(right,Text,W,H)  :-
	draw(writeterm((width-W),(height-H)/2+H,Text)).

change_attr(text,Name,_) :- clear_widget(Name), layout.
change_attr(align,Name,_) :- clear_widget(Name), layout.
