
:- module(resizeable,[resizeable/2]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).

/* note * when used with moveable, resizeable must be executed first
		to avoid unpleasent side-efects
ex.
		behavior(A,B) :- moveable(A,B).
		behavior(A,B) :- resizeable(A,B).
*/


resizeable(buttonPress(_,PX,PY),Name) :-
	current_window(Name,[x=OX,y=OY,width=OW,height=OH,border=B]),
	(PX<0 -> Type=x;
	(PY<0 -> Type=y;
	(PX>=OW -> Type=width;
	(PY>=OH -> Type=height)))),
	set_attr(Name,moves,0),	
	set_attr(Name,'$pos',(OX,OY,OW,OH)),
	while_moving(Name,X,Y,resize(Type,Name,PX,PY,X,Y,B)),
	reconfigure(Name).

resize(x,Name,PX,_,X,_,_B) :-
	get_attr(Name,'$pos',(OX,OY,OW,OH)),
	NX is OX + (X-PX), 
	NW is OW - (X-PX), NW > 0,
	(NX \== OX; NW \== OW),
	window(Name,[x=NX,width=NW]),
	set_attr(Name,'$pos',(NX,OY,NW,OH)),
	wait_for(Name,configureNotify(_,_,_,_,_)).
resize(y,Name,_,PY,_,Y,_B) :-
	get_attr(Name,'$pos',(OX,OY,OW,OH)),
	NY is OY + (Y-PY),
	NH is OH - (Y-PY), NH > 0,
	(NY \== OY; NH \== OH),
	window(Name,[y=NY,height=NH]),
	set_attr(Name,'$pos',(OX,NY,OW,NH)),
	wait_for(Name,configureNotify(_,_,_,_,_)).
resize(width,Name,_,_,X,_,B) :-
	W is X-B<<1, W > 0,
	window(Name,[width=W]).
resize(height,Name,_,_,_,Y,B) :-
	H is Y-B<<1, H > 0,
	window(Name,[height=H]).



% :- meta_predicate while_moving(?,?,?,:).

while_moving(W,X,Y,C) :-
	gc('$moving',[function=invert]),
	repeat,
	event(W,E),
	recall(E,X,Y,C), !.


recall(motionNotify(X,Y),X,Y,Call) :-
	Call, fail.
recall(buttonRelease(_,X,Y),X,Y,Call) :-
	(Call -> otherwise; true).


reconfigure(Name) :-
	current_window(Name,[x=X,y=Y,width=W,height=H,border=B]),
	send_event(configureNotify(X,Y,W,H,B),Name).
