




:- module(editable,[editable/2,get_line/2, get_line/3,set_line/2,set_line/3]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).



% ---- editable ---------------------------------------
%							|
%							|

editable(createNotify,Name) :- 	
	writebox('A',CW,CH),
	set_attr(Name,char_size,CW+CH),
	(get_attr(Name,chars,D) ->
	    set_line(Name,D), unset_attr(Name,chars)
	    ;
	    set_attr(Name,line(1),line(A,A,V,V,CW))
	),
	dup_gc(reverse),
	gc(reverse,[foreground=white,background=black]).
editable(expose(0),Name) :- redraw_field(Name).
editable(buttonPress(_,X,Y),Name) :-
	set_attr(Name,selecting,true),
	get_attr(Name,char_size,CW+CH),
	get_attr(Name,line(O),OL), !,
	N is (Y // (CH+3))+1,
	P is X - X mod CW,
	get_attr(Name,line(N),line(L,J,J,[],_)),
	write_line(O,OL,CW,CH),
	(open_line(L,P,CW,A,B,C,D) -> 
		set_attr(Name,line(N),line(A,B,C,D,P)),
		clear_line(Name,N,CH),
		write_edit_line(N,A,B,C,D,P,CW,CH)
	;
		get_attr(Name,line(N),line(A,B,C,D,_)),		
		set_attr(Name,line(N),line(A,B,C,D,_)),		
		(X>CH -> end_line(Name); start_line(Name))
	).
editable(buttonRelease(_,X,_),Name) :-
	unset_attr(Name,selecting),
	get_attr(Name,char_size,CW+CH),
	P is X - X mod CW,
	(get_attr(Name,line(N),line(A,B,C,D,OP)) -> otherwise; true),
	(P > OP ->
		L=C,D=[],S=OP,
		open_line(L,P,CW,E,F,_,_)
	;
		L=A,B=[],S=P,
		open_line(L,P,CW,_,_,E,F)
	),
	set_attr('$editable','$ring',ring(E,F)),
	set_attr(Name,selected,selected(E,F,S)),
	write_edit_line(N,A,B,C,D,P,CW,CH),
	write_selected(N,E,F,S,CW,CH).
editable(motionNotify(X,_),Name) :-
	get_attr(Name,selecting,true),
	get_attr(Name,char_size,CW+CH),
	P is X - X mod CW,
%	get_attr(Name,line(N),line(A,B,L,[],OP)),
	(get_attr(Name,line(N),line(A,B,C,D,OP))-> otherwise; true),
	(P > OP ->
		L=C,D=[],
		(open_line(L,P,CW,E,F,_,_)-> otherwise; E=L),
		S=OP
	;
		L=A,B=[],
		open_line(L,P,CW,_,_,E,F),
		S=P
	),
	(get_attr(Name,line(N),line(TA,TB,TC,TD,Q)) -> otherwise; true),
	write_edit_line(N,TA,TB,TC,TD,Q,CW,CH),
	write_selected(N,E,F,S,CW,CH).
editable(leaveNotify,Name) :-
	get_attr(Name,char_size,CW+CH),
	(get_attr(Name,line(N),line(A,B,C,D,P)) -> otherwise; true),
	clear_line(Name,N,CH),
	write_edit_line0(N,A,B,C,D,P,CW,CH).
editable(enterNotify,Name) :-
	get_attr(Name,char_size,CW+CH),
	(get_attr(Name,line(N),line(A,B,C,D,P)) -> otherwise; true),
	clear_line(Name,N,CH),
	write_edit_line(N,A,B,C,D,P,CW,CH).


editable(keyPress([K],K,_,_),Name) :- !,
	get_attr(Name,char_size,CW+CH),
	(get_attr(Name,line(N),line(A,[K|B],C,D,P)) -> otherwise; true),
	Q is P+CW,
	set_attr(Name,line(N),line(A,B,C,D,Q)),
	write_edit_line(N,A,B,C,D,Q,CW,CH).
editable(keyPress([K],_,_,_),Name) :- !,
	command_key(K,Name,Command),
	Command.

%
%	COMMANDS
%

keys :- 
	write('char	char code	key	key code'),nl,
	write('-----------------------------------------'),nl,
	repeat,
	event(_,keyPress([A],B,_,_)),
	put(A),put(9),write(A),put(9),put(9),put(B),put(9),write(B),nl,
	fail.

command_key(127,Name,	delete_left(Name)).		% Delete	Delete
command_key(4,  Name,	delete_right(Name)).	% ->Del		CTR-D
command_key(20, Name,	transpose(Name)).	% <->		CTR-T
command_key(2,  Name,	move_left(Name)).	% <-		CTR-B
command_key(6,  Name,	move_right(Name)).	% ->		CTR-F
command_key(16,  Name,	move_up(Name)).		% ^		CTR-P
command_key(14,  Name,	move_down(Name)).	% v		CTR-N
command_key(1,  Name,	start_line(Name)).	% |<-		CTR-A
command_key(5,  Name,	end_line(Name)).	% ->|		CTR-E
command_key(11, Name,	kill_end(Name)).	% KILL  	CTR-K
command_key(25,	Name,	yank(Name)).		% YANK		CTR-Y
command_key(12,	Name,	redraw_field(Name)).	% 		CTR-L
command_key(13,	Name,	enter(Name)).		% callback
command_key(10,	Name,	enter(Name)).		% callback

enter(Name) :-	call_back(Name,callback).
enter(Name) :-		
	get_attr(Name,line(N),_), !,
	get_attr(Name,char_size,_CW+CH),
	current_window(Name,[height=H]),
	CY is 2+(CH+2)*(N-1),
	CY < H,				% lines are inserted only if 
	new_line(Name).			% there is enough space

redraw_field(Name) :-
	clear,
	get_attr(Name,char_size,CW+CH),
	(get_attr(Name,line(K),L), 
		write_line(K,L,CW,CH), 	gc(Name,[]), % back to normal
	fail;true),
	get_attr(Name,line(N),line(A,B,C,D,P)), !,
	write_edit_line0(N,A,B,C,D,P,CW,CH).


new_line(Name) :-		%	get_attr(Name,lines,Max),
	get_attr(Name,nlines,NL), ML is NL+1,
	set_attr(Name,nlines,ML),

	get_attr(Name,line(N),line(A,B,C,D,P)), !,
	get_attr(Name,char_size,CW+CH),
	set_attr(Name,line(N),line(A,B,V,V,P)),
	write_line(N,line(A,B,V,V,P),CW,CH),
	M is N+1,
	insert_line(Name,M,line(C,D,Z,Z,CW),CW,CH),
	start_line(Name).


insert_line(Name,N,LN,CW,CH) :-
	(get_attr(Name,line(N),LM) -> 	
		M is N+1,
		insert_line(Name,M,LM,CW,CH)
	; true),
	set_attr(Name,line(N),LN),
	write_line(N,LN,CW,CH).

kill_line(Name) :-
	get_attr(Name,line(N),_), !,
	get_attr(Name,char_size,CW+CH),
	M is N+1,
	delete(Name,M,LM,CW,CH),
	set_attr(Name,line(N),LM),
	start_line(Name).

delete_line(Name,N,LN,CW,CH) :-
	get_attr(Name,line(N),LN),
	M is N+1,
	(delete_line(Name,M,LM,CW,CH) ->
		set_attr(Name,line(N),LM),
		write_line(N,LM,CW,CH)
	; 
		unset_attr(Name,line(N)), 
		clear_line(Name,N,CH)
	).


move_up(Name) :-
	get_attr(Name,line(N),O), !,
	get_attr(Name,char_size,CW+CH),
	M is N-1,
	get_attr(Name,line(M),L),
	set_attr(Name,line(M),L),
	write_line(N,O,CW,CH),
	write_edit_line(M,L,CW,CH).

move_down(Name) :-
	get_attr(Name,line(N),O), !,
	get_attr(Name,char_size,CW+CH),
	M is N+1,
	get_attr(Name,line(M),L),
	set_attr(Name,line(M),L),
	write_line(N,O,CW,CH),
	write_edit_line(M,L,CW,CH).

delete_left(Name) :-
	get_attr(Name,char_size,CW+CH),
	get_attr(Name,line(N),line(A,B,C,D,P)), !,
	but_last(A,NA,U), 
	(var(U) ->
		M is N-1,
		get_attr(Name,line(M),line(L,R,R,A,Q)),
		delete_line(Name,N,_,CW,CH),
		set_attr(Name,line(M),line(L,B,C,D,Q)),
		write_edit_line(M,L,B,C,D,Q,CW,CH)
	;
		Q is P-CW,
		set_attr(Name,line(N),line(NA,B,C,D,Q)),
		write_edit_line(N,NA,B,C,D,Q,CW,CH)
	).
delete_right(Name) :-
	get_attr(Name,char_size,CW+CH),
	get_attr(Name,line(N),line(A,B,[X|C],D,P)), !,
	nonvar(X),
	set_attr(Name,line(N),line(A,B,C,D,P)),
	write_edit_line(N,A,B,C,D,P,CW,CH).
transpose(Name) :-
	get_attr(Name,char_size,CW+CH),
	(get_attr(Name,line(N),line(A,B,[T|C],D,P)) -> otherwise; true),
	but_last(A,NA,U), nonvar(U), Q is P+CW,
	B=[T,U|E],
	set_attr(Name,line(N),line(NA,E,C,D,Q)),
	write_edit_line(N,NA,E,C,D,Q,CW,CH).
move_left(Name) :-
	get_attr(Name,char_size,CW+CH),
	(get_attr(Name,line(N),line(A,B,C,D,P)) -> otherwise; true),
	but_last(A,NA,U), nonvar(U), Q is P-CW,
	set_attr(Name,line(N),line(NA,B,[U|C],D,Q)),
	write_edit_line(N,NA,B,[U|C],D,Q,CW,CH).
move_right(Name) :- 
	get_attr(Name,char_size,CW+CH),
	(get_attr(Name,line(N),line(A,[U|E],[U|C],D,P)) -> otherwise; true),
	nonvar(U), Q is P+CW,
	set_attr(Name,line(N),line(A,E,C,D,Q)),
	write_edit_line(N,A,E,C,D,Q,CW,CH).
start_line(Name) :-
	get_attr(Name,char_size,CW+CH),
	(get_attr(Name,line(N),line(A,J,J,D,_)) -> otherwise; true),
	set_attr(Name,line(N),line(V,V,A,D,CW)),
	write_edit_line(N,V,V,A,D,CW,CW,CH).
end_line(Name) :- 
	get_attr(Name,char_size,CW+CH),
	(get_attr(Name,line(N),line(A,J,J,D,_)) -> otherwise; true),
	line_size(A,CW,S),
	set_attr(Name,line(N),line(A,D,V,V,S)),
	write_edit_line(N,A,D,V,V,S,CW,CH).
kill_end(Name) :-		
	get_attr(Name,char_size,CW+CH),
	get_attr(Name,line(N),line(A,B,C,D,P)), !,
	(var(A), var(C) -> kill_line(Name)
	;
		set_attr('$editable','$ring',ring(C,D)),
		set_attr(Name,line(N),line(A,B,V,V,P)),
		clear_line(Name,N,CH),
		write_edit_line(N,A,B,V,V,P,CW,CH)
	).
yank(Name) :-
	get_attr(Name,char_size,CW+CH),
	get_attr('$editable','$ring',ring(E,F)),
	(get_attr(Name,line(N),line(A,E,C,D,_)) -> otherwise; true),
	line_size(A,CW,Q),
	set_attr(Name,line(N),line(A,F,C,D,Q)),
	clear_line(Name,N,CH),
	write_edit_line(N,A,F,C,D,Q,CW,CH).


/* exported  */

get_line(Name,N,EF) :- get_attr(Name,line(N),line(EF,J,J,[],_)).

get_line(Name,Chars) :- get_lines(Name,1,Chars).

get_lines(Name,N,Chars) :-
	(get_attr(Name,line(N),line(Chars,J,J,Cont,_)) ->
		M is N+1,
		get_lines(Name,M,Rest),
		(Rest=[] -> Cont=Rest; Cont=[32|Rest])
	;
		Chars=[]
	).


set_line(Name,N,EF) :- 
	(get_attr(Name,char_size,CW+CH), !; writebox('A',CW,CH)),
	(open_line(EF,CW,CW,A,B,C,D) ->
		set_attr(Name,line(N),line(A,B,C,D,CW))
	;
		set_attr(Name,line(N),line(A,A,V,V,CW))
	),
	send_event(expose(0),Name).
/*
	clear_line(Name,N,CH), 
	write_edit_line0(N,A,B,C,D,CW,CW,CH).
*/

set_line(Name,Text) :-
	current_window(Name,[width=WW]), window(Name,[]), writebox(0,CW,_),
	Chars_per_line is integer(WW/CW),
	set_lines(Text,Name,1,Chars_per_line).

set_lines([],Name,N,_Chars_per_line) :- !, 
	set_attr(Name,nlines,N),
	(N==1 -> set_line(Name,N,[]) ; true).
set_lines(Text,Name,N,Chars_per_line) :-
	one_line(Text,Chars_per_line,Line,Rest),
	(Line=[] -> % cannot break this line
		set_line(Name,N,Rest)
	;
		set_line(Name,N,Line),
		M is N+1,
		set_lines(Rest,Name,M,Chars_per_line)
	).

one_line([],_Chars_per_line,[],[]) :- !.
one_line(Text,CPL,Line,Rest) :-
	next_word(Text,WLine,Diff,WRest,WC),
	NCPL is CPL-WC,
	(NCPL<0 -> 
		Line=[], Rest=Text
	;
		one_line(WRest,NCPL,Diff,Rest),
		Line=WLine
	).

next_word([],V,V,[],0) :- !.
next_word([32|Text],[32|V],V,Text,1) :- !.
next_word([C|Text],[C|Cont],V,Rest,M) :- 
	next_word(Text,Cont,V,Rest,N),
	M is N+1.

/* private utils */


str_line([],V,V,CW,CW).
str_line([H|T],[H|R],V,CW,M) :- 
	str_line(T,R,V,CW,N),
	M is N+CW.

open_line(L,P,CW,A,B,C,D) :-
	open_first(CW,P,CW,L,A,B,R),
	open_last(R,C,D).

open_first(P,P,_CW,L,A,A,L) :- !.
open_first(J,P,CW,[X|L],[X|A],B,R) :- 
	K is J+CW,
	open_first(K,P,CW,L,A,B,R).
% open_first(J,P,CW,[],A,A,[]). 

open_last([],D,D).
open_last([X|L],[X|C],D) :- open_last(L,C,D).

write_line(N,line(Line,R,R,[],_),CW,CH) :- 
	CH2 is (CH+2)*N,
	CY is 2+(CH+2)*(N-1),
	current_window(_,[width=W]),!,
	crectangle(0,CY,W,CH),
	writestring(CW,CH2,Line).

write_edit_line(N,line(A,B,C,D,P),CW,CH) :- 
	write_edit_line(N,A,B,C,D,P,CW,CH).

write_edit_line(N,Line,[H|R],[H|R],"  ",P,CW,CH) :- 
	CH2 is (CH+2)*N,
	writestring(CW,CH2,Line),
	gc(reverse,[]), writestring(P,CH2,[H]).

clear_line(Name,N,CH) :-
	CY is 2+(CH+2)*(N-1),
	current_window(Name,[width=W]),
	crectangle(0,CY,W,CH).

write_edit_line0(N,Line,R,R,"  ",P,CW,CH) :- 
	CH2 is (CH+2)*N,
	CY is 2+(CH+2)*(N-1),
	CH1 is CH-1,
	writestring(CW,CH2,Line), rectangle(P,CY,CW,CH1).

write_selected(N,Line,"",P,_CW,CH) :- 
	CH2 is (CH+2)*N,
	gc(reverse,[]), writestring(P,CH2,Line).



but_last(V,V,V) :- var(V), !.
but_last(L,NL,U) :- bl(L,NL,U).

bl([U|V],V,U) :- var(V), !.
bl([H|T],[H|R],U) :- bl(T,R,U).

line_size(V,CW,CW) :- var(V), !.
line_size([_|R],CW,M) :- line_size(R,CW,N), M is N+CW.

%							|
%							|
%-------------------------------------------------------
