


:- module(bully,[bully/2]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).

bully(leaveNotify,	Name) :- get_attr(Name,maped,true), 	my_loop(Name).
bully(mapNotify,	Name) :- set_attr(Name,maped,true),	my_loop(Name).
bully(unmapNotify,	Name) :- unset_attr(Name,maped).

my_loop(Name) :-
	repeat,
	event(W,E),
	my_process(E,W,Name), !, 
	unset_attr(Name,parent(_)).



desc_of(W,N) :- 
	get_parent(W,N,P),
	(N=P -> otherwise; desc_of(P,N)).

get_parent(W,N,P) :- 
	(get_attr(N,parent(W),P) ->
		otherwise
	; 
 		get_window_attr(W,parent,P),
		set_attr(N,parent(W),P)
	).

my_process(enterNotify,W,W) :- !.
my_process(leaveNotify,W,W) :- !.
my_process(unmapNotify,W,W) :- !, unset_attr(W,maped).

my_process(E,W,W) :- !, send_event(E,W), cont_my_loop.
my_process(E,W,N) :- desc_of(W,N), !,
	send_event(E,W), cont_my_loop.

my_process(buttonPress(_,_,_),_,_) :- !, bell(10), cont_my_loop.
my_process(buttonRelease(_,_,_),_,_) :- !, cont_my_loop.
my_process(motionNotify(_,_),_,_) :- !, cont_my_loop.
my_process(keyPress(_,_,_,_),_,_) :- !, cont_my_loop.
my_process(keyRelease(_,_,_,_),_,_) :- !, cont_my_loop.

my_process(E,W,_) :- send_event(E,W), cont_my_loop.


trace(E,W) :- send_event(E,W).

cont_my_loop :- recorded('$exit_loop','$exit_loop',_).
