/*
:- module(primitives, [load_foreign_files/2]).

:- meta_predicate load_foreign_files(:, ?).
*/
/***/

load_foreign_files(M : QtObjFileNames, Libraries) :-
	get_real_names(QtObjFileNames, QtObjFileRealNames),
	get_yap_src_file(YapSrcFile),
	make_yap_src(M, YapSrcFile),
	get_yap_obj_file(YapSrcFile, YapObjFile),
	my_system(['cc -c', YapSrcFile, '-o', YapObjFile,'-I/usr/big6/users/yap_distr/YAP3/s441/distr']),
	load_foreign_files([YapObjFile| QtObjFileRealNames], Libraries,
	init_preds).
%	my_system([rm, YapSrcFile, YapObjFile]).

get_real_names([], []).
get_real_names([Name| T1], [RealName| T2]) :-
	get_real_name(Name, RealName), get_real_names(T1, T2).

get_real_name(library(Name), RealName) :-
	!, qt_libraries_directory(Dir), append_atoms(Dir, Name, RealName).
get_real_name(Name, Name).

get_yap_src_file('/tmp/.qtoytmpfile.c').

get_yap_obj_file(YapCFile, YapObjFile) :-
	name(YapCFile, YapCChars),
	append(Chars, ".c", YapCChars),
	append(Chars, ".o", YapObjChars),
	name(YapObjFile, YapObjChars).

make_yap_src(M, YapSrcFile) :-
	open(YapSrcFile, write, YapSrcStream),
	current_output(OldOutputStream),
	set_output(YapSrcStream),
	include_header,
	get_predicates_info(M, PredsInfo),
	make_yap_routines(PredsInfo),
	make_init_preds_routine(PredsInfo),
	set_output(OldOutputStream),
	close(YapSrcStream).

include_header :-
	write('#include "c_interface.h"'),
	nl, nl.

get_predicates_info(M, PredsInfo) :-
	findall(PredInfo, get_predicate_info(M, PredInfo), PredsInfo).

get_predicate_info(M, pi(Name, Arity, ArgsType, QtRoutine, YapRoutine)) :-
	M : foreign(QtRoutine, Functor),
	functor(Functor, Name, Arity),
	Functor =.. [_| ArgsType],
	get_yap_routine(QtRoutine, YapRoutine).
get_predicate_info(M, pi(Name, Arity, ArgsType, QtRoutine, YapRoutine)) :-
	M : foreign(QtRoutine, c, Functor),
	functor(Functor, Name, Arity),
	Functor =.. [_| ArgsType],
	get_yap_routine(QtRoutine, YapRoutine).

get_yap_routine(QtRoutine, YapRoutine) :-
	name(QtRoutine, Chars), name(YapRoutine, [0'_| Chars]).

make_yap_routines([]).
make_yap_routines([pi(_, _, ArgsType, QtRoutine, YapRoutine)| T]) :-
	make_yap_routine(QtRoutine, YapRoutine, ArgsType),
	make_yap_routines(T).	

make_yap_routine(QtRoutine, YapRoutine, ArgsType) :-
	get_args_info(ArgsType, XArgsInfo, YArgsInfo, ZArgsInfo),
	dcl_qt_routine(QtRoutine, ZArgsInfo),
	make_yap_routine_header(YapRoutine),
	write('{'),
	nl,
	dcl_vars(XArgsInfo, YArgsInfo, ZArgsInfo),
	assign_x_vars(XArgsInfo),
	call_qt_routine(QtRoutine, XArgsInfo, YArgsInfo, ZArgsInfo),
	assign_and_unify_t_vars(YArgsInfo, ZArgsInfo),
	return,
	write('}'),
	nl,
	nl.

get_args_info(ArgsType, XArgsInfo, YArgsInfo, ZArgsInfo) :-
	get_args_info(ArgsType, XArgsInfo, YArgsInfo, ZArgsInfo, 1).

get_args_info([], [], [], [], _).
get_args_info([+Type| T1], [x(Type, Name, N)| T2], YArgsInfo, ZArgsInfo, N) :-
	get_x_var(N, Name),
	M is N+1,
	get_args_info(T1, T2, YArgsInfo, ZArgsInfo, M).
get_args_info([-Type| T1], XArgsInfo, [y(Type, Name, TName, N)| T2], ZArgsInfo,
	N) :-
	get_y_var(N, Name),
	get_t_var(N, TName),
	M is N+1,
	get_args_info(T1, XArgsInfo, T2, ZArgsInfo, M).
get_args_info([[-Type]| T1], XArgsInfo, YArgsInfo,
[z(Type, Name, TName, N)| T2], N) :-
	get_z_var(N, Name),
	get_t_var(N, TName),
	M is N+1,
	get_args_info(T1, XArgsInfo, YArgsInfo, T2, M).

get_x_var(N, Name) :- name(N, Chars), name(Name, [0'x| Chars]).
	
get_y_var(N, Name) :- name(N, Chars), name(Name, [0'y| Chars]).
	
get_z_var(N, Name) :- name(N, Chars), name(Name, [0'z| Chars]).
	
get_t_var(N, Name) :- name(N, Chars), name(Name, [0't| Chars]).

dcl_qt_routine(QtRoutine, []) :-	
	format('extern void ~w();~n~n', [QtRoutine]).
dcl_qt_routine(QtRoutine, [z(integer, _, _, _)]) :-	
	format('extern Int ~w();~n~n', [QtRoutine]).
dcl_qt_routine(QtRoutine, [z(float, _, _, _)]) :-	
	format('extern flt ~w();~n~n', [QtRoutine]).
dcl_qt_routine(QtRoutine, [z(string, _, _, _)]) :-
	format('extern char * ~w();~n~n', [QtRoutine]).
dcl_qt_routine(QtRoutine, [z(address(_), _, _, _)]) :-	
	format('extern Int ~w();~n~n', [QtRoutine]).

dcl_qt_routine(QtRoutine, [z(atom, _, _, _)]) :-	% ZP (91/09/25)
	format('extern Int ~w();~n~n', [QtRoutine]).

make_yap_routine_header(YapRoutine) :-
	format('static int ~w()~n', [YapRoutine]).

dcl_vars([], [], []) :- nl.
dcl_vars([x(Type, Name, _)| T], YArgsInfo, ZArgsInfo) :-
	dcl_xyz_var(Type, Name),
	dcl_vars(T, YArgsInfo, ZArgsInfo).
dcl_vars([], [y(Type, Name, TName, _)| T], ZArgsInfo) :-
	dcl_xyz_var(Type, Name),
	dcl_t_var(TName),
	dcl_vars([], T, ZArgsInfo).
dcl_vars([], [], [z(Type, Name, TName, _)]) :-
	dcl_xyz_var(Type, Name),
	dcl_t_var(TName),
	nl.

dcl_xyz_var(integer, Name) :- format('  Int ~w;~n', [Name]).
dcl_xyz_var(float, Name) :- format('  flt ~w;~n', [Name]).
dcl_xyz_var(string, Name) :- format('  char * ~w;~n', [Name]).
dcl_xyz_var(atom, Name) :- format('  Term ~w;~n', [Name]).
dcl_xyz_var(address(_), Name) :- format('  Int ~w;~n', [Name]).

dcl_t_var(TName) :- format('  Term ~w;~n', [TName]).

assign_x_vars([]).
assign_x_vars([x(integer, Name, ArgN)| T]) :-
	format('  ARG(~w) = Deref(ARG(~w));~n', [ArgN, ArgN]),
	format('  if (IsVarTerm(ARG(~w))) return(0);~n', [ArgN]),
	format('  if (!IsIntTerm(ARG(~w))) return(0);~n', [ArgN]),
	format('  ~w = IntOfTerm(ARG(~w));~n', [Name, ArgN]),
	assign_x_vars(T).
assign_x_vars([x(float, Name, ArgN)| T]) :-
	format('  ARG(~w) = Deref(ARG(~w));~n', [ArgN, ArgN]),
	format('  if (IsVarTerm(ARG(~w))) return(0);~n', [ArgN]),
	format('  if (!IsFloatTerm(ARG(~w))) return(0);~n', [ArgN]),
	format('  ~w = FloatOfTerm(ARG(~w));~n', [Name, ArgN]),
	assign_x_vars(T).
assign_x_vars([x(string, Name, ArgN)| T]) :-
	format('  ARG(~w) = Deref(ARG(~w));~n', [ArgN, ArgN]),
	format('  if (IsVarTerm(ARG(~w))) return(0);~n', [ArgN]),
	format('  if (!IsAtomTerm(ARG(~w))) return(0);~n', [ArgN]),
	format('  ~w = AtomName(AtomOfTerm(ARG(~w)));~n', [Name, ArgN]),
	assign_x_vars(T).
assign_x_vars([x(atom, Name, ArgN)| T]) :-
	format('  ~w = Deref(ARG(~w));~n', [Name, ArgN]),
	assign_x_vars(T).
assign_x_vars([x(address(_), Name, ArgN)| T]) :-
	format('  ARG(~w) = Deref(ARG(~w));~n', [ArgN, ArgN]),
	format('  if (IsVarTerm(ARG(~w))) return(0);~n', [ArgN]),
	format('  if (!IsIntTerm(ARG(~w))) return(0);~n', [ArgN]),
	format('  ~w = IntOfTerm(ARG(~w));~n', [Name, ArgN]),
	assign_x_vars(T).

call_qt_routine(QtRoutine, XArgsInfo, YArgsInfo, []) :-
	format('  ~w(', [QtRoutine]),
	args_for_qt_routine(XArgsInfo, YArgsInfo),
	write('); '),
	nl.
call_qt_routine(QtRoutine, XArgsInfo, YArgsInfo, [z(_, Name, _, _)]) :-
	format('  ~w = ~w(', [Name, QtRoutine]),
	args_for_qt_routine(XArgsInfo, YArgsInfo),
	write('); '),
	nl.

args_for_qt_routine([], []).
args_for_qt_routine([x(_, Name, _)| T], YArgsInfo) :-	
	write(Name),
	((T = [], YArgsInfo = []) ->
	    true;
	    write(', '),
	    args_for_qt_routine(T, YArgsInfo)
	).
args_for_qt_routine([], [y(_, Name, _, _)| T]) :-
	write(&),
	write(Name),
	(T = [] ->
	    true;
	    write(', '),
	    args_for_qt_routine([], T)
	).

assign_and_unify_t_vars([], []).
assign_and_unify_t_vars([y(Type, Name, TName, ArgN)| T], ZArgsInfo) :-
	assign_t_var(Type, Name, TName),
	unify_t_var(TName, ArgN),
	assign_and_unify_t_vars(T, ZArgsInfo).
assign_and_unify_t_vars([], [z(Type, Name, TName, ArgN)]) :-
	assign_t_var(Type, Name, TName),
	unify_t_var(TName, ArgN).

assign_t_var(integer, Name, TName) :-
	format('  ~w = MkIntTerm(~w);~n', [TName, Name]).
assign_t_var(float, Name, TName) :-
	format('  ~w = MkFloatTerm(~w);~n', [TName, Name]).
assign_t_var(string, Name, TName) :-
	format('  ~w = MkAtomTerm(LookupAtom(~w));~n', [TName, Name]).
assign_t_var(atom, Name, TName) :-
	format(' ~w = ~w;~n', [TName, Name]).
assign_t_var(address(_), Name, TName) :-
	format('  ~w = MkIntTerm(~w);~n', [TName, Name]).
	
unify_t_var(TName, ArgN) :-
	format('  if (!unify(&ARG(~w), &~w)) return(0);~n', [ArgN, TName]).

return :- write('  return(1);'), nl.

make_init_preds_routine(PredsInfo) :-
	write('void init_preds()'),
	nl,
	write('{'),
	nl,
	init_preds(PredsInfo),
	write('}'),
	nl.	

init_preds([]).
init_preds([pi(Name, Arity, _, _, YapRoutine)| T]) :-
	init_pred(Name, Arity, YapRoutine), init_preds(T).

init_pred(Name, Arity, YapRoutine) :-
	format('  UserCPredicate("~w", ~w, ~w);~n', [Name, YapRoutine, Arity]).

/***/

my_system(Args) :- get_command_line(Args, CommandLine), system(CommandLine).

get_command_line(Args, CommandLine) :-
	get_command_line_(Args, L),
	name(CommandLine, L).

get_command_line_([], []).
get_command_line_([Arg| T], L) :-
	name(Arg, Chars),
	get_command_line_(T, R),
	append(Chars, [0' | R], L).

append([], L, L).
append([X| T1], L, [X| T2]) :- append(T1, L, T2).

append_atoms(A1, A2, A3) :-
	name(A1, L1), name(A2, L2), append(L1, L2, L3), name(A3, L3).

/***/

qt_libraries_directory('/usr/big6/tape/q2.2/library/').

