
:- module(dialog,[]).

:- ensure_loaded(library(ytoolkit)).

:- ytoolkit:super_class(dialog:dialog_box).

default(width,300).
default(height,130).
default(font,Font) :-
	current_font([
			'9x15',
			'-*-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*',
			'*15*'],Font).



sub_widgets(Self) :-
	get_attr(Self,message,M),
	draw(writeterm(20,30,M)),
	new_widget(field,[
		parent=Self
		,x=20
		,y=50
	        ,width=Self~width-40
		,callback=ok(Self,Field)
	    ],Field),
	    focus(Field),
	BW=80,
	new_widget(button,[
		parent=Self
		,x=Self~width/2-20-BW
		,y=80
		,text='Ok'
		,callback=ok(Self,Field)
		],_),
	new_widget(button,[
		parent=Self
		,x=Self~width/2+20
		,y=80
		,text='Cancel'
		,callback=cancel(Self)
		],_).


% callback

ok(Self,Field) :- 
	current_widget(field,[chars=C],Field),
	name(N,C),
	get_attr(Self,callback(N),CallBack),
	defocus,
	kill_widget(_,[],Self),
	call(CallBack).


cancel(Self) :-
	defocus,
	kill_widget(_,[],Self).
