/*portray(X) :-
    p(0,X,X_),
    write(X_).
*/

portray(cut(CP,CP_)) :-
    portray(CP).

portray(fc(_,_,_,CP) ) :-
    portray(CP).

portray( A+B ) :-
    portray(A), nl, write(+),nl,
    portray(B).


p(_,A,A) :- atomic(A);var(A).

p(10,[_|_],'[...]') :- !.

p(L,S,S_) :-
    q(L,S,S_), !.

p(L,S,S_) :-
    functor( S, F, _ ),
    r( F ), !,
    name(F,FChars),
    append( FChars, "(....)", C ),
    name( S_, C ).

p(10,S,AC) :-
    functor(S,F,_), name(F,FChars),
    append( FChars, "(....)", C ),
    name( AC, C ).

p(L,S,S_) :-
    S =.. [ P | A ],
    L_ is L + 1,
    p_l( L_, A, A_ ),
    S_ =.. [ P | A_ ].


p_l( _, [], [] ) :- !.

p_l( L, [H|T], [H_|T_] ) :-
    p( L, H, H_ ),
    p_l( L, T, T_ ).


r( and_list ).
