/*  MODE.PL  */


:- module mode.


:- public is_mode/1,
          set_mode/1.


:- dynamic is_mode/1.


/*
SPECIFICATION
-------------

is_mode( Mode? ):

Indicates whether the current mode is Logic ('logic') or Prolog
('prolog').


set_mode( Mode+ ):

Sets the current mode.
*/


/*
IMPLEMENTATION
--------------
*/


set_mode(M) :-
    is_mode(M),
    !.

set_mode(M) :-
    retractall( is_mode(_) ),
    asserta(is_mode(M)).


:- endmodule.
