/*  MASTER.PL  */


/*
This is the top-level file for the Logic Programming Tutor. Its main
purpose is to load and call 'go'. It does several things:


1) Undefine various Poplop macros that clash with atoms used in the
Tutor. Remove this code if not using Poplog.

You will find a few other references to Poplog throughout the source. If
you are running a different system, you can remove or replace them; I've
had to leave them in so that I can test the version that I'm about to
distribute. All such references are commented.
*/
:- library(macro).
:- killmac("prolog").
:- killmac("teach").
:- killmac("ref").
:- killmac("help").
:- killmac("lib").


/*
2) Define 'loop' as a quicker-to-type way of invoking the
read-and-process loop. This is useful during development when you may
want to alternate between testing the Tutor and amending and
reconsulting source files. It is not needed at other times, so it can be
safely removed.

If your Prolog allows you to call a predicate after an interrupt has
been typed, then that predicate should be read_and_do_sentences.
Note that you should protect retract/assert pairs from interrupts to
maintain internal consistency - see COMMANDS.PL.
*/
loop :- read_and_do_sentences.


/*
3) Turn on 'quietspy' so that calling spy doesn't give all those
irritating messages. Also define a version of spy that doesn't spy on
the term- and goal- expansion predicates. Remove this if not using
Poplog.
*/
:- quietspy(on).
sp :- (spy), (nospy prolog_expand_term),
    (nospy prolog_user_goal),
    (nospy prolog_expand_goal).


/*
4) Load module 'lib'. You will need this, and should read it NOW.
*/
:- reconsult( 'lib.pl' ).


/*
5) Load the other files needed by the Tutor.
*/
:- lib(
        [ bug
        , files
        , lib
        , chars
        , control
        , findall
        , useful
        , lists
        , output
        , output_english
        , read_line
        , tokenise
        /* , numbervars - built in to Poplog */
        , system
        , read_term
        , output_to_chars
        /* , compare_terms - built in to Poplog */
        , arrays
        , sdo
        , sdo_output
        , ask
        , parse_utils
        , mode
        , answers
        , script
        , kbfiles
        , show
        , 'show_sdo.sdo'-sdo_reconsult
        , analyse
        , 'analyse_sdo.sdo'-sdo_reconsult
        , string_edit
        , screen_edit
        , editor
        , db
        , and_or
        , why
        , 'why_sdo.sdo'-sdo_reconsult
        , command_help
        , help
        , commands
        , check_clause
        , parse_logic
        , parse_prolog
        , parse
        , main_loop
        , go
        , random    /*  Needed by student exercises.  */
        ] ).


/*
6) Load a Poplog library which allows me to capture output in a file.
I use this during testing, but you can discard it.
*/
:- library(log).


/*
7) Call the main predicate, 'go'. (I have commented this out for
testing.)
:- go.
*/
