/*  DB.PL  */


:- module db.


:- public add/1,
          adda/1,
          del/1.


/*
SPECIFICATION
-------------

This module implements 'visible' equivalents of assert, retract, etc., used
when teaching. The idea is that the student can write code that alters the
database dynamically, and can see, when she does a 'show', the changes
reflected in the editor's fact list.

PUBLIC add( Clause ):
Append Clause to the end of the knowledge base.

PUBLIC adda( Clause ):
Prepend Clause to the front of the knowledge base.

PUBLIC del( Clause ):
Delete the first instance of Clause from the knowledge base.
*/


/*
IMPLEMENTATION
--------------

Implementation is just a matter of calling the appropriate add/delete
predicates from EDITOR, and then calling sync_database to ensure the
Prolog database has been updated.
*/


:- needs
    append_fact / 2,
    delete_fact_matching / 2,
    fact_vs_clause_and_vars / 3,
    prepend_fact / 2,
    standardise_clause / 2,
    sync_database / 0.


add( Clause ) :-
    standardise_clause( Clause, Clause_ ),
    fact_vs_clause_and_vars( F, Clause_, [] ),
    append_fact( F , _ ),
    sync_database.


adda( Clause ) :-
    standardise_clause( Clause, Clause_ ),
    fact_vs_clause_and_vars( F, Clause_, [] ),
    prepend_fact( F, _ ),
    sync_database.


del( (H:-T) ) :-
    !,
    delete_fact_matching( _, (H:-T) ),
    sync_database.

del( (H:-true) ) :-
    !,
    delete_fact_matching( _, (H) ),
    sync_database.

del( (H) ) :-
    !,
    delete_fact_matching( _, (H) ),
    sync_database.


:- endmodule.
