/*  SIN.PL  */


/*  From a lecture by Richard Ennals. Used in Supplement 3.  */


deserves( X, damnation ) :-
    committed( X, Y ),
    is_a( Y, deadly_sin ),
    doesnt_repent( X, Y ).

deserves( X, limbo ) :-
    committed( X, Y ),
    is_a( Y, deadly_sin ),
    repents( X, Y ).

deserves( X, commendation ) :-
    committed( X, Y ),
    is_a( Y, useful_act ),
    doesnt_benefit_just( Y, X ).


committed( nick, secret_drinking ).
committed( richard, overtime ).
committed( charles, overtime ).
committed( charles, secret_theft ).
committed( terry, theft ).
committed( julia, overtime ).
committed( julia, secret_theft ).
committed( bernie, first_degree_mopery ).
committed( bernie, driving_a_terminal_without_due_care_and_attention ).


is_a( secret_drinking, deadly_sin ).
is_a( secret_theft, deadly_sin ).
is_a( first_degree_mopery, deadly_sin ).
is_a( overtime, useful_act ).
is_a( driving_a_terminal_without_due_care_and_attention, deadly_sin ).


doesnt_repent( richard, secret_drinking ).
doesnt_repent( nick, secret_drinking ).
doesnt_repent( nick, secret_theft ).
doesnt_repent( bernie, first_degree_mopery ).


doesnt_benefit_just( overtime, richard ).
doesnt_benefit_just( overtime, charles ).


repents( julia, secret_theft ).
repents( terry, theft ).
repents( bernie, driving_a_terminal_without_due_care_and_attention ).
