/* xlgraph.h - External declarations and defines for XLISP-STAT.       */
/* XLISP-STAT 2.1 Copyright (c) 1990, by Luke Tierney                  */
/* Additions to Xlisp 2.1, Copyright (c) 1989 by David Michael Betz    */
/* You may give out copies of this software; for conditions see the    */
/* file COPYING included with this distribution.                       */

#ifdef MACINTOSH
/* edit.c */
extern VOID get_default_volume _((void));
extern int set_volume _((int new_vref));

/* editwindows.c */
extern VOID set_edit_window_procs _((WindowPtr w));
extern VOID adjust_insert _((WindowPtr w));
extern VOID return_action _((TEHandle te));
extern VOID TtyPutc _((int c));
extern VOID TtyPrint _((char *s));
extern VOID TtyFlush _((void));
extern VOID make_listener_window _((Rect r));

/* macdialogs2.c */
extern VOID doDialog _((int theItem, EventRecord *theEvent));
extern VOID closeDialog _((void));
extern VOID activateDialog _((int active));
extern VOID clobberDialog _((void));

/* maciviewwindow.c */
extern VOID init_mac_cursors _((void));
extern Rect scroll_bar_bounds _((WindowPtr w, int which));
extern VOID DrawGWGrowBox _((StGWWinInfo *gwinfo));
extern VOID mac_do_cursor _((StGWWinInfo *gwinfo));

/* maciviewwindow2.c */
extern VOID init_mac_colors _((void));
extern VOID SetHardwareState _((StGWWinInfo *gwinfo));
extern VOID set_fore_color _((StGWWinInfo *gwinfo));
extern VOID set_back_color _((StGWWinInfo *gwinfo));

/* maciviewwindow3.c */
extern VOID initialize_static_globals _((void));
extern VOID reset_clip_rect _((StGWWinInfo *gwinfo));
extern VOID adjust_graph_workport _((StGWWinInfo *gwinfo));

/* macstuff.c */
extern VOID getttyline _((LVAL s));
extern VOID MyShowWindow  _((WindowPeek wind));

/* macwindows.c */
extern LVAL get_window_object _((WindowPtr w));
VOID mac_update_action _((int resized));
VOID mac_activate_action _((int active));
VOID mac_close_action _((void));

/* TransSkel1.c */
void SkelInit (void);
void SkelMain (void);
void SkelWhoa (void);
void SkelClobber (void);
void SkelMenu (MenuHandle theMenu, ProcPtr pSelect, ProcPtr pClobber);
void SkelMenuUpdateProc (MenuHandle theMenu, ProcPtr pUpdate);
void SkelRmveMenu (MenuHandle theMenu);
void SkelApple (StringPtr aboutTitle, ProcPtr aboutProc);
void SkelWindow (WindowPtr theWind, ProcPtr pMouse, ProcPtr pKey, ProcPtr pUpdate,
                 ProcPtr pActivate, ProcPtr pClose, ProcPtr pClobber, ProcPtr pIdle,
                 Boolean frontOnly);
void SkelRmveWind (WindowPtr theWind);
#ifdef supportDialogs
void SkelDialog (DialogPtr theDialog, ProcPtr pEvent, ProcPtr pClose, ProcPtr pClobber);
void SkelRmveDlog (DialogPtr theDialog);
#endif
void SkelGrowBounds (WindowPtr theWind, int hLo, int vLo, int hHi, int vHi);
void SkelEventMask (int mask);
void SkelGetEventMask (int *mask);
void SkelBackground (ProcPtr p);
void SkelGetBackground (ProcPtr	*p);
void SkelEventHook (Boolean	(*p)());
void SkelGetEventHook (Boolean	(**p)());
#ifdef	supportDialogs
void SkelDlogMask (int mask);
void SkelGetDlogMask (int *mask);
#endif

#endif /* MACINTOSH */

#ifdef X11WINDOWS
/* X11BSDstuff.c */
extern VOID StX11FlushStdin _((void));

/* X11buttons.c */
extern VOID InstallButtonItem _((Window win, LVAL item));
extern VOID DeleteButtonItem _((Window win, LVAL item));
extern int ClosePanelHeight _((void));
extern VOID InstallCloseButton _((Window win, LVAL object));
extern VOID DeleteCloseButton _((Window win));

/* X11choice.c */
extern VOID InstallChoiceItem _((Window win, LVAL item));
extern VOID DeleteChoiceItem _((Window win, LVAL item));

/* X11dialogs.c */
extern VOID install_dialog_item_handler _((Display *dpy,
					   Window win,
					   LVAL (*handler)(),
					   LVAL item));
extern VOID delete_dialog_item_handler _((Display *dpy, Window win));
extern VOID DialogAllocate _((LVAL dialog));
extern VOID DialogRemove _((LVAL dialog));

/* X11graph.c */
extern char *StX11GetDefault _((char *name));
extern VOID StProcessEvent _((Display *dpy, XEvent report));
extern Display *StX11Display _((void));
extern int StX11Screen _((void));
extern VOID StX11PressButton _((void));
extern VOID StX11ReleaseButton _((void));
extern int StX11ButtonIsDown _((void));
extern VOID StX11HandleClientMessage _((XEvent report));
extern VOID StX11SetWindowClass _((Display *dpy, Window win));
extern VOID StX11SetNormalHints _((Display *dpy, Window win,
				   int left, int top, int width, int height));
extern VOID StX11SetTransientHint _((Display *dpy, Window win));
extern VOID StX11SetStandardHints _((Display *dpy, Window w));
extern int StX11UseICCCM _((void));
extern VOID StWGetSize _((Window w, int *pwidth, int *pheight, int frame));
extern VOID StWGetLocation _((Window w, int *left, int *top, int frame));
extern int is_option_on _((char *s));

/* X11listitem.c */
extern VOID InstallListItem _((Window win, LVAL item));
extern VOID DeleteListItem _((Window win, LVAL item));

/* X11menus.c */
extern int StMObPopup _((LVAL menu, int x, int y, LVAL window));

/* X11scroll.c */
extern VOID InstallScrollBar _((Window w,
				LVAL object,
				int left, int top, int width, int height,
				Window *ps,
				VOID (*action)()));
extern VOID DeleteScrollBar _((Window s));
extern VOID AdjustScrollBar _((Window s, int val, int page, int max));

/* X11slider.c */
extern VOID InstallScrollItem _((Window win, LVAL item));
extern VOID DeleteScrollItem _((Window win, LVAL item));

/* X11text.c */
extern VOID InstallTextItem _((Window win, LVAL item));
extern VOID DeleteTextItem _((Window win, LVAL item));

/* X11toggle.c */
extern VOID InstallToggleItem _((Window win, LVAL item));
extern VOID DeleteToggleItem _((Window win, LVAL item));
#endif /* X11WINDOWS */
