/* utilities - basic utility functions                                 */
/* XLISP-STAT 2.1 Copyright (c) 1990, by Luke Tierney                  */
/* Additions to Xlisp 2.1, Copyright (c) 1989 by David Michael Betz    */
/* You may give out copies of this software; for conditions see the    */
/* file COPYING included with this distribution.                       */

/****** ///// clean this stuff up */

#include "xlisp.h"
#include "xlstat.h"

/************************************************************************/
/**                           Basic Utilities                          **/
/************************************************************************/

/* return list of two elements */
LVAL list2(x1, x2)
     LVAL x1, x2;
{
  LVAL list, y1, y2;
  
  /* protect some pointers */
  xlstkcheck(3);
  xlsave(list);
  xlsave(y1);
  xlsave(y2);
  
  y1 = x1;
  y2 = x2;
  list = consa(y2);
  list = cons(y1, list);
  
  /* restore the stack frame */
  xlpopn(3);
  
  return(list);
}

/* return list of three elements */
LVAL list3(x1, x2, x3)
     LVAL x1, x2, x3;
{
  LVAL list, y1, y2, y3;
  
  /* protect some pointers */
  xlstkcheck(4);
  xlsave(list);
  xlsave(y1);
  xlsave(y2);
  xlsave(y3);

  y1 = x1;
  y2 = x2;
  y3 = x3;
  list = consa(y3);
  list = cons(y2, list);
  list = cons(y1, list);
  
  /* restore the stack frame */
  xlpopn(4);
  
  return(list);
}

/* return the i-th argument, without popping it; signal an error if needed. */
LVAL peekarg(i)
     int i;
{
  if (xlargc <= i) xltoofew();
  return(xlargv[i]);
}

/* Get the next element in the sequence; cdr the pointer if it is a list */
LVAL getnextelement(pseq, i)
     LVAL *pseq;
     int i;
{
  LVAL value;

  switch (ntype(*pseq)) {
  case VECTOR:
    value = getelement(*pseq, i);
    break;
  case TVEC:
    value = gettvecelement(*pseq, i);
    break;
  case CONS:  
    value = car(*pseq);
    *pseq = cdr(*pseq);
    break;
  default:
    xlbadtype(*pseq);
    value = NIL;
  }
  return(value);
}

/* get and check a sequence argument */
LVAL xsgetsequence()
{
  LVAL arg;
  
  arg = xlgetarg();
  if (! sequencep(arg)) xlerror("not a sequence", arg);
  return(arg);
}

/* Set the next element in the sequence; cdr the pointer if it is a list */
VOID setnextelement(pseq, i, value)
     LVAL *pseq, value;
     int i;
{
  if (vectorp(*pseq)) setelement(*pseq, i, value);
  else {
    rplaca(*pseq, value);
    *pseq = cdr(*pseq);
  }
}

/* return value of a number coerced to a double */
/***** replae with makefloat */
double makedouble(x)
     LVAL x;
{
    if (fixp(x)) return ((FLOTYPE) getfixnum(x));
    else if (floatp(x)) return getflonum(x);
#ifdef RATIOS
    else if (ratiop(x)) return (getnumer(x)/(FLOTYPE)getdenom(x));
#endif
    xlerror("not a number", x);
    return 0.0; /* never reached */
}

/************************************************************************/
/**                  Function Applicaiton Utilities                    **/
/************************************************************************/

VOID pushargvec(fun, argc, argv)
     LVAL fun, *argv;
     int argc;
{
  LVAL *newfp;
  int i;

  /* build a new argument stack frame */
  newfp = xlsp;
  pusharg(cvfixnum((FIXTYPE)(newfp - xlfp)));
  pusharg(fun);
  pusharg(cvfixnum((FIXTYPE)argc));

  /* push the arguments */
  for (i = 0; i < argc; i++)
    pusharg(argv[i]);

  /* establish the new stack frame */
  xlfp = newfp;
}
    
LVAL xsapplysubr(f, args)
     LVAL (*f) _((void)), args;
{
  LVAL *oldargv, val;
  int argc, oldargc;
   
  xlprot1(args); /* protect arguments while pushing */
  argc = pushargs(NIL, args);
  xlpop();       /* now they are protected since they are on the stack */

  oldargc = xlargc;
  oldargv = xlargv;
  xlargc = argc;
  xlargv = xlfp + 3;
  val = (*f)();
  xlargc = oldargc;
  xlargv = oldargv;

  /* remove the call frame */
  xlsp = xlfp;
  xlfp = xlfp - (int)getfixnum(*xlfp);
  return(val);
}

LVAL xscallsubrvec(f, argc, argv)
     LVAL (*f) _((void)), *argv;
     int argc;
{
  LVAL *oldargv, val;
  int oldargc;
   
  pushargvec(NIL, argc, argv);
  oldargc = xlargc;
  oldargv = xlargv;
  xlargc = argc;
  xlargv = xlfp + 3;
  val = (*f)();
  xlargc = oldargc;
  xlargv = oldargv;

  /* remove the call frame */
  xlsp = xlfp;
  xlfp = xlfp - (int)getfixnum(*xlfp);
  return(val);
}

LVAL xscallsubr1(f, x)
     LVAL (*f) _((void)), x;
{
  return(xscallsubrvec(f, 1, &x));
}

LVAL xscallsubr2(f, x, y)
     LVAL (*f) _((void)), x, y;
{
  LVAL args[2];

  args[0] = x;
  args[1] = y;
  return(xscallsubrvec(f, 2, args));
}

LVAL xsfuncall1(fun, x)
     LVAL fun, x;
{
  pushargvec(fun, 1, &x);
  return(xlapply(1));
}

LVAL xsfuncall2(fun, x, y)
     LVAL fun, x, y;
{
  LVAL args[2];
  
  args[0] = x;
  args[1] = y;
  pushargvec(fun, 2, args);
  return(xlapply(2));
}

/* replicates a list n times */ 
int xsboolkey(key, dflt)
     LVAL key;
     int dflt;
{
  LVAL val;
  int result = dflt;
  
  if (xlgetkeyarg(key, &val)) result = ((val != NIL) ? TRUE : FALSE);
  return(result);
}
