#include <windows.h>
#include <dde.h>
#include <alloc.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "ledit.h"
#include "winutils.h"
#include "wxlisp.h"

/* command line arguments */
#define ARGLIMIT 10
static int argc = 1;
static char *argv[ARGLIMIT + 2] = {"WXLISP", ""};

/* structures for storing child data */
typedef struct {
  short cxClient;
  short cyClient;
  short type;
  int n;
  double *data;
} RECTDATA;
typedef RECTDATA NEAR *NPRECTDATA;

/* global variables */
static char szFrameClass[] = "MdiFrame";
static char szListenerClass[] = "MdiListenerChild";
static char szRectClass[]  = "MdiRectChild";
HANDLE hInst;
HWND hWndFrame, hWndClient;
static HWND hEditWnd, hEditFrame;
HMENU hMainMenu;
HMENU hWinMenu;
HANDLE hAccel;
int Exiting = FALSE;

static HWND hLSPEclient = 0;
static ATOM atomXLS, atomEval;
static CATCHBUF exit_tag;

/* forward declarations */
static BOOL CheckSystem(void);
static BOOL InitApplication(HANDLE);
static BOOL InitInstance(HANDLE, int);
BOOL InitApplDialogs(HANDLE);
BOOL InitInstDialogs(HANDLE);
BOOL InitApplGraphics(HANDLE);
BOOL InitInstGraphics(HANDLE);
long FAR PASCAL FrameWndProc(HWND, WORD, WORD, LONG);
BOOL FAR PASCAL AboutXLS(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL CloseEnumProc(HWND, LONG);
long FAR PASCAL ListenerWndProc(HWND, WORD, WORD, LONG);
long FAR PASCAL RectWndProc(HWND, WORD, WORD, LONG);
BOOL FAR PASCAL ClientWndProc(HWND, unsigned, WORD, LONG);
static void mainloop(void);

/* function prototypes */
extern void MSWDoIdleActions(void);
extern void xexit(void);
extern int IsLispMenuHandle(WORD);
extern void LispMenuUpdate(WORD);
extern int IsLispMenuItem(WORD);
extern void LispMenuSelect(WORD);
extern void xlsmain(int, char **);
extern char *string2stream(char *);
extern void readevalstream(char *);
extern void MSWCloseHelp(void);
extern void xlsigint(void);

#define LSGR_LINES 0
#define LSGR_POINTS 1
#define LSGR_MARGIN 10

int PASCAL WinMain(HANDLE hInstance,
		   HANDLE hPrevInstance,
		   LPSTR lpCmdLine,
		   int nCmdShow)
{
  MSG msg;

  /* check system characteristics */
  if (! CheckSystem()) return(FALSE);

  /* Try to cooperate with other running instances of the application */
  if (! hPrevInstance)
    if (! InitApplication(hInstance))
      return(FALSE);

  /* initialize the specific instance */
  if (! InitInstance(hInstance, nCmdShow))
    return(FALSE);

  /* parse the argument list into argv */
  {
    int i;
    char *p;

    argv[1] = calloc(strlen(lpCmdLine + 1), 1);
    strcpy(argv[1], lpCmdLine);
    p = argv[1];
    for (p = argv[1]; *p != '\0' && argc < ARGLIMIT;) {
      for (; *p != '\0' && isspace(*p); p++); // skip spaces
      if (*p != '\0') {
	argv[argc++] = p;
	for (; *p != '\0' && ! isspace(*p); p++); // skip non-spaces
	if (*p != '\0') *p++ = '\0';
      }
    }
  }

  if (Catch(&exit_tag) == 0)
    xlsmain(argc, argv);

  /* process orderly shutdown */
  Exiting = TRUE;
  while (GetMessage(&msg, 0, 0, 0)) {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }

  MSWCloseHelp();
  MSWGraphCleanup();
  MSWDLLCleanup();
  malloc_cleanup();
  return(msg.wParam);
}

void ExitXLS(void)
{
  Throw(&exit_tag, 1);
}

static BOOL CheckSystem(void)
{
  LONG flags = GetWinFlags();
  if (! flags & WF_PMODE) {
    MessageBox((HWND) NULL,
	       "XLISP-STAT must be run in protected mode.",
	       NULL,
	       MB_ICONHAND);
    return(FALSE);
  }
  return(TRUE);
}

static BOOL InitApplication(HANDLE hInstance)
{
  WNDCLASS wc;

  /* class structure for the MDI frame window */
  wc.style = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc = FrameWndProc;
  wc.cbClsExtra = 0;
  wc.cbWndExtra = 0;
  wc.hInstance = hInstance;
  wc.hIcon = LoadIcon(hInstance, "WXLSIcon");
  wc.hCursor = LoadCursor((HWND) NULL, IDC_ARROW);
  wc.hbrBackground = COLOR_APPWORKSPACE + 1; // *** looks weird
  wc.lpszMenuName = NULL;
  wc.lpszClassName = szFrameClass;
  if (! RegisterClass(&wc)) return(FALSE);

  /* class structure for the listener frame window */
  wc.style = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc = ListenerWndProc;
  wc.cbClsExtra = 0;
  wc.cbWndExtra = 0;
  wc.hInstance = hInstance;
  wc.hIcon = LoadIcon(hInstance, "LEditIcon");
  wc.hCursor = LoadCursor((HWND) NULL, IDC_ARROW);
  wc.hbrBackground = GetStockObject(WHITE_BRUSH);
  wc.lpszMenuName = NULL;
  wc. lpszClassName = szListenerClass;
  if (! RegisterClass(&wc)) return(FALSE);

  /* class structure for the Rect window */
  wc.style = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc = RectWndProc;
  wc.cbClsExtra = 0;
  wc.cbWndExtra = sizeof(LOCALHANDLE);
  wc.hInstance = hInstance;
  wc.hIcon = LoadIcon(hInstance, "GraphIcon");
  wc.hCursor = LoadCursor((HWND) NULL, IDC_ARROW);
  wc.hbrBackground = GetStockObject(WHITE_BRUSH);
  wc.lpszMenuName = NULL;
  wc. lpszClassName = szRectClass;
  if (! RegisterClass(&wc)) return(FALSE);

  if (! InitApplDialogs(hInstance)) return(FALSE);
  if (! InitApplGraphics(hInstance)) return(FALSE);

  return(TRUE);
}

static BOOL InitInstance(HANDLE hInstance, int nCmdShow)
{
  WNDCLASS wc;
  MDICREATESTRUCT mdicreate;
  RECT r;

  hInst = hInstance;

  InitLEditClass(mainloop);
  InitInstDialogs(hInstance);
  InitInstGraphics(hInstance);

  hAccel = LoadAccelerators(hInst, "MdiAccel");

  hMainMenu = LoadMenu(hInst, "MdiMenu");
  hWinMenu = GetSubMenu(hMainMenu, GetMenuItemCount(hMainMenu) - 1);

  /* create MDI frame for this instance */
  hWndFrame = CreateWindow(szFrameClass,
			   "XLISP-STAT",
			   WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
			   CW_USEDEFAULT,
			   CW_USEDEFAULT,
			   CW_USEDEFAULT,
			   CW_USEDEFAULT,
			   (HWND) NULL,
			   hMainMenu,
			   hInstance,
			   NULL);
  if (! hWndFrame) return(FALSE);

  hWndClient = GetWindow(hWndFrame, GW_CHILD);
  if (! hWndClient) {
    DestroyWindow(hWndFrame);
    return(FALSE);
  }

  ShowWindow(hWndFrame, nCmdShow);
  UpdateWindow(hWndFrame);

  /* create the listener frame */
  GetClientRect(hWndClient, (LPRECT) &r);
  mdicreate.szClass = szListenerClass;
  mdicreate.szTitle = "Listener";
  mdicreate.hOwner = hInst;
  mdicreate.x = CW_USEDEFAULT;
  mdicreate.y = CW_USEDEFAULT;
  mdicreate.cx = r.right - r.left;
  mdicreate.cy = CW_USEDEFAULT;
  mdicreate.style = 0;
  mdicreate.lParam = NULL;
  hEditFrame = (HWND) SendMessage(hWndClient,
				  WM_MDICREATE,
				  0,
				  (LONG) (LPMDICREATESTRUCT) &mdicreate);
  if (! hEditFrame) {
    DestroyWindow(hWndClient);
    DestroyWindow(hWndFrame);
    return(FALSE);
  }

  /* create the listener editor window pane */
  hEditWnd = CreateLEditWindow(hEditFrame, IDC_EDIT, hInst);
  if (! hEditWnd) {
    DestroyWindow(hEditFrame);
    DestroyWindow(hWndClient);
    DestroyWindow(hWndFrame);
    return(FALSE);
  }

  ShowWindow(hEditFrame, SW_SHOW);
  UpdateWindow(hEditFrame);
  SetFocus(hEditWnd);

  return(TRUE);
}

long FAR PASCAL FrameWndProc(HWND hWnd,
			     WORD message,
			     WORD wParam,
			     LONG lParam)
{
  static HWND hWndClient;
  FARPROC lpfnEnum, lpProcAbout;
  HWND hWndChild;
  CLIENTCREATESTRUCT clientcreate;
  double *x;
  int i, n;

  switch (message) {
  case WM_CREATE:
    clientcreate.hWindowMenu = hWinMenu;
    clientcreate.idFirstChild = IDM_FIRSTCHILD;
    hWndClient = CreateWindow("MDICLIENT",
			      NULL,
			      WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE,
			      0,
			      0,
			      0,
			      0,
			      hWnd,
			      1,
			      hInst,
			      (LPSTR) &clientcreate);
    return(0);
  case WM_COMMAND:
    switch (wParam) {
    case IDM_ABOUT:
      lpProcAbout = MakeProcInstance(AboutXLS, hInst);
      DialogBox(hInst, "AboutXLS", hWnd, lpProcAbout);
      FreeProcInstance(lpProcAbout);
      break;
#if defined(TESTING) || defined(NOGRAPHICS)
    case IDM_NEWPOINTS:
      n = 20;
      x = (double *) calloc(2 * n, sizeof(double));
      for (i = 0; i < 2 * n; i++)
	x[i] = ((double) rand()) / RAND_MAX;
      makeplot(n, x, LSGR_POINTS);
      return(0);
    case IDM_NEWLINES:
      n = 20;
      x = (double *) calloc(2 * n, sizeof(double));
      for (i = 0; i < 2 * n; i++)
	x[i] = ((double) rand()) / RAND_MAX;
      makeplot(n, x, LSGR_LINES);
      return(0);
#endif /* TESTING || NOGRAPHICS */
    case IDM_CLOSE:
      hWndChild = LOWORD(SendMessage(hWndClient, WM_MDIGETACTIVE, 0, 0));
      SendMessage(hWndChild, WM_CLOSE, 0, 0);
      return(0);
    case IDM_EXIT:
      SendMessage(hWnd, WM_CLOSE, 0, 0);
      return(0);
    case IDM_TILE:
      SendMessage(hWndClient, WM_MDITILE, 0, 0);
      return(0);
    case IDM_CASCADE:
      SendMessage (hWndClient, WM_MDICASCADE, 0, 0);
      return(0);
    case IDM_ARRANGE:
      SendMessage(hWndClient, WM_MDIICONARRANGE, 0, 0);
      return(0);
    case IDM_CLOSEALL:
      lpfnEnum = MakeProcInstance(CloseEnumProc, hInst);
      EnumChildWindows(hWndClient, lpfnEnum, 0);
      FreeProcInstance(lpfnEnum);
      return(0);
    default:
      if (IsLispMenuItem(wParam)) {
	LispMenuSelect(wParam);
	return(0);
      }
      hWndChild = LOWORD(SendMessage(hWndClient, WM_MDIGETACTIVE, 0, 0));
      if (IsWindow(hWndChild))
	SendMessage(hWndChild, WM_COMMAND, wParam, lParam);
      break;
    }
    break;
  case WM_INITMENUPOPUP:
    if (IsLispMenuHandle(wParam)) LispMenuUpdate(wParam);
    break;
  case WM_QUERYENDSESSION:
  case WM_CLOSE:
    if (OKorCancelBox("Do you really want to quit?") == IDCANCEL)
      return(0);
    Exiting = TRUE;
#ifdef DODO
    SendMessage(hWndClient, WM_MDIRESTORE, hEditFrame, 0);
    SendMessage(hWnd, WM_COMMAND, IDM_CLOSEALL, 0);
    SendMessage(hWndClient, WM_MDIDESTROY, hEditFrame, 0);
    if (NULL != GetWindow(hWndClient, GW_CHILD))
      return(0);
#endif DODO
    break;
  case WM_DDE_INITIATE:
    if (! hLSPEclient) {
      atomXLS = GlobalAddAtom("XLISP-STAT");
      atomEval = GlobalAddAtom("Eval");
      if (atomXLS == LOWORD(lParam) && atomEval == HIWORD(lParam)) {
	hLSPEclient = wParam;
	SendMessage(wParam, WM_DDE_ACK, hWnd, MAKELONG(atomXLS, atomEval));
      }
      else {
	GlobalDeleteAtom(atomXLS);
	GlobalDeleteAtom(atomEval);
      }
    }
    break;
  case WM_DDE_POKE:
    if (hLSPEclient) {
      DDEPOKE FAR *ddep;
      char *p, *stream = NULL;
      int i, n = 0;

      if (lParam) {
	ddep = (DDEPOKE FAR *) GlobalLock((HANDLE) lParam);
	if (ddep) {
	  p = (char *) ddep->Value;
	  n = strlen(p);
#ifdef TESTING
	  for (i = 0; i < n; i++) TTYPutC(p[i]);
	  TTYFlush();
#else
	  stream = string2stream(p);
#endif /* TESTING */
	}
	GlobalUnlock((HANDLE) lParam);
      }
      PostMessage(hLSPEclient, WM_DDE_ACK, hWnd, lParam);
      if (n > 0 && stream != NULL) {
#ifndef TESTING
	readevalstream(stream);
#endif /* TESTING */
      }
    }
    break;
  case WM_DDE_TERMINATE:
    PostMessage(hLSPEclient, WM_DDE_TERMINATE, hWnd, 0);
    hLSPEclient = (HWND) NULL;
    break;
  case WM_DESTROY:
    xexit();
    //PostQuitMessage(0);
    return(0);
  }

  /* pass unprocessed messages to DefFrameProc (not DefWindowProc) */
  return(DefFrameProc(hWnd, hWndClient, message, wParam, lParam));
}

/**** fix this up ****/
BOOL FAR PASCAL CloseEnumProc(HWND hWnd, LONG lParam)
{
  if (GetWindow(hWnd, GW_OWNER)) // check for icon title
    return(1);
  if (hWnd == hEditFrame)
    return(1);
  SendMessage(GetParent(hWnd), WM_MDIRESTORE, hWnd, 0);
  if (! SendMessage(hWnd, WM_QUERYENDSESSION, 0, 0))
    return(1);
  SendMessage(GetParent(hWnd), WM_MDIDESTROY, hWnd, 0);
  return(1);
}

long FAR PASCAL ListenerWndProc(HWND hWnd,
			     WORD message,
			     WORD wParam,
			     LONG lParam)
{
  switch (message) {
  case WM_CREATE:
    return(0);
  case WM_SIZE:
    MoveWindow(hEditWnd, 0, 0, LOWORD(lParam), HIWORD(lParam), TRUE);
    if (! IsIconic(hWnd)) { // ### to avoid problems with maximizing
      DefMDIChildProc(hWnd, message, wParam, lParam);
      SendMessage(hWndClient, WM_MDIRESTORE, hWnd, 0);
      return(0);
    }
    break;
  case WM_SETFOCUS:
    SetFocus(hEditWnd);
    break;
  case WM_COMMAND:
    switch (wParam) {
    case IDM_UNDO:
      WarningBox("Command Not Implemented");
      break;
    case IDM_CUT:
      TTYSelToClip();
      TTYClearSel();
      break;
    case IDM_COPY:
      TTYSelToClip();
      break;
    case IDM_PASTE:
      TTYPasteFromClip();
      break;
    case IDM_CLEAR:
      TTYClearSel();
      break;
    case IDM_COPYPASTE:
      TTYSelToClip();
      TTYPasteFromClip();
      break;
    case IDC_EDIT:
      if (HIWORD(lParam) == EN_ERRSPACE) {
	WarningBox("Out of memory");
	TTYTrimBuffer();
      }
      break;
    case IDM_TOPLEVEL:
      xlsigint();
      break;
    }
    return(0);
  case WM_MDIACTIVATE:
    return(0);
  case WM_QUERYENDSESSION:
    break;
  case WM_CLOSE:
    ShowWindow(hWnd, SW_MINIMIZE);
    return(0);
  case WM_DESTROY:
    return(0);
  }
  return(DefMDIChildProc(hWnd, message, wParam, lParam));
}

long FAR PASCAL RectWndProc(HWND hWnd,
			    WORD message,
			    WORD wParam,
			    LONG lParam)
{
  LOCALHANDLE hRectData;
  NPRECTDATA npRectData;

  switch (message) {
  case WM_CREATE:
    hRectData = LocalAlloc(LMEM_MOVEABLE | LMEM_ZEROINIT, sizeof(RECTDATA));
    SetWindowWord(hWnd, 0, hRectData);
    return(0);
  case WM_SIZE:
    hRectData = GetWindowWord(hWnd, 0);
    if (hRectData) {
      npRectData = (NPRECTDATA) LocalLock(hRectData);
      if (npRectData) {
	npRectData->cxClient = LOWORD(lParam);
	npRectData->cyClient = HIWORD(lParam);
	LocalUnlock(hRectData);
      }
    }
    if (! IsIconic(hWnd)) { // ### to avoid problems with maximizing
      DefMDIChildProc(hWnd, message, wParam, lParam);
      SendMessage(hWndClient, WM_MDIRESTORE, hWnd, 0);
      return(0);
    }
    break;
  case WM_PAINT:
    {
      HDC hDC;
      PAINTSTRUCT ps;
      short left, bottom, width, height;
      int i, ix, iy, n, type;
      double *x, *y;

      hRectData = GetWindowWord(hWnd, 0);
      if (hRectData) {
	npRectData = (NPRECTDATA) LocalLock(hRectData);
	if (npRectData) {
	  width = npRectData->cxClient - 2 * LSGR_MARGIN;
	  if (width < 0) width = 0;
	  height = npRectData->cyClient - 2 * LSGR_MARGIN;
	  if (height < 0) height = 0;

	  left = LSGR_MARGIN;
	  bottom = LSGR_MARGIN + height;

	  n = npRectData->n;
	  type = npRectData->type;
	  x = npRectData->data;
	  y = x + n;

	  hDC = BeginPaint(hWnd, &ps);
	  if (type == LSGR_POINTS) {
	    for (i = 0; i < n; i++) {
	      ix = left + x[i] * width;
	      iy = bottom - y[i] * height;
	      TextOut(hDC, ix, iy, "*", 1);
	    }
	  }
	  else if (n > 0) {
	    ix = left + x[0] * width;
	    iy = bottom - y[0] * height;
	    MoveTo(hDC, ix, iy);
	    for (i = 1; i < n; i++) {
	      ix = left + x[i] * width;
	      iy = bottom - y[i] * height;
	      LineTo(hDC, ix, iy);
	    }
	  }
	  EndPaint(hWnd, &ps);

	  LocalUnlock(hRectData);
	}
      }
      return(0);
    }
  case WM_MDIACTIVATE:
    return(0);
  case WM_DESTROY:
    if (Exiting) return(0);
    hRectData = GetWindowWord(hWnd, 0);
    if (hRectData) {
      npRectData = (NPRECTDATA) LocalLock(hRectData);
      if (npRectData) {
	if (npRectData->data) free(npRectData->data);
	LocalFree(hRectData);
      }
    }
    return(0);
  }
  return(DefMDIChildProc(hWnd, message, wParam, lParam));
}

BOOL FAR PASCAL AboutXLS(hDlg, message, wParam, lParam)
	HWND hDlg;
	unsigned message;
	WORD wParam;
	LONG lParam;
{
  switch(message) {
  case WM_INITDIALOG:
    return(TRUE);
  case WM_COMMAND:
    if (wParam == IDOK || wParam == IDCANCEL) {
      EndDialog(hDlg, TRUE);
      return(TRUE);
    }
    else break;
  }
  return(FALSE);
}

#ifdef TESTING
xlsmain()
{
  int c;

  while (TRUE) {
    TTYPutStr("=> ");
    while ((c = TTYGetC()) != '\n') TTYPutC(c);
    TTYPutC('\n');
  }
}

xexit()
{
  Exiting = TRUE;
  exit(1);
  return(0);
}

void xlsigint(void)
{
  SysBeep(10);
  TTYPutStr("[back to top level]\n");
  return(0);
}
#endif TESTING

static void mainloop(void)
{
  MSG msg;

#ifdef DODO
  while (GetMessage(&msg, NULL, 0, 0)) {
    if(! TranslateMDISysAccel(hWndClient, &msg)
       && ! TranslateAccelerator(hWndFrame, hAccel, &msg)) {
      TTYFlushOutput();
      TranslateMessage(&msg);
      DispatchMessage(&msg);
      if (TTYHasInput()) break;
    }
  }
#endif DODO
  while (1) {
    if (PeekMessage(&msg, 0, 0, 0, PM_REMOVE)) {
      if(! TranslateMDISysAccel(hWndClient, &msg)
	 && ! TranslateAccelerator(hWndFrame, hAccel, &msg)) {
	TTYFlushOutput();
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	if (TTYHasInput()) break;
      }
    }
    else MSWDoIdleActions();
  }
}

void oscheck()
{
  MSG msg;

  if (HIBIT(GetAsyncKeyState(VK_CONTROL))
      && HIBIT(GetAsyncKeyState('\C'))) {
    FlushAllEvents();
    xlsigint();
 }
#ifdef DODO
  if (PeekMessage(&msg, NULL, WM_KEYDOWN, WM_KEYDOWN, PM_NOREMOVE)
      && msg.wParam == VK_CONTROL) {
    while (PeekMessage(&msg, NULL, WM_KEYDOWN, WM_KEYDOWN, PM_REMOVE)) {
      if (msg.wParam == VK_C) {
	FlushAllEvents();
	xlsigint();
      }
    }
  }
#endif
}

#if defined(TESTING) || defined(NOGRAPHICS)
makeplot(int n, double *x, int type)
{
  HWND hWnd;
  MDICREATESTRUCT mdicreate;
  LOCALHANDLE hRectData;
  NPRECTDATA npRectData;
  int i;
  double xlow, xhigh, ylow, yhigh, *y = x + n;

  if (n <= 0) {
    xlow = ylow = 0.0;
    xhigh = yhigh = 1.0;
  }
  else {
    xlow = xhigh = x[0]; ylow = yhigh = y[0];
    for (i = 1; i < n; i++) {
      if (x[i] < xlow) xlow = x[i];
      else if (x[i] > xhigh) xhigh = x[i];
      if (y[i] < ylow) ylow = y[i];
      else if (y[i] > yhigh) yhigh = y[i];
    }
  }
  if (xlow >= xhigh) { xlow -= 0.5; xhigh = xlow + 1.0; }
  if (ylow >= yhigh) { ylow -= 0.5; yhigh = ylow + 1.0; }
  for (i = 0; i < n; i++) {
    x[i] = (x[i] - xlow) / (xhigh - xlow);
    y[i] = (y[i] - ylow) / (yhigh - ylow);
  }

  mdicreate.szClass = szRectClass;
  mdicreate.szTitle = (type == LSGR_POINTS) ? "Points" : "Lines";
  mdicreate.hOwner = hInst;
  mdicreate.x = CW_USEDEFAULT;
  mdicreate.y = CW_USEDEFAULT;
  mdicreate.cx = CW_USEDEFAULT;
  mdicreate.cy = CW_USEDEFAULT;
  mdicreate.style = 0;
  mdicreate.lParam = NULL;
  hWnd = SendMessage(hWndClient,
		    WM_MDICREATE,
		    0,
		    (LONG) (LPMDICREATESTRUCT) &mdicreate);
  hRectData = GetWindowWord(hWnd, 0);
  if (hRectData) {
    npRectData = (NPRECTDATA) LocalLock(hRectData);
    if (npRectData) {
      npRectData->n = n;
      npRectData->data = x;
      npRectData->type = type;
      LocalUnlock(hRectData);
      InvalidateRect(hWnd, NULL, TRUE);
    }
  }
}
#endif /* TESTING || NOGRAPHICS */

#ifdef TESTING
HANDLE FAR PASCAL OpenFileDlg(HWND hWnd,
			      unsigned message,
			      WORD wParam,
			      LONG lParam)
{
  return(0);
}

int FAR PASCAL SaveFileDlg(HWND hWnd,
			   unsigned message,
			   WORD wParam,
			   LONG lParam)
{
  return(0);
}

HANDLE FAR PASCAL XLSDlgProc(HWND hWnd,
			     unsigned message,
			     WORD wParam,
			     LONG lParam)
{
  return(0);
}

HANDLE FAR PASCAL IVWinProc(HWND hWnd,
			    unsigned message,
			    WORD wParam,
			    LONG lParam)
{
  return(0);
}

HANDLE FAR PASCAL RSZWinProc(HWND hWnd,
			     unsigned message,
			     WORD wParam,
			     LONG lParam)
{
  return(0);
}

IsLispMenuItem(WORD wParam) { return(FALSE); }
IsLispMenuHandle(WORD wParam) { return(FALSE); }
LispMenuSelect(WORD wParam) {}
LispMenuUpdate(WORD wParam) {}
BOOL InitApplDialogs(HANDLE h) { return(TRUE); }
BOOL InitInstDialogs(HANDLE h) { return(TRUE); }
BOOL InitApplGraphics(HANDLE h) { return(TRUE); }
BOOL InitInstGraphics(HANDLE h) { return(TRUE); }
void MSWDoIdleActions(void) {};
void MSWCloseHelp(void) {};
#endif /* TESTING */

// access string resources created by spp
char *GetStringResource(int id)
{
  static char gsr_buffer[256];

  if (LoadString(hInst, id, (LPSTR)gsr_buffer, 255) < 1) {
    SysBeep(10);
    WarningBox("LoadString Error -- bailing out.");
    xexit();
  }
  return gsr_buffer;
}
