#include "mswivwin.h"
#include "wxlisp.h"

extern HWND hWndFrame, hWndClient;
extern LVAL s_true, s_location, s_size, s_msw_help_file, s_context, s_help,
  s_index, s_key, s_quit;

extern LVAL integer_list_2(int, int);

static LVAL MSWMESSAGE(int which)
{
  xllastarg();
  SendMessage(hWndFrame, WM_COMMAND, which, 0);
  return(NIL);
}

LVAL xsabout_xlisp_stat() { return(MSWMESSAGE(IDM_ABOUT)); }

LVAL msw_cut() {  return(MSWMESSAGE(IDM_CUT)); }
LVAL msw_copy() { return(MSWMESSAGE(IDM_COPY)); }
LVAL msw_paste() { return(MSWMESSAGE(IDM_PASTE)); }
LVAL msw_clear() { return(MSWMESSAGE(IDM_CLEAR)); }
LVAL msw_copy_paste() { return(MSWMESSAGE(IDM_COPYPASTE)); }

LVAL msw_tile() { return(MSWMESSAGE(IDM_TILE)); }
LVAL msw_cascade() { return(MSWMESSAGE(IDM_CASCADE)); }
LVAL msw_closeall() { return(MSWMESSAGE(IDM_CLOSEALL)); }
LVAL msw_arrange_icons() { return(MSWMESSAGE(IDM_ARRANGE)); }

LVAL msw_exit() {  return(MSWMESSAGE(IDM_EXIT)); }

LVAL msw_win_exec()
{
  LPSTR s;
  LVAL lshow;
  int show, result;

  s = (LPSTR) getstring(xlgastring());
  if (moreargs()) {
    lshow = xlgetarg();
    if (lshow == s_true) show = SW_SHOWNORMAL;
    else if (lshow == NIL) show = SW_SHOWMINIMIZED;
    else if (fixp(lshow)) show = (int) getfixnum(xlgafixnum());
    else xlbadtype(lshow);
  }
  else show = SW_SHOWNORMAL;

  result = WinExec(s, show);
  return(result > 32 ? s_true : cvfixnum((FIXTYPE) result));
}

void MSWCloseHelp(void)
{
  LVAL fname = getvalue(s_msw_help_file);

  if (stringp(fname)) {
    WinHelp(hWndFrame, getstring(fname), HELP_QUIT, NULL);
    setvalue(s_msw_help_file, NIL);
  }
}

LVAL msw_win_help()
{
  LVAL cmd, fname, data;
  int result;

  fname = xlgastring();
  cmd = xlgasymbol();

  if (cmd == s_context) {
    data = xlgafixnum();
    result = WinHelp(hWndFrame, getstring(fname), HELP_CONTEXT, getfixnum(data));
    setvalue(s_msw_help_file, fname);
  }
  else if (cmd == s_help) {
    result = WinHelp(hWndFrame, getstring(fname), HELP_HELPONHELP, NULL);
    setvalue(s_msw_help_file, fname);
  }
  else if (cmd == s_index) {
    result = WinHelp(hWndFrame, getstring(fname), HELP_INDEX, NULL);
    setvalue(s_msw_help_file, fname);
  }
  else if (cmd == s_key) {
    data = xlgastring();
    result = WinHelp(hWndFrame, getstring(fname), HELP_KEY, (DWORD) getstring(data));
    setvalue(s_msw_help_file, fname);
  }
  else if (cmd == s_quit) {
    result = WinHelp(hWndFrame, getstring(fname), HELP_QUIT, NULL);
    setvalue(s_msw_help_file, NIL);
  }
  else xlfail("unknown help command");

  return(result ? s_true : NIL);
}

LVAL msw_free_mem(void)
{
  xllastarg();
  return(cvfixnum((FIXTYPE) GetFreeSpace(0)));
}

LVAL msw_cursor_size(void)
{
  xllastarg();
  return(integer_list_2(GetSystemMetrics(SM_CXCURSOR),
			GetSystemMetrics(SM_CYCURSOR)));
}

void StShowWindow(IVIEW_WINDOW w)
{
  SendMessage((HWND) w, WM_COMMAND, IDC_SHOWWINDOW, 0);
}

void StHideWindow(IVIEW_WINDOW w)
{
  SendMessage((HWND) w, WM_COMMAND, IDC_HIDEWINDOW, 0);
}

void StWSetTitle(IVIEW_WINDOW w, char *str)
{
  SetWindowText((HWND) w, str);
}

void StGetScreenSize(int *width, int *height)
{
  if (width) *width = GetSystemMetrics(SM_CXSCREEN);
  if (height) *height = GetSystemMetrics(SM_CYSCREEN);
}

int StScreenHasColor(void)
{
  static int inited = FALSE, hasColor = FALSE;
  if (! inited) {
    HDC hDC;
    int nPlanes, nBitsPixel, nColors;
    hDC = GetDC(hWndFrame);
    nPlanes = GetDeviceCaps(hDC, PLANES);
    nBitsPixel = GetDeviceCaps(hDC, BITSPIXEL);
    ReleaseDC(hWndFrame, hDC);
    nColors = 1 << (nPlanes * nBitsPixel);
    hasColor = (nColors > 1) ? TRUE : FALSE;
    inited = TRUE;
  }
  return(hasColor);
}

int StHasWindows(void)
{
  return(TRUE);
}

void StFlushGraphics(void) {}

/* assumes border width and border height of dialogs are the same */
void StWSetLocation(IVIEW_WINDOW w, int left, int top, int frame)
{
  RECT fr, cr;
  int bw, ch, width, height;

  if (IsChild(hWndClient, (HWND) w) && IsIconic((HWND) w)) return;

  GetWindowRect((HWND) w, &fr);
  if (! frame) {
    GetClientRect((HWND) w, &cr);
    bw = ((fr.right - fr.left) - (cr.right - cr.left)) / 2;
    ch = (fr.bottom - fr.top) - (cr.bottom - cr.top) - bw;
    left -= bw;
    top -= ch;
  }
  width = fr.right - fr.left;
  height = fr.bottom - fr.top;
  MoveWindow((HWND) w, left, top, width, height, TRUE);
}

/* assumes border width and border height are the same */
void StWGetLocation(IVIEW_WINDOW w, int *pleft, int *ptop, int frame)
{
  RECT fr, cr;
  int bw, ch;
  POINT loc;
  LVAL location;

  if (IsChild(hWndClient, (HWND) w) && IsIconic((HWND) w)) {
    location = slot_value(GETWINOBJECT(w), s_location);
    if (location != NIL) loc = ListToPoint(location);
    else {
      loc.x = 50;
      loc.y = 50;
    }
  }
  else {
    GetWindowRect((HWND) w, &fr);
    if (! frame) {
      GetClientRect((HWND) w, &cr);
      bw = ((fr.right - fr.left) - (cr.right - cr.left)) / 2;
      ch = (fr.bottom - fr.top) - (cr.bottom - cr.top) - bw;
      fr.left += bw;
      fr.top += ch;
    }
    loc.x = fr.left;
    loc.y = fr.top;
    if (IsChild(hWndClient, (HWND) w))
      ScreenToClient(hWndClient, &loc);
  }
  if (pleft) *pleft = loc.x;
  if (ptop) *ptop = loc.y;
}

void StWSetSize(IVIEW_WINDOW w, int width, int height, int frame)
{
  RECT fr, cr;
  POINT loc;

  if (IsChild(hWndClient, (HWND) w) && IsIconic((HWND) w)) return;

  GetWindowRect((HWND) w, &fr);
  if (! frame) {
    GetClientRect((HWND) w, &cr);
    width += (fr.right - fr.left) - (cr.right - cr.left);
    height += (fr.bottom - fr.top) - (cr.bottom - cr.top);
  }
  loc.x = fr.left;
  loc.y = fr.top;
  if (IsChild(hWndClient, (HWND) w))
    ScreenToClient(hWndClient, &loc);
  MoveWindow((HWND) w, loc.x, loc.y, width, height, TRUE);
}

void StWGetSize(IVIEW_WINDOW w, int *pwidth, int *pheight, int frame)
{
  RECT r;
  int bw, ch;
  POINT sz;
  LVAL size;

  if (IsChild(hWndClient, (HWND) w) && IsIconic((HWND) w)) {
    size = slot_value(GETWINOBJECT(w), s_size);
    if (size != NIL) sz = ListToPoint(size);
    else {
      sz.x = 250;
      sz.y = 250;
    }
  }
  else {
    if (frame) GetWindowRect((HWND) w, &r);
    else GetClientRect((HWND) w, &r);
    sz.x = r.right - r.left;
    sz.y = r.bottom - r.top;
  }
  if (pwidth) *pwidth = sz.x;
  if (pheight) *pheight = sz.y;
}
