/* macstuff.c - macintosh interface routines for xlisp-stat */

#include "time.h"
#include "xlisp.h"
#include "xlstat.h"
#include "xlgraph.h"
#include "version.h"

# define arrow qd.arrow

#ifdef applec
# ifdef mc68881
#  ifndef _MC68881_
#   define _MC68881_
#  endif _MC68881_
# else
#  ifdef _MC68881_
#   undef _MC68881_
#  endif _MC68881_
# endif mc68881
#else
# if (__option(mc68881))
#  ifndef _MC68881_
#   define _MC68881_
#  endif _MC68881_
# else
#  ifdef _MC68881_
#   undef _MC68881_
#  endif _MC68881_
# endif mc68881
#endif /* applec */

# include "TransEdit.h"


/* resource numbers */
#define ttyWindRes  1001
#define GC_CURS_RES 1800

/* externals */
extern FILEP tfp;
extern int in_send;
extern LVAL s_input_stream, s_event_queue;
extern LVAL s_breakenable;
#ifdef CONDITIONS
extern LVAL s_condition_hook;
#endif /* CONDITIONS */

/* forward declarations */
#ifdef _MC68881_
static VOID check_MC68881 _((void));
#endif
static VOID background_tasks _((void));
LOCAL VOID waitforline _((void));
static VOID warn_low_memory _((long space));
#ifdef FILETABLE
LOCAL FILEP osopen(const char *name, const char *mode);
#endif /* FILETABLE */

/* local variables */
static time_t time_stamp;
WindowPtr ttyWind;
static LVAL input_stream;
/* -- local variables */
#define LBSIZE  200
static  char    lbuf[LBSIZE];
static  int     lindex;
static  int     lcount;

VOID osinit(name)
  char *name;
{
  long size;
  
  time_stamp = time((time_t *) 0);

  if ((char *) GetApplLimit() - (char *) GetZone() < 1200000){
	SetApplLimit(GetApplLimit() - 2048);SysBeep(10);}
  else
    SetApplLimit(GetApplLimit() - /*4*/6 * 32768);
  
  MaxApplZone();

  SkelInit ();
  SetEWindowCreator ('X1St');

#ifdef _MC68881_
  check_MC68881();
#endif _MC68881_
  
  get_default_volume();
  
  if (ttyWind == nil) {
    Rect r;
    SetRect(&r, 10, 40, 500, 320);
    make_listener_window(r);
  }
  MaxMem(&size);
  /*SkelEventHook(event_hook);*/
  SkelBackground((ProcPtr) background_tasks);

  lposition = 0;
  lindex  = 0;
  lcount  = 0;

  TtyPrint(name);
  sprintf(buf, "\nXLISP-STAT 2.1 Release %d.%d%s.\n",
	  XLS_MAJOR_RELEASE, XLS_MINOR_RELEASE, XLS_RELEASE_STATUS);
  TtyPrint(buf);
  sprintf(buf, "Copyright (c) 1989-1994, by Luke Tierney.\n"); 
  TtyPrint(buf);
  sprintf(buf, "Initialization may take a moment.\n\n");
  TtyPrint(buf);
}

VOID osfinish()
{
  CONTEXT cntxt;
  xlbegin(&cntxt,CF_TOPLEVEL|CF_CLEANUP|CF_BRKLEVEL,(LVAL)1);
  if (setjmp(cntxt.c_jmpbuf))
    exit(0);
  if (s_breakenable != NULL) setvalue(s_breakenable, NIL);
#ifdef CONDITIONS
  if (s_condition_hook != NULL) setvalue(s_condition_hook, NIL);
#endif /* CONDITIONS */
  while(! ClobberEWindows())	/* deal with any open edit windows */
    SysBeep(10);
  SkelClobber ();		/* throw away windows and menus */
}

VOID osreset()
{
  in_send = FALSE;
  StGWResetBuffer();
}

VOID xoserror(msg)
     char *msg;
{
#ifdef DODO
  char line[100],*p;
  sprintf(line,"error: %s\n",msg);
  for (p = line; *p != '\0'; ++p)
    ostputc(*p);
#endif DODO
  strcpy(buf, msg);
  CtoPstr(buf);
  FakeAlert ((StringPtr) buf, "\p", "\p", "\p", 1, 1, "\pOK", "\p", "\p");
}

#ifdef DODO /**** need this stuff if no FILETABLE */
FILE *osaopen(name,mode)
  char *name,*mode;
{
  short vref;
  
  if (mode[0] == 'w' || mode[0] == 'a') {
    /*** this may need to be cleaned up to catch errors and handle append mode ***/
	GetVol((StringPtr) buf, &vref);
    CtoPstr(name);
	Create((StringPtr) name, vref, 'X1St', 'TEXT');
    PtoCstr((StringPtr) name);
  }
  return (fopen(name,mode));
}

#ifdef THINK_C
FILE *osbopen(name,mode)
  const char *name,*mode;
{
  char nmode[4];
  strcpy(nmode,mode); strcat(nmode,"b");
  return (fopen(name,nmode));
}
#endif /* THINK_C */
#endif DODO

#ifdef FILETABLE
extern VOID gc();

/***** fix this */
int truename(name, rname)
char *name,*rname;
{
#ifdef DODO
  char *cp;
  char pathbuf[FNAMEMAX+1];   /* copy of path part of name */
  char curdir[FNAMEMAX+1];    /* current directory */
  char *fname;                /* pointer to file name part of name */

  /* check for absolute path (good news!) */
    
    if (*name == '/') {
        strcpy(rname, name);
    }
    else {
        strcpy(pathbuf, name);
        if ((cp = strrchr(pathbuf, '/')) != NULL) { /* path present */
            cp[1] = 0;
            fname = strrchr(name, '/') + 1;
        }
        else {
            pathbuf[0] = 0;
            fname = name;
        }

        /* get the current directory of the selected drive */
        
        getcwd(curdir, FNAMEMAX);

        /* peel off "../"s */
        while (strncmp(pathbuf, "../", 3) == 0) {
            if (*curdir == 0) return FALSE;     /* already at root */
            strcpy(pathbuf, pathbuf+3);
            if ((cp=strrchr(curdir+1, '/')) != NULL)
                *cp = 0;    /* peel one depth of directories */
            else
                *curdir = 0;    /* peeled back to root */
        }
        
        /* allow for a "./" */
        if (strncmp(pathbuf, "./", 2) == 0)
            strcpy(pathbuf, pathbuf+2);
        
        /* final name is /curdir/pathbuf/fname */

        if ((int)(strlen(pathbuf)+strlen(curdir)+strlen(fname)+4) > FNAMEMAX) 
            return FALSE;
        
        if (*curdir)
            sprintf(rname, "%s/%s%s", curdir, pathbuf, fname);
        else
            sprintf(rname, "/%s%s", pathbuf, fname);
    }
    
    return TRUE;
#endif
  return FALSE;
}

int getslot()
{
    int i=0;
    
    for (; i < FTABSIZE; i++)   /* look for available slot */
        if (filetab[i].fp == NULL) return i;
    
    gc();   /* is this safe??????? */

    for (; i < FTABSIZE; i++) /* try again -- maybe one has been freed */
        if (filetab[i].fp == NULL) return i;

    xlfail("too many open files");
    
    return 0;   /* never returns */
}

/**** fix -- needs creation stuff */
FILEP osaopen(name, mode)
     const char *name, *mode;
{
  return osopen(name, mode);
}

/**** fix -- needs binary stuff for THINK C */
FILEP osbopen(name, mode)
     const char *name, *mode;
{
  char m[3];
  strcpy(m, mode);
  strcat(m, "b");
  return osopen(name, m);
}

LOCAL FILEP osopen(name, mode)
     const char *name, *mode;
{
  int i=getslot();
  char namebuf[FNAMEMAX+1];
  FILE *fp;

  if (!truename((char *)name, namebuf))
    strcpy(namebuf, name);  /* should not happen */

  if ((filetab[i].tname = (char *)malloc(strlen(namebuf)+1)) == NULL) {
    xlfail("insufficient memory");
  }

  if ((fp = fopen(name,mode)) == NULL) {
  	free(filetab[i].tname);
    return CLOSED;
  }
  
  filetab[i].fp = fp;

  strcpy(filetab[i].tname, namebuf);

  return i;
}
    
VOID osclose(f)
  FILEP f;
{
    if (filetab[f].fp != NULL)
        fclose(filetab[f].fp);
    /* remind stdin/stdout/stderr */
    if (f>2 && filetab[f].tname != NULL)
        free(filetab[f].tname);
    filetab[f].tname = NULL;
    filetab[f].fp = NULL;
}
#endif

int ostgetc()
{
  int ch;

  while (! ustreamp(input_stream) || (ch = xlgetc(input_stream)) == EOF) {
    waitforline();
    lposition = 0;
  }
  if (tfp != CLOSED) OSPUTC(ch, tfp);
  if (ch == RETURNCHAR) ch = '\n';
  return (ch);
}

VOID ostputc(ch)
  int ch;
{
  if (ch == '\n') lposition = 0;
  else lposition++;
  ch = (ch == '\n') ? RETURNCHAR : ch;
  if (tfp != CLOSED) OSPUTC(ch, tfp);
  TtyPutc(ch);
}

/* osflush - flush the input line buffer */
VOID osflush()
{
  ostputc('\n');
  while (ustreamp(input_stream) && xlgetc(input_stream) != EOF)
    ;
  lindex = lcount = 0;
}

VOID osforce(fp)
     FILEP fp;
{
#ifdef FILETABLE
  if (fp == CONSOLE) TtyFlush();
  else fflush(filetab[fp].fp);
#else
  if (fp == CONSOLE) TtyFlush();
  else fflush(fp);
#endif /* FILETABLE */
}

/* oscheck - check for control characters during execution */
/* command-period is the interrupt for the mac             */
VOID oscheck()
{
  EventRecord theEvent;
  char c;
  static EventRecord lastEvent;
  
  if (EventAvail(autoKeyMask, &theEvent))
    if (theEvent.when == lastEvent.when) {
      GetNextEvent(autoKeyMask, &theEvent);
      c = theEvent.message & charCodeMask;
      if ((theEvent.modifiers & cmdKey) && (c == '.')) {
	    FlushEvents (everyEvent - diskMask, 0 );      
        xlsigint();
      }
    }
  else lastEvent = theEvent;
}

VOID ossymbols()
{
  statsymbols();
}

#ifdef DODO
VOID osfinit()
{
  statfinit();
  warn_low_memory(250000);
}
#endif /* DODO */

/*
  Show a window if it's not visible.  Select the window FIRST, then
  show it, so that it comes up in front.  Otherwise it will be drawn
  in back then brought to the front, which is ugly.
*/

VOID MyShowWindow (wind)
  WindowPeek wind;
{
  SelectWindow ((WindowPtr) wind);
  ShowWindow ((WindowPtr) wind);
}

LOCAL VOID waitforline()
{
  SkelMain ();
}
	
VOID getttyline(s)
	LVAL s;
{
  input_stream = getvalue(s_input_stream);
  SkelWhoa();
}

static VOID background_tasks()
{
  LVAL task, queue, oldenv, oldfenv;
    
  queue = getvalue(s_event_queue);
  if (consp(queue)) {
  
    /* set the lexical environment to null */
    xlstkcheck(2);
    xlsave(oldenv);
    xlsave(oldfenv);
    oldenv = xlenv; xlenv = NIL;
    oldfenv = xlfenv; xlfenv = NIL;

    task = car(queue);
  	setvalue(s_event_queue, cdr(queue));
  	xleval(task);

    /* reset the environment */
    xlenv = oldenv;
    xlfenv = oldfenv;
    xlpopn(2);
  }
}

VOID set_gc_cursor(on)
	int on;
{
  static Cursor;
  CursHandle c;
  
  if (on && (c = GetCursor(GC_CURS_RES)) != nil) SetCursor(*c);
  else {
    SetCursor(&arrow);
	oscheck();
    warn_low_memory(75000);
  }
}

VOID enable_interrupts() {}
VOID disable_interrupts() {}

max(x, y)
	int x, y;
{
  return((x > y) ? x : y);
}

min(x, y)
	int x, y;
{
  return((x < y) ? x : y);
}

#ifdef DODO
int is_small_machine() { return(FreeMem() < 600000); }
#endif DODO

#define TIMEGAP 120L
#ifdef applec
#define WARNSTRING "\pMemory is down to %ldK. \nClose plots and \"undef\" variables."
#endif /* applec */
#ifdef THINK_C
#define WARNSTRING "\pMemory is down to %ldK. \rClose plots and \"undef\" variables."
#endif /* THINK_C */
unsigned long time();

static VOID warn_low_memory(space)
	long space;
{
  char s[100];
  unsigned long tm;
  static unsigned long old_tm = 0L;
  static int inited = FALSE;
  long free;
  
  if (FreeMem() < space) {
    MaxMem(&free);
    free = FreeMem();
    if (free < space) {
      tm = time((unsigned long *) NULL);
      if (! inited || tm > old_tm + TIMEGAP) {
        old_tm = tm;
        sprintf(s, (char *) WARNSTRING, free / 1000);
        FakeAlert ((StringPtr) s, "\p", "\p", "\p", 1, 1, "\pOK", "\p", "\p");
      }
      inited = TRUE;
    }
  }
}

VOID maximum_memory()
{
  long size;
  MaxMem(&size);
}

#ifdef _MC68881_
static VOID check_MC68881()
{
  SysEnvRec r;

  SysEnvirons(1, &r);
  if (! r.hasFPU) {
    FakeAlert ("\pThis version requres the MC68881", "\p", "\p", "\p",
               1, 1, "\pOK", "\p", "\p");
    exit(1);
  }
}
#endif _MC68881_

#ifndef HZ
#define HZ 60
#endif

unsigned long ticks_per_second() { return((unsigned long) HZ); }

unsigned long run_tick_count()
{
  return((unsigned long) TickCount());
}

unsigned long real_tick_count() 
{
  return((unsigned long) (60L * (time((unsigned long *) NULL) - time_stamp)));
}

unsigned long system_tick_count()
{
  return((unsigned long) (time((unsigned long *) NULL)));
}

/* there ought to be a sensible way to do this, but I can't figure it out yet */
void get_directory(s)
	char *s;
{
  strcpy(s, "");
}

#undef SysBeep
VOID SYSBEEPMPW(x)
	int x;
{
  SysBeep(x);
}

int renamebackup(name) char *name; { return(TRUE); }

#ifdef THINK_C
VOID fsetfileinfo (fname, creator, type)
      char *fname;
      OSType creator, type;
{
  FInfo finfo;
  short vol;
  GetVol((StringPtr) buf, &vol);
  strcpy(buf, fname);
  CtoPstr(buf);
  GetFInfo((StringPtr) buf, vol, &finfo);
  finfo.fdCreator = creator;
  finfo.fdType = type;
  SetFInfo((StringPtr) buf, vol, &finfo);
}
#endif
