; initialization file for XLISP-STAT 2.1

(defun xlisp::small-machine-p () nil)
(export 'xlisp::small-machine-p 'xlisp)

; disable strict keyword checking
(setf *strict-keywords* nil)

; restore old printing
;(setf *float-format* "%g")

; enable macro displacement
(setf *displace-macros* t)

; load in lisp files
(load "common")
(load "loadfsl")
(load "conditns")

; initialize to disable breaks and trace back
;(setf *breakenable* t)
;(setf *tracenable* t)
;(setf *tracelimit* 1)
;(setf *baktrace-print-arguments* nil)
(setf *interrupt-action* #'top-level)
(setf *debug-print-length* 4)
(setf *debug-print-level* 3)

(setf xlisp::*default-handler*
      #'(lambda (c)
	  (when (and (null *breakenable*) (typep c 'error))
		(format *error-output* "~&Error: ~a~%" c)
		(let ((f (xlisp::debug-fun)))
		  (if f (format *error-output* "Happened in: ~s~%" f)))
		(abort))))

; load xlispstat objects and related functions
(require "help")
(require "objects")
(require "menus")

; load statistics and graphics functions
(require "dialogs")
(require "stats")
(require "graphics")
(require "regress")
(require "autoload")

(in-package "XLISP")

(defvar *help-file-name*)
(defvar *help-stream*)
(defvar *line-length* 78 "Line length used in printing help messages")
(defvar *help-loaded* nil)

(defun initialize-system ()
  (setf *help-file-name*
	(if *default-path*
	    (concatenate 'string *default-path* "xlisp.hlp")
	    "xlisp.hlp"))

  ;; adjust *features*
  (when (system-has-windows)
	(pushnew :windows *features*)
	(pushnew :dialogs *features*)
	(if (screen-has-color) (pushnew :color *features*))
	(if (small-machine-p) (pushnew :small-machine *features*)))

  ;; get some more space
  (expand 10)

  (setf *help-stream* (open *help-file-name* :if-does-not-exist nil))
  ;;(setf *help-loaded* nil)

  ;; install macintosh listener and menu bar
  #+macintosh
  (progn
    (setq *listener* (send listener-proto :new))
    (set-menu-bar *standard-menu-bar*))

  ;; load user initialization file
  (let ((*package* (find-package "USER")))
    (load "statinit" :if-does-not-exist nil)))

(setf *startup-functions* '(use-conditions initialize-system))
