// *** fix open file to allow directory change
// *** make directory change an option?
// *** merge with lspedit code

#include <string.h>
#include "xlisp.h"
#include "wxlisp.h"
#include "winutils.h"

static char FileName[128];
static char OpenName[128];
static char DefPath[128];
static char DefSpec[13] = "*.lsp";
static char DefExt[] = ".lsp";
static char str[255];
static char *prompt;
static OFSTRUCT OfStruct;

extern HWND hWndFrame;
extern HANDLE hInst;

HANDLE FAR PASCAL OpenFileDlg(HWND, unsigned, WORD, LONG);
int FAR PASCAL SaveFileDlg(HWND, unsigned, WORD, LONG);
static void UpdateListBox(HWND);
static void SeparateFile(HWND, LPSTR, LPSTR, LPSTR);
static void ChangeDefExt(PSTR, PSTR);
static void AddExt(PSTR, PSTR);
static BOOL CheckFileName(HWND, PSTR, PSTR);

LVAL xsopenfiledialog()
{
  int result;
  FARPROC lpOpenFileDlg;

  lpOpenFileDlg = MakeProcInstance((FARPROC) OpenFileDlg, hInst);
  result = DialogBox(hInst, "Open", hWndFrame, lpOpenFileDlg);
  FreeProcInstance(lpOpenFileDlg);
  return(result == IDOK ? cvstring(FileName) : NIL);
}

LVAL xssetfiledialog()
{
  int result;
  FARPROC lpSaveFileDlg;

  prompt = (char *) getstring(xlgastring());
  strcpy(FileName, moreargs() ? (char *) getstring(xlgastring()) : "");

  lpSaveFileDlg = MakeProcInstance((FARPROC) SaveFileDlg, hInst);
  result = DialogBox(hInst, "SaveAs", hWndFrame, lpSaveFileDlg);
  FreeProcInstance(lpSaveFileDlg);
  return(result == IDOK ? cvstring(FileName) : NIL);
}

HANDLE FAR PASCAL OpenFileDlg(HWND hDlg,
			      unsigned message,
			      WORD wParam,
			      LONG lParam)
{
  switch (message) {
  case WM_COMMAND:
    switch (wParam) {
    case IDC_LISTBOX:
      switch (HIWORD(lParam)) {
      case LBN_SELCHANGE:
	if (! DlgDirSelect(hDlg, str, IDC_LISTBOX)) {
	  SetDlgItemText(hDlg, IDC_EDIT, str);
	  SendDlgItemMessage(hDlg, IDC_EDIT, EM_SETSEL, NULL,
			     MAKELONG(0, 0x7fff));
	}
	else {
	  strcat(str, DefSpec);
	  DlgDirList(hDlg, str, IDC_LISTBOX, IDC_PATH, 0x4010);
	}
	break;
      case LBN_DBLCLK:
	goto openfile;
      }
      return(TRUE);
    case IDOK:
openfile:
      GetDlgItemText(hDlg, IDC_EDIT, OpenName, 128);
      if (strchr(OpenName, '*') || strchr(OpenName, '?')) {
	SeparateFile(hDlg, (LPSTR) str, (LPSTR) DefSpec, (LPSTR) OpenName);
	if (str[0]) strcpy(DefPath, str);
	ChangeDefExt(DefExt, DefSpec);
	UpdateListBox(hDlg);
	return(TRUE);
      }
      if (! OpenName[0]) {
	MessageBox(hDlg, "No filename specified.", NULL,
		   MB_OK | MB_ICONQUESTION);
	return(TRUE);
      }
      AddExt(OpenName, DefExt);
      strcpy(FileName, OpenName);
      EndDialog(hDlg, TRUE);
      return(TRUE);
    case IDCANCEL:
      EndDialog(hDlg, NULL);
      return(TRUE);
    }
    break;
  case WM_INITDIALOG:
    UpdateListBox(hDlg);
    SetDlgItemText(hDlg, IDC_EDIT, DefSpec);
    SendDlgItemMessage(hDlg, IDC_EDIT, EM_SETSEL, NULL, MAKELONG(0, 0x7fff));
    SetFocus(GetDlgItem(hDlg, IDC_EDIT));
    return(FALSE);
  }
  return(FALSE);
}

int FAR PASCAL SaveFileDlg(HWND hDlg,
			   unsigned message,
			   WORD wParam,
			   LONG lParam)
{
  char TempName[128];
  static BOOL bSaveEnabled;

  switch (message) {
  case WM_INITDIALOG:
    if (! FileName[0]) bSaveEnabled = FALSE;
    else {
      bSaveEnabled = TRUE;
      DlgDirList(hDlg, DefPath, NULL, IDC_PATH, 0x4010);
      SetDlgItemText(hDlg, IDC_EDIT, FileName);
      SendDlgItemMessage(hDlg, IDC_EDIT, EM_SETSEL, 0, MAKELONG(0, 0x7fff));
    }
    SetDlgItemText(hDlg, IDC_FILENAME, prompt);
    EnableWindow(GetDlgItem(hDlg, IDOK), bSaveEnabled);
    SetFocus(GetDlgItem(hDlg, IDC_EDIT));
    return(FALSE);
  case WM_COMMAND:
    switch (wParam) {
    case IDC_EDIT:
      if (HIWORD(lParam) == EN_CHANGE || HIWORD(lParam) == EN_UPDATE) {
	if (! bSaveEnabled) {
	  bSaveEnabled = TRUE;
	  EnableWindow(GetDlgItem(hDlg, IDOK), bSaveEnabled);
	}
      }
      return(TRUE);
    case IDOK:
      GetDlgItemText(hDlg, IDC_EDIT, TempName, 128);
      if (CheckFileName(hDlg, (PSTR) FileName, (PSTR) TempName)) {
	SeparateFile(hDlg, (LPSTR) str, (LPSTR) DefSpec, (LPSTR) FileName);
	if (str[0]) strcpy(DefPath, str);
	EndDialog(hDlg, IDOK);
      }
      return(TRUE);
    case IDCANCEL:
      EndDialog(hDlg, IDCANCEL);
      return(TRUE);
    }
    break;
  }
  return(FALSE);
}

static void UpdateListBox(HWND hDlg)
{
  strcpy(str, DefPath);
  strcat(str, DefSpec);
  DlgDirList(hDlg, str, IDC_LISTBOX, IDC_PATH, 0x4010);
  SetDlgItemText(hDlg, IDC_EDIT, DefSpec);
}

static void SeparateFile(HWND hDlg,
			 LPSTR lpDestPath,
			 LPSTR lpDestFileName,
			 LPSTR lpSrcFileName)
{
  LPSTR lpTmp;
  char cTmp;

  lpTmp = lpSrcFileName + (long) lstrlen(lpSrcFileName);

  while (*lpTmp != ':' && *lpTmp != '\\' && lpTmp > lpSrcFileName)
    lpTmp = AnsiPrev(lpSrcFileName, lpTmp);

  if (*lpTmp != ':' && *lpTmp != '\\') {
    lstrcpy(lpDestFileName, lpSrcFileName);
    lpDestPath[0] = 0;
    return;
  }
  lstrcpy(lpDestFileName, lpTmp + 1);
  cTmp = *(lpTmp + 1);
  lstrcpy(lpDestPath, lpSrcFileName);
  *(lpTmp + 1) = cTmp;
  lpDestPath[(lpTmp - lpSrcFileName) + 1] = 0;
}

static void ChangeDefExt(PSTR Ext, PSTR Name)
{
  PSTR pTptr;

  pTptr = Name;
  while (*pTptr && *pTptr != '.') pTptr++;
  if (*pTptr)
    if (! strchr(pTptr, '*') && ! strchr(pTptr, '?'))
      strcpy(Ext, pTptr);
}

static void AddExt(PSTR Name, PSTR Ext)
{
  PSTR pTptr;

  pTptr = Name;
  while (*pTptr && *pTptr != '.') pTptr++;
  if (*pTptr != '.') strcat(Name, Ext);
}

static BOOL CheckFileName(HWND hWnd, PSTR pDest, PSTR pSrc)
{
  PSTR pTmp;

  if (! pSrc[0]) return(FALSE);

  pTmp = pSrc;
  while (*pTmp) {
    switch (*pTmp++) {
    case '*':
    case '?':
      MessageBox(hWnd, "Wildcards not allowed.", NULL, MB_OK | MB_ICONEXCLAMATION);
      return(FALSE);
    }
  }

  AddExt(pSrc, DefExt);

  if (OpenFile(pSrc, (LPOFSTRUCT) & OfStruct, OF_EXIST) >= 0) {
    sprintf(str, "Replace existing %s?", (LPSTR) pSrc);
    if (MessageBox(hWnd, str, "LSPEdit", MB_OKCANCEL | MB_ICONHAND) == IDCANCEL)
      return(FALSE);
  }
  strcpy(pDest, pSrc);
  return(TRUE);
}
