; dwtrans.lsp                Gordon S. Novak Jr.              04 Sep 92

; Copyright 1992, The University of Texas at Austin (UTA).  All rights
; reserved.  By using this software the USER indicates that he or she
; has read, understood and will comply with the following:
;
; -UTA hereby grants USER nonexclusive permission to use, copy and/or
; modify this software for internal, noncommercial, research purposes only.
; Any distribution, including commercial sale or license, of this software,
; copies of the software, its associated documentation and/or modifications
; of either is strictly prohibited without the prior consent of UTA.  Title
; to copyright to this software and its associated documentation shall at
; all times remain with UTA.  Appropriate copyright notice shall be placed
; on all software copies, and a complete copy of this notice shall be
; included in all copies of the associated documentation.  No right is
; granted to use in advertising, publicity or otherwise any trademark,
; service mark, or the name of UTA.  Software and/or its associated
; documentation identified as "confidential," if any, will be protected
; from unauthorized use/disclosure with the same degree of care USER
; regularly employs to safeguard its own such information.
;
; -This software and any associated documentation is provided "as is," and
; UTA MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
; THOSE OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR THAT
; USE OF THE SOFTWARE, MODIFICATIONS, OR ASSOCIATED DOCUMENTATION WILL
; NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER INTELLECTUAL
; PROPERTY RIGHTS OF A THIRD PARTY.  UTA, the University of Texas System,
; its Regents, officers, and employees shall not be liable under any
; circumstances for any direct, indirect, special, incidental, or
; consequential damages with respect to any claim by USER or any third
; party on account of or arising from the use, or inability to use, this
; software or its associated documentation, even if UTA has been advised
; of the possibility of those damages.
;
; -Submit software operation questions to: Gordon S. Novak Jr., Department
; of Computer Sciences, UT, Austin, TX 78712, novak@cs.utexas.edu .
;
; -Submit commercialization requests to: Office of the Executive Vice
; President and Provost, UT Austin, 201 Main Bldg., Austin, TX, 78712,
; ATTN: Technology Licensing Specialist.

(IN-PACKAGE :USER)

(DEFVAR *WINDOW-MENU* NIL)

(DEFVAR *MOUSE-X* NIL)

(DEFVAR *MOUSE-Y* NIL)

(DEFVAR *MOUSE-WINDOW* NIL)

(DEFVAR *WINDOW-FONTS*
        '((COURIER-BOLD-12
              "*-*-courier-bold-r-*-*-12-*-*-*-*-*-iso8859-1")
          (8X10 "8x10") (9X15 "9x15")))

(DEFVAR *WINDOW-MENU*)
(SETF (GET '*WINDOW-MENU* 'GLISPGLOBALVAR) T)
(SETF (GET '*WINDOW-MENU* 'GLISPGLOBALVARTYPE) 'MENU)
(DEFVAR *MOUSE-X*)
(SETF (GET '*MOUSE-X* 'GLISPGLOBALVAR) T)
(SETF (GET '*MOUSE-X* 'GLISPGLOBALVARTYPE) 'INTEGER)
(DEFVAR *MOUSE-Y*)
(SETF (GET '*MOUSE-Y* 'GLISPGLOBALVAR) T)
(SETF (GET '*MOUSE-Y* 'GLISPGLOBALVARTYPE) 'INTEGER)
(DEFVAR *MOUSE-WINDOW*)
(SETF (GET '*MOUSE-WINDOW* 'GLISPGLOBALVAR) T)
(SETF (GET '*MOUSE-WINDOW* 'GLISPGLOBALVARTYPE) 'WINDOW)


(DEFVAR *WINDOW-DISPLAY* NIL)

(DEFVAR *WINDOW-SCREEN* NIL)

(DEFVAR *ROOT-WINDOW*)

(DEFVAR *BLACK-PIXEL*)

(DEFVAR *WHITE-PIXEL*)

(DEFVAR *DEFAULT-FG-COLOR*)

(DEFVAR *DEFAULT-BG-COLOR*)

(DEFVAR *DEFAULT-SIZE-HINTS*)

(DEFVAR *DEFAULT-GC*)

(DEFVAR *DEFAULT-COLORMAP*)

(DEFVAR *WINDOW-EVENT*)

(DEFVAR *WINDOW-DEFAULT-POS-X* 10)

(DEFVAR *WINDOW-DEFAULT-POS-Y* 20)

(DEFVAR *WINDOW-DEFAULT-BORDER* 1)

(DEFVAR *WINDOW-DEFAULT-FONT-NAME* 'COURIER-BOLD-12)

(DEFVAR *WINDOW-DEFAULT-CURSOR* 68)

(DEFVAR *WINDOW-SAVE-FOREGROUND*)

(DEFVAR *WINDOW-SAVE-FUNCTION*)

(DEFVAR *WINDOW-ATTRIBUTES*)

(DEFVAR *WINDOW-ATTR*)

(DEFVAR *ROOT-RETURN* (INT-ARRAY 1))

(DEFVAR *CHILD-RETURN* (INT-ARRAY 1))

(DEFVAR *ROOT-X-RETURN* (INT-ARRAY 1))

(DEFVAR *ROOT-Y-RETURN* (INT-ARRAY 1))

(DEFVAR *WIN-X-RETURN* (INT-ARRAY 1))

(DEFVAR *WIN-Y-RETURN* (INT-ARRAY 1))

(DEFVAR *MASK-RETURN* (INT-ARRAY 1))

(DEFVAR *X-RETURN* (INT-ARRAY 1))

(DEFVAR *Y-RETURN* (INT-ARRAY 1))

(DEFVAR *WIDTH-RETURN* (INT-ARRAY 1))

(DEFVAR *HEIGHT-RETURN* (INT-ARRAY 1))

(DEFVAR *DEPTH-RETURN* (INT-ARRAY 1))

(DEFVAR *BORDER-WIDTH-RETURN* (INT-ARRAY 1))

(DEFVAR *TEXT-WIDTH-RETURN* (INT-ARRAY 1))

(DEFVAR *GC-VALUES*)

(SETF (GET 'DRAWABLE 'GLSTRUCTURE) '(ANYTHING))
(SETF (GET 'MENU 'GLSTRUCTURE)
      '((LISTOBJECT (MENU-WINDOW WINDOW) (FLAT BOOLEAN)
            (PARENT-WINDOW DRAWABLE) (PARENT-OFFSET-X INTEGER)
            (PARENT-OFFSET-Y INTEGER) (PICTURE-WIDTH INTEGER)
            (PICTURE-HEIGHT INTEGER) (TITLE STRING) (PERMANENT BOOLEAN)
            (MENU-FONT SYMBOL) (ITEM-WIDTH INTEGER)
            (ITEM-HEIGHT INTEGER) (ITEMS (LISTOF SYMBOL)))
        PROP
        ((MENUW (MENU-WINDOW OR (MENU-INIT SELF)) RESULT WINDOW)
         (TITLE-PRESENT (TITLE AND ((LENGTH TITLE) > 0)))
         (WIDTH ((WIDTH MENUW))) (HEIGHT ((HEIGHT MENUW)))
         (BASE-X ((IF FLAT THEN PARENT-OFFSET-X ELSE 0)))
         (BASE-Y ((IF FLAT THEN PARENT-OFFSET-Y ELSE 0)))
         (OFFSET MENU-OFFSET) (SIZE MENU-SIZE))
        MSG
        ((INIT MENU-INIT)
         (INIT? ((MENU-WINDOW AND (ITEM-HEIGHT > 0)) OR (INIT SELF)))
         (CREATE MENU-CREATE RESULT MENU) (CLEAR MENU-CLEAR)
         (SELECT MENU-SELECT) (SELECT! MENU-SELECT!)
         (CHOOSE MENU-CHOOSE) (DRAW MENU-DRAW) (DESTROY MENU-DESTROY)
         (MOVETO-XY MENU-MOVETO-XY) (BOX-ITEM MENU-BOX-ITEM)
         (UNBOX-ITEM MENU-UNBOX-ITEM) (DISPLAY-ITEM MENU-DISPLAY-ITEM)
         (ITEM-VALUE MENU-ITEM-VALUE OPEN T)
         (ITEM-POSITION MENU-ITEM-POSITION RESULT VECTOR)
         (FIND-ITEM-WIDTH MENU-FIND-ITEM-WIDTH)
         (FIND-ITEM-HEIGHT MENU-FIND-ITEM-HEIGHT)
         (ADJUST-OFFSET MENU-ADJUST-OFFSET)
         (MENU-X (GLAMBDA (M X) ((BASE-X M) + X)))
         (MENU-Y (GLAMBDA (M Y) ((BASE-Y M) + Y))))))
(SETF (GET 'PICMENU 'GLSTRUCTURE)
      '((LISTOBJECT (MENU-WINDOW WINDOW) (FLAT BOOLEAN)
            (PARENT-WINDOW DRAWABLE) (PARENT-OFFSET-X INTEGER)
            (PARENT-OFFSET-Y INTEGER) (PICTURE-WIDTH INTEGER)
            (PICTURE-HEIGHT INTEGER) (TITLE STRING) (PERMANENT BOOLEAN)
            (SPEC (TRANSPARENT PICMENU-SPEC)) (BOXFLG BOOLEAN))
        PROP
        ((MENUW (MENU-WINDOW OR (PICMENU-INIT SELF)) RESULT WINDOW)
         (TITLE-PRESENT (TITLE AND ((LENGTH TITLE) > 0)))
         (WIDTH (PICTURE-WIDTH)) (HEIGHT (PICTURE-HEIGHT)))
        MSG
        ((INIT PICMENU-INIT)
         (INIT? ((MENU-WINDOW AND (PICTURE-HEIGHT > 0)) OR (INIT SELF)))
         (CREATE PICMENU-CREATE RESULT PICMENU) (SELECT PICMENU-SELECT)
         (DRAW PICMENU-DRAW) (BOX-ITEM PICMENU-BOX-ITEM)
         (UNBOX-ITEM PICMENU-UNBOX-ITEM)
         (ITEM-POSITION PICMENU-ITEM-POSITION RESULT VECTOR))
        SUPERS (MENU)))
(SETF (GET 'PICMENU-SPEC 'GLSTRUCTURE)
      '((LISTOBJECT (DRAWING-WIDTH INTEGER) (DRAWING-HEIGHT INTEGER)
            (BUTTONS (LISTOF PICMENU-BUTTON)) (DOTFLG BOOLEAN)
            (DRAWFN ANYTHING) (MENU-FONT SYMBOL))))
(SETF (GET 'PICMENU-BUTTON 'GLSTRUCTURE)
      '((LIST (NAME SYMBOL) (OFFSET VECTOR) (SIZE VECTOR)
              (HIGHLIGHTFN ANYTHING) (UNHIGHLIGHTFN ANYTHING))
        MSG ((CONTAINSXY? PICMENU-BUTTON-CONTAINSXY?))))
(SETF (GET 'WINDOW 'GLSTRUCTURE)
      '((LISTOBJECT (PARENT DRAWABLE) (GCONTEXT ANYTHING)
            (DRAWABLE-HEIGHT INTEGER) (DRAWABLE-WIDTH INTEGER)
            (LABEL STRING) (FONT ANYTHING))
        DEFAULT ((SELF NIL)) PROP
        ((WIDTH (DRAWABLE-WIDTH)) (HEIGHT (DRAWABLE-HEIGHT))
         (LEFT WINDOW-LEFT OPEN T RESULT INTEGER)
         (RIGHT (LEFT + WIDTH))
         (TOP-NEG-Y WINDOW-TOP-NEG-Y OPEN T RESULT INTEGER)
         (LEFTMARGIN (1)) (RIGHTMARGIN (WIDTH - 1))
         (YPOSITION WINDOW-YPOSITION RESULT INTEGER OPEN T)
         (WFUNCTION WINDOW-WFUNCTION OPEN T)
         (FOREGROUND WINDOW-FOREGROUND OPEN T)
         (BACKGROUND WINDOW-BACKGROUND OPEN T))
        MSG
        ((FORCE-OUTPUT WINDOW-FORCE-OUTPUT OPEN T)
         (SET-FONT WINDOW-SET-FONT)
         (SET-FOREGROUND WINDOW-SET-FOREGROUND OPEN T)
         (SET-BACKGROUND WINDOW-SET-BACKGROUND OPEN T)
         (SET-CURSOR WINDOW-SET-CURSOR OPEN T)
         (SET-ERASE WINDOW-SET-ERASE OPEN T)
         (SET-XOR WINDOW-SET-XOR OPEN T)
         (SET-INVERT WINDOW-SET-INVERT OPEN T)
         (SET-COPY WINDOW-SET-COPY OPEN T)
         (SET-LINE-WIDTH WINDOW-SET-LINE-WIDTH OPEN T)
         (SET-LINE-ATTR WINDOW-SET-LINE-ATTR OPEN T)
         (STD-LINE-ATTR WINDOW-STD-LINE-ATTR OPEN T)
         (UNSET WINDOW-UNSET OPEN T) (RESET WINDOW-RESET OPEN T)
         (SYNC WINDOW-SYNC OPEN T) (GEOMETRY WINDOW-GEOMETRY OPEN T)
         (SIZE WINDOW-SIZE) (GET-GEOMETRY WINDOW-GET-GEOMETRY OPEN T)
         (RESET-GEOMETRY WINDOW-RESET-GEOMETRY OPEN T)
         (QUERY-POINTER WINDOW-QUERY-POINTER OPEN T)
         (WAIT-EXPOSURE WINDOW-WAIT-EXPOSURE)
         (CLEAR WINDOW-CLEAR OPEN T) (MAPW WINDOW-MAP OPEN T)
         (UNMAP WINDOW-UNMAP OPEN T) (OPEN WINDOW-OPEN OPEN T)
         (CLOSE WINDOW-CLOSE OPEN T) (DESTROY WINDOW-DESTROY OPEN T)
         (POSITIVE-Y WINDOW-POSITIVE-Y OPEN T)
         (DRAWLINE WINDOW-DRAW-LINE OPEN T)
         (DRAW-LINE WINDOW-DRAW-LINE OPEN T)
         (DRAW-LINE-XY WINDOW-DRAW-LINE-XY OPEN T)
         (DRAW-ARROW-XY WINDOW-DRAW-ARROW-XY)
         (DRAW-ARROW2-XY WINDOW-DRAW-ARROW2-XY)
         (DRAW-ARROWHEAD-XY WINDOW-DRAW-ARROWHEAD-XY)
         (DRAW-BOX WINDOW-DRAW-BOX OPEN T)
         (DRAW-BOX-XY WINDOW-DRAW-BOX-XY)
         (DRAW-BOX-CORNERS WINDOW-DRAW-BOX-CORNERS OPEN T)
         (DRAW-RCBOX-XY WINDOW-DRAW-RCBOX-XY)
         (XOR-BOX-XY WINDOW-XOR-BOX-XY OPEN T)
         (DRAW-CIRCLE WINDOW-DRAW-CIRCLE OPEN T)
         (DRAW-CIRCLE-XY WINDOW-DRAW-CIRCLE-XY OPEN T)
         (DRAW-ELLIPSE-XY WINDOW-DRAW-ELLIPSE-XY OPEN T)
         (DRAW-ARC-XY WINDOW-DRAW-ARC-XY OPEN T)
         (INVERTAREA WINDOW-INVERTAREA OPEN T)
         (INVERT-AREA WINDOW-INVERT-AREA OPEN T)
         (INVERT-AREA-XY WINDOW-INVERT-AREA-XY OPEN T)
         (COPY-AREA-XY WINDOW-COPY-AREA-XY OPEN T)
         (PRINTAT WINDOW-PRINTAT OPEN T)
         (PRINTAT-XY WINDOW-PRINTAT-XY OPEN T)
         (PRETTYPRINTAT WINDOW-PRETTYPRINTAT OPEN T)
         (PRETTYPRINTAT-XY WINDOW-PRETTYPRINTAT-XY OPEN T)
         (STRING-WIDTH WINDOW-STRING-WIDTH OPEN T)
         (ERASE-AREA WINDOW-ERASE-AREA OPEN T)
         (ERASE-AREA-XY WINDOW-ERASE-AREA-XY OPEN T)
         (MOVETO-XY WINDOW-MOVETO-XY)
         (CENTEROFFSET WINDOW-CENTEROFFSET OPEN T)
         (TRACK-MOUSE WINDOW-TRACK-MOUSE) (GET-POINT WINDOW-GET-POINT)
         (GET-CLICK WINDOW-GET-CLICK)
         (GET-LINE-POSITION WINDOW-GET-LINE-POSITION)
         (GET-BOX-POSITION WINDOW-GET-BOX-POSITION)
         (GET-BOX-SIZE WINDOW-GET-BOX-SIZE)
         (GET-REGION WINDOW-GET-REGION)
         (ADJUST-BOX-SIDE WINDOW-ADJUST-BOX-SIDE)
         (GET-MOUSE-POSITION WINDOW-GET-MOUSE-POSITION))))


(SETF (GET 'WINDOWCHARWIDTH 'GLISPCONSTANTFLG) T)
(SETF (GET 'WINDOWCHARWIDTH 'GLISPORIGCONSTVAL) 9)
(SETF (GET 'WINDOWCHARWIDTH 'GLISPCONSTANTVAL) 9)
(SETF (GET 'WINDOWCHARWIDTH 'GLISPCONSTANTTYPE) 'INTEGER)
(SETF (GET 'WINDOWLINEYSPACING 'GLISPCONSTANTFLG) T)
(SETF (GET 'WINDOWLINEYSPACING 'GLISPORIGCONSTVAL) 17)
(SETF (GET 'WINDOWLINEYSPACING 'GLISPCONSTANTVAL) 17)
(SETF (GET 'WINDOWLINEYSPACING 'GLISPCONSTANTTYPE) 'INTEGER)


(DEFUN STRINGIFY (X)
  (COND
    ((STRINGP X) X)
    ((SYMBOLP X) (SYMBOL-NAME X))
    (T (PRINC-TO-STRING X))))

(DEFUN WINDOW-XINIT ()
  (SETQ *WINDOW-DISPLAY* (XOPENDISPLAY (GET-C-STRING "")))
  (SETQ *WINDOW-SCREEN* (XDEFAULTSCREEN *WINDOW-DISPLAY*))
  (SETQ *ROOT-WINDOW* (XROOTWINDOW *WINDOW-DISPLAY* *WINDOW-SCREEN*))
  (SETQ *BLACK-PIXEL* (XBLACKPIXEL *WINDOW-DISPLAY* *WINDOW-SCREEN*))
  (SETQ *WHITE-PIXEL* (XWHITEPIXEL *WINDOW-DISPLAY* *WINDOW-SCREEN*))
  (SETQ *DEFAULT-FG-COLOR* *BLACK-PIXEL*)
  (SETQ *DEFAULT-BG-COLOR* *WHITE-PIXEL*)
  (SETQ *DEFAULT-GC* (XDEFAULTGC *WINDOW-DISPLAY* *WINDOW-SCREEN*))
  (SETQ *DEFAULT-COLORMAP*
        (XDEFAULTCOLORMAP *WINDOW-DISPLAY* *WINDOW-SCREEN*))
  (SETQ *WINDOW-ATTRIBUTES* (MAKE-XSETWINDOWATTRIBUTES))
  (SET-XSETWINDOWATTRIBUTES-BACKING_STORE *WINDOW-ATTRIBUTES*
      WHENMAPPED)
  (SET-XSETWINDOWATTRIBUTES-SAVE_UNDER *WINDOW-ATTRIBUTES* 1)
  (SETQ *WINDOW-ATTR* (MAKE-XWINDOWATTRIBUTES))
  (XFLUSH *WINDOW-DISPLAY*)
  (SETQ *DEFAULT-SIZE-HINTS* (MAKE-XSIZEHINTS))
  (SETQ *WINDOW-EVENT* (MAKE-XEVENT))
  (SETQ *GC-VALUES* (MAKE-XGCVALUES)))

(DEFUN WINDOW-GET-MOUSE-POSITION ()
  (XQUERYPOINTER *WINDOW-DISPLAY* *ROOT-WINDOW* *ROOT-RETURN*
      *CHILD-RETURN* *ROOT-X-RETURN* *ROOT-Y-RETURN* *WIN-X-RETURN*
      *WIN-Y-RETURN* *MASK-RETURN*)
  (SETQ *MOUSE-X* (INT-POS *ROOT-X-RETURN* 0))
  (SETQ *MOUSE-Y* (INT-POS *ROOT-Y-RETURN* 0))
  (SETQ *MOUSE-WINDOW* (INT-POS *CHILD-RETURN* 0)))

(SETF (GET 'WINDOW-CREATE 'GLFNRESULTTYPE) 'WINDOW)

(DEFUN WINDOW-CREATE
       (WIDTH HEIGHT &OPTIONAL STR PARENTW POS-X POS-Y FONT)
  (LET (W PW FG-COLOR BG-COLOR)
    (OR *WINDOW-DISPLAY* (WINDOW-XINIT))
    (SETQ FG-COLOR *DEFAULT-FG-COLOR*)
    (SETQ BG-COLOR *DEFAULT-BG-COLOR*)
    (UNLESS POS-X (SETQ POS-X *WINDOW-DEFAULT-POS-X*))
    (UNLESS POS-Y (SETQ POS-Y *WINDOW-DEFAULT-POS-Y*))
    (SETQ W
          (LIST 'WINDOW NIL NIL HEIGHT WIDTH
                (IF STR (STRINGIFY STR) " ") NIL))
    (SETQ PW (OR PARENTW *ROOT-WINDOW*))
    (WINDOW-GET-GEOMETRY-B PW)
    (RPLACA (CDR W)
            (XCREATESIMPLEWINDOW *WINDOW-DISPLAY* PW POS-X
                (- (- (INT-POS *HEIGHT-RETURN* 0) POS-Y) HEIGHT) WIDTH
                HEIGHT *WINDOW-DEFAULT-BORDER* FG-COLOR BG-COLOR))
    (SET-XSIZEHINTS-X *DEFAULT-SIZE-HINTS* POS-X)
    (SET-XSIZEHINTS-Y *DEFAULT-SIZE-HINTS* POS-Y)
    (SET-XSIZEHINTS-WIDTH *DEFAULT-SIZE-HINTS* (FIFTH W))
    (SET-XSIZEHINTS-HEIGHT *DEFAULT-SIZE-HINTS* (CADDDR W))
    (SET-XSIZEHINTS-FLAGS *DEFAULT-SIZE-HINTS* 12)
    (XSETSTANDARDPROPERTIES *WINDOW-DISPLAY* (CADR W)
        (GET-C-STRING (SIXTH W)) (GET-C-STRING (SIXTH W)) NONE NULL
        NULL *DEFAULT-SIZE-HINTS*)
    (RPLACA (CDDR W) (XCREATEGC *WINDOW-DISPLAY* (CADR W) 0 NULL))
    (XSETFOREGROUND *WINDOW-DISPLAY* (CADDR W) FG-COLOR)
    (XSETBACKGROUND *WINDOW-DISPLAY* (CADDR W) BG-COLOR)
    (WINDOW-SET-FONT W (OR FONT *WINDOW-DEFAULT-FONT-NAME*))
    (LET (C)
      (SETQ C
            (XCREATEFONTCURSOR *WINDOW-DISPLAY*
                *WINDOW-DEFAULT-CURSOR*))
      (XDEFINECURSOR *WINDOW-DISPLAY* (CADR W) C))
    (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 0 1 0)
    (XCHANGEWINDOWATTRIBUTES *WINDOW-DISPLAY* (CADR W) 1088
        *WINDOW-ATTRIBUTES*)
    (XSELECTINPUT *WINDOW-DISPLAY* (CADR W) 32876)
    (XMAPWINDOW *WINDOW-DISPLAY* (CADR W))
    (XFLUSH *WINDOW-DISPLAY*)
    (WINDOW-WAIT-EXPOSURE W)
    W))

(DEFUN WINDOW-SET-FONT (W FONTSYMBOL)
  (LET (FONTSTRING FONT-INFO (DISPLAY *WINDOW-DISPLAY*))
    (SETQ FONTSTRING
          (OR (CADR (ASSOC FONTSYMBOL *WINDOW-FONTS*))
              (STRINGIFY FONTSYMBOL)))
    (SETQ FONT-INFO (XLOADQUERYFONT DISPLAY (GET-C-STRING FONTSTRING)))
    (IF (ZEROP FONT-INFO)
        (FORMAT T "~%can't open font ~a ~a~%" FONTSYMBOL FONTSTRING)
        (PROGN
          (XSETFONT DISPLAY (CADDR W) (XFONTSTRUCT-FID FONT-INFO))
          (SETF (SEVENTH W) FONT-INFO)))))

(DEFUN WINDOW-FONT-INFO (FONTSYMBOL)
  (XLOADQUERYFONT *WINDOW-DISPLAY*
      (GET-C-STRING
          (OR (CADR (ASSOC FONTSYMBOL *WINDOW-FONTS*))
              (STRINGIFY FONTSYMBOL)))))

(DEFUN WINDOW-GCONTEXT (W) (CADDR W))

(DEFUN WINDOW-PARENT (W) (CADR W))

(DEFUN WINDOW-DRAWABLE-HEIGHT (W) (CADDDR W))

(DEFUN WINDOW-DRAWABLE-WIDTH (W) (FIFTH W))

(DEFUN WINDOW-LABEL (W) (SIXTH W))

(DEFUN WINDOW-FONT (W) (SEVENTH W))

(DEFUN WINDOW-FOREGROUND (W)
  (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCFOREGROUND *GC-VALUES*)
  (XGCVALUES-FOREGROUND *GC-VALUES*))

(DEFUN WINDOW-SET-FOREGROUND (W FG-COLOR)
  (XSETFOREGROUND *WINDOW-DISPLAY* (CADDR W) FG-COLOR))

(DEFUN WINDOW-BACKGROUND (W)
  (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCBACKGROUND *GC-VALUES*)
  (XGCVALUES-BACKGROUND *GC-VALUES*))

(DEFUN WINDOW-SET-BACKGROUND (W BG-COLOR)
  (XSETBACKGROUND *WINDOW-DISPLAY* (CADDR W) BG-COLOR))

(DEFUN WINDOW-WFUNCTION (W)
  (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCFUNCTION *GC-VALUES*)
  (XGCVALUES-FUNCTION *GC-VALUES*))

(DEFUN WINDOW-GET-GEOMETRY (W) (WINDOW-GET-GEOMETRY-B (CADR W)))

(DEFUN WINDOW-SET-CURSOR (W N)
  (LET (C)
    (SETQ C (XCREATEFONTCURSOR *WINDOW-DISPLAY* N))
    (XDEFINECURSOR *WINDOW-DISPLAY* (CADR W) C)))

(DEFUN WINDOW-GET-GEOMETRY-B (W)
  (XGETGEOMETRY *WINDOW-DISPLAY* W *ROOT-RETURN* *X-RETURN* *Y-RETURN*
      *WIDTH-RETURN* *HEIGHT-RETURN* *BORDER-WIDTH-RETURN*
      *DEPTH-RETURN*))

(DEFUN WINDOW-SYNC (W) (XSYNC *WINDOW-DISPLAY* 1))

(DEFUN WINDOW-SCREEN-HEIGHT ()
  (WINDOW-GET-GEOMETRY-B *ROOT-WINDOW*)
  (INT-POS *HEIGHT-RETURN* 0))

(DEFUN WINDOW-GEOMETRY (W)
  (LET (SH)
    (SETQ SH (WINDOW-SCREEN-HEIGHT))
    (WINDOW-GET-GEOMETRY-B (CADR W))
    (SETF (FIFTH W) (INT-POS *WIDTH-RETURN* 0))
    (RPLACA (CDDDR W) (INT-POS *HEIGHT-RETURN* 0))
    (LIST (INT-POS *X-RETURN* 0)
          (- (- SH (INT-POS *Y-RETURN* 0)) (INT-POS *HEIGHT-RETURN* 0))
          (INT-POS *WIDTH-RETURN* 0) (INT-POS *HEIGHT-RETURN* 0)
          (INT-POS *BORDER-WIDTH-RETURN* 0))))

(DEFUN WINDOW-SIZE (W)
  (WINDOW-GET-GEOMETRY-B (CADR W))
  (LIST (SETF (FIFTH W) (INT-POS *WIDTH-RETURN* 0))
        (CAR (RPLACA (CDDDR W) (INT-POS *HEIGHT-RETURN* 0)))))

(DEFUN WINDOW-LEFT (W)
  (WINDOW-GET-GEOMETRY-B (CADR W))
  (INT-POS *X-RETURN* 0))

(DEFUN WINDOW-TOP-NEG-Y (W)
  (WINDOW-GET-GEOMETRY-B (CADR W))
  (INT-POS *Y-RETURN* 0))

(DEFUN WINDOW-RESET-GEOMETRY (W)
  (WINDOW-GET-GEOMETRY-B (CADR W))
  (SETF (FIFTH W) (INT-POS *WIDTH-RETURN* 0))
  (CAR (RPLACA (CDDDR W) (INT-POS *HEIGHT-RETURN* 0))))

(DEFUN WINDOW-FORCE-OUTPUT (&OPTIONAL W) (XFLUSH *WINDOW-DISPLAY*))

(DEFUN WINDOW-QUERY-POINTER (W) (WINDOW-QUERY-POINTER-B (CADR W)))

(DEFUN WINDOW-QUERY-POINTER-B (W)
  (XQUERYPOINTER *WINDOW-DISPLAY* W *ROOT-RETURN* *CHILD-RETURN*
      *ROOT-X-RETURN* *ROOT-Y-RETURN* *WIN-X-RETURN* *WIN-Y-RETURN*
      *MASK-RETURN*))

(DEFUN WINDOW-POSITIVE-Y (W Y) (- (CADDDR W) Y))

(DEFUN WINDOW-SET-XOR (W)
  (LET ((GC (CADDR W)))
    (SETQ *WINDOW-SAVE-FUNCTION*
          (PROGN
            (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCFUNCTION
                *GC-VALUES*)
            (XGCVALUES-FUNCTION *GC-VALUES*)))
    (XSETFUNCTION *WINDOW-DISPLAY* GC GXXOR)
    (SETQ *WINDOW-SAVE-FOREGROUND*
          (PROGN
            (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCFOREGROUND
                *GC-VALUES*)
            (XGCVALUES-FOREGROUND *GC-VALUES*)))
    (XSETFOREGROUND *WINDOW-DISPLAY* GC
        (LOGXOR *WINDOW-SAVE-FOREGROUND*
                (PROGN
                  (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCBACKGROUND
                      *GC-VALUES*)
                  (XGCVALUES-BACKGROUND *GC-VALUES*))))))

(DEFUN WINDOW-UNSET (W)
  (LET ((GC (CADDR W)))
    (XSETFUNCTION *WINDOW-DISPLAY* GC *WINDOW-SAVE-FUNCTION*)
    (XSETFOREGROUND *WINDOW-DISPLAY* GC *WINDOW-SAVE-FOREGROUND*)))

(DEFUN WINDOW-RESET (W)
  (LET ((GC (CADDR W)))
    (XSETFUNCTION *WINDOW-DISPLAY* GC GXCOPY)
    (XSETFOREGROUND *WINDOW-DISPLAY* GC *DEFAULT-FG-COLOR*)
    (XSETBACKGROUND *WINDOW-DISPLAY* GC *DEFAULT-BG-COLOR*)))

(DEFUN WINDOW-SET-ERASE (W)
  (LET ((GC (CADDR W)))
    (SETQ *WINDOW-SAVE-FUNCTION*
          (PROGN
            (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCFUNCTION
                *GC-VALUES*)
            (XGCVALUES-FUNCTION *GC-VALUES*)))
    (XSETFUNCTION *WINDOW-DISPLAY* GC GXCOPY)
    (SETQ *WINDOW-SAVE-FOREGROUND*
          (PROGN
            (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCFOREGROUND
                *GC-VALUES*)
            (XGCVALUES-FOREGROUND *GC-VALUES*)))
    (XSETFOREGROUND *WINDOW-DISPLAY* GC
        (PROGN
          (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCBACKGROUND
              *GC-VALUES*)
          (XGCVALUES-BACKGROUND *GC-VALUES*)))))

(DEFUN WINDOW-SET-COPY (W)
  (SETQ *WINDOW-SAVE-FUNCTION*
        (PROGN
          (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCFUNCTION
              *GC-VALUES*)
          (XGCVALUES-FUNCTION *GC-VALUES*)))
  (XSETFUNCTION *WINDOW-DISPLAY* (CADDR W) GXCOPY)
  (SETQ *WINDOW-SAVE-FOREGROUND*
        (PROGN
          (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCFOREGROUND
              *GC-VALUES*)
          (XGCVALUES-FOREGROUND *GC-VALUES*))))

(DEFUN WINDOW-SET-INVERT (W)
  (LET ((GC (CADDR W)))
    (SETQ *WINDOW-SAVE-FUNCTION*
          (PROGN
            (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCFUNCTION
                *GC-VALUES*)
            (XGCVALUES-FUNCTION *GC-VALUES*)))
    (XSETFUNCTION *WINDOW-DISPLAY* GC GXXOR)
    (SETQ *WINDOW-SAVE-FOREGROUND*
          (PROGN
            (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCFOREGROUND
                *GC-VALUES*)
            (XGCVALUES-FOREGROUND *GC-VALUES*)))
    (XSETFOREGROUND *WINDOW-DISPLAY* GC
        (LOGXOR *WINDOW-SAVE-FOREGROUND*
                (PROGN
                  (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCBACKGROUND
                      *GC-VALUES*)
                  (XGCVALUES-BACKGROUND *GC-VALUES*))))))

(DEFUN WINDOW-SET-LINE-WIDTH (W WIDTH)
  (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) (OR WIDTH 1) 0 1 0))

(DEFUN WINDOW-SET-LINE-ATTR
       (W WIDTH &OPTIONAL LINE-STYLE CAP-STYLE JOIN-STYLE)
  (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) (OR WIDTH 1)
      (OR LINE-STYLE LINESOLID) (OR CAP-STYLE CAPBUTT)
      (OR JOIN-STYLE JOINMITER)))

(DEFUN WINDOW-STD-LINE-ATTR (W)
  (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 LINESOLID CAPBUTT
      JOINMITER))

(DEFUN WINDOW-DRAW-LINE (W FROM TO &OPTIONAL LINEWIDTH)
  (WINDOW-DRAW-LINE-XY W (CAR FROM) (CADR FROM) (CAR TO) (CADR TO)
      LINEWIDTH))

(DEFUN WINDOW-DRAW-LINE-XY
       (W FROMX FROMY TOX TOY &OPTIONAL LINEWIDTH OPERATION)
  (LET ((QQWHEIGHT (CADDDR W)))
    (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
        (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) (OR LINEWIDTH 1)
            0 1 0))
    (CASE OPERATION
      (XOR (LET ((GC (CADDR W)))
             (SETQ *WINDOW-SAVE-FUNCTION*
                   (PROGN
                     (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W)
                         GCFUNCTION *GC-VALUES*)
                     (XGCVALUES-FUNCTION *GC-VALUES*)))
             (XSETFUNCTION *WINDOW-DISPLAY* GC GXXOR)
             (SETQ *WINDOW-SAVE-FOREGROUND*
                   (PROGN
                     (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W)
                         GCFOREGROUND *GC-VALUES*)
                     (XGCVALUES-FOREGROUND *GC-VALUES*)))
             (XSETFOREGROUND *WINDOW-DISPLAY* GC
                 (LOGXOR *WINDOW-SAVE-FOREGROUND*
                         (PROGN
                           (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W)
                               GCBACKGROUND *GC-VALUES*)
                           (XGCVALUES-BACKGROUND *GC-VALUES*))))))
      (ERASE (LET ((GC (CADDR W)))
               (SETQ *WINDOW-SAVE-FUNCTION*
                     (PROGN
                       (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W)
                           GCFUNCTION *GC-VALUES*)
                       (XGCVALUES-FUNCTION *GC-VALUES*)))
               (XSETFUNCTION *WINDOW-DISPLAY* GC GXCOPY)
               (SETQ *WINDOW-SAVE-FOREGROUND*
                     (PROGN
                       (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W)
                           GCFOREGROUND *GC-VALUES*)
                       (XGCVALUES-FOREGROUND *GC-VALUES*)))
               (XSETFOREGROUND *WINDOW-DISPLAY* GC
                   (PROGN
                     (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W)
                         GCBACKGROUND *GC-VALUES*)
                     (XGCVALUES-BACKGROUND *GC-VALUES*))))))
    (XDRAWLINE *WINDOW-DISPLAY* (CADR W) (CADDR W) FROMX
        (- QQWHEIGHT FROMY) TOX (- QQWHEIGHT TOY))
    (CASE OPERATION
      ((XOR ERASE)
       (LET ((GC (CADDR W)))
         (XSETFUNCTION *WINDOW-DISPLAY* GC *WINDOW-SAVE-FUNCTION*)
         (XSETFOREGROUND *WINDOW-DISPLAY* GC *WINDOW-SAVE-FOREGROUND*))))
    (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
        (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 0 1 0))))

(DEFUN WINDOW-DRAW-ARROWHEAD-XY
       (W X1 Y1 X2 Y2 &OPTIONAL (LINEWIDTH 1) SIZE)
  (LET (TH THETA YSTH YCTH (Y2DELA 0) (Y2DELB 0) (X2DELA 0) (X2DELB 0))
    (OR SIZE (SETQ SIZE (+ 20 (* LINEWIDTH 5))))
    (SETQ TH (ATAN (- Y2 Y1) (- X2 X1)))
    (SETQ THETA (* TH (/ 180.0 PI)))
    (SETQ YSTH (ROUND (* (1+ SIZE) (SIN TH))))
    (SETQ YCTH (ROUND (* (1+ SIZE) (COS TH))))
    (IF (AND (EQL Y1 Y2) (EVENP LINEWIDTH))
        (IF (> X2 X1) (SETQ Y2DELB 1) (SETQ Y2DELA 1)))
    (IF (AND (EQL X1 X2) (EVENP LINEWIDTH))
        (IF (> Y2 Y1) (SETQ X2DELB 1) (SETQ X2DELA 1)))
    (WINDOW-DRAW-ARC-XY W (- (- X2 YSTH) X2DELA) (+ (+ Y2 YCTH) Y2DELA)
        SIZE SIZE (+ 240 THETA) 30 LINEWIDTH)
    (WINDOW-DRAW-ARC-XY W (- (+ X2 YSTH) X2DELB) (+ (- Y2 YCTH) Y2DELB)
        SIZE SIZE (+ 90 THETA) 30 LINEWIDTH)))

(DEFUN WINDOW-DRAW-ARROW-XY
       (W X1 Y1 X2 Y2 &OPTIONAL (LINEWIDTH 1) SIZE)
  (WINDOW-DRAW-LINE-XY W X1 Y1 X2 Y2 LINEWIDTH)
  (WINDOW-DRAW-ARROWHEAD-XY W X1 Y1 X2 Y2 LINEWIDTH SIZE))

(DEFUN WINDOW-DRAW-ARROW2-XY
       (W X1 Y1 X2 Y2 &OPTIONAL (LINEWIDTH 1) SIZE)
  (WINDOW-DRAW-LINE-XY W X1 Y1 X2 Y2 LINEWIDTH)
  (WINDOW-DRAW-ARROWHEAD-XY W X1 Y1 X2 Y2 LINEWIDTH SIZE)
  (WINDOW-DRAW-ARROWHEAD-XY W X2 Y2 X1 Y1 LINEWIDTH SIZE))

(DEFUN WINDOW-DRAW-BOX (W OFFSET SIZE &OPTIONAL LINEWIDTH)
  (WINDOW-DRAW-BOX-XY W (CAR OFFSET) (CADR OFFSET) (CAR SIZE)
      (CADR SIZE) LINEWIDTH))

(DEFUN WINDOW-DRAW-BOX-XY
       (W OFFSETX OFFSETY SIZEX SIZEY &OPTIONAL LINEWIDTH)
  (LET ((QQWHEIGHT (CADDDR W)) MINY LW LW2 LW2B (PW (CADR W))
        (GC (CADDR W)))
    (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
        (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) (OR LINEWIDTH 1)
            0 1 0))
    (SETQ LW (OR LINEWIDTH 1))
    (SETQ LW2 (TRUNCATE LW 2))
    (SETQ LW2B (TRUNCATE (1+ LW) 2))
    (SETQ MINY (- OFFSETY LW2B))
    (XDRAWLINE *WINDOW-DISPLAY* PW GC OFFSETX (- QQWHEIGHT MINY)
        OFFSETX (- QQWHEIGHT (+ (+ MINY SIZEY) LW)))
    (XDRAWLINE *WINDOW-DISPLAY* PW GC (+ OFFSETX SIZEX)
        (- QQWHEIGHT MINY) (+ OFFSETX SIZEX)
        (- QQWHEIGHT (+ (+ MINY SIZEY) LW)))
    (XDRAWLINE *WINDOW-DISPLAY* PW GC (+ OFFSETX LW2B)
        (- QQWHEIGHT OFFSETY) (- (+ OFFSETX SIZEX) LW2)
        (- QQWHEIGHT OFFSETY))
    (XDRAWLINE *WINDOW-DISPLAY* PW GC (+ OFFSETX LW2B)
        (- QQWHEIGHT (+ OFFSETY SIZEY)) (- (+ OFFSETX SIZEX) LW2)
        (- QQWHEIGHT (+ OFFSETY SIZEY)))
    (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
        (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 0 1 0))))

(DEFUN WINDOW-XOR-BOX-XY
       (W OFFSETX OFFSETY SIZEX SIZEY &OPTIONAL LINEWIDTH)
  (WINDOW-SET-XOR W)
  (WINDOW-DRAW-BOX-XY W OFFSETX OFFSETY SIZEX SIZEY LINEWIDTH)
  (WINDOW-UNSET W))

(DEFUN WINDOW-DRAW-BOX-CORNERS (W XA YA XB YB &OPTIONAL LW)
  (WINDOW-DRAW-BOX-XY W (MIN XA XB) (MIN YA YB) (ABS (- XA XB))
      (ABS (- YA YB)) LW))

(DEFUN WINDOW-DRAW-RCBOX-XY
       (W X Y WIDTH HEIGHT RADIUS &OPTIONAL LINEWIDTH)
  (LET (X1 X2 Y1 Y2 R)
    (SETQ R
          (MAX 0
               (MIN RADIUS (TRUNCATE (ABS WIDTH) 2)
                    (TRUNCATE (ABS HEIGHT) 2))))
    (SETQ X1 (+ X R))
    (SETQ X2 (- (+ X WIDTH) R))
    (SETQ Y1 (+ Y R))
    (SETQ Y2 (- (+ Y HEIGHT) R))
    (LET ((QQWHEIGHT (CADDDR W)))
      (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
          (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W)
              (OR LINEWIDTH 1) 0 1 0))
      (XDRAWLINE *WINDOW-DISPLAY* (CADR W) (CADDR W) X1 (- QQWHEIGHT Y)
          X2 (- QQWHEIGHT Y))
      (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
          (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 0 1 0)))
    (LET ((QQWHEIGHT (CADDDR W)))
      (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
          (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W)
              (OR LINEWIDTH 1) 0 1 0))
      (XDRAWLINE *WINDOW-DISPLAY* (CADR W) (CADDR W) (+ X WIDTH)
          (- QQWHEIGHT Y1) (+ X WIDTH) (- QQWHEIGHT Y2))
      (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
          (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 0 1 0)))
    (LET ((QQWHEIGHT (CADDDR W)))
      (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
          (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W)
              (OR LINEWIDTH 1) 0 1 0))
      (XDRAWLINE *WINDOW-DISPLAY* (CADR W) (CADDR W) X1
          (- QQWHEIGHT (+ Y HEIGHT)) X2 (- QQWHEIGHT (+ Y HEIGHT)))
      (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
          (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 0 1 0)))
    (LET ((QQWHEIGHT (CADDDR W)))
      (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
          (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W)
              (OR LINEWIDTH 1) 0 1 0))
      (XDRAWLINE *WINDOW-DISPLAY* (CADR W) (CADDR W) X (- QQWHEIGHT Y1)
          X (- QQWHEIGHT Y2))
      (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
          (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 0 1 0)))
    (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
        (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) (OR LINEWIDTH 1)
            0 1 0))
    (XDRAWARC *WINDOW-DISPLAY* (CADR W) (CADDR W) (- X1 R)
        (- (CADDDR W) (+ Y1 R)) (* 2 R) (* 2 R) 11520 5760)
    (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
        (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 0 1 0))
    (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
        (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) (OR LINEWIDTH 1)
            0 1 0))
    (XDRAWARC *WINDOW-DISPLAY* (CADR W) (CADDR W) (- X2 R)
        (- (CADDDR W) (+ Y1 R)) (* 2 R) (* 2 R) 17280 5760)
    (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
        (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 0 1 0))
    (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
        (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) (OR LINEWIDTH 1)
            0 1 0))
    (XDRAWARC *WINDOW-DISPLAY* (CADR W) (CADDR W) (- X2 R)
        (- (CADDDR W) (+ Y2 R)) (* 2 R) (* 2 R) 0 5760)
    (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
        (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 0 1 0))
    (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
        (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) (OR LINEWIDTH 1)
            0 1 0))
    (XDRAWARC *WINDOW-DISPLAY* (CADR W) (CADDR W) (- X1 R)
        (- (CADDDR W) (+ Y2 R)) (* 2 R) (* 2 R) 5760 5760)
    (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
        (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 0 1 0))))

(DEFUN WINDOW-DRAW-ARC-XY
       (W X Y RADIUSX RADIUSY ANGLEA ANGLEB &OPTIONAL LINEWIDTH)
  (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
      (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) (OR LINEWIDTH 1) 0
          1 0))
  (XDRAWARC *WINDOW-DISPLAY* (CADR W) (CADDR W) (- X RADIUSX)
      (- (CADDDR W) (+ Y RADIUSY)) (* 2 RADIUSX) (* 2 RADIUSY)
      (TRUNCATE (* 64 ANGLEA)) (TRUNCATE (* 64 ANGLEB)))
  (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
      (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 0 1 0)))

(DEFUN WINDOW-DRAW-CIRCLE-XY (W X Y RADIUS &OPTIONAL LINEWIDTH)
  (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
      (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) (OR LINEWIDTH 1) 0
          1 0))
  (XDRAWARC *WINDOW-DISPLAY* (CADR W) (CADDR W) (- X RADIUS)
      (- (CADDDR W) (+ Y RADIUS)) (* 2 RADIUS) (* 2 RADIUS) 0 23040)
  (IF (AND LINEWIDTH (NOT (EQL LINEWIDTH 1)))
      (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 0 1 0)))

(DEFUN WINDOW-DRAW-CIRCLE (W POS RADIUS &OPTIONAL LINEWIDTH)
  (WINDOW-DRAW-CIRCLE-XY W (CAR POS) (CADR POS) RADIUS LINEWIDTH))

(DEFUN WINDOW-ERASE-AREA (W OFFSET SIZE)
  (WINDOW-ERASE-AREA-XY W (CAR OFFSET) (CADR OFFSET) (CAR SIZE)
      (CADR SIZE)))

(DEFUN WINDOW-ERASE-AREA-XY (W XOFF YOFF XSIZE YSIZE)
  (XCLEARAREA *WINDOW-DISPLAY* (CADR W) XOFF
      (- (CADDDR W) (1- (+ YOFF YSIZE))) XSIZE YSIZE 0))

(DEFUN WINDOW-DRAW-ELLIPSE-XY (W X Y RX RY &OPTIONAL LW)
  (IF (AND LW (NOT (EQL LW 1)))
      (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) (OR LW 1) 0 1 0))
  (XDRAWARC *WINDOW-DISPLAY* (CADR W) (CADDR W) (- X RX)
      (- (CADDDR W) (+ Y RY)) (* 2 RX) (* 2 RY) 0 23040)
  (IF (AND LW (NOT (EQL LW 1)))
      (XSETLINEATTRIBUTES *WINDOW-DISPLAY* (CADDR W) 1 0 1 0)))

(DEFUN WINDOW-COPY-AREA-XY (W FROMX FROMY TOX TOY WIDTH HEIGHT)
  (LET ((QQWHEIGHT (CADDDR W)))
    (SETQ *WINDOW-SAVE-FUNCTION*
          (PROGN
            (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCFUNCTION
                *GC-VALUES*)
            (XGCVALUES-FUNCTION *GC-VALUES*)))
    (XSETFUNCTION *WINDOW-DISPLAY* (CADDR W) GXCOPY)
    (SETQ *WINDOW-SAVE-FOREGROUND*
          (PROGN
            (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCFOREGROUND
                *GC-VALUES*)
            (XGCVALUES-FOREGROUND *GC-VALUES*)))
    (XCOPYAREA *WINDOW-DISPLAY* (CADR W) (CADR W) (CADDR W) FROMX
        (- QQWHEIGHT (+ FROMY HEIGHT)) WIDTH HEIGHT TOX
        (- QQWHEIGHT (+ TOY HEIGHT)))
    (LET ((GC (CADDR W)))
      (XSETFUNCTION *WINDOW-DISPLAY* GC *WINDOW-SAVE-FUNCTION*)
      (XSETFOREGROUND *WINDOW-DISPLAY* GC *WINDOW-SAVE-FOREGROUND*))))

(DEFUN WINDOW-INVERTAREA (W AREA)
  (WINDOW-INVERT-AREA-XY W (CAAR AREA) (CADAR AREA) (CAADR AREA)
      (CADADR AREA)))

(DEFUN WINDOW-INVERT-AREA (W OFFSET SIZE)
  (WINDOW-INVERT-AREA-XY W (CAR OFFSET) (CADR OFFSET) (CAR SIZE)
      (CADR SIZE)))

(DEFUN WINDOW-INVERT-AREA-XY (W LEFT BOTTOM WIDTH HEIGHT)
  (LET ((GC (CADDR W)))
    (SETQ *WINDOW-SAVE-FUNCTION*
          (PROGN
            (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCFUNCTION
                *GC-VALUES*)
            (XGCVALUES-FUNCTION *GC-VALUES*)))
    (XSETFUNCTION *WINDOW-DISPLAY* GC GXXOR)
    (SETQ *WINDOW-SAVE-FOREGROUND*
          (PROGN
            (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCFOREGROUND
                *GC-VALUES*)
            (XGCVALUES-FOREGROUND *GC-VALUES*)))
    (XSETFOREGROUND *WINDOW-DISPLAY* GC
        (LOGXOR *WINDOW-SAVE-FOREGROUND*
                (PROGN
                  (XGETGCVALUES *WINDOW-DISPLAY* (CADDR W) GCBACKGROUND
                      *GC-VALUES*)
                  (XGCVALUES-BACKGROUND *GC-VALUES*)))))
  (XFILLRECTANGLE *WINDOW-DISPLAY* (CADR W) (CADDR W) LEFT
      (- (CADDDR W) (1- (+ BOTTOM HEIGHT))) WIDTH HEIGHT)
  (LET ((GC (CADDR W)))
    (XSETFUNCTION *WINDOW-DISPLAY* GC *WINDOW-SAVE-FUNCTION*)
    (XSETFOREGROUND *WINDOW-DISPLAY* GC *WINDOW-SAVE-FOREGROUND*)))

(DEFUN WINDOW-PRETTYPRINTAT (W S POS)
  (LET ((SSTR (STRINGIFY S)))
    (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR W) (CADDR W) (CAR POS)
        (- (CADDDR W) (CADR POS)) (GET-C-STRING SSTR) (LENGTH SSTR))))

(DEFUN WINDOW-PRETTYPRINTAT-XY (W S X Y)
  (LET ((SSTR (STRINGIFY S)))
    (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR W) (CADDR W) X
        (- (CADDDR W) Y) (GET-C-STRING SSTR) (LENGTH SSTR))))

(DEFUN WINDOW-PRINTAT (W S POS)
  (LET ((SSTR (STRINGIFY S)))
    (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR W) (CADDR W) (CAR POS)
        (- (CADDDR W) (CADR POS)) (GET-C-STRING SSTR) (LENGTH SSTR))))

(DEFUN WINDOW-PRINTAT-XY (W S X Y)
  (LET ((SSTR (STRINGIFY S)))
    (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR W) (CADDR W) X
        (- (CADDDR W) Y) (GET-C-STRING SSTR) (LENGTH SSTR))))

(DEFUN WINDOW-STRING-WIDTH (W S)
  (LET ((SSTR (STRINGIFY S)))
    (XTEXTWIDTH (SEVENTH W) (GET-C-STRING SSTR) (LENGTH SSTR))))

(DEFUN WINDOW-FONT-STRING-WIDTH (FONT S)
  (LET ((SSTR (STRINGIFY S)))
    (XTEXTWIDTH FONT (GET-C-STRING SSTR) (LENGTH SSTR))))

(DEFUN WINDOW-YPOSITION (W)
  (WINDOW-GET-MOUSE-POSITION)
  (- (CADDDR W)
     (- *MOUSE-Y*
        (PROGN
          (WINDOW-GET-GEOMETRY-B (CADR W))
          (INT-POS *Y-RETURN* 0)))))

(DEFUN WINDOW-CENTEROFFSET (W V)
  (LIST (TRUNCATE (- (FIFTH W) (CAR V)) 2)
        (TRUNCATE (- (CADDDR W) (CADR V)) 2)))

(DEFUN DOWINDOWCOM (W)
  (LET (COMM)
    (SETQ COMM (SELECT (WINDOW-MENU)))
    (CASE COMM
      (CLOSE (XUNMAPWINDOW *WINDOW-DISPLAY* (CADR W))
             (XFLUSH *WINDOW-DISPLAY*))
      (PAINT (PAINT W))
      (CLEAR (XCLEARWINDOW *WINDOW-DISPLAY* (CADR W))
             (XFLUSH *WINDOW-DISPLAY*))
      (MOVE (MOVE W))
      (T (WHEN COMM (PRINC "This command not implemented.") (TERPRI))))))

(DEFUN WINDOW-MENU ()
  (OR *WINDOW-MENU*
      (SETQ *WINDOW-MENU*
            (COPY-LIST
                '(MENU NIL NIL NIL 0 0 0 0 "" NIL NIL 0 0
                       (CLOSE PAINT CLEAR MOVE))))))

(DEFUN WINDOW-CLOSE (W)
  (XUNMAPWINDOW *WINDOW-DISPLAY* (CADR W))
  (XFLUSH *WINDOW-DISPLAY*))

(DEFUN WINDOW-UNMAP (W) (XUNMAPWINDOW *WINDOW-DISPLAY* (CADR W)))

(DEFUN WINDOW-OPEN (W)
  (XMAPWINDOW *WINDOW-DISPLAY* (CADR W))
  (XFLUSH *WINDOW-DISPLAY*)
  (WINDOW-WAIT-EXPOSURE W))

(DEFUN WINDOW-MAP (W) (XMAPWINDOW *WINDOW-DISPLAY* (CADR W)))

(DEFUN WINDOW-DESTROY (W)
  (XDESTROYWINDOW *WINDOW-DISPLAY* (CADR W))
  (XFLUSH *WINDOW-DISPLAY*)
  (RPLACA (CDR W) NIL)
  (XFREEGC *WINDOW-DISPLAY* (CADDR W))
  (CAR (RPLACA (CDDR W) NIL)))

(DEFUN WINDOW-DESTROY-SELECTED-WINDOW ()
  (PROG (WW CHILD)
    (SLEEP 3)
    (SETQ WW *ROOT-WINDOW*)
    LP
    (WINDOW-QUERY-POINTER-B WW)
    (SETQ CHILD (INT-POS *CHILD-RETURN* 0))
    (IF (> CHILD 0) (PROGN (SETQ WW CHILD) (GO LP)))
    (IF (/= WW *ROOT-WINDOW*)
        (PROGN
          (XDESTROYWINDOW *WINDOW-DISPLAY* WW)
          (XFLUSH *WINDOW-DISPLAY*)))))

(DEFUN WINDOW-CLEAR (W)
  (XCLEARWINDOW *WINDOW-DISPLAY* (CADR W))
  (XFLUSH *WINDOW-DISPLAY*))

(DEFUN WINDOW-MOVETO-XY (W X Y)
  (XMOVEWINDOW *WINDOW-DISPLAY* (CADR W) X
      (- (WINDOW-SCREEN-HEIGHT) Y)))

(DEFUN WINDOW-PAINT (WINDOW)
  (LET (STATE)
    (WINDOW-TRACK-MOUSE WINDOW
        #'(LAMBDA (X Y CODE)
            (IF (= CODE 1)
                (IF (= STATE 1) (SETQ STATE 0) (SETQ STATE 1))
                (IF (= CODE 2)
                    (IF (= STATE 2) (SETQ STATE 0) (SETQ STATE 2))))
            (IF (= STATE 1)
                (WINDOW-DRAW-LINE-XY WINDOW X Y X Y 1 'PAINT)
                (IF (= STATE 2)
                    (WINDOW-DRAW-LINE-XY WINDOW X Y X Y 1 'ERASE)))
            (= CODE 3)))))

(DEFUN WINDOW-MOVE (W)
  (WINDOW-GET-MOUSE-POSITION)
  (XMOVEWINDOW *WINDOW-DISPLAY* (PARENT W) *MOUSE-X*
      (- (WINDOW-SCREEN-HEIGHT) *MOUSE-Y*)))

(DEFUN WINDOW-TRACK-MOUSE (W FN &OPTIONAL OUTFLG)
  (LET (WIN H)
    (SETQ WIN (WINDOW-PARENT W))
    (SETQ H (WINDOW-DRAWABLE-HEIGHT W))
    (XSYNC *WINDOW-DISPLAY* 1)
    (XSELECTINPUT *WINDOW-DISPLAY* WIN
        (+ BUTTONPRESSMASK POINTERMOTIONMASK))
    (DO ((RES NIL)) (RES RES)
      (XNEXTEVENT *WINDOW-DISPLAY* *WINDOW-EVENT*)
      (LET ((TYPE (XANYEVENT-TYPE *WINDOW-EVENT*))
            (EVENTWINDOW (XANYEVENT-WINDOW *WINDOW-EVENT*)))
        (WHEN (OR (AND (EQL EVENTWINDOW WIN)
                       (OR (EQL TYPE MOTIONNOTIFY)
                           (EQL TYPE BUTTONPRESS)))
                  (AND OUTFLG (EQL TYPE BUTTONPRESS)))
          (LET ((X (XMOTIONEVENT-X *WINDOW-EVENT*))
                (Y (XMOTIONEVENT-Y *WINDOW-EVENT*))
                (CODE (IF (EQL TYPE BUTTONPRESS)
                          (XBUTTONEVENT-BUTTON *WINDOW-EVENT*) 0)))
            (SETQ RES
                  (IF (EQL EVENTWINDOW WIN) (FUNCALL FN X (- H Y) CODE)
                      (FUNCALL FN -1 -1 CODE)))))))))

(DEFUN WINDOW-WAIT-EXPOSURE (W)
  (PROG (WIN START-TIME MAX-TIME EVENTWINDOW TYPE)
    (SETQ WIN (WINDOW-PARENT W))
    (XGETWINDOWATTRIBUTES *WINDOW-DISPLAY* WIN *WINDOW-ATTR*)
    (UNLESS (EQL (XWINDOWATTRIBUTES-MAP_STATE *WINDOW-ATTR*)
                 ISUNMAPPED)
      (RETURN T))
    (SETQ START-TIME (GET-INTERNAL-REAL-TIME))
    (SETQ MAX-TIME INTERNAL-TIME-UNITS-PER-SECOND)
    (XSELECTINPUT *WINDOW-DISPLAY* WIN (+ EXPOSUREMASK))
    LP
    (COND
      ((> (XPENDING *WINDOW-DISPLAY*) 0)
       (XNEXTEVENT *WINDOW-DISPLAY* *WINDOW-EVENT*)
       (SETQ TYPE (XANYEVENT-TYPE *WINDOW-EVENT*))
       (SETQ EVENTWINDOW (XANYEVENT-WINDOW *WINDOW-EVENT*))
       (IF (AND (EQL EVENTWINDOW WIN) (EQL TYPE EXPOSE)) (RETURN T)))
      ((> (- (GET-INTERNAL-REAL-TIME) START-TIME) MAX-TIME)
       (RETURN NIL)))
    (GO LP)))

(DEFUN MENU-INIT (M)
  (LET (MAXWIDTH MAXHEIGHT NITEMS)
    (OR *WINDOW-DISPLAY* (WINDOW-XINIT))
    (OR (NTH 10 M) (SETF (NTH 10 M) '9X15))
    (SETQ MAXWIDTH (MENU-FIND-ITEM-WIDTH M (NINTH M)))
    (SETQ MAXHEIGHT 13)
    (SETQ NITEMS (IF (AND (NINTH M) (PLUSP (LENGTH (NINTH M)))) 1 0))
    (DOLIST (ITEM (NTH 13 M))
      (INCF NITEMS)
      (SETQ MAXWIDTH (MAX MAXWIDTH (MENU-FIND-ITEM-WIDTH M ITEM)))
      (SETQ MAXHEIGHT (MAX MAXHEIGHT (MENU-FIND-ITEM-HEIGHT M ITEM))))
    (SETF (NTH 11 M) (+ 6 MAXWIDTH))
    (SETF (SEVENTH M) (1+ (NTH 11 M)))
    (SETF (NTH 12 M) (+ 2 MAXHEIGHT))
    (SETF (EIGHTH M) (+ 2 (* (NTH 12 M) NITEMS)))
    (MENU-ADJUST-OFFSET M)
    (UNLESS (CADDR M)
      (CAR (RPLACA (CDR M)
                   (WINDOW-CREATE (SEVENTH M) (EIGHTH M)
                       (OR (NINTH M) "") (CADDDR M) (FIFTH M) (SIXTH M)
                       (NTH 10 M)))))))

(DEFUN MENU-ADJUST-OFFSET (M)
  (LET (XBASE YBASE WBASE HBASE XOFF YOFF WGM WIDTH HEIGHT)
    (SETQ WIDTH (SEVENTH M))
    (SETQ HEIGHT (EIGHTH M))
    (UNLESS (CADDDR M)
      (WINDOW-GET-MOUSE-POSITION)
      (SETQ WGM T)
      (RPLACA (CDDDR M) *MOUSE-WINDOW*))
    (WINDOW-GET-GEOMETRY-B (CADDDR M))
    (SETQ XBASE (INT-POS *X-RETURN* 0))
    (SETQ YBASE (INT-POS *Y-RETURN* 0))
    (SETQ WBASE (INT-POS *WIDTH-RETURN* 0))
    (SETQ HBASE (INT-POS *HEIGHT-RETURN* 0))
    (IF (OR (NOT (FIFTH M)) (ZEROP (FIFTH M)))
        (PROGN
          (OR WGM (WINDOW-GET-MOUSE-POSITION))
          (SETQ XOFF (- (- (- *MOUSE-X* XBASE) (TRUNCATE WIDTH 2)) 4))
          (SETQ YOFF
                (- (- HBASE (- *MOUSE-Y* YBASE)) (TRUNCATE HEIGHT 2))))
        (PROGN (SETQ XOFF (FIFTH M)) (SETQ YOFF (SIXTH M))))
    (SETF (FIFTH M) (MAX 0 (MIN XOFF (- WBASE WIDTH))))
    (SETF (SIXTH M) (MAX 0 (MIN YOFF (- HBASE HEIGHT))))))

(DEFUN MENU-DRAW (M)
  (LET (MW XZERO YZERO BOTTOM)
    (SETQ XZERO (IF (CADDR M) (FIFTH M) 0))
    (SETQ YZERO (IF (CADDR M) (SIXTH M) 0))
    (SETQ MW (CADR M))
    (XMAPWINDOW *WINDOW-DISPLAY* (CADR MW))
    (XFLUSH *WINDOW-DISPLAY*)
    (WINDOW-WAIT-EXPOSURE MW)
    (MENU-CLEAR M)
    (IF (CADDR M)
        (WINDOW-DRAW-BOX-XY MW (1- XZERO) YZERO (+ 2 (SEVENTH M))
            (1+ (EIGHTH M)) 1))
    (SETQ BOTTOM (+ 3 (+ YZERO (EIGHTH M))))
    (WHEN (AND (NINTH M) (PLUSP (LENGTH (NINTH M))))
      (SETQ BOTTOM (- BOTTOM (NTH 12 M)))
      (LET ((SSTR (STRINGIFY (STRINGIFY (NINTH M)))))
        (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR MW) (CADDR MW)
            (+ 3 XZERO) (- (CADDDR MW) BOTTOM) (GET-C-STRING SSTR)
            (LENGTH SSTR)))
      (LET ((GLVAR1242 (NTH 12 M)))
        (LET ((GC (CADDR MW)))
          (SETQ *WINDOW-SAVE-FUNCTION*
                (PROGN
                  (XGETGCVALUES *WINDOW-DISPLAY* (CADDR MW) GCFUNCTION
                      *GC-VALUES*)
                  (XGCVALUES-FUNCTION *GC-VALUES*)))
          (XSETFUNCTION *WINDOW-DISPLAY* GC GXXOR)
          (SETQ *WINDOW-SAVE-FOREGROUND*
                (PROGN
                  (XGETGCVALUES *WINDOW-DISPLAY* (CADDR MW)
                      GCFOREGROUND *GC-VALUES*)
                  (XGCVALUES-FOREGROUND *GC-VALUES*)))
          (XSETFOREGROUND *WINDOW-DISPLAY* GC
              (LOGXOR *WINDOW-SAVE-FOREGROUND*
                      (PROGN
                        (XGETGCVALUES *WINDOW-DISPLAY* (CADDR MW)
                            GCBACKGROUND *GC-VALUES*)
                        (XGCVALUES-BACKGROUND *GC-VALUES*)))))
        (XFILLRECTANGLE *WINDOW-DISPLAY* (CADR MW) (CADDR MW) XZERO
            (- (CADDDR MW) (1- (+ (- BOTTOM 2) GLVAR1242)))
            (1+ (SEVENTH M)) GLVAR1242)
        (LET ((GC (CADDR MW)))
          (XSETFUNCTION *WINDOW-DISPLAY* GC *WINDOW-SAVE-FUNCTION*)
          (XSETFOREGROUND *WINDOW-DISPLAY* GC *WINDOW-SAVE-FOREGROUND*))))
    (DOLIST (ITEM (NTH 13 M))
      (SETQ BOTTOM (- BOTTOM (NTH 12 M)))
      (MENU-DISPLAY-ITEM M ITEM (+ 3 XZERO) BOTTOM))
    (XFLUSH *WINDOW-DISPLAY*)))

(DEFUN MENU-ITEM-VALUE (SELF ITEM) (IF (CONSP ITEM) (CDR ITEM) ITEM))

(DEFUN MENU-FIND-ITEM-WIDTH (SELF ITEM)
  (LET (TMP)
    (IF (AND (CONSP ITEM) (SYMBOLP (CAR ITEM)) (FBOUNDP (CAR ITEM)))
        (OR (AND (SETQ TMP (GET (CAR ITEM) 'DISPLAY-SIZE)) (CAR TMP))
            40)
        (WINDOW-FONT-STRING-WIDTH
            (OR (AND (CADDR SELF) (CADR SELF) (SEVENTH (CADR SELF)))
                (WINDOW-FONT-INFO (NTH 10 SELF)))
            (STRINGIFY (IF (CONSP ITEM) (CAR ITEM) ITEM))))))

(DEFUN MENU-FIND-ITEM-HEIGHT (SELF ITEM)
  (LET (TMP)
    (IF (AND (CONSP ITEM) (SYMBOLP (CAR ITEM))
             (SETQ TMP (GET (CAR ITEM) 'DISPLAY-SIZE)))
        (+ 3 (CADR TMP)) 15)))

(DEFUN MENU-CLEAR (M)
  (IF (CADDR M)
      (LET ((GLVAR1243 (CADR M)) (GLVAR1247 (+ 3 (EIGHTH M))))
        (XCLEARAREA *WINDOW-DISPLAY* (CADR GLVAR1243)
            (1- (IF (CADDR M) (FIFTH M) 0))
            (- (CADDDR GLVAR1243)
               (1- (+ (1- (IF (CADDR M) (SIXTH M) 0)) GLVAR1247)))
            (+ 3 (SEVENTH M)) GLVAR1247 0))
      (PROGN
        (XCLEARWINDOW *WINDOW-DISPLAY* (CADADR M))
        (XFLUSH *WINDOW-DISPLAY*))))

(DEFUN MENU-DISPLAY-ITEM (SELF ITEM X Y)
  (LET ((MW (CADR SELF)))
    (IF (CONSP ITEM)
        (COND
          ((AND (SYMBOLP (CAR ITEM)) (FBOUNDP (CAR ITEM)))
           (FUNCALL (CAR ITEM) MW X Y))
          ((OR (STRINGP (CAR ITEM)) (SYMBOLP (CAR ITEM))
               (NUMBERP (CAR ITEM)))
           (LET ((SSTR (STRINGIFY (CAR ITEM))))
             (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR MW) (CADDR MW) X
                 (- (CADDDR MW) Y) (GET-C-STRING SSTR) (LENGTH SSTR))))
          (T (LET ((SSTR (STRINGIFY (STRINGIFY ITEM))))
               (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR MW) (CADDR MW)
                   X (- (CADDDR MW) Y) (GET-C-STRING SSTR)
                   (LENGTH SSTR)))))
        (LET ((SSTR (STRINGIFY (STRINGIFY ITEM))))
          (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR MW) (CADDR MW) X
              (- (CADDDR MW) Y) (GET-C-STRING SSTR) (LENGTH SSTR))))))

(DEFUN MENU-CHOOSE (M)
  (LET (MW CURRENT-ITEM-N NEWN ITEMH ITMS NITEMS VAL MAXX INSIDE XZERO
           YZERO)
    (OR (AND (CADR M) (PLUSP (NTH 12 M))) (MENU-INIT M))
    (SETQ MW (CADR M))
    (MENU-DRAW M)
    (SETQ XZERO (IF (CADDR M) (FIFTH M) 0))
    (SETQ YZERO (IF (CADDR M) (SIXTH M) 0))
    (SETQ MAXX (+ XZERO (SEVENTH M)))
    (SETQ ITEMH (NTH 12 M))
    (SETQ ITMS (NTH 13 M))
    (SETQ NITEMS (LENGTH ITMS))
    (WINDOW-TRACK-MOUSE MW
        #'(LAMBDA (X Y CODE)
            (SETQ NEWN
                  (1- (- NITEMS (TRUNCATE (- Y (+ 3 YZERO)) ITEMH))))
            (IF (AND (>= X XZERO) (<= X MAXX) (>= NEWN 0)
                     (< NEWN NITEMS))
                (PROGN
                  (IF CURRENT-ITEM-N
                      (WHEN (/= NEWN CURRENT-ITEM-N)
                        (MENU-UNBOX-ITEM M CURRENT-ITEM-N)
                        (MENU-BOX-ITEM M NEWN)
                        (SETQ CURRENT-ITEM-N NEWN))
                      (PROGN
                        (SETQ INSIDE T)
                        (MENU-BOX-ITEM M NEWN)
                        (SETQ CURRENT-ITEM-N NEWN)))
                  (WHEN (AND CURRENT-ITEM-N (PLUSP CODE))
                    (MENU-UNBOX-ITEM M CURRENT-ITEM-N)
                    (SETQ VAL CURRENT-ITEM-N)))
                (PROGN
                  (WHEN CURRENT-ITEM-N
                    (MENU-UNBOX-ITEM M CURRENT-ITEM-N)
                    (SETQ CURRENT-ITEM-N NIL))
                  (IF (OR (PLUSP CODE)
                          (AND INSIDE
                               (OR (< X XZERO) (> X MAXX) (< Y YZERO)
                                   (> Y (+ YZERO (EIGHTH M))))))
                      (SETQ VAL 'NO-SELECCTION-VAL)))))
        T)
    (UNLESS (EQ VAL 'NO-SELECCTION-VAL)
      (LET ((GLVAR1253 (NTH VAL ITMS)))
        (IF (CONSP GLVAR1253) (CDR GLVAR1253) GLVAR1253)))))

(DEFUN MENU-BOX-ITEM (M ITEM)
  (LET (ITEMH NITEMS)
    (SETQ ITEMH (NTH 12 M))
    (SETQ NITEMS (LENGTH (NTH 13 M)))
    (WINDOW-DRAW-BOX-XY (CADR M) (1+ (IF (CADDR M) (FIFTH M) 0))
        (+ (IF (CADDR M) (SIXTH M) 0)
           (+ 2 (* (1- (- NITEMS ITEM)) ITEMH)))
        (- (NTH 11 M) 2) ITEMH 1)))

(DEFUN MENU-UNBOX-ITEM (M ITEM)
  (LET ((MW (OR (CADR M) (MENU-INIT M))))
    (LET ((GC (CADDR MW)))
      (SETQ *WINDOW-SAVE-FUNCTION*
            (PROGN
              (XGETGCVALUES *WINDOW-DISPLAY* (CADDR MW) GCFUNCTION
                  *GC-VALUES*)
              (XGCVALUES-FUNCTION *GC-VALUES*)))
      (XSETFUNCTION *WINDOW-DISPLAY* GC GXCOPY)
      (SETQ *WINDOW-SAVE-FOREGROUND*
            (PROGN
              (XGETGCVALUES *WINDOW-DISPLAY* (CADDR MW) GCFOREGROUND
                  *GC-VALUES*)
              (XGCVALUES-FOREGROUND *GC-VALUES*)))
      (XSETFOREGROUND *WINDOW-DISPLAY* GC
          (PROGN
            (XGETGCVALUES *WINDOW-DISPLAY* (CADDR MW) GCBACKGROUND
                *GC-VALUES*)
            (XGCVALUES-BACKGROUND *GC-VALUES*))))
    (MENU-BOX-ITEM M ITEM)
    (LET ((GC (CADDR MW)))
      (XSETFUNCTION *WINDOW-DISPLAY* GC *WINDOW-SAVE-FUNCTION*)
      (XSETFOREGROUND *WINDOW-DISPLAY* GC *WINDOW-SAVE-FOREGROUND*))))

(DEFUN MENU-ITEM-POSITION (M ITEMNAME &OPTIONAL PLACE)
  (LET ((N 0) FOUND ITMS ITEM (XSIZE (NTH 11 M)) (YSIZE (NTH 12 M)))
    (SETQ ITMS (NTH 13 M))
    (TAGBODY
      GLLABEL1255
      (WHEN (AND ITMS (NOT FOUND))
        (INCF N)
        (SETQ ITEM (POP ITMS))
        (IF (OR (AND (SYMBOLP ITEM) (EQ ITEM ITEMNAME))
                (AND (CONSP ITEM) (EQ (CDR ITEM) ITEMNAME)))
            (SETQ FOUND T))
        (GO GLLABEL1255)))
    (IF FOUND
        (LIST (+ (IF (CADDR M) (FIFTH M) 0)
                 (CASE PLACE
                   ((CENTER TOP BOTTOM) (TRUNCATE XSIZE 2))
                   (LEFT 0)
                   (RIGHT XSIZE)
                   (T 0)))
              (+ (+ (IF (CADDR M) (SIXTH M) 0)
                    (* (- (LENGTH (NTH 13 M)) N) YSIZE))
                 (CASE PLACE
                   ((CENTER RIGHT LEFT) (TRUNCATE YSIZE 2))
                   (BOTTOM 0)
                   (TOP YSIZE)
                   (T 0)))))))

(DEFUN MENU-SELECT (M) (MENU-SELECT-B M NIL))

(DEFUN MENU-SELECT! (M) (MENU-SELECT-B M T))

(DEFUN MENU-SELECT-B (M FLG)
  (PROG (RES)
    LP
    (SETQ RES (MENU-CHOOSE M))
    (IF (AND FLG (NOT RES)) (GO LP))
    (UNLESS (TENTH M)
      (IF (CADDR M) (PROGN (MENU-CLEAR M) (XFLUSH *WINDOW-DISPLAY*))
          (PROGN
            (XUNMAPWINDOW *WINDOW-DISPLAY* (CADADR M))
            (XFLUSH *WINDOW-DISPLAY*))))
    (RETURN RES)))

(DEFUN MENU-DESTROY (M)
  (UNLESS (CADDR M)
    (LET ((GLVAR1259 (CADR M)))
      (XDESTROYWINDOW *WINDOW-DISPLAY* (CADR GLVAR1259))
      (XFLUSH *WINDOW-DISPLAY*)
      (RPLACA (CDR GLVAR1259) NIL)
      (XFREEGC *WINDOW-DISPLAY* (CADDR GLVAR1259))
      (RPLACA (CDDR GLVAR1259) NIL))
    (CAR (RPLACA (CDR M) NIL))))

(DEFUN MENU (ITEMS &OPTIONAL TITLE)
  (LET (M RES)
    (SETQ M (MENU-CREATE ITEMS TITLE))
    (SETQ RES (MENU-SELECT M))
    (MENU-DESTROY M)
    RES))

(DEFUN MENU-CREATE (ITEMS &OPTIONAL TITLE PARENTW X Y PERM FLAT FONT)
  (LIST 'MENU (IF FLAT PARENTW) FLAT (CADR PARENTW) X Y 0 0
        (IF TITLE (STRINGIFY TITLE) "") PERM FONT 0 0 ITEMS))

(DEFUN MENU-OFFSET (M)
  (LIST (IF (CADDR M) (FIFTH M) 0) (IF (CADDR M) (SIXTH M) 0)))

(DEFUN MENU-SIZE (M) (LIST (SEVENTH M) (EIGHTH M)))

(DEFUN MENU-MOVETO-XY (M X Y)
  (WHEN (CADDR M)
    (SETF (FIFTH M) X)
    (SETF (SIXTH M) Y)
    (MENU-ADJUST-OFFSET M)))

(DEFUN PICMENU-CREATE
       (BUTTONS WIDTH HEIGHT DRAWFN &OPTIONAL TITLE DOTFLG PARENTW X Y
                PERM FLAT FONT BOXFLG)
  (PICMENU-CREATE-FROM-SPEC
      (PICMENU-CREATE-SPEC BUTTONS WIDTH HEIGHT DRAWFN DOTFLG FONT)
      TITLE PARENTW X Y PERM FLAT BOXFLG))

(DEFUN PICMENU-CREATE-SPEC
       (BUTTONS WIDTH HEIGHT DRAWFN &OPTIONAL DOTFLG FONT)
  (LIST 'PICMENU-SPEC WIDTH HEIGHT BUTTONS DOTFLG DRAWFN
        (OR FONT '9X15)))

(DEFUN PICMENU-CREATE-FROM-SPEC
       (SPEC &OPTIONAL TITLE PARENTW X Y PERM FLAT BOXFLG)
  (LET ((GLVAR1260
            (LIST 'PICMENU (IF FLAT PARENTW) FLAT
                  (IF PARENTW (CADR PARENTW)) X Y 0 0
                  (IF TITLE (STRINGIFY TITLE) "") PERM SPEC BOXFLG)))
    (SETF (NTH 10 GLVAR1260) SPEC)
    GLVAR1260))

(DEFUN PICMENU-INIT (M)
  (LET (MAXWIDTH MAXHEIGHT)
    (SETQ MAXWIDTH
          (MAX (IF (NINTH M) (+ 6 (* 9 (LENGTH (NINTH M)))) 0)
               (CADR (NTH 10 M))))
    (SETQ MAXHEIGHT
          (+ (IF (AND (NINTH M) (PLUSP (LENGTH (NINTH M)))) 15 0)
             (CADDR (NTH 10 M))))
    (SETF (SEVENTH M) MAXWIDTH)
    (SETF (EIGHTH M) MAXHEIGHT)
    (MENU-ADJUST-OFFSET M)
    (UNLESS (CADDR M)
      (CAR (RPLACA (CDR M)
                   (WINDOW-CREATE MAXWIDTH MAXHEIGHT (OR (NINTH M) "")
                       (CADDDR M) (FIFTH M) (SIXTH M)
                       (SEVENTH (NTH 10 M))))))))

(DEFUN PICMENU-DRAW (M)
  (LET (MW BOTTOM XZERO YZERO)
    (OR (AND (CADR M) (PLUSP (EIGHTH M))) (PICMENU-INIT M))
    (SETQ MW (CADR M))
    (XMAPWINDOW *WINDOW-DISPLAY* (CADR MW))
    (XFLUSH *WINDOW-DISPLAY*)
    (WINDOW-WAIT-EXPOSURE MW)
    (MENU-CLEAR M)
    (SETQ XZERO (IF (CADDR M) (FIFTH M) 0))
    (SETQ YZERO (IF (CADDR M) (SIXTH M) 0))
    (SETQ BOTTOM (+ YZERO (EIGHTH M)))
    (WHEN (AND (NINTH M) (PLUSP (LENGTH (NINTH M))))
      (LET ((SSTR (STRINGIFY (STRINGIFY (NINTH M)))))
        (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR MW) (CADDR MW)
            (+ 3 XZERO) (- (CADDDR MW) (- BOTTOM 13))
            (GET-C-STRING SSTR) (LENGTH SSTR)))
      (LET ((GC (CADDR MW)))
        (SETQ *WINDOW-SAVE-FUNCTION*
              (PROGN
                (XGETGCVALUES *WINDOW-DISPLAY* (CADDR MW) GCFUNCTION
                    *GC-VALUES*)
                (XGCVALUES-FUNCTION *GC-VALUES*)))
        (XSETFUNCTION *WINDOW-DISPLAY* GC GXXOR)
        (SETQ *WINDOW-SAVE-FOREGROUND*
              (PROGN
                (XGETGCVALUES *WINDOW-DISPLAY* (CADDR MW) GCFOREGROUND
                    *GC-VALUES*)
                (XGCVALUES-FOREGROUND *GC-VALUES*)))
        (XSETFOREGROUND *WINDOW-DISPLAY* GC
            (LOGXOR *WINDOW-SAVE-FOREGROUND*
                    (PROGN
                      (XGETGCVALUES *WINDOW-DISPLAY* (CADDR MW)
                          GCBACKGROUND *GC-VALUES*)
                      (XGCVALUES-BACKGROUND *GC-VALUES*)))))
      (XFILLRECTANGLE *WINDOW-DISPLAY* (CADR MW) (CADDR MW) XZERO
          (- (CADDDR MW) BOTTOM) (SEVENTH M) 16)
      (LET ((GC (CADDR MW)))
        (XSETFUNCTION *WINDOW-DISPLAY* GC *WINDOW-SAVE-FUNCTION*)
        (XSETFOREGROUND *WINDOW-DISPLAY* GC *WINDOW-SAVE-FOREGROUND*)))
    (FUNCALL (SIXTH (NTH 10 M)) MW XZERO YZERO)
    (IF (NTH 11 M)
        (WINDOW-DRAW-BOX-XY MW XZERO YZERO (SEVENTH M) (EIGHTH M) 1))
    (IF (FIFTH (NTH 10 M))
        (DOLIST (B (CADDDR (NTH 10 M)))
          (WINDOW-DRAW-BOX-XY MW (- (+ XZERO (CAADR B)) 2)
              (- (+ YZERO (CADADR B)) 2) 4 4 1)))
    (XFLUSH *WINDOW-DISPLAY*)))

(DEFUN PICMENU-SELECT (M)
  (LET (MW CURRENT-BUTTON ITEM ITEMS VAL XZERO YZERO INSIDE)
    (SETQ MW (OR (CADR M) (PICMENU-INIT M)))
    (UNLESS (TENTH M) (PICMENU-DRAW M))
    (SETQ XZERO (IF (CADDR M) (FIFTH M) 0))
    (SETQ YZERO (IF (CADDR M) (SIXTH M) 0))
    (WINDOW-TRACK-MOUSE MW
        #'(LAMBDA (X Y CODE)
            (SETQ X (- X XZERO))
            (SETQ Y (- Y YZERO))
            (IF (AND (>= X 0) (<= X (SEVENTH M)) (>= Y 0)
                     (<= Y (EIGHTH M)))
                (SETQ INSIDE T))
            (IF CURRENT-BUTTON
                (UNLESS (PICMENU-BUTTON-CONTAINSXY? CURRENT-BUTTON X Y)
                  (PICMENU-UNBOX-ITEM M CURRENT-BUTTON)
                  (SETQ CURRENT-BUTTON NIL)))
            (UNLESS CURRENT-BUTTON
              (SETQ ITEMS (CADDDR (NTH 10 M)))
              (TAGBODY
                GLLABEL1266
                (WHEN (AND (NOT CURRENT-BUTTON)
                           (SETQ ITEM (POP ITEMS)))
                  (WHEN (PICMENU-BUTTON-CONTAINSXY? ITEM X Y)
                    (PICMENU-BOX-ITEM M ITEM)
                    (SETQ CURRENT-BUTTON ITEM))
                  (GO GLLABEL1266))))
            (WHEN (OR (PLUSP CODE)
                      (AND INSIDE
                           (OR (MINUSP X) (> X (SEVENTH M)) (MINUSP Y)
                               (> Y (EIGHTH M)))))
              (IF CURRENT-BUTTON (PICMENU-UNBOX-ITEM M CURRENT-BUTTON))
              (SETQ VAL (OR CURRENT-BUTTON 'NO-SELECCTION-VAL))))
        T)
    (UNLESS (TENTH M)
      (IF (CADDR M) (PROGN (MENU-CLEAR M) (XFLUSH *WINDOW-DISPLAY*))
          (PROGN
            (XUNMAPWINDOW *WINDOW-DISPLAY* (CADADR M))
            (XFLUSH *WINDOW-DISPLAY*))))
    (UNLESS (EQ VAL 'NO-SELECCTION-VAL) (CAR VAL))))

(DEFUN PICMENU-BOX-ITEM (M ITEM)
  (LET ((MW (OR (CADR M) (PICMENU-INIT M))) XOFF YOFF SIZ)
    (SETQ XOFF (+ (IF (CADDR M) (FIFTH M) 0) (CAADR ITEM)))
    (SETQ YOFF (+ (IF (CADDR M) (SIXTH M) 0) (CADADR ITEM)))
    (IF (CADDDR ITEM)
        (FUNCALL (CADDDR ITEM) (OR (CADR M) (PICMENU-INIT M)) XOFF
                 YOFF)
        (PROGN
          (LET ((GC (CADDR MW)))
            (SETQ *WINDOW-SAVE-FUNCTION*
                  (PROGN
                    (XGETGCVALUES *WINDOW-DISPLAY* (CADDR MW)
                        GCFUNCTION *GC-VALUES*)
                    (XGCVALUES-FUNCTION *GC-VALUES*)))
            (XSETFUNCTION *WINDOW-DISPLAY* GC GXXOR)
            (SETQ *WINDOW-SAVE-FOREGROUND*
                  (PROGN
                    (XGETGCVALUES *WINDOW-DISPLAY* (CADDR MW)
                        GCFOREGROUND *GC-VALUES*)
                    (XGCVALUES-FOREGROUND *GC-VALUES*)))
            (XSETFOREGROUND *WINDOW-DISPLAY* GC
                (LOGXOR *WINDOW-SAVE-FOREGROUND*
                        (PROGN
                          (XGETGCVALUES *WINDOW-DISPLAY* (CADDR MW)
                              GCBACKGROUND *GC-VALUES*)
                          (XGCVALUES-BACKGROUND *GC-VALUES*)))))
          (IF (SETQ SIZ (CADDR ITEM))
              (WINDOW-DRAW-BOX-XY MW (- XOFF (TRUNCATE (CAR SIZ) 2))
                  (- YOFF (TRUNCATE (CADR SIZ) 2)) (CAR SIZ) (CADR SIZ)
                  1)
              (WINDOW-DRAW-BOX-XY MW (- XOFF 6) (- YOFF 6) 12 12 1))
          (LET ((GC (CADDR MW)))
            (XSETFUNCTION *WINDOW-DISPLAY* GC *WINDOW-SAVE-FUNCTION*)
            (XSETFOREGROUND *WINDOW-DISPLAY* GC
                *WINDOW-SAVE-FOREGROUND*))
          (XFLUSH *WINDOW-DISPLAY*)))))

(DEFUN PICMENU-UNBOX-ITEM (M ITEM)
  (IF (FIFTH ITEM)
      (PROGN
        (FUNCALL (UNHIGHLIGHTFN M) (OR (CADR M) (PICMENU-INIT M))
                 (CAADR ITEM) (CADADR ITEM))
        (XFLUSH *WINDOW-DISPLAY*))
      (PICMENU-BOX-ITEM M ITEM)))

(DEFUN PICMENU-DESTROY (M) (MENU-DESTROY M))

(DEFUN PICMENU-BUTTON-CONTAINSXY? (B X Y)
  (LET ((XSIZE 6) (YSIZE 6))
    (WHEN (CADDR B)
      (SETQ XSIZE (TRUNCATE (CAADDR B) 2))
      (SETQ YSIZE (TRUNCATE (CADR (CADDR B)) 2)))
    (AND (>= X (- (CAADR B) XSIZE)) (<= X (+ (CAADR B) XSIZE))
         (>= Y (- (CADADR B) YSIZE)) (<= Y (+ (CADADR B) YSIZE)))))

(DEFUN PICMENU-ITEM-POSITION (M ITEMNAME &OPTIONAL PLACE)
  (LET (B (XSIZE 0) (YSIZE 0))
    (WHEN (SETQ B
                (FIND-IF #'(LAMBDA (GLVAR1271)
                             (EQ (CAR GLVAR1271) ITEMNAME))
                         (CADDDR (NTH 10 M))))
      (WHEN (CADDR B)
        (SETQ XSIZE (CAADDR B))
        (SETQ YSIZE (CADR (CADDR B))))
      (LIST (+ (+ (IF (CADDR M) (FIFTH M) 0) (CAADR B))
               (CASE PLACE
                 ((CENTER TOP BOTTOM) (TRUNCATE XSIZE 2))
                 (LEFT 0)
                 (RIGHT XSIZE)
                 (T 0)))
            (+ (+ (IF (CADDR M) (SIXTH M) 0) (CADADR B))
               (CASE PLACE
                 ((CENTER RIGHT LEFT) (TRUNCATE YSIZE 2))
                 (BOTTOM 0)
                 (TOP YSIZE)
                 (T 0)))))))

(SETF (GET 'WINDOW-GET-POINT 'GLFNRESULTTYPE) 'VECTOR)

(DEFUN WINDOW-GET-POINT (W)
  (LET (ORGX ORGY)
    (WINDOW-TRACK-MOUSE W
        #'(LAMBDA (X Y CODE)
            (WHEN (NOT (ZEROP CODE)) (SETQ ORGX X) (SETQ ORGY Y))))
    (LIST ORGX ORGY)))

(SETF (GET 'WINDOW-GET-CLICK 'GLFNRESULTTYPE)
      '(LIST (BUTTON INTEGER) (POS VECTOR)))

(DEFUN WINDOW-GET-CLICK (W)
  (LET (ORGX ORGY BUTTON)
    (WINDOW-TRACK-MOUSE W
        #'(LAMBDA (X Y CODE)
            (WHEN (NOT (ZEROP CODE))
              (SETQ BUTTON CODE)
              (SETQ ORGX X)
              (SETQ ORGY Y))))
    (LIST BUTTON (LIST ORGX ORGY))))

(SETF (GET 'WINDOW-GET-LINE-POSITION 'GLFNRESULTTYPE) 'VECTOR)

(DEFUN WINDOW-GET-LINE-POSITION (W ORGX ORGY)
  (WINDOW-GET-ICON-POSITION W #'WINDOW-DRAW-LINE-XY
      (LIST ORGX ORGY 1 'PAINT)))

(SETF (GET 'WINDOW-GET-BOX-POSITION 'GLFNRESULTTYPE) 'VECTOR)

(DEFUN WINDOW-GET-BOX-POSITION (W WIDTH HEIGHT &OPTIONAL (DX 0) (DY 0))
  (WINDOW-GET-ICON-POSITION W #'WINDOW-DRAW-BOX-XY
      (LIST WIDTH HEIGHT 1) DX DY))

(DEFUN WINDOW-GET-ICON-POSITION (W FN ARGS &OPTIONAL (DX 0) (DY 0))
  (LET (LASTX LASTY ARGL)
    (SETQ ARGL (CONS W (CONS 0 (CONS 0 ARGS))))
    (WINDOW-SET-XOR W)
    (WINDOW-TRACK-MOUSE W
        #'(LAMBDA (X Y CODE)
            (WHEN (OR (NULL LASTX) (/= X LASTX) (/= Y LASTY))
              (IF LASTX (APPLY FN ARGL))
              (RPLACA (CDR ARGL) (+ X DX))
              (RPLACA (CDDR ARGL) (+ Y DY))
              (APPLY FN ARGL)
              (SETQ LASTX X)
              (SETQ LASTY Y))
            (NOT (ZEROP CODE))))
    (APPLY FN ARGL)
    (WINDOW-UNSET W)
    (WINDOW-FORCE-OUTPUT W)
    (LIST LASTX LASTY)))

(SETF (GET 'WINDOW-GET-REGION 'GLFNRESULTTYPE) 'REGION)

(DEFUN WINDOW-GET-REGION (W &OPTIONAL WID HT)
  (LET (LASTX LASTY START END WIDTH HEIGHT PLACE OFFX OFFY STX STY)
    (IF (AND (NUMBERP WID) (NUMBERP HT))
        (PROGN
          (SETQ START
                (WINDOW-GET-BOX-POSITION W WID HT (- WID) (- HT)))
          (SETQ STX (- (CAR START) WID))
          (SETQ STY (- (CADR START) HT)))
        (PROGN
          (SETQ START (WINDOW-GET-POINT W))
          (SETQ STX (CAR START))
          (SETQ STY (CADR START))))
    (SETQ END
          (WINDOW-GET-ICON-POSITION W #'WINDOW-DRAW-BOX-CORNERS
              (LIST STX STY 1)))
    (SETQ LASTX (CAR END))
    (SETQ LASTY (CADR END))
    (SETQ WIDTH (ABS (- STX LASTX)))
    (SETQ HEIGHT (ABS (- STY LASTY)))
    (SETQ OFFX (- (MIN STX LASTX) LASTX))
    (SETQ OFFY (- (MIN STY LASTY) LASTY))
    (SETQ PLACE (WINDOW-GET-BOX-POSITION W WIDTH HEIGHT OFFX OFFY))
    (LIST (LIST (+ OFFX (FIRST PLACE)) (+ OFFY (SECOND PLACE)))
          (LIST WIDTH HEIGHT))))

(SETF (GET 'WINDOW-GET-BOX-SIZE 'GLFNRESULTTYPE) 'VECTOR)

(DEFUN WINDOW-GET-BOX-SIZE (W OFFSETX OFFSETY)
  (LET (LEGENDY LASTX LASTY DX DY)
    (SETQ OFFSETY (MIN OFFSETY 30))
    (SETQ LEGENDY (- OFFSETY 25))
    (WINDOW-ERASE-AREA-XY W OFFSETX LEGENDY 70 20)
    (WINDOW-DRAW-BOX-XY W OFFSETX LEGENDY 70 20)
    (WINDOW-TRACK-MOUSE W
        #'(LAMBDA (X Y CODE)
            (WHEN (OR (NULL LASTX) (/= X LASTX) (/= Y LASTY))
              (IF LASTX
                  (WINDOW-XOR-BOX-XY W OFFSETX OFFSETY
                      (- LASTX OFFSETX) (- LASTY OFFSETY)))
              (SETQ LASTX NIL)
              (SETQ DX (- X OFFSETX))
              (SETQ DY (- Y OFFSETY))
              (WHEN (AND (> DX 0) (> DY 0))
                (WINDOW-XOR-BOX-XY W OFFSETX OFFSETY DX DY)
                (WINDOW-PRINTAT-XY W (FORMAT NIL "~3D x ~3D" DX DY)
                    (+ OFFSETX 3) (+ LEGENDY 5))
                (SETQ LASTX X)
                (SETQ LASTY Y)))
            (NOT (ZEROP CODE))))
    (IF LASTX
        (WINDOW-XOR-BOX-XY W OFFSETX OFFSETY (- LASTX OFFSETX)
            (- LASTY OFFSETY)))
    (WINDOW-ERASE-AREA-XY W OFFSETX LEGENDY 70 20)
    (WINDOW-FORCE-OUTPUT W)
    (LIST DX DY)))

(SETF (GET 'WINDOW-TRACK-MOUSE-IN-REGION 'GLFNRESULTTYPE)
      '(LIST (CODE INTEGER) (POSITION (TRANSPARENT VECTOR))))

(DEFUN WINDOW-TRACK-MOUSE-IN-REGION
       (W OFFSETX OFFSETY SIZEX SIZEY &OPTIONAL BOXFLG)
  (LET (RES INSIDE)
    (WHEN BOXFLG
      (WINDOW-SET-XOR W)
      (WINDOW-DRAW-BOX-XY W (- OFFSETX 4) (- OFFSETY 4) (+ SIZEX 8)
          (+ SIZEY 8))
      (WINDOW-UNSET W)
      (WINDOW-FORCE-OUTPUT W))
    (SETQ RES
          (WINDOW-TRACK-MOUSE W
              #'(LAMBDA (X Y CODE)
                  (IF (> CODE 0) (IF INSIDE (LIST CODE (LIST X Y)) T)
                      (IF (OR (< X OFFSETX) (> X (+ OFFSETX SIZEX))
                              (< Y OFFSETY) (> Y (+ OFFSETY SIZEY)))
                          INSIDE (AND (SETQ INSIDE T) NIL))))))
    (WHEN BOXFLG
      (WINDOW-SET-XOR W)
      (WINDOW-DRAW-BOX-XY W (- OFFSETX 4) (- OFFSETY 4) (+ SIZEX 8)
          (+ SIZEY 8))
      (WINDOW-UNSET W)
      (WINDOW-FORCE-OUTPUT W))
    (IF (CONSP RES) RES)))

(SETF (GET 'WINDOW-ADJUST-BOX-SIDE 'GLFNRESULTTYPE) 'REGION)

(DEFUN WINDOW-ADJUST-BOX-SIDE (W ORGX ORGY WIDTH HEIGHT SIDE)
  (LET (NEW (XX ORGX) (YY ORGY) (WW WIDTH) (HH HEIGHT))
    (SETQ NEW
          (WINDOW-GET-ICON-POSITION W #'WINDOW-ADJ-BOX-XY
              (LIST ORGX ORGY WIDTH HEIGHT SIDE)))
    (CASE SIDE
      (LEFT (SETQ XX (CAR NEW)) (SETQ WW (+ WIDTH (- ORGX (CAR NEW)))))
      (RIGHT (SETQ WW (- (CAR NEW) ORGX)))
      (TOP (SETQ HH (- (CADR NEW) ORGY)))
      (BOTTOM (SETQ YY (CADR NEW))
              (SETQ HH (+ HEIGHT (- ORGY (CADR NEW))))))
    (LIST (LIST XX YY) (LIST WW HH))))

(DEFUN WINDOW-ADJ-BOX-XY (W X Y ORGX ORGY WIDTH HEIGHT SIDE)
  (LET ((XX ORGX) (YY ORGY) (WW WIDTH) (HH HEIGHT))
    (CASE SIDE
      (LEFT (SETQ XX X) (SETQ WW (+ WIDTH (- ORGX X))))
      (RIGHT (SETQ WW (- X ORGX)))
      (TOP (SETQ HH (- Y ORGY)))
      (BOTTOM (SETQ YY Y) (SETQ HH (+ HEIGHT (- ORGY Y)))))
    (WINDOW-DRAW-BOX-XY W XX YY WW HH)))

(DEFUN COMPILE-DWINDOW ()
  (GLCOMPFILES '("/v/ai/v0/novak/glisp/vector.lsp")
      '("/v/ai/v0/novak/X/dwindow.lsp") "/v/ai/v0/novak/X/dwtrans.lsp")
  (COMPILE-FILE "/v/ai/v0/novak/X/dwtrans.lsp"))
