/* Main Part of YY-Server
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: server.c,v 3.1 1992/10/27 08:10:20 keisuke Exp keisuke $
 */

#ifndef lint
static char *RcsId =
    "$Id: server.c,v 3.1 1992/10/27 08:10:20 keisuke Exp keisuke $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/02/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.3 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.1 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/27 08:10:20 $
****************************************************************************/

#include <stdio.h>
#include <strings.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"

char *CmdName;
int YYPacketBlockSize;
bool YYSynchronizeMode = FALSE;
bool YYSingleShot = FALSE;

extern void cleanup();

#define YYSTAT_COMMAND_CHANNEL		01
#define YYSTAT_EVENT_CHANNEL		02
int YYServerStatus = 0;
yy_comm_channel *YyChannel = (yy_comm_channel *)NULL;

void cleanup(code, fmt, a1, a2, a3, a4, a5, a6)
    int code;
    char *fmt;
{
    if (YyChannel != (yy_comm_channel *)NULL) {
	x_private *xp = XPRIVATE(YyChannel);
	if (xp != (x_private *)NULL)
	    XCloseDisplay(xp->xDisp);
	if (YyChannel->ccYYFd >= 0) {
	    shutdown(YyChannel->ccYYFd, 2);
	    close(YyChannel->ccYYFd);
	}
	if (YyChannel->ccYYFd2 >= 0) {
	    shutdown(YyChannel->ccYYFd2, 2);
	    close(YyChannel->ccYYFd2);
	}
    }
    if (fmt != (char *)NULL)
	fprintf(stderr, fmt, a1, a2, a3, a4, a5, a6);
    exit(code);
}

void warning(fmt, a1, a2, a3, a4, a5, a6)
    char *fmt;
{
    fprintf(stderr, fmt, a1, a2, a3, a4, a5, a6);
}

static void usage()
{
    fprintf(stderr, "Usage: %s [-p port#] [-P size]\n", CmdName);
    fprintf(stderr, "\tsize: Packet Size (0-%d)\n", YYMAXONEPACKETSIZE);
    cleanup(1, (char *)NULL);
}

static bool getargnum(acp, avp, ret)
    int *acp;
    char ***avp;
    int *ret;		/* return value */
{
    char **av = *avp;
    if (av[0][1] != EOS) {
	*ret = atoi(&av[0][2]);
	return TRUE;
    } else if (*acp > 0) {
	(*acp)--; (*avp)++;
	*ret = atoi(*avp);
	return TRUE;
    }
    return FALSE;
}

main(argc, argv)
    int argc;
    char *argv[];
{
    int chno = DEFAULTCHANNEL;
    yy_comm_channel *CH;
    extern yy_comm_channel *make_channel();

    CmdName = *argv++; argc--;
    YYPacketBlockSize = YYMAXONEPACKETSIZE;
    while (argc > 0 && argv[0][0] == '-') {
	switch (argv[0][1]) {
	case 's': /* Single Shot Mode */
	    YYSingleShot = TRUE;
	    break;
#ifndef SUPERSERVER
	case 'p': { /* port number */
	    if (!getargnum(&argc, &argv, &chno))
		usage();
	    break;
	}
#endif /*!SUPERSERVER*/
	case 'P': { /* Packet Size */
	    if (!getargnum(&argc, &argv, &YYPacketBlockSize) ||
		YYPacketBlockSize <= 0 ||
		YYPacketBlockSize > YYMAXONEPACKETSIZE)
		usage();
	    break;
	}
	case 'S': /* Syncronize Mode */
	    YYSynchronizeMode = TRUE;
	    break;
	default:
	    usage();
	}
	argc--, argv++;
    }
#ifdef DEBUG_PRINT
    debug_init(".yydebug", (char *)NULL, NULL, NULL);
#endif /*DEBUG_PRINT*/
    /* Print Initial Message */
    puts(Version);
    init_edit_func_table(YYINPUTEDITFILE);
#ifdef WNNKINPUT
    init_kanakan_proc();
#endif /*WNNKINPUT*/
    /* fix_command_search_table(); */

#ifdef SUPERSERVER
    YyChannel = CH = make_channel();
    if (YyChannel == (yy_comm_channel *)NULL)
	cleanup(1, "Cannot Setup Server..\n");
#else
    if ((YyChannel = CH = make_channel(chno)) == (yy_comm_channel *)NULL)
	cleanup(1, "Cannot Setup Server..\n");
#endif /*!SUPERSERVER*/
    /* Set X Error Handler */
    set_error_handler();
    for (;;) wait_for_request(CH);
    /*NOTREACHED*/
}

struct min_max_pair {
    int mmMin;
    int mmMax;
    int mmCount;
} ;
struct _yy_server_info {
    char *svControlDir;
    char *svFontFile;
    int svVersion;
    struct min_max_pair svRelease;
    struct min_max_pair svSync;
    struct min_max_pair svMouse;
} ;
typedef struct _yy_server_info yy_server_info;
#define svMinRel	svRelease.mmMin
#define svMaxRel	svRelease.mmMax
#define svMinSync	svSync.mmMin
#define svMaxSync	svSync.mmMax
#define svCountSync	svSync.mmCount
#define svMinMouse	svMouse.mmMin
#define svMaxMouse	svMouse.mmMax
#define svCountMouse	svMouse.mmCount

yy_server_info YYServerInfo;

struct yy_server_info_entry {
    char *siCommand;
    char *siEntry;
    bool (*siParseFunc)();
} ;

#define ISWS(c)		((c)==' '||(c)=='\t')
#define ISNUM(c)	((c)>='0'||(c)<='9')

static bool parse_yy_server_info_string(arg, str)
    char *arg;
    char **str;
{
    char work[256];
    register char *p;
    register char *s = arg;
    register char firstc = EOS;
    if (*s == SINGLEQUOTE || *s == DOUBLEQUOTE)
	firstc = *s++;
    for (p = work; *s != firstc && *s != EOS; ) {
	if (*s == BACKSLASH && *(s+1) != EOS)
	    s++;
	*p++ = *s++;
    }
    *p = EOS;
    *str = (char *)malloc(strlen(work)+1);
    strcpy(*str, work);
    return TRUE;
}

static char *pickup_integer(s, ip)
    char *s;
    int *ip;
{
    int ret = 0;
    bool notdef = TRUE;
    bool minus = FALSE;
    while (ISWS(*s))
	s++;
    if ((minus = (*s == '-')) || *s == '+')
	s++;
    notdef =  (!ISNUM(*s));
    while (ISNUM(*s))
	ret = ret*10 + *s - '0';
    *ip = (notdef? -1: (minus? -ret: ret));
    return((*s == EOS)? s: s+1);
}

static bool parse_yy_server_info_integer(s, ip)
    char *s;
    int *ip;
{
    pickup_integer(s, ip);
    return TRUE;
}

static bool parse_yy_server_info_minmax(s, mm)
    char *s;
    struct min_max_pair *mm;
{
    s = pickup_integer(s, &mm->mmMin);
    s = pickup_integer(s, &mm->mmMax);
    s = pickup_integer(s, &mm->mmCount);
    return TRUE;
}

struct yy_server_info_entry ServerInfoCmdTbl[] = {
{ "dir",     (char *)&YYServerInfo.svControlDir, parse_yy_server_info_string},
{ "font",    (char *)&YYServerInfo.svFontFile,   parse_yy_server_info_string},
{ "version", (char *)&YYServerInfo.svVersion,    parse_yy_server_info_integer},
{ "release", (char *)&YYServerInfo.svRelease,    parse_yy_server_info_minmax},
{ "sync",    (char *)&YYServerInfo.svSync,       parse_yy_server_info_minmax},
{ "mouse",   (char *)&YYServerInfo.svMouse,      parse_yy_server_info_minmax},
{ NULL, NULL, NULL},
} ;

bool parse_server_info_file(file)
    char *file;
{
    char line[256];
    FILE *fp;
    DebugSetFunc("control", "parse_server_info_file");
    if ((fp = fopen(file, "r")) == (FILE *)NULL)
	cleanup(1, "Can't open Server Info File '%s'\n", file);
    while(fgets(line, sizeof(line), fp) != (char *)NULL) {
	register char *s, *e;
	if (line[0] != '$')
	    continue;
	if ((s = index(line, EOL)) != (char *)NULL)
	    *s = EOS;
	for (s = line; *s != EOS; s++)
	    if (ISWS(*s) || *s == '=') {
		e = s++;
		while (ISWS(*s))
		    s++;
		break;
	    }
	if (*s != EOS) {
	    struct yy_server_info_entry *cmd;
	    char c = *e;
	    *e = EOS;
	    for (cmd = ServerInfoCmdTbl;
		 cmd->siCommand != (char *)NULL; cmd++)
		if (strSAME(cmd->siCommand, &line[1]))
		    break;
	    if (cmd->siCommand != (char *)NULL) {
		continue;
	    }
	    *e = c;
	}
	DebugPrint1(1, "Can't Parse Line '%s'\n", line);
	continue;
    }
    DebugEndFunc("control", "parse_server_info_file");
}


/* FILE IO */
struct file_io_entry {
    FILE *ioFP;
    char *ioFPath;
    int ioLine;
    int ioLastChar;
} ;
typedef struct file_io_entry FILEIO;

FILEIO *fIOopen(dir, name, mode)
    char *dir;
    char *name;
    char *mode;
{
    char fpath[256];
    FILEIO *fio;

    if ((fio = (FILEIO *)malloc(sizeof(FILEIO))) == (FILEIO *)NULL)
	return (FILEIO *)NULL;
    if (dir != (char *)NULL && dir[0] != EOS)
	sprintf(fpath, "%s/%s", dir, name);
    else
	strcpy(fpath, name);
    if ((fio->ioFP = fopen(fpath, mode)) == (FILE *)NULL)
	return (FILEIO *)NULL;
    fio->ioFPath = strDUP(fpath);
    fio->ioLine = 0;
    fio->ioLastChar = EOS;
    return fio;
}

void fIOclose(fio)
    FILEIO *fio;
{
    fclose(fio->ioFP);
    free((char *)fio->ioFPath);
    free((char *)fio);
}

int fIOgetc(fio)
    FILEIO *fio;
{
    register int c;
    register bool havesp = FALSE;
    if ((c = fio->ioLastChar) == EOS)
	c = getc(fio->ioFP);
    for ( ; ISWS(c); c = getc(fio->ioFP))
	havesp = TRUE;
    if (c == EOF) {
	fio->ioLastChar = EOF;
	return EOF;
    }
    if (havesp && c != EOL) {
	fio->ioLastChar = c;
	return ' ';
    }
    fio->ioLastChar = EOS;
    if (c == EOL)
	fio->ioLine++;
    return c;
}

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
