/* Support Error on YY-server
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: error.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $
 */

#ifndef lint
static char *RcsId =
    "$Id: error.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/03/19 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.1 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"

struct err_code_tab {
	int erCode;
	char *erLabel;
} ;

struct err_code_tab ErrCodes[] = {
{ YYERROR_NOTYYPACKET, "Not YY Packet!!" },
{ YYERROR_NODISP, "No Such Display" },
{ YYERROR_NOTERRITORY, "No such Territory!!" },
{ YYERROR_NOCOLOR, "No such Color Name" },
{ -1, "Unknown Error" }
} ;

yy_packet *create_error_packet(pkt, errcode)
    yy_packet *pkt;
    int errcode;
{
    yy_packet *repl;
    DebugSetFunc("control", "create_error_packet");
    if (DebugON(1)) {
	struct err_code_tab *err = ErrCodes;
	for (err = ErrCodes; err->erCode > 0; err++)
	    if (err->erCode == errcode)
		break;
	DebugPrint2(1, "YY ERROR (CODE:%d, '%s')\n", errcode, err->erLabel);
    }
    repl = ALLOC_ERRPACKET(pkt);
    append_packet_entry_integer(repl, errcode);
    DebugEndFunc("control", "create_error_packet");
    return repl;
}

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
