/* Function to support Frame Animation
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: com_animation.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $
 */

#ifndef lint
static char *RcsId=
    "$Id: com_animation.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 91/01/25 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"
#include "territory.h"

/***************************************************************************
 * Commands on Page Mode Territory
 ***************************************************************************/
typedef struct _yy_animation_job_queue_ YYANIMATIONJOBQUEUE;
struct _yy_animation_job_queue_ {
    YYANIMATIONFRAMEFOLDER *aqFrameFolder;
    struct timeval aqLastTime;
    int aqInterval; /*(micro sec)*/
    YYANIMATIONJOBQUEUE *aqPrev;
    YYANIMATIONJOBQUEUE *aqNext;
};

static YYANIMATIONJOBQUEUE *YYAnimationQueue
    = (YYANIMATIONJOBQUEUE *)NULL;

/*
 * void sched_animation(ch)
 *
 * ˥᡼Υ塼
 */
void sched_animation(ch)
    yy_comm_channel *ch;
{
    int blank;
    struct timeval curtime;
    register YYANIMATIONJOBQUEUE *queue = YYAnimationQueue;
    YYANIMATIONFRAMEFOLDER *ff;
    int retval;

    DebugSetFunc("animation", "sched_animation");
    gettimeofday(&curtime);
    while (queue != (YYANIMATIONJOBQUEUE *)NULL) {
	ff = queue->aqFrameFolder;
	if (!ff->afRunning) {
	    yy_packet *event;
	    YYANIMATIONJOBQUEUE *next_queue;
	    /* End of Animation */
	    event = ALLOC_EVENTPACKET(YYCOMMAND_START_ANIMATION);
	    append_packet_entry_integer(event, ff->afTr->teID);
	    if (ff->afCurFrame != (YYANIMATIONFRAMETABLE *)NULL)
		append_packet_entry_integer(event,
					    ff->afCurFrame->frNumber);
	    else
		append_packet_entry_integer(event, 0);
	    append_packet_entry_integer(event, 2);
	    put_packet_on_sendq(QUE(ch), event);
	    /* de-queue and turn off */
	    ff->afCurFrame = (YYANIMATIONFRAMETABLE *)NULL;
	    next_queue = queue->aqNext;
	    if (queue->aqPrev != (YYANIMATIONJOBQUEUE *)NULL)
		queue->aqPrev->aqNext = queue->aqNext;
	    else
		YYAnimationQueue = queue->aqNext;
	    if (queue->aqNext != (YYANIMATIONJOBQUEUE *)NULL)
		queue->aqNext->aqPrev = queue->aqPrev;
	    memFREE(queue);
	    queue = next_queue;
	    continue;
	}
	blank = (curtime.tv_sec - queue->aqLastTime.tv_sec)*1000000
	    + (curtime.tv_usec - queue->aqLastTime.tv_usec);
	DebugPrint1(5, "Current Time: %d\n", blank);
	if (blank >= queue->aqInterval) {
	    ff = queue->aqFrameFolder;
	    if (ff->afCurFrame == (YYANIMATIONFRAMETABLE *)NULL)
		retval = put_first_animation_frame(ch, ff);
	    else
		retval = put_next_animation_frame(ch, ff);
	    if (retval >= 2 || (retval == 1 && ff->afLoop == 1)) {
		yy_packet *event;
		YYANIMATIONJOBQUEUE *next_queue;
		/* End of Animation */
		event = ALLOC_EVENTPACKET(YYCOMMAND_START_ANIMATION);
		append_packet_entry_integer(event, ff->afTr->teID);
		if (ff->afCurFrame != (YYANIMATIONFRAMETABLE *)NULL)
		    append_packet_entry_integer(event,
						ff->afCurFrame->frNumber);
		else
		    append_packet_entry_integer(event, 0);
		append_packet_entry_integer(event, retval);
		put_packet_on_sendq(QUE(ch), event);
		/* de-queue and turn off */
		ff->afRunning = FALSE;
		ff->afCurFrame = (YYANIMATIONFRAMETABLE *)NULL;
		next_queue = queue->aqNext;
		if (queue->aqPrev != (YYANIMATIONJOBQUEUE *)NULL)
		    queue->aqPrev->aqNext = queue->aqNext;
		else
		    YYAnimationQueue = queue->aqNext;
		if (queue->aqNext != (YYANIMATIONJOBQUEUE *)NULL)
		    queue->aqNext->aqPrev = queue->aqPrev;
		memFREE(queue);
		queue = next_queue;
	    } else {
		if (retval == 1 && ff->afLoop > 1)
		    ff->afLoop--;
		if (ff->afSync-- <= 0) {
		    /* put sync packet */
		    yy_packet *event;
		    event = ALLOC_EVENTPACKET(YYCOMMAND_START_ANIMATION);
		    append_packet_entry_integer(event, ff->afTr->teID);
		    append_packet_entry_integer(event, ff->afCurFrame->frNumber);
		    append_packet_entry_integer(event, 0);
		    put_packet_on_sendq(QUE(ch), event);
		    ff->afSync = ff->afSyncInterval;
		}
		queue->aqLastTime.tv_sec = curtime.tv_sec;
		queue->aqLastTime.tv_usec = curtime.tv_usec;
		queue = queue->aqNext;
	    }
	} else {
	    queue = queue->aqNext;
	}
    }
    DebugEndFunc("animation", "sched_animation");
}

/*
 * int put_animation_frame(ch, ff)
 *
 * ff->afCurFrame Υե졼 ff->afTr 褹
 * ƥȥ꤬ visible Ǥ XSync Ū˹Ԥʤ
 */
static void put_animation_frame(ch, ff)
    yy_comm_channel *ch;
    YYANIMATIONFRAMEFOLDER *ff;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(ff->afTr);

    DebugSetFunc("animation", "put_animation_frame");
    DebugPrint5(5, "Put Image on TR#%d (%d,%d)[%d,%d]\n", ff->afTr->teID,
		ff->afX, ff->afY, ff->afWidth, ff->afHeight);
    XSetFunction(xp->xDisp, tx->txGC, GXcopy);
    XCopyArea(xp->xDisp, ff->afCurFrame->frImage, tx->txPixmap, tx->txGC,
	      0, 0, ff->afWidth, ff->afHeight, ff->afX, ff->afY);
    if (IsVisibleTerritory(ff->afTr)) {
	XCopyArea(xp->xDisp, ff->afCurFrame->frImage, tx->txWindow, tx->txGC,
		  0, 0, ff->afWidth, ff->afHeight, ff->afX, ff->afY);
	sync_x_server(xp);
    }
    DebugEndFunc("animation", "put_animation_frame");
    /*No Retuen Value*/
}

/*
 * int put_first_animation_frame(ch, ff)
 *
 * ff Ǽ륢˥᡼ե졼ˤ
 * ff->afDir ǼܤΥե졼ɽԤʤ
 *
 * Return Value:
 *  0: continue
 *  1: this is a last frame
 *  2: Error (No such frame)
 */
int put_first_animation_frame(ch, ff)
    yy_comm_channel *ch;
    YYANIMATIONFRAMEFOLDER *ff;
{
    int retval;
    YYANIMATIONFRAMETABLE *fr;
    YYANIMATIONFRAMETABLE *start_frame;

    DebugSetFunc("animation", "put_first_animation_frame");
    DebugPrint1(5, "Start Frame Number: %d\n", ff->afStartFrame);
    /* Start Frame 򤵤 */
    for (fr = ff->afFrames;
	 fr != (YYANIMATIONFRAMETABLE *)NULL; fr = fr->frNext)
	if (fr->frNumber == ff->afStartFrame)
	    break;
    if (fr == (YYANIMATIONFRAMETABLE *)NULL)
	ff->afDir = -1; /* No such frame */

    /* Rearrange Frame List */
    ff->afCurFrame = start_frame = fr;
    switch (ff->afDir) {
    case 0: /* Only this frame */
	(void)put_animation_frame(ch, ff);
	retval = 1;
	break;
    case 1: /* forward */
	if (start_frame->frPrev != (YYANIMATIONFRAMETABLE *)NULL) {
	    register YYANIMATIONFRAMETABLE *last;
	    for (last = start_frame->frNext; ; last = last->frNext)
		if (last->frNext == (YYANIMATIONFRAMETABLE *)NULL)
		    break;
	    last->frNext = ff->afFrames;
	    ff->afFrames->frPrev = last;
	    start_frame->frPrev->frNext = (YYANIMATIONFRAMETABLE *)NULL;
	    start_frame->frPrev = (YYANIMATIONFRAMETABLE *)NULL;
	    ff->afFrames = start_frame;
	}
	(void)put_animation_frame(ch, ff);
	retval = (start_frame->frNext == (YYANIMATIONFRAMETABLE *)NULL? 1: 0);
	break;
    case 2: /* backward */
	if (start_frame->frNext != (YYANIMATIONFRAMETABLE *)NULL) {
	    register YYANIMATIONFRAMETABLE *last;
	    for (last = start_frame->frNext; ; last = last->frNext)
		if (last->frNext == (YYANIMATIONFRAMETABLE *)NULL)
		    break;
	    last->frNext = ff->afFrames;
	    ff->afFrames->frPrev = last;
	    ff->afFrames = start_frame->frNext;
	    start_frame->frNext->frPrev = (YYANIMATIONFRAMETABLE *)NULL;
	    start_frame->frNext = (YYANIMATIONFRAMETABLE *)NULL;
	}
	(void)put_animation_frame(ch, ff);
	retval = (start_frame->frPrev == (YYANIMATIONFRAMETABLE *)NULL? 1: 0);
	break;
    default:
	retval = 2; /* Error */
	break;
    }
    DebugEndFunc("animation", "put_first_animation_frame");
    return retval;
}

int put_next_animation_frame(ch, ff)
    yy_comm_channel *ch;
    YYANIMATIONFRAMEFOLDER *ff;
{
    int retval;
    DebugSetFunc("animation", "put_next_animation_frame");
    switch (ff->afDir) {
    case 0: /* Only this frame */
    default:
	DebugPrint0(3, "No Such Direction\n");
	retval = 2;
	break;
    case 1: /* forward */
	DebugPrint0(3, "Put Next Frame\n");
	if (ff->afCurFrame->frNext != (YYANIMATIONFRAMETABLE *)NULL) {
	    ff->afCurFrame = ff->afCurFrame->frNext;
	    (void)put_animation_frame(ch, ff);
	    retval = (ff->afCurFrame->frNext == (YYANIMATIONFRAMETABLE *)NULL?
		      1: 0);
	} else {
	    ff->afCurFrame = (YYANIMATIONFRAMETABLE *)NULL;
	    retval = put_first_animation_frame(ch, ff);
	}
	break;
    case 2: /* backward */
	DebugPrint0(3, "Put Previous Frame\n");
	if (ff->afCurFrame->frPrev != (YYANIMATIONFRAMETABLE *)NULL) {
	    ff->afCurFrame = ff->afCurFrame->frPrev;
	    (void)put_animation_frame(ch, ff);
	    retval = (ff->afCurFrame->frPrev == (YYANIMATIONFRAMETABLE *)NULL?
		      1: 0);
	} else {
	    ff->afCurFrame = (YYANIMATIONFRAMETABLE *)NULL;
	    retval = put_first_animation_frame(ch, ff);
	}
	break;
    }
    DebugEndFunc("animation", "put_next_animation_frame");
    return retval;
}

/***************************************************************************
 ***** Operation No. 51
 *****
 *****  Define Animation Frames
 *****
 ***************************************************************************/

yy_packet *yycom_define_animation_frame(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;
    int w, h;
    YYANIMATIONFRAMEFOLDER *ff;

    DebugSetFunc("animation", "yycom_define_animation_frame");
    /* ʰץ˥᡼ǽ ViewPort Mode Territory ǤΤͭ */
    if ((tr = catch_territory(pkt, TR_VIEWPORT, &repl)) == (TERRITORY *)NULL) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    if (tr->teModeEnt.tViewPortControl.vcFrameFolder
	!= (YYANIMATIONFRAMEFOLDER *)NULL) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    /* */
    ff = (YYANIMATIONFRAMEFOLDER *)memALLOC(sizeof(YYANIMATIONFRAMEFOLDER));
    ff->afTr = tr;
    ff->afFrameNum = ff->afStartFrame = ff->afDir = 0;
    ff->afX = ff->afY = 0;
    ff->afWidth = read_packet_entry_integer(pkt);
    ff->afHeight = read_packet_entry_integer(pkt);
    ff->afFrames = ff->afCurFrame = (YYANIMATIONFRAMETABLE *)NULL;
    ff->afRunning = FALSE;
    tr->teModeEnt.tViewPortControl.vcFrameFolder = ff;
    DebugPrint3(1, "Define Animation Frame [%d,%d] on TR#%d\n",
		ff->afWidth, ff->afHeight, tr->teID);
 send_reply:
    DebugEndFunc("animation", "yycom_define_animation_frame");
    return repl;
}

yy_packet *yycom_start_animation(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;
    YYANIMATIONFRAMEFOLDER *ff;
    YYANIMATIONJOBQUEUE *queue;

    DebugSetFunc("animation", "yycom_start_animation");
    /* ʰץ˥᡼ǽ ViewPort Mode Territory ǤΤͭ */
    if ((tr = catch_territory(pkt, TR_VIEWPORT, &repl)) == (TERRITORY *)NULL) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    ff = tr->teModeEnt.tViewPortControl.vcFrameFolder;
    if (ff == (YYANIMATIONFRAMEFOLDER *)NULL || ff->afRunning) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    ff->afX = read_packet_entry_integer(pkt);
    ff->afY = read_packet_entry_integer(pkt);
    ff->afStartFrame = read_packet_entry_integer(pkt);
    ff->afSpeed = read_packet_entry_integer(pkt);
    ff->afDir = read_packet_entry_integer(pkt);
    ff->afRepeat = read_packet_entry_integer(pkt);
    ff->afSyncInterval = read_packet_entry_integer(pkt);
    /* Scheduling Parameter */
    ff->afRunning = TRUE;
    ff->afTime = 0;
    ff->afLoop = ff->afRepeat;
    ff->afSync = ff->afSyncInterval;
    ff->afCurFrame = (YYANIMATIONFRAMETABLE *)NULL;
    queue = (YYANIMATIONJOBQUEUE *)memALLOC(sizeof(YYANIMATIONJOBQUEUE));
    queue->aqFrameFolder = ff;
    gettimeofday(&queue->aqLastTime);
    queue->aqInterval = ff->afSpeed*10000;
    queue->aqNext = YYAnimationQueue;
    queue->aqPrev = (YYANIMATIONJOBQUEUE *)NULL;
    if (YYAnimationQueue != (YYANIMATIONJOBQUEUE *)NULL)
	YYAnimationQueue->aqPrev = queue;
    YYAnimationQueue = queue;
    DebugPrint4(6, "Animation on (%d,%d) Direction:%d, Speed:%d\n",
		ff->afX, ff->afY, ff->afDir, queue->aqInterval);
 send_reply:
    DebugEndFunc("animation", "yycom_start_animation");
    return repl;
}

yy_packet *yycom_stop_animation(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;
    YYANIMATIONFRAMEFOLDER *ff;

    DebugSetFunc("animation", "yycom_stop_animation");
    /* ʰץ˥᡼ǽ ViewPort Mode Territory ǤΤͭ */
    if ((tr = catch_territory(pkt, TR_VIEWPORT, &repl)) == (TERRITORY *)NULL) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    ff = tr->teModeEnt.tViewPortControl.vcFrameFolder;
    if (ff == (YYANIMATIONFRAMEFOLDER *)NULL || !ff->afRunning) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    ff->afRunning = FALSE;
 send_reply:
    DebugEndFunc("animation", "yycom_stop_animation");
    return repl;
}

yy_packet *yycom_destroy_animation_frame(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    x_private *xp = XPRIVATE(ch);
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;
    YYANIMATIONFRAMEFOLDER *ff;
    YYANIMATIONFRAMETABLE *fr;

    DebugSetFunc("animation", "yycom_destroy_animation_frame");
    /* ʰץ˥᡼ǽ ViewPort Mode Territory ǤΤͭ */
    if ((tr = catch_territory(pkt, TR_VIEWPORT, &repl)) == (TERRITORY *)NULL) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    ff = tr->teModeEnt.tViewPortControl.vcFrameFolder;
    if (ff == (YYANIMATIONFRAMEFOLDER *)NULL) {
	err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    for (fr = ff->afFrames; fr != (YYANIMATIONFRAMETABLE *)NULL; ) {
	YYANIMATIONFRAMETABLE *next_fr = fr;
	XFreePixmap(xp->xDisp, fr->frImage);
	memFREE(fr);
	fr = next_fr;
    }
    memFREE(ff);
    tr->teModeEnt.tViewPortControl.vcFrameFolder
	= (YYANIMATIONFRAMEFOLDER *)NULL;
 send_reply:
    DebugEndFunc("animation", "yycom_destroy_animation_frame");
    return repl;
}

/*
 * void insert_new_frame(ch, ff, fr)
 *
 * ff Ǽե졼ե fr Ǽե졼ɲä
 * ե졼եǳƥե졼ϥե졼ֹξ¤֡
 * ƱΥե졼ֹ椬¸ߤϡΥե졼ϳ
 */
static void insert_new_frame(ch, ff, fr)
    yy_comm_channel *ch;
    YYANIMATIONFRAMEFOLDER *ff;
    YYANIMATIONFRAMETABLE *fr;
{
    x_private *xp = XPRIVATE(ch);
    YYANIMATIONFRAMETABLE *frame = ff->afFrames;
    YYANIMATIONFRAMETABLE *last = (YYANIMATIONFRAMETABLE *)NULL;

    DebugSetFunc("animation", "insert_new_frame");
    DebugPrint1(5, "Frame #%d\n", fr->frNumber);
    while (frame != (YYANIMATIONFRAMETABLE *)NULL) {
	if (frame->frNumber >= fr->frNumber)
	    break;
	frame = (last = frame)->frNext;
    }
    if (frame != (YYANIMATIONFRAMETABLE *)NULL) {
	if (frame->frNumber > fr->frNumber) {
	    fr->frNext = frame;
	    frame->frPrev = fr;
	} else {
	    fr->frNext = frame->frNext;
	    if (frame->frNext != (YYANIMATIONFRAMETABLE *)NULL)
		frame->frNext->frPrev = fr;
	    XFreePixmap(xp->xDisp, frame->frImage);
	    memFREE(frame);
	}
    } else
	fr->frNext = (YYANIMATIONFRAMETABLE *)NULL;
    fr->frPrev = last;
    if (last != (YYANIMATIONFRAMETABLE *)NULL)
	last->frNext = fr;
    else
	ff->afFrames = fr;
    DebugEndFunc("animation", "insert_new_frame");
    /*NoReturnValue*/
}


void read_packet_entry_image(ch, pkt, src_w, src_h, off_x, off_y,
			      image, dst_x, dst_y, dst_w, dst_h, format)
    yy_comm_channel *ch;
    yy_packet *pkt;
    int src_w, src_h, off_x, off_y;
    XImage *image;
    int dst_x, dst_y, dst_w, dst_h;
    int format;
{
    int bytes;

    DebugSetFunc("animation", "read_packet_entry_image");
    bytes = read_packet_entry_integer(pkt);
    DebugPrint7(3, "%dbytes image [%d,%d] on (%d,%d)[%d,%d]\n",
		bytes, dst_w, dst_h, off_x, off_y, src_w, src_h);
    if (format & YYIMAGEFORM_COLOR) {
        /* color image */
        int wx, wy, lx, ly;
		DebugPrint0(5, "Color Image\n");
        for (wy = 0, ly = src_h; ly > 0 ; wy++, ly--) {
            for (wx = 0, lx = src_w; lx > 0 ; wx++, lx--) {
                u_long pixel;
		if (bytes-- > 0) pixel = read_packet_entry_integer(pkt);
		else		 pixel = 0;
                if (wx >= off_x && wy >= off_y &&
		    (wx-off_x+dst_x) < dst_w && (wy-off_y+dst_y) < dst_h) {
		    DebugPrint1(9, " %02x", pixel);
                    XPutPixel(image, (wx-off_x+dst_x), (wy-off_y+dst_y),
			      pixel);
		}
            }
	    DebugPrint0(9, "\n");
        }
    } else if (format & YYIMAGEFORM_GRAY) {
        /* Gray */
    } else {
        /* B&W */
        int wx, wy, lx, ly, ll;
        u_long cc;
        cc = read_packet_entry_integer(pkt); ll = 16;
        for (wy = 0, ly = src_h; ly > 0 ; wy++, ly--) {
            for (wx = 0, lx = src_w; lx > 0 ; wx++, lx--) {
                if (wx >= off_x && wy >= off_y &&
		    (wx-off_x+dst_x) < dst_w && (wy-off_y+dst_y) < dst_h) {
		    u_long pixel;
		    pixel = ((cc >> 30) & 3);
		    XPutPixel(image, (wx-off_x+dst_x), (wy-off_y+dst_y), pixel);
                }
                ll--;
                if (ll > 0) {
                    cc <<= 2;
                } else {
		    if (bytes-- > 0)
			cc = read_packet_entry_integer(pkt);
		    else
			cc = 0;
		    ll = 16;
                }
            }
        }
    }
    DebugEndFunc("animation", "read_packet_entry_image");
}



yy_packet *yycom_put_animation_frame(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    x_private *xp = XPRIVATE(ch);
    int err_code = YYNOERROR;
    yy_packet *repl = (yy_packet *)NULL;
    YYANIMATIONFRAMEFOLDER *ff;
    int frames, format;

    DebugSetFunc("animation", "yycom_put_animation_frame");
    /* ʰץ˥᡼ǽ ViewPort Mode Territory ǤΤͭ */
    if ((tr = catch_territory(pkt, TR_VIEWPORT, &repl)) == (TERRITORY *)NULL) {
		err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    tx = GetTerritoryXEntry(tr);
    ff = tr->teModeEnt.tViewPortControl.vcFrameFolder;
    if (ff == (YYANIMATIONFRAMEFOLDER *)NULL || ff->afRunning) {
		err_code = YYERROR_NOTERRITORY; goto send_reply;
    }
    frames = read_packet_entry_integer(pkt);
    format = read_packet_entry_integer(pkt);
    DebugPrint1(5, "Number of Frames: %d\n", frames);
    DebugPrint2(5, "Size of Frame: [%d,%d]\n", ff->afWidth, ff->afHeight);
    if (frames > 0) {
	GC wkgc;
	Pixmap dummy_pix;
	XImage *im;
	wkgc = XCreateGC(xp->xDisp, tx->txPixmap, (u_long)0, NULL);
	XCopyGC(xp->xDisp, tx->txGC, ~0L, wkgc);
	XSetFunction(xp->xDisp, wkgc, GXcopy);
	dummy_pix = XCreatePixmap(xp->xDisp, tx->txPixmap,
				  ff->afWidth, ff->afHeight,
				  DefaultDepth(xp->xDisp, xp->xScreen));
	im = XGetImage(xp->xDisp, dummy_pix, 0, 0,
		       ff->afWidth, ff->afHeight, AllPlanes, ZPixmap);
	while (frames-- > 0) {
	    YYANIMATIONFRAMETABLE *fr;
	    int type;
	    fr = (YYANIMATIONFRAMETABLE *)
		memALLOC(sizeof(YYANIMATIONFRAMETABLE));
	    fr->frNumber = read_packet_entry_integer(pkt);
	    type = read_packet_entry_integer(pkt);
	    fr->frImage = XCreatePixmap(xp->xDisp, tx->txPixmap,
					ff->afWidth, ff->afHeight,
					DefaultDepth(xp->xDisp,xp->xScreen));
	    switch (type) {
	    case 0:
		DebugPrint0(5, "Data is loaded from Packet\n");
		read_packet_entry_image(ch, pkt, ff->afWidth, ff->afHeight,
					0, 0, im, 0, 0,
					ff->afWidth, ff->afHeight, format);
		XPutImage(xp->xDisp, fr->frImage, wkgc, im,
			  0, 0, 0, 0, ff->afWidth, ff->afHeight);
		break;
	    case 1: {
		TERRITORY *src_tr;
		int src_x, src_y;
		DebugPrint0(5, "Data is loaded from Territory\n");
		src_tr = catch_territory(pkt, TR_VIEWPORT, &repl);
		src_x = read_packet_entry_integer(pkt);
		src_y = read_packet_entry_integer(pkt);
		DebugPrint5(5, "Data is loaded from TR#%d (%d,%d)[%d,%d]\n",
			    src_tr->teID, src_x, src_y,
			    ff->afWidth, ff->afHeight);
		if (src_tr != (TERRITORY *)NULL)
		    XCopyArea(xp->xDisp, GetTerritoryXEntry(src_tr)->txPixmap,
			      fr->frImage, wkgc, src_x, src_y,
			      ff->afWidth, ff->afHeight, 0, 0);
		else
		    fr->frNumber = -1;
		break;
	    }
	    case 2: {
		register int leng = read_packet_entry_integer(pkt);
		char fpath[128];
		read_packet_entry_string(pkt, leng, fpath);
		DebugPrint3(5, "Data is loaded from '%s' [%d,%d]\n",
			    fpath, ff->afWidth, ff->afHeight);
		read_image_file(ch, fpath, ff->afWidth, ff->afHeight, im);
		XPutImage(xp->xDisp, fr->frImage, wkgc, im,
			  0, 0, 0, 0, ff->afWidth, ff->afHeight);
		break;
	    }
	    default:
		DebugPrint0(5, "Unknown data type\n");
		fr->frNumber = -1;
		break;
	    }
	    if (fr->frNumber >= 0)
		insert_new_frame(ch, ff, fr);
	}
	XFreePixmap(xp->xDisp, dummy_pix);
	XDestroyImage(im);
    }
 send_reply:
    DebugEndFunc("animation", "yycom_put_animation_frame");
    return repl;
}

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
