;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@%&%#%s%I%&%9%H%j!<%`4XO"$N%/%i%9$rDj5A(J
;;; yy-stream-class.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University CSK Corp.
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the names of Aoyama Gakuin and CSK
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 91/11/20 by t.kosaka (kosaka@csrl.aoyama.ac.jp)

(in-package :yy)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%&%#%s%I%&$N?F;R7;Do4X78%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass window-relation ()
  ((parent-window :initform nil
		  :initarg :parent-window
		  :accessor parent-window)
   (old-brother-window :initform nil
		       :accessor old-brother-window)
   (young-brother-window :initform nil
		:accessor young-brother-window)

   (children-windows :initform nil
	     :accessor children-windows)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%&%#%s%I%&$N%"%$%3%s%/%i%9(J   ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass icon (event-drawable-piece window-parts)
  ((p-left :initarg :p-left :accessor p-left
		:initform 0)
   (p-bottom :initarg :p-bottom :accessor p-bottom
	     :initform 0)
   (p-width :initarg :p-width :accessor p-width
	    :initform 0)
   (p-height :initarg :p-height :accessor p-height
	     :initform 0)
  ))
				      
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%&%#%s%I%&%9%H%j!<%`%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass window-stream
  (window-relation fundamental-character-input-stream drawable-piece
		   event-method-mixin)

   ;;; $@%&%#%s%I%&$NBg$-$5%\!<%@$NBg$-$5$G$b$"$k(J
  ((window-region :initarg :window-region
			   :initform (make-region :width 100 :height 100)
			   :reader window-region)
   ;;;$@%\!<%@$NI}(J
   (border-belt :initarg :border-belt :initform 1
		:accessor border-belt)

   (real-border-belt :initarg real-border-belt
		     :initform 1 :accessor real-border-belt)

   (border-visible :initform T :accessor border-visible
                   :initarg :border-visible)

   (border-color :initarg :border-color
		 :initform *black-color*
		 :accessor border-color)

   ;; $@%&%#%s%I%&$NItIJ$N%$%s%9%?%s%9%j%9%H(J
   (window-parts-list :initform nil :accessor window-parts-list)

   ;;; $@3F9=@.MWAG$N$?$a$N%9%m%C%H(J
   (child-object-list :initarg :child-object-list
					  :accessor child-object-list
					  :initform nil)

   ;;; $@%&%#%s%I%&$N>uBV$r<($9!#(J :window $@%&%#%s%I%&(J :icon $@%"%$%3%s(J
   (window-status :initarg :window-status 
		  :initform :window ;;; :icon $@$K$b$J$k(J
		  :accessor window-status)

   ;;; $@%"%$%3%s%/%i%9$N%$%s%9%?%s%9$,F~$k(J
   (window-icon :initarg :window-icon :initform nil
		:accessor window-icon)

   (window-symbol :initform (gentemp)
		  :accessor window-symbol)

   ;;; $@F~NO%^%9%/(J
   (input-mask-table :initarg :input-mask-table
                     :initform *default-input-mask-table*
                     :accessor input-mask-table)

   (window-mouse-cursor :initarg window-mouse-cursor
			:initform *SYSTEM-MOUSE-CURSOR*
			:accessor window-mouse-cursor)

   ;;; $@%"%/%F%#%V%j!<%8%g%s$N$,F~$k(J
   (active-region-list :initform nil
		       :accessor active-region-list)

  ;;; $@%&%#%s%I%&$NItIJ(J
  (title-bar :accessor window-title-bar
	     :reader title-bar-region :initform nil)

  (horizontal-scroll-bar :accessor window-horizontal-scroll-bar
			 :reader horizontal-scroll-region
			 :initform nil)

  (vertical-scroll-bar :accessor window-vertical-scroll-bar
		       :reader vertical-scroll-region
		       :initform nil)
  
  (coordinate-area :accessor window-coordinate-area
		  :initform nil)

  (frame :initarg :frame :accessor window-frame
	 :reader frame-region :initform nil)

  (border :initarg :border :accessor border-method
	  :reader window-border :initform nil)

  ;;; $@F~NOMQ$N4X?t@_Dj(J
  (read-event-proc :initform nil
				   :accessor read-event-proc)
  (end-of-read :initform nil
			   :accessor end-of-read)
  ;;; $@2TF/Cf$N%"%K%a!<%7%g%s%U%l!<%`(J
  (exec-animation-frame :initform nil :accessor exec-animation-frame)
  ))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; $@%Z!<%8%b!<%I%&%#%s%I%&%9%H%j!<%`(J  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass page-window-stream (window-stream drawable-page-world) ())

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%S%e!<%]!<%H%b!<%I%&%#%s%I%&%9%H%j!<%`(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass viewport-window-stream (window-stream drawable-viewport-world)
	  ())


  
