;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@F~NO$K4X$9$k%U%!%$%k(J
;;; yy-input-stream.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; $@F~NO%$%Y%s%H$N%/%i%9(J
;;; 2/27 1990 $@8E:d(J
;;; Version 1.0   Coded by t.kosaka 1990-2-27
;;; Update        Add resize-territory notification 1990-8-19 by kosaka

(in-package :yy)

(defparameter *INTEGER-BITS* 32)  ;;; $@@0?t$O(J32BIT$@$G$"$k!#(J


;;; $@%-!<%\!<%I%$%Y%s%H$NI=<(%a%=%C%I(J
(defmethod print-object ((enent yy-keybord-event) stream)
  (format stream "\#<Keybord Event territory ~a>" (territory-no enent)))

;;; $@%^%&%9!"3d$j9~$_%-!<%$%Y%s%H$NI=<(%a%=%C%I(J
(defmethod print-object ((enent yy-interrupt-event) stream)
  (format stream "\#<Interrupt Event territory ~a>" (territory-no enent)))

;;; $@%F%j%H%j!<$NBg$-$5JQ99%$%Y%s%H$NI=<(%a%=%C%I(J
(defmethod print-object ((event yy-resize-event) stream)
  (format stream "#\<Resize Event territory ~a>" (territory-no event)))
   		  
;;; $@%^%9%/$h$j%9%m%C%HL>$r5a$a$k(J
(defmethod event-method-slot-name ((event-method event-method-mixin)
				  (mask integer))
  (declare 
   #-CMU
   (inline = /= logand)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf mask (logand mask #x0001FFFF))
  (cond 
   ((= mask *mouse-button-down-1*)
    'button-down1)
   ((/= (logand mask *mouse-left-1*) 0)
    'left-button-down-1)
   ((/= (logand mask *mouse-middle-1*) 0)
    'middle-button-down-1)
   ((/= (logand mask *mouse-right-1*) 0)
    'right-button-down-1)
   ((= mask *mouse-button-up*)
    'button-up)
   ((/= (logand mask *mouse-left-up*) 0)
    'left-button-up)
   ((/= (logand mask *mouse-middle-up*) 0)
    'middle-button-up)
   ((/= (logand mask *mouse-right-up*) 0)
    'right-button-up)
   ((= mask *mouse-button-down-2*)
    'button-down2)
   ((/= (logand mask *mouse-left-2*) 0)
    'left-button-down-2)
   ((/= (logand mask *mouse-middle-2*) 0)
    'middle-button-down-2)
   ((/= (logand *mouse-right-2* mask) 0)
    ' right-button-down-2)
   ((/= (logand *mouse-move* mask) 0)
    'move-mouse-cursor)
   ((/= (logand mask *mouse-in*) 0)
    'mouse-cursor-in)
   ((/= (logand mask *mouse-out*) 0)
    ' mouse-cursor-out)
   ((/= (logand mask *mouse-wait*) 0)
    'mouse-cursor-wait)
   ((/= (logand mask *interrupt*) 0)
    'interrupt-key)
   (t
    nil)))
  

;;; $@%$%Y%s%H%^%9%/$KBP1~$7$?%f!<%6!<Dj5A%a%=%C%I$r5a$a$k!#(J
;;;  $@%j%?!<%sCM$O!"%a%=%C%IL>$G$"$k!#(J
(defmethod get-available-method ((event-method T) mask)
#-:PCL
  (declare (ignore mask))
  nil)

(defmethod get-available-method ((event-method event-method-mixin)  mask)
  #-CMU
  (declare (special *mouse-move* *mouse-in* *mouse-out* *mouse-wait*
		    *interrupt* *mouse-button-down-1* *mouse-right-1*
		    *mouse-middle-1* *mouse-left-1* *mouse-button-up*
		    *mouse-right-up* *mouse-middle-up* *mouse-left-up*
		    *mouse-button-down-2* *mouse-right-2* *mouse-middle-2*
		    *mouse-left-2*)
		   (inline not zerop logand)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (let ((new-mask (logand #x0001FFFF mask))
		(ret nil))
    (cond
     ((not (zerop (logand new-mask *mouse-move*)))
      ;;; $@%^%&%9$,0\F0$5$l$?;~$N%$%Y%s%H$"$j(J
      (if (setf ret (move-mouse-cursor-method event-method))
		  ret
		nil))
     ((not (zerop (logand new-mask *mouse-in*)))
      ;;; $@%^%&%9$,F~$C$?;~$N%$%Y%s%H$"$j(J
      (if (setf ret (mouse-cursor-in-method event-method))
		  ret
		nil))
     ((not (zerop (logand new-mask *mouse-out*)))
      ;;; $@%^%&%9$,=P$?;~$N%$%Y%s%H$"$j(J
      (if (setf ret (mouse-cursor-out-method event-method))
		  ret
		nil))
     ((not (zerop (logand new-mask *mouse-wait*)))
      ;;; $@%^%&%9$,;_$^$C$?;~$N%$%Y%s%H$"$j(J
      (if (setf ret (mouse-cursor-wait-method event-method))
		  ret
		nil))
     ((not (zerop (logand new-mask *interrupt*)))
      ;;; $@3d$j9~$_%-!<$,2!2<$5$l$?(J
      (if (setf ret (interrupt-key-method event-method))
		  ret
		nil))
     ((not (zerop (logand new-mask *mouse-button-down-1*)))
      ;;; $@2?$+%\%?%s$,(J1$@2s2!2<$5$l$?$i5/F0$9$k%a%=%C%I$,$"$k(J
      (if (setf ret  (button1-method event-method))
		  ret
		(cond 
		 ((not (zerop (logand new-mask *mouse-right-1*)))
		  ;; $@1&%\%?%s(J
		  (if (setf ret (right-button-down-1-method event-method))
			  ret
			nil))
		 ((not (zerop (logand new-mask *mouse-middle-1*)))
		  ;; $@??Cf%\%?%s(J
		  (if (setf ret (middle-button-down-1-method event-method))
			  ret
			nil))
		 (t ;;; $@:8%\%?%s(J
		  (if (setf ret (left-button-down-1-method event-method))
			  ret
			nil))))
      )
     ((not (zerop (logand new-mask *mouse-button-up*)))
      ;;; $@2?$+%\%?%s$,N%$5$l$?$i5/F0$9$k%a%=%C%I$,$"$k!#(J
      (if (setf ret (button-up-method  event-method))
	  ret
	(cond
	 ((not (zerop (logand new-mask *mouse-left-up*)))
	  (if (setf ret (left-button-up-method event-method))
	      ret
	    nil))
	 ((not (zerop (logand new-mask *mouse-middle-up*)))
	  (if (setf ret (middle-button-up-method event-method))
	      ret
	    nil))
	 (t
	  (if (setf ret (right-button-up-method event-method))
	      ret
	    nil))
	 )))
     ((not (zerop (logand new-mask *mouse-button-down-2*)))
      ;;; $@2?$+%\%?%s$,(J2$@2s2!2<$5$l$?$i5/F0$9$k%a%=%C%I$,$"$k!#(J
      (if (setf ret (button2-method event-method))
	  ret
	(cond
	 ((not (zerop (logand new-mask *mouse-left-2*)))
	    (if (setf ret (left-button-down-2-method event-method))
		ret
	      nil))
	 ((not (zerop (logand new-mask *mouse-middle-2*)))
	  (if (setf ret (middle-button-down-2-method event-method))
	      ret
	    nil))
	 (t
	  (if (setf ret (right-button-down-2-method event-method))
	      ret
	    nil))
	 )))
     )))

  

;;; $@%$%Y%s%H%a%=%C%I%_%-%7%s$N%"%/%;%C%5(J
(defmethod event-mask ((event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (slot-value event-method 'event-mask))

;;; $@%$%Y%s%H%a%=%C%I%_%-%7%s$N%"%/%;%C%5(J SETF
(defmethod (setf event-mask) ((new-mask integer) 
			      (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (slot-value event-method 'event-mask) 
	(logior new-mask (slot-value event-method 'event-mask))))

;;; $@%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J setf
(defmethod (setf button1-method) :after (new-value 
				       (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-button-down-1*
					  (event-mask event-method)))))


;;; $@:8%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J SETF
(defmethod (setf left-button-down-1-method) :after (new-value
				       (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-left-1*
					  (event-mask event-method)))))

;;; $@Cf%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J SETF
(defmethod (setf middle-button-down-1-method) :after (new-value
			   (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-middle-1*
					  (event-mask event-method)))))

;;; $@1&%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
(defmethod (setf right-button-down-1-method) :after (new-value
			    (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-right-1*
					   (event-mask event-method)))))

;;; $@%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(J
(defmethod (setf button-up-method) :after (new-value
				     (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-button-up*
					   (event-mask event-method)))))

;;; $@:8%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(J
(defmethod (setf left-button-up-method) :after (new-value
			    (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-left-up*
					  (event-mask event-method)))))

;;; $@Cf%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(J
(defmethod (setf middle-button-up-method) :after (new-value
			   (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-middle-up*
					  (event-mask event-method)))))

;;; $@1&%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(J
(defmethod (setf right-button-up-method) :after (new-value
			   (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-right-up*
					   (event-mask event-method)))))

;;; $@%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
(defmethod (setf button2-method) :after (new-value
			   (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-button-down-2*
					  (event-mask event-method)))))

;;; $@:8%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
(defmethod (setf left-button-down-2-method) :after (new-value
   		           (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-left-2*
					  (event-mask event-method)))))

;;; $@Cf%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
(defmethod (setf middle-button-down-2-method) :after (new-value
                           (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-middle-2*
					  (event-mask event-method)))))

;;; $@1&%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(J
(defmethod (setf right-button-down-2-method) :after (new-value
                           (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-right-2*
					  (event-mask event-method)))))

;;; $@%^%&%9%+!<%=%k$,F0$/$3$H$K$h$j5/F0$9$k%a%=%C%I(J
(defmethod (setf move-mouse-cursor-method) :after (new-value
                           (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method)  (logior *mouse-move*
					   (event-mask event-method)))))

;;; $@%^%&%9%+!<%=%k$,F~$C$?;~$K5/F0$9$k%a%=%C%I(J
(defmethod (setf mouse-cursor-in-method) :after (new-value
                           (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-in*
					  (event-mask event-method)))))

;;; $@%^%&%9%+!<%=%k$,=P$?;~$K5/F0$9$k%a%=%C%I(J
(defmethod (setf mouse-cursor-out-method) :after (new-value
                           (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-out*
					   (event-mask event-method)))))


;;; $@%^%&%9%+!<%=%k$,$"$kNN0h$G(JN$@%_%jICDd;_$7$?;~$K5/F0$9$k%a%=%C%I(J
(defmethod (setf mouse-cursor-wait-method) :after (new-value
                           (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *mouse-wait*
					   (event-mask event-method)))))

;;; $@3d$j9~$_%-!<$,2!2<$5$l$?;~$K5/F0$5$l$k%a%=%C%I(J
(defmethod (setf interrupt-key-method) :after (new-value (event-method event-method-mixin))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new-value
      (setf (event-mask event-method) (logior *interrupt*
					  (event-mask event-method)))))

;;; $@%^%&%9%9%F!<%H$N>zB$BN(J
(defstruct (mouse-state-st (:conc-name mouse-state-)
	    #+ (and :PCL (not CMU))
	    (:print-function 'print-mouse-state)
	    )
	    x-position
	    y-position
	    button-state
	    object)

#+ (or :PCL :symbolics)
(defun print-mouse-state (object s l)
  (format s "\#<Button State: ~b x: ~a y: ~a>" 
	  (mouse-state-button-state object) (mouse-state-x-position object)
	  (mouse-state-y-position object)))


;;; $@%^%&%9%9%F!<%H$NI=<(%a%=%C%I(J
#- (or :PCL :symbolics)
(defmethod  print-object ((object mouse-state-st) stream)
  (format stream "\#<Button State: ~b x: ~a y: ~a>" 
	  (mouse-state-button-state object) (mouse-state-x-position object)
	  (mouse-state-y-position object)))

  
;;; $@%^%&%9%9%F!<%H$r:n$k(J
(defun make-mouse-state (&key (position nil) (x 0) (y 0)
			      (mask #b00000000000000000000000000000000)
			      (any-object nil))
  (if position
      (make-mouse-state-st :x-position (position-x position)
			   :y-position (position-y position)
			   :button-state mask
			   :object any-object)
    (make-mouse-state-st :x-position x
			 :y-position y
			 :button-state mask
			 :object any-object)))

#| $@%^%&%9%9%F!<%H$r9=B$$K$9$k(J
;;; $@%^%&%9%9%F!<%H$N%/%i%9(J
(defclass mouse-state ()
	((mouse-position :initarg :mouse-position
			 :type position :accessor mouse-position
			 :initform (make-position))
	 (button-state :initarg :button-state
		       :accessor button-state
		       :initform NIL)
	 ;;; $@%&%#%s%I%&%9%H%j!<%`!"%W%l%<%s%F!<%7%g%s!"%"%/%F%#%V%j!<%8%g%s(J
	 ;;; $@$,F~$k%9%m%C%H(J
	 (any-object :initarg :any-object :initform nil
		     :accessor mouse-state-object)))

;;; $@%^%&%9%9%F!<%H$NI=<(%a%=%C%I(J
(defmethod print-object ((mouse-state mouse-state) stream)
  (format stream "\#<Button State ~a Position ~a >" 
	  (get-mask-to-symbol (button-state mouse-state))
	  (mouse-position mouse-state)))

;;; $@%^%&%9%9%F!<%H$r:n$k(J
(defun make-mouse-state (&key (position nil) (x 0) (y 0)
			      (mask #b00000000000000000000000000000000)
			      (any-object nil))
  (if position
      (make-instance 'mouse-state :mouse-position position
		     :button-state mask
		     :any-object any-object)
    (make-instance 'mouse-state :mouse-position (make-position :x x :y y)
		   :button-state mask
		   :any-object any-object)))

;;; $@%^%&%9%9%F!<%H$N%"%/%;%C%5(J mouse-position x
(defmethod mouse-position-x ((mouse-state mouse-state))
  (position-x (mouse-position mouse-state)))

;;; $@%^%&%9%9%F!<%H$N%"%/%;%C%5(J mouse-position y
(defmethod mouse-position-y ((mouse-state mouse-state))
  (position-y (mouse-position mouse-state)))
|#


;;; $@F~NO%^%9%/$+$i%^%&%9%9%F%$%H$r5a$a$k(J
(defun get-mask-to-state (mask)
  #-CMU
  (declare (special  *mouse-button-down-1*
		     *mouse-move*
		     *mouse-wait*
		     *mouse-in*
		     *mouse-out* )
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (not (zerop mask))
      (let* ((i (- *INTEGER-BITS* 1)) (flg T)
	     (string 
	     (with-output-to-string (s)
		(when (and (not (zerop (logand *mouse-button-down-1* mask)))
			   (not (zerop (logand *mouse-move* mask))))
		      (princ "MOUSE-MOVE-WHILE-" s)
		      (setf flg nil))

		(when (and (not (zerop (logand *mouse-button-down-1* mask)))
			   (not (zerop (logand *mouse-wait* mask))))
		      (princ "MOUSE-WAIT-WHILE-" s)
		      (setf flg nil))

		(when (and (not (zerop (logand *mouse-button-down-1* mask)))
			   (not (zerop (logand *mouse-in* mask))))
		      (princ "MOUSE-IN-WHILE-" s)
		      (setf flg nil))

		(when (and (not (zerop (logand *mouse-button-down-1* mask)))
			   (not (zerop (logand *mouse-out* mask))))
		      (princ "MOUSE-OUT-WHILE-" s)
		      (setf flg nil))
		      
		(loop
		  (if (= i -1)
		      (return))
		  (if (logbitp i mask)
		      (case i
			(26 (princ "SHIFT-" s))
			(25 (princ "CONTROL-" s))
			(24 (princ "META-" s))
			(16 (return (princ "INTERRUPT" s)))
			(12 (return (princ "MOUSE-LEFT-2" s)))
			(11 (return (princ "MOUSE-MIDDLE-2" s)))
			(10 (return (princ "MOUSE-RIGHT-2" s)))
			(9 (if flg (return (princ "MOUSE-WAIT" s))))
			(8 (if flg (return (princ "MOUSE-OUT" s))))
			(7 (if flg (return (princ "MOUSE-IN" s))))
			(6 (if flg (return (princ "MOUSE-MOVE" s))))
			(5 (return (princ "MOUSE-LEFT-UP" s)))
			(4 (return (princ "MOUSE-MIDDLE-UP" s)))
			(3 (return (princ "MOUSE-RIGHT-UP" s)))
			(2 (return (princ "MOUSE-LEFT-1" s)))
			(1 (return (princ "MOUSE-MIDDLE-1" s)))
			(0 (return (princ "MOUSE-RIGHT-1" s)))))
		  (decf i)))))
	     
	string)
    "MOUSE-NONE"))

;;;$@F~NO%^%9%/$+$i%7%s%\%k$r5a$a$k(J
(defun get-mask-to-symbol (mask)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (intern  (with-output-to-string (s)
			 (princ "*" s)
			 (princ (get-mask-to-state mask) s)
			 (princ "*" s))))

;;; end of file

