;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; ӥǥ˥᡼μ¸
;;; This file is EUC code.
;;; vtr-control.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;	      All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/11/19 by t.kosaka
;;;

;;;  ʲΥ᥽åɤؿ饹ϡɥΩ夬äƤ

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ץꥱΥȥ ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package :yy)

;;; ץ쥼ȤƤ륪֥Ȥΰư
(defmethod moved-presented-object ((ob pos-data) window step-x step-y)

  (declare 
   #-PCL
   (ignore window)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (pos-x pos-y) ob
   (incf pos-x step-x)
   (incf pos-y step-y)))

(defun check-wait (window)
  (if (not (slot-value window 'accept-stop))
	  T
	nil))

;;; ȥåץ٥롼
(defun vtr-top-level (window)
  (let ((ob nil)
		(type nil)
		(present nil))
	(with-slots 
	 (accept-stop accept-condition) window
	 (loop
	  (when accept-stop
		  (wait-process #'check-wait window))
	  (multiple-value-setq
	   (ob type present)
	   (accept accept-condition window))
	  (disnable-event window (event-mask window))
	  (if (eq type :normal)
		  (action-object ob present)
		(return))
	  ))))

;;; 줿˵ư᥽å
(defmethod action-object :before ((ob vtr-switch) present)
  (redisplay-vtr-switch ob present :push))

;;; Υ줿˵ư᥽å
(defmethod action-object :after ((ob vtr-switch) present)
  (redisplay-vtr-switch ob present :normal))

;;; Υå
;;; ˥᡼󤬲ƯƤߤ
;;; ˥᡼Υɥɽ֤ˤ
(defmethod stop-current-switch ((ob vtr-switch) window)
  (declare
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (current-tape) window
   (with-slots 
	(animation-window animation-frame) current-tape
	(stop-animation animation-frame)
	(deactivate animation-window))
   (setf current-tape nil)))

(defmethod stop-current-switch ((ob t) window)
  (declare
   #-PCL
   (ignore window))
  nil)

;;; VTR Υơ׼ФФ줿
(defmethod action-object ((ob eject) present)
  (declare 
   #-PCL
   (ignore present)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (my-window) ob
   (with-slots
	(vtr-monitor other-color accept-condition current-swtich) my-window
	(stop-current-switch current-swtich my-window)
	(setf current-swtich nil)
	(with-slots
	 (pos-x pos-y) vtr-monitor
	 (with-graphic-state 
	  (color filled-type) my-window
	  (setf color other-color
			filled-type *FillSolid*)
	   (draw-region-xy my-window (+ pos-x 50) (+ pos-y 185)
					   24 12))
	(setf accept-condition 'vtr-tape)
	))
  ))

;;; VTRδ⤷Ф줿
(defmethod action-object ((ob rew) present)
  (declare 
   #-PCL
   (ignore present)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (my-window) ob
   (let ((tape (slot-value my-window 'current-tape))
		 (switch (slot-value my-window 'current-swtich))
		 (mouse-s (mouse-status)))
	  (when 
	   switch ;;; Ƥ
	   (with-slots
		(animation-window animation-frame) tape
		(stop-animation animation-frame)
		;; դ˹®
		(without-wait-run-animation animation-frame
					   :start-frame (current-frame-no animation-frame)
					   :direction :backward)
		;; Ƥֽ³
		(loop
		 (when (zerop (logand (mouse-state-button-state mouse-s)
							  *mouse-button-down-1*))
			   (return))
		 (sleep 0.2)
		 (setf mouse-s (mouse-status)))
		;;; ˥᡼
		(stop-animation animation-frame)
		;;; ˥᡼κƵư
		(without-wait-run-animation animation-frame
					   :start-frame (current-frame-no animation-frame)
					   :speed 30)
		)))))

;;; VTRκФ줿
(defmethod action-object ((ob play) present)
  (declare 
   #-PCL
   (ignore present)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (my-window) ob
   (let ((tape (slot-value my-window 'current-tape))
		 (switch (slot-value my-window 'current-swtich)))
	 (unless
	  switch ;;; ʤˤⲡƤʤ
	  (setf (slot-value my-window 'current-swtich) ob)
	  (with-slots
	   (animation-window animation-frame) tape
	   ;; ɥΥƥ
	   (activate animation-window)
	   ;; ˥᡼εư
	   (without-wait-run-animation animation-frame :speed 30)
	   ))
	 )))
		
;;; VTRδȤ꤬Ф줿
(defmethod action-object ((ob ff) present)
  (declare 
   #-PCL
   (ignore present)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (my-window) ob
   (let ((tape (slot-value my-window 'current-tape))
		 (switch (slot-value my-window 'current-swtich))
		 (mouse-s (mouse-status)))
	  (when 
	   switch ;;; Ƥ
	   (with-slots
		(animation-window animation-frame) tape
		(stop-animation animation-frame)
		;; ®
		(without-wait-run-animation animation-frame
					   :start-frame (current-frame-no animation-frame))
		;; Ƥֽ³
		(loop
		 (when (zerop (logand (mouse-state-button-state mouse-s)
							  *mouse-button-down-1*))
			   (return))
		 (sleep 0.2)
		 (setf mouse-s (mouse-status)))
		;;; ˥᡼
		(stop-animation animation-frame)
		;;; ˥᡼κƵư
		(without-wait-run-animation animation-frame
					   :start-frame (current-frame-no animation-frame)
					   :speed 30)
		)))))


;;; ߤФ줿
(defmethod action-object ((ob pose) present)
  (declare 
   #-PCL
   (ignore present)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (my-window) ob
   (let ((tape (slot-value my-window 'current-tape))
		 (switch (slot-value my-window 'current-swtich)))
	  (when 
	   switch ;;; Ƥ
	   (with-slots
		(animation-window animation-frame) tape
		(if (eql (animation-status animation-frame) :active)
			(stop-animation animation-frame)
		  ;;; 
		  (without-wait-run-animation animation-frame
						  :start-frame (current-frame-no animation-frame)
						  :speed 30))
		)))))

;;; ߤФ줿
(defmethod action-object ((ob stop) present)
  (declare 
  #-PCL
  (ignore present)
  (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (my-window) ob
   (let ((tape (slot-value my-window 'current-tape))
		 (switch (slot-value my-window 'current-swtich)))
	  (when 
	   switch ;;; Ƥ
	   (with-slots
		(animation-window animation-frame) tape
		(when (eql (animation-status animation-frame) :active)
			  (setf (slot-value my-window 'current-swtich) nil)
			  (stop-animation animation-frame)
			  (deactivate animation-window))
		)))))
		
;;; 򤵤줿ư VTR ơפξ
;;; ɬơפϡơץåVTRˤ롣
(defmethod action-object ((ob vtr-tape) present)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((my-window (slot-value ob 'my-window)))
	(with-slots
	 (accept-stop select-tape) my-window
	 (setf accept-stop T
		   select-tape (list ob present)))
	(enable-event my-window)))

;;; ޥΰưΥޥ᥽å
(defun tape-move (window state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((tape-and-p (slot-value window 'select-tape))
		(x (mouse-state-x-position state))
		(y (mouse-state-y-position state)))
	(when 
	 tape-and-p
	 (let ((ob (car tape-and-p))
		   (pre (second tape-and-p)))
		  (with-slots 
		   (pos-x pos-y) ob
		   (move-presented-object-alone
			ob window 
			'vtr-tape (- x pos-x) (- y pos-y) pre)
		   (setf pos-x x pos-y y))))))
  

;;; ޥβΥޥ᥽å
(defun button-down-with-tape (window state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((tape-and-p (slot-value window 'select-tape))
		(monitor (slot-value window 'vtr-monitor))
		(ruck (slot-value window 'tape-ruck))
		(x (mouse-state-x-position state))
		(y (mouse-state-y-position state)))
	(when 
	 tape-and-p
	 (let ((ob (car tape-and-p))
		   (pre (second tape-and-p)))
	   (with-slots 
		(pos-x pos-y) ob
		(cond 
		 ((region-contains-position-xy-p
		   (slot-value monitor 'insert-region) x y)
		  (insert-tape window ob pre))
		 ((region-contains-position-xy-p ruck x y)
		  (return-to-ruck window ob pre))
		 (t
		  ))))
	 )))


;;; VTR˥˥ơפ
(defun insert-tape (window tape present)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (current-tape vtr-monitor accept-condition tape-title-color) window
   (let ((region (slot-value vtr-monitor 'insert-region)))
	 (setf current-tape tape
		   accept-condition 'vtr-switch)
	 (with-slots
	  (pos-x pos-y animation-window) tape
	  (with-region-slots
	   (left bottom) region
	   (move-presented-object tape window 'vtr-tape
							  (- left pos-x) (- bottom pos-y)
		present)
	   (setf pos-x left pos-y bottom))
	  (with-slots
	   ((ppx pos-x) (ppy pos-y) screen-x screen-y) vtr-monitor
	   ;; ơޡ
	   (with-graphic-state 
		(color filled-type) window
		(setf color tape-title-color
			  filled-type *FillSolid*)
	   (draw-region-xy window (+ ppx 50) (+ ppy 185)
					   24 12))
;	   (put-image-xy window tape-mark (+ ppx 50)
;					(+ ppy 185))
	   ;; ˥᡼󥦥ɥΰư
	   (move-xy animation-window (+ ppx screen-x)
				(+ ppy screen-y))
	   ))))
   (disnable-event window (event-mask window))
   (setf (accept-stop window) nil
		 (select-tape window) nil)
  )

;;; ơץå
(defun return-to-ruck (window tape present)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (pos-x pos-y original-x original-y) tape
   (move-presented-object tape window 'vtr-tape
						  (- original-x pos-x) 
						  (- original-y pos-y)
						  present)
   (setf pos-x original-x pos-y original-y))
  (setf (accept-stop window) nil
		 (select-tape window) nil)
  (disnable-event window (event-mask window)))

;;;; End of file

