;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka
;;
;; YY$@%&%#%s%I%&%7%9%F%`$NJ8;zNsI=<(%a%=%C%I(J
;;               1990.3.20  $@8E:d(J
;;; Version 1.0   Coded by t.kosaka 1990-3-20
;;;               Change LOG   Add page mode drawing 
;;;               Change LOG   Change drawing-text-internal-yoko-mode
;;; Version 1.3   90/12/19 By T.kosaka
;;;               Add method drawing-text becouse presentation needs 
;;;               after method.
;;; Version 1.4   92 4/9 T.kosaka

(in-package :yy)

;;; $@J8;zNs$NI=<((J
;;; $@%9%H%j!<%`$N%+!<%=%k0LCV$+$iI=<((J
(defmethod drawing-text ((stream world-primitive) (string string))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (eq (stream-output-direction stream) :vertical)
      (drawing-text-internal-tate stream string)
    (drawing-text-internal-yoko stream string)))


;;; $@%Z!<%8MQ(J $@2#=q$-J8;zNs$NI=<((J
;;; $@=q$$$?Bg$-$5$r(Jdrawing-region $@$K@_Dj(J
(defmethod drawing-text-internal-yoko ((stream page-window-stream)
					(string string))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((region (page-drawing-text stream string)))
    ;;; $@%+!<%=%k0LCV$r@_Dj(J
    (set-cursor-yoko-mode stream string region)))


;;; $@%S%e%]!<%HMQ(J $@2#=q$-J8;zNs$NI=<((J
;;; $@=q$$$?Bg$-$5$r(Jdrawing-region $@$K@_Dj(J
(defmethod drawing-text-internal-yoko ((stream viewport-window-stream)
					(string string))
  (declare 
   #-CMU
   (inline max min)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((posx (position-x (slot-value stream 'cursor-position)))
		 (posy (position-y (slot-value stream 'cursor-position)))
		 (ret (string-display-region-yoko 
			   (work-region2 stream) stream string posx posy))
	     (s-list (cdddr ret))
		 (new-x (second ret))
		 (new-y (third ret)))
				 
    ;;; $@%o!<%k%I%j!<%8%g%s$NJQ99(J
	(setf (world-region stream) (car ret))

        ;;; $@J8;zNs$r%W%m%H%3%k$KAw$k(J
	(draw-text-with-matrix (stream-transform-by-matrix stream)
			    stream (graphic-operation stream)
			    s-list string)
		
    ;;; $@%+!<%=%k%]%8%7%g%s$r@_Dj(J
	(setf (position-x (slot-value stream 'cursor-position)) new-x
	      (position-y (slot-value stream 'cursor-position)) new-y)

    ;;; drawing-region$@$K:#$N%j!<%8%g%s$rDI2C(J
	(set-drawing-region (drawing-region stream) (first ret))
    ))


;;; $@J8;zNs$r%W%m%H%3%k$KAw$k(J
;;; $@2sE>9TNs$J$7(J
(defmethod draw-text-with-matrix ((matrix graphic-transform-matrix-non)
				  (stream window-stream) op s-list string)
  (declare 
   #-CMU
   (inline + incf)
   (optimize (compilation-speed 0) (speed 3) (safety 0))
   #-PCL
   (ignore string)
   )

  (with-slots
   (presentation-instance (tno world-territory-no) font) stream

   (let ((color-no (color-no (graphic-color stream)))
		 (font-no (font-no font))
		 (posx 0) (posy 0) (end-x 0) (end-y 0)
		 (font-height (font-kanji-height font)))
		 
	  ;; $@J8;zNs$NIA2h(J $@2sE>9TNsL5;k(J
	  (do ((item s-list (cdr item)))
		  ((null item))

		  (setf posx (car (car item))
				posy (second (car item))
				end-x (fourth (car item))
				end-y (fifth (car item)))

		  (make-normal-string-object  presentation-instance
									  (list tno (list posx posy end-x end-y)
											op color-no font-no 
											(third (car item))
											font-height)
									  stream)

		  ))))


;;; $@J8;zNs$r%W%m%H%3%k$KAw$k(J
;;; $@2sE>9TNs$"$j(J
(defmethod draw-text-with-matrix ((matrix graphic-transform-matrix-exec)
								  (stream window-stream) op s-list string)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   #-PCL
		   (ignore string)
		   )

  (with-slots
   (presentation-instance
	(tno world-territory-no) font (matrix transform-by-matrix)) stream
	(let ((color-no (color-no (graphic-color stream)))
		  (font-no (font-no font))
		  (posx 0) (posy 0) (end-x 0) (end-y 0) 
		  (font-height (font-kanji-height font))
		  (xtime (round (matrix-x-time matrix)))
		  (ytime (round (matrix-y-time matrix)))
		  (theta 
		   #+:YY2.0
		   (round (* (matrix-theta matrix) 64))
		   #-:YY2.0
		   (if (not (zerop (matrix-theta matrix)))
			   (round (*  (matrix-theta matrix)
								 -64))
			 0))
		  )

    (do ((item s-list (cdr item)))
	((null item))
	(setf posx (car (car item))
		  posy (second (car item))
		  end-x (fourth (car item)) 
		  end-y (fifth (car item)))

	(make-angle-string-object  presentation-instance
							(list tno (list posx posy end-x end-y)
								  op color-no font-no xtime ytime theta
								  (third (car item)) font-height)
							stream)
	)))
  )


;;; $@%S%e%]!<%HMQ=D=q$-J8;zNs$NI=<((J
;;; $@=q$$$?Bg$-$5$r(Jdrawing-region $@$K@_Dj(J
(defmethod drawing-text-internal-tate ((stream viewport-window-stream)
									   (string string))
  (declare 
   #-CMU
   (inline + -min max)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (with-translate-transform-xy 
   ((xx yy) stream (position-x (slot-value stream 'cursor-position))
	(position-y (slot-value stream 'cursor-position)))
	
   (let* ((posx xx)
		  (posy yy)
		  (ret (string-display-region-tate (work-region2 stream)
										   stream string posx posy))
		  (new-region (car ret))
		  (new-posx (second ret))
		  (new-posy (third ret))
		  (s-list (cdddr ret))
		  (op (graphic-operation stream))
		  (drawing-region (drawing-region stream)))

	 ;; $@%o!<%k%I%j!<%8%g%s$NJQ99(J
	 (setf (world-region stream) new-region)

	 ;; $@J8;zNs$NIA2h(J 
	 (draw-text-with-matrix-tate stream op s-list string)

	 ;; $@%+!<%=%k%]%8%7%g%s$r@_Dj(J
	 (setf (position-x (slot-value stream 'cursor-position)) new-posx
		   (position-y (slot-value stream 'cursor-position)) 
		   (with-translate-coordinate-stream new-posy stream))

	 ;; drawing-region$@$K:#$N%j!<%8%g%s$rDI2C(J
	 (set-drawing-region drawing-region new-region)
	 )))

;;; $@J8;zNs$r%W%m%H%3%k$KAw$k(J $@=D=q$-MQ(J
;;; $@2sE>9TNs$"$j(J
(defun draw-text-with-matrix-tate (stream op s-list string)
  (declare 
   #-CMU
   (inline + * round)
   (optimize (compilation-speed 0) (speed 3) (safety 0))
   #-PCL
   (ignore string)
   )
  (with-slots
    (presentation-instance
     (tno world-territory-no) font) stream
    (let ((color-no (color-no (graphic-color stream)))
	  (font-no (font-no font))
	  (font-height (font-kanji-height font))
	  (posx 0) (posy 0) (end-x 0) (end-y 0))

      (do ((item s-list (cdr item)))
	  ((null item))

	(setf posx (car (car item))
	      posy (second (car item))
	      end-x (fourth (car item))
	      end-y (fifth (car item)))
		
	(make-tate-string-object  presentation-instance
				  (list tno (list posx posy end-x end-y)
					op color-no font-no 
					(third (car item)) font-height)
				  stream)
	)
      )))


;;; $@;XDj0LCV$,%U%l!<%`$NCf1{$KF~$k$h$&$K%*%U%;%C%H$rJQ99(J
;;; $@$3$N%a%=%C%I$O!":BI87O$,$$$D$b:8>e(J
(defun change-offset-xy (stream x y)
  (declare 
   #-CMU
   (inline - + / < >)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((offset-x (world-x-offset stream))
	 (offset-y (world-y-offset stream))
	 (base-line (font-kanji-base-line (stream-font stream)))
	 (add-height (- (font-kanji-height (stream-font stream)) base-line))
	 (new-x (+ x offset-x))
	 (new-y (+ y offset-y))
	 (new-offset-x nil)
	 (new-offset-y nil)
	 (f-width (region-width (frame-region stream)))
	 (f-height (region-height (frame-region stream)))
	 (x-shift (round (/ f-width 2)))
	 (y-shift (round (/ f-height 2))))

;(format t "x : ~a offset ~a start ~a ~%" x offset-x world-x)
    ;;; $@%*%U%;%C%H$GH=CG$9$k(J
    (cond 
     ;;; $@%*%U%;%C%H$,#0$G$"$k(J
     ((zerop offset-x)
      ;;; $@:8B&$K0\F0$+!)(J
      (if (< x 0)
	(setf new-offset-x x-shift)
      ;;; $@1&$K0\F0$+!)(J
      (if (> (+ x (font-kanji-width (stream-font stream)))  f-width)
	  (setf new-offset-x (- x-shift)))))
     ;;; $@%*%U%;%C%H$,#0$h$jBg$-$$(J --> $@%o!<%k%I$,1&$K$$$C$F$$$k(J
     ((> offset-x 0)
      ;;; $@1&$K0\F0$+!)(J
      (if (< x (- offset-x))
	  (setf new-offset-x (+ offset-x x-shift))
	(if (> (+ new-x (font-kanji-width (stream-font stream))) f-width)
	    (setf new-offset-x (- offset-x x-shift)))))
     ;;; $@%*%U%;%C%H$,#0$h$j>.$5$$(J --> $@%o!<%k%I$,:8$K$h$C$F$$$k(J
     (t
      ;;; $@1&$K0\F0$+!)(J
      (if (< (+ offset-x x) 0)
	  (setf new-offset-x x-shift)
	(if (> (+ offset-x x (font-kanji-width (stream-font stream))) f-width)
	    (setf new-offset-x (- offset-x x-shift))))))

;(format t "offset-y : ~a world-y : ~a ~% region : ~a ~%" offset-y world-y
	;(world-region stream))

    ;;; $@%*%U%;%C%H$GH=CG$9$k(J
    (cond 
     ;;; $@%*%U%;%C%H$,#0$G$"$k(J
     ((zerop offset-y)
      ;;; $@:8B&$K0\F0$+!)(J
      (if (< (- y base-line) 0)
	 (setf new-offset-y y-shift))
      ;;; $@1&$K0\F0$+!)(J
      (if (> (+ y add-height)  f-height)
	  (setf new-offset-y (- y-shift))))
     ;;; $@%*%U%;%C%H$,#0$h$jBg$-$$(J --> $@%o!<%k%I$,2<$K$$$C$F$$$k(J
     ((> offset-y 0)
      ;;; $@1&$K0\F0$+!)(J
      (if (< (- y base-line) (- offset-y))
	  (setf new-offset-y (+ offset-y y-shift))
	(if (> (+ new-y add-height) f-height)
	    (setf new-offset-y (- offset-y y-shift)))))
     ;;; $@%*%U%;%C%H$,#0$h$j>.$5$$(J --> $@%o!<%k%I$,>e$K$h$C$F$$$k(J
     ((< offset-y 0)
      ;;; $@1&$K0\F0$+!)(J
      (if (< (+ offset-y y base-line) 0)
	  (setf new-offset-y y-shift)
	(if (> (+ offset-y y add-height) f-height)
	    (setf new-offset-y (- offset-y y-shift))))))

    ;;; $@%*%U%;%C%H$rJQ99(J
    (change-world-xy-offset stream new-offset-x new-offset-y)))


;;; $@;XDj0LCV$KF~$k$h$&$K%*%U%;%C%H$rJQ99$9$k(J
(defmethod change-offset-position ((stream world-primitive) (pos position))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (change-offset-xy stream (position-x pos) (position-y pos)))


;;; $@%Z!<%8MQ(J $@=D=q$-J8;zNs$NI=<((J
;;; $@=q$$$?Bg$-$5$r(Jdrawing-region $@$K@_Dj(J
(defmethod drawing-text-internal-tate ((stream page-window-stream)
				       (string string))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((region (page-drawing-text stream string)))
    (set-cursor-tate-mode stream string region)))


;;; $@%Z!<%8%b!<%I$N%F%-%9%H$NIA2h(J
(defmethod page-drawing-text ((stream page-window-stream)
							  (string string))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((tno (world-territory-no stream))
		 (color-no (color-no (graphic-color stream)))
		 (font-no (font-no (stream-font stream)))
		 (op (graphic-operation stream))
		 (drawing-region (drawing-region stream))
		 (ret nil))

#+:Symbolics
    (dotimes (i (length string))
      (if (char= (char string i) #\newline)
		  (setf (char string i) (code-char 10))))

    ;;; $@%W%m%H%3%k$KAw$k(J
    (setf ret (yy-protocol-84 tno op color-no font-no string))

    ;;; $@%+%i%`$H9T$r@_Dj(J
    (setf (page-column stream) (nth 4 ret)
		  (page-line stream) (nth 5 ret))

    ;;; $@IA2h%j!<%8%g%s$r5a$a$k(J
    (with-temp-region-args 
	 ((region) (work-region1 stream)
	  :left (first ret)
	  :bottom (second ret)
	  :width (third ret)
	  :height (nth 4 ret))
	 
	 ;; $@IA2h%j!<%8%g%s$r:BI87O$K9g$o$9(J
	 (setf region (change-coodinate-region region stream))

	 (when region
		   (with-region-slots
			(left bottom width height) region
			(with-slots 
			 (presentation-instance) stream
			 (make-page-mode-string-object 
			  presentation-instance
			  (list nil (list left bottom) width height
					nil)))))
									
	 ;; drawing-region$@$K:#$N%j!<%8%g%s$rDI2C(J
	 (if (null drawing-region)
		 (setf (drawing-region stream) region)
	   (setf (region-left drawing-region)
			 (min (region-left drawing-region) (region-left region))
			 (region-top drawing-region) 
			 (max (region-top drawing-region) (region-top region))
			 (region-right drawing-region)
			 (max (region-right drawing-region) (region-right region))
			 (region-bottom drawing-region)
			 (min (region-bottom drawing-region) (region-bottom region))))
	 region)
    ))

    
;;; $@%Z!<%8%b!<%I$N(Jx,y$@%]%8%7%g%s$r@_Dj$9$k!#(J
(defmethod set-cursor-yoko-mode ((stream  page-window-stream)
				 (string string)
				 (region region))
  (declare 
   #-CMU
   (inline > -)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((last-c (char (reverse string) 0))
	(x 0) (y 0))

    ;;; $@IA2h%+!<%=%k$N@_Dj(J
    (if (> (char-code last-c) #xA1)
	;;; $@4A;z(J
	(setf y (- (region-bottom region)
		   (- (font-kanji-height  (stream-font stream))
		       (font-kanji-base-line (stream-font stream))))
	      x (- (region-right region)
		   (font-kanji-width (stream-font stream))))
      ;;; $@1Q;z(J
      (setf y (- (region-bottom region)
		 (- (character-height (stream-font stream) last-c)
		    (character-base-line (stream-font stream) last-c)))
	    x (- (region-right region)
		 (character-width (stream-font stream) last-c))))

    (setf (stream-cursor-x-position stream) x
	  (stream-cursor-y-position stream) y)
    ))



;;; $@%Z!<%8MQ(J $@=D=q$-J8;zNs$NI=<((J
;;; $@=q$$$?Bg$-$5$r(Jdrawing-region $@$K@_Dj(J
(defmethod set-cursor-tate-mode ((stream  page-window-stream)
				 (string string)
				 (region region))
  (declare
   #-CMU
   (inline > -)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((last-c (char (reverse string) 0))
	(x 0) (y 0))

    ;;; $@IA2h%+!<%=%k$N@_Dj(J
    (if (> (char-code last-c) #xA1)
	;;; $@4A;z(J
	(setf y (- (region-bottom region)
		   (- (font-kanji-height  (stream-font stream))
		       (font-kanji-base-line (stream-font stream))))
	      x (- (region-right region)
		   (font-kanji-width (stream-font stream))))
      ;;; $@1Q;z(J
      (setf y (- (region-bottom region)
		 (character-width (stream-font stream) last-c))
	    x (- (region-right region)
		 (character-height (stream-font stream) last-c))))

    (setf (stream-cursor-x-position stream) x
	  (stream-cursor-y-position stream) y)
    ))

;;; $@9T$K$h$j(Jy-position$@$H9T$r@_Dj$9$k(J
(defmethod set-y-position-for-page-maode ((stream page-window-stream)
					  line-amount
					  colum-amount)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (eq (stream-output-direction  stream) :vertical)
      (let ((colum-no (- colum-amount (page-column stream))))
	(setf (page-column stream) colum-amount
	      (stream-cursor-x-position stream)
	      (* colum-no (stream-line-feed stream))))
    (let ((lin-no (- line-amount (page-line stream))))
      (setf (page-line stream) line-amount
	    (stream-cursor-y-position stream)
	    (* lin-no (stream-line-feed stream)))
      )))


;;; End of file









