;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; ˥᡼μ¸
;;; This file is EUC code.
;;; sample-window.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;	      All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/06/06 by t.kosaka
;;;
;;;  ʲΥ᥽åɤؿ饹ϡɥΩ夬äƤ

(in-package :yy)
;;;; home/YY/kosaka/images/yyformat/"

(defvar *yyformat-images-directory-pathname*
  "/home/kosaka/images/yyformat/"
  "YYformat images directory name
Type must use string, don't use pathname")

;;; ȥСκɽ᥽å after᥽å
(defmethod redisplay-title-bar :after ((title animation-switch-title-bar))
  (declare (special *mouse-button-down-1* *default-font* *image-yy*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (null (switch1 title))
    (let ((ob1 (make-instance 'switch
    		     :object-parent title
		     :draw-piece-visible T
    		     :switch-stream (object-parent title)
    			 :bottom 1 :left (- (region-width title) 65)
			 :width 30 :height (- (region-height title) 2)))
	  (ob2 (make-instance 'switch
		 :object-parent title
		 :draw-piece-visible T
		 :switch-stream (object-parent title)
		 :bottom 1 :left (- (region-width title) 33)
		 :width 30 :height (- (region-height title) 2))))

      (with-event-object (ob1)
		 (setf (button1-method ob1) 'start-animation
			   (get 'start-animation 'single-process) T
	    	   (slot-value ob1 'event-mask) *mouse-button-down-1*))

      (with-event-object (ob2)
		 (setf (button1-method ob2) 'animation-stop
		       (get 'animation-stop 'single-process) t
	    	   (slot-value ob2 'event-mask) *mouse-button-down-1*))

      (setf (switch1 title) ob1
	    (switch2 title) ob2)
      
      (with-slots 
       ((color title-bar-color)) title
       (draw-animation-title ob1 "ư" color)
       (draw-animation-title ob2 "" color)))

    (let ((ob1 (switch1 title))
	  (ob2 (switch2 title)))
      (with-region-slots
       (width) title
       (with-real-object 
	(ob1)
	(set-region-position-xy ob1 (- width 65) 1))
       (with-real-object
        (ob2)
        (set-region-position-xy ob2 (- width 35) 1)))
      )
    ))
       
;;;˥᡼μ¹
(defmethod start-animation ((ob switch) state)
  (declare (ignore state))
  (run-animation (animation-frame (switch-stream ob))
				 :speed 10))

;;; ˥᡼
(defmethod animation-stop ((ob switch) state)
  (declare (ignore state))
  (stop-animation (animation-frame (switch-stream ob))))


;;; ˥᡼Υåɽ
(defun draw-animation-title (ob string color)
  (draw-piece-color ob color)
  (draw-piece-string ob 0 (font-kanji-base-line *default-font*) string :color *white-color*))


(defvar *animation-window* nil)


;;; YYΥ᡼
(defvar *image-and-file-list* nil)

;;; YYΥ˥᡼󥦥ɥ
(defun make-yylogo-window ()
  (declare (special *animation-window*)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((region (get-box-region (make-region :left 0 :bottom 0
											 :width 118 :height 105)))
		 (window
		  (make-animation-window "f-"
					 30 region 106 80 :scroll T))
		 )
    
    (setf *animation-window* window)))



;;; ˥᡼󥦥ɥ
(defun make-animation-window (file-name frame-no region frame-width
			      frame-height &key 
			      (scroll nil)
			      (parent *root-window*))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((window (if scroll
		     (make-window-instance 
		       'animation-window
		       :window-region region
		       :title-bar 'animation-switch-title-bar
		       :title-bar-string "YYLOGO")
		     (make-window-instance
		       'animation-window
		       :parent-window parent
		       :window-region region
		       :vertical-scroll-bar nil
		       :parent-window parent
		       :horizontal-scroll-bar nil
		       :coordinate-area nil
		       :title-bar nil)))
	 (frame (define-animation-frame window 1 1 frame-width frame-height
					frame-no
					))
	 (file-name 
	  (concatenate 'string user::*YY-IMAGE-directory* file-name)))

    ;;; ˥᡼Υ
	(dotimes (i frame-no)
			 (put-frame frame i (format nil "~a~a.ras" file-name i)))

    ;;; ˥᡼ե졼
	(setf (animation-frame window) frame)
	window
	))


;;; ɤ߹᡼
;;; ɤǤʤäɤ߹
(defun alrady-load-image (file)
  (declare (special *image-and-file-list* )
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((ret nil))
	(dolist (item *image-and-file-list*)
			(when (string= (car item) file)
				  (setf ret (second item))
				  (return)))
	(when (null ret)
		  (setf ret (load-image file))
		(push (list file ret) *image-and-file-list*))
	ret))

(defmethod initialize-instance :after ((ob application) &rest args)
  (declare (special *application-box*)
		   #-PCL
		   (ignore args)
		   )
  (let ((window *application-box*))
	(with-output-as-presentation
	 (ob window 'application)
	 (write-string (application-title ob) window)
	 (terpri window)
	 (force-output window))))
;;; End of file




