;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@%W%l%<%s%F!<%7%g%s4XO"(J
;;; presentation.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; $@%W%l%<%s%F!<%7%g%s$N4X?t4X78(J
;;; 3/13 1990 $@8E:d(J
;;; Version 1.0   Corded by t.kosaka 1990-3-13
;;; Version 1.3   Corded by T.kosaka 1990-12-19
;;; Version 1.4   Corded by T.kosaka 1992-03-04

(in-package :yy)

;;; $@%W%l%<%s%F!<%7%g%s$rGK2u$9$k(J
;;; flush-presentation presentation &optional (territory T)
;;; ARG.
;;;          presentation = $@%W%l%<%s%F!<%7%g%s%$%s%9%?%s%9(J
;;;          territory    = $@$b$7(JT$@$J$i$P%F%j%H%j!<$NGK2u(J
(defmethod flush-presentation ((presentation display-yy-presentation)
                               &optional (territory T))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  ;;; $@4XO"IU$1$r2r=|(J
  (delete-lisp-object (presentation-territory-no presentation))
  (when territory
     ;(yy-protocol-5 (presentation-territory-no presentation))
     ;(yy-protocol-2 (presentation-territory-no presentation) 0)
		(with-region-slots 
		 (left bottom width height) presentation
		 (setf left -100 bottom -100 width 1 height 1)
		 (yy-protocol-4 (presentation-territory-no presentation)
                          left bottom width height 0 0))
	)
  (setf (presentation-territory-no presentation) nil))


;;; $@%*%V%8%'%/%H$N$"$k0LCV$r%k!<%H%&%#%s%I%&%9%H%j!<%`$+$i$N0LCV$KJQ99$7$?(J
;;; $@0LCV$r5a$a$k(JXY$@MQ%W%l%<%s%F!<%7%g%sMQ(J
(defmethod translate-root-xy ((object display-yy-presentation) x y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (translate-root-xy (slot-value object '_presented-stream)
		     (+ x (region-left object))
		     (+ y (region-bottom object)))
  )

;;; $@%$%Y%s%H$N2sI|(J
(defmethod enable-event ((presentation display-yy-presentation))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-72 (presentation-territory-no presentation)
                  (event-mask presentation)))

;;; $@%$%Y%s%H$N0l;~Dd;_(J 
(defmethod disnable-event ((presentation display-yy-presentation) mask)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((old-mask (event-mask presentation))
         (new-mask (logand (lognot mask) old-mask)))
    (yy-protocol-72 (presentation-territory-no presentation) new-mask)))

;;; $@%$%Y%s%H$N2sI|(J ($@;R$I$bMQ(J)
(defmethod enable-event ((presentation display-yy-presentation-root))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  presentation)

;;; $@%$%Y%s%H$N0l;~Dd;_(J ($@;R$I$bMQ(J)
(defmethod disnable-event ((presentation display-yy-presentation-root) mask)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore mask))
  presentation)

;;; $@86E@$+$i$N5wN%$G3QEY7W;;$r$9$k(J
;;; $@86E@$+$i$N5wN%(J x y
;;; $@H?;~7W2s$j(J
;;; $@:BI87O$O(Jleft top$@$N>l9g$@$1(J
(defun angle-from-axsis-top (x y)
    (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
	(setf y (* y -1))
	(if (zerop y) ;;; $@FC0[E@(J
		(if (> x 0)
			0.0
			pi)
	  (if (zerop x) ;;; $@FC0[E@(J
		  (if (> y 0)
			  (/ pi 2)
			(+ pi (/ pi 2)))
		(cond 
		 ((and (> x 0) (> y 0)) ;;; $@Bh0l<!>]8=(J
		  (atan (/ y x)))
		 ((and (< x 0) (> y 0)) ;;; $@BhFs<!>]8=(J
		  (+ pi (atan (/ y x))))
		 ((and (< x 0) (< y 0)) ;;; $@Bh;0<!>]8=(J
		  (+ (atan (/ y x)) pi))
		 (t
		  (+ (atan (/ y x)) (* 2 pi)))
		 ))))

;;; $@@~$N79$-$+$i3QEY$r5a$a$k(J
(defun angle-from-katamuki (katamuki)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (eq :none katamuki)  ;;; x = 10 $@$N$h$&$J@~(J
	 (/ pi 2)
	(atan katamuki)))

;;; $@E@$N8!:w4X?t(J
(defun point-point-selection (event-x event-y xy &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore args))
  (if (and (<= (- (car xy) 1) event-x)
		   (<=  event-x (+ (car xy )1))
		   (<= (- (second xy) 1) event-y)
		   (<= event-y (+ (second xy) 1)))
	  T
	nil))

(defun yy-protocol-20-pr (no xys op color)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-20 no (car xys) (second xys) op color))


;;; $@@~$N8!:w4X?t(J
(defun point-line-selection (event-x event-y xy line-width &rest arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore arg))
	(if (= line-width 1)
		(setf line-width 3))
    ;;; $@86E@$r(Jx1 y1 $@$K$9$k(J
	(let* ((x1 (car xy))
		   (y1 (second xy))
		   (x2 (third xy))
		   (y2 (fourth xy))
		   (nx2 (- x2 x1))
		   (ny2 (- y2 y1))
		  (katamuki (if (zerop nx2)
						:none
					  (/ ny2 nx2)))
		(kakudo (* -1.0 (angle-from-katamuki katamuki)))
		(cosv (cos kakudo))
		(sinv (sin kakudo))
		(new-event-x (- event-x x1))
		(new-event-y (- event-y y1))
		(new-x (- (* new-event-x cosv)
				  (* sinv new-event-y)))
		(new-y (+ (* sinv  new-event-x) 
				  (*  cosv new-event-y)))
		(max-x (- (* nx2 cosv) (* sinv ny2)))
		(line-w (float (/ line-width 2))))
;(format t "~%new-x: ~a new-y: ~a max-x: ~a" new-x new-y max-x)
	(if (and (>= new-y (* -1 line-w)) (>= new-x (min 0.0 max-x))
			 (>= (max max-x 0.0) new-x)
			 (>= line-w new-y))
		T
	  nil))
  )

(defun yy-protocol-21-pr (no xys width op edge color dashing)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-21 no (car xys) (second xys) (third xys) (fourth xys)
				   width op edge color dashing))


;;; $@OH6k7A$NA*Br(J
(defun point-region-selection (event-x event-y xy width height lw 
									   &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore args))
  (let* ((left (car xy))
		 (bottom (second xy))
		 (right (+ left width))
		 (top (+ bottom height))
		 (line-width (float (/ lw 2))))

	(if (and (>= event-x left)
			 (>= right event-x)
			 (>= event-y bottom)
			 (>= top event-y))
		(cond
		 ((and (>= event-x left)
			   (>= (+ left line-width) event-x))
		  T)
		 ((and (>= event-x (- right line-width))
			   (>= right event-x))
		  T)
		 ((and (>= event-y bottom)
			   (>= (+ bottom line-width) event-y))
		  T)
		 ((and (>= event-y (- top line-width))
			   (>= top event-y))
		  T)
		 (T
		  nil)))
	))

(defun yy-protocol-26-pr (no xys width height linewidt op color dashing)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-26 no (car xys) (second xys) width height linewidt op 
				  color dashing))


;;; $@6k7AEI$j$D$V$7$NA*Br(J
(defun point-region-selection-fill (event-x event-y xy width height 
									   &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
			 (ignore args))
  (let* ((left (car xy))
		 (bottom (second xy))
		 (right (+ left width))
		 (top (+ bottom height)))
	(if (and (>= event-x left)
			 (>= right event-x)
			 (>= event-y bottom)
			 (>= top event-y))
		T
	  NIL)
	))

(defun yy-protocol-28-pr (no xys width height op color pattern)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-28 no (car xys) (second xys) 
				  width height op color pattern))


;;; $@@^$l@~$NA*Br(J
(defun point-polyline-selection (event-x event-y xy line-width &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore args))
  (let ((ret-flg nil))
	(do ((xy-list xy (cddr xy-list)))
		((= (length xy-list) 2))
		(when (point-line-selection event-x event-y xy-list line-width)
			  (setf ret-flg T)
			  (return))
		)
	ret-flg))


;;; $@B?3Q7A$NOH$NA*Br(J
(defun point-polygon-selection (event-x event-y xy line-width &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore args)
		   (integer event-x event-y line-width)
		   (cons xy))
  (let ((new-xy (append (copy-seq xy) (list (car xy) (second xy)))))
	(do ((xys new-xy (cddr xys)))
		((= (length xys) 2))
		(if (point-line-selection event-x event-y
								  xys line-width event-x event-y)
					  (return T)))
				 
	))

;;; $@M?$($i$l$?@~J,$,M?$($i$l$?E@$h$j(J
;;; $@:BI8>e(JY$@<4J}8~$KBg$-$$$H$-$O(JT$@$rJV$9(J
;;; x y $@$O!"E@$N0LCV(J
(defun line-upper-pointp (x y katamuki seppen)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (integer x y)
		   (float seppen))
  (if (eq katamuki :none)
	  nil
	(if (>= (+ (* katamuki x) seppen) (float y))
		T
	  nil))
  )

;;; $@M?$($i$l$?@~J,$NHO0O$KM?$($i$l$?E@$H$N(J
;;; $@8rE@$,@~J,$NHO0O$K$"$k$+D4$Y$k(J
(defun line-point-interp (x y y1 y2 katamuki seppen)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (integer x y y1 y2)
		   (float seppen))
  (if (eq katamuki :none)
	  nil
	(let ((new-y (+ (* katamuki x) seppen)))
	  (if (= katamuki 0.0)
		  (if (= (float y) seppen)
			  T
			NIL)
		(if (and (>= new-y (float (min y1 y2)))
				 (>= (float (max y1 y2)) new-y))
			T
		  nil))
	   ))
  )

;;; $@B?3Q7A$NEI$j$D$V$7$NA*Br(J
(defun point-polygon-selection-fill (event-x event-y xy &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore args)
		   (integer event-x event-y)
		   (cons xy))
  (let ((new-xy (append (copy-seq xy) (list (car xy) (second xy))))
		(katamuki 0.0)
		(seppen 0.0)
		(setten 0))

	(do ((xys new-xy (cddr xys)))
		   ((= (length xys) 2))
		   (setf katamuki 
				 (if (zerop (- (third xys) (car xys)))
					 :none
				   (float (/ (- (fourth xys) (second xys))
							 (- (third xys) (car xys))))
				   )
				 seppen (if (eq katamuki :none)
							(float (car xys))
						  (- (float (second xys)) (* katamuki (car xys)))))
		   (if (line-upper-pointp event-x event-y katamuki seppen)
			   (if (line-point-interp event-x event-y (second xys)
									  (fourth xys) katamuki seppen)
				   (incf setten))
			   )
		   )
	(if (oddp setten)
		   T
	  nil))
  )

;;; $@8L$^$?$O!"@p7?$NA*Br(J
(defun arc-point-selection (center-x center-y start-a end-a event-x event-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (integer center-x center-y start-a end-a event-x event-y))
  (let* ((new-x (- event-x center-x))
		 (new-y (- event-y center-y))
;		 (new-end-angle end-a)
		 (kakudo (angle-from-axsis-top new-x new-y))
		 (start-angle (float (* (/ start-a 64 180) pi)))
		 (end-angle (float (* (/ end-a 64 180) pi))))
#|
     ;;; $@3QEY$ND4@0(J
	(if (> start-angle end-angle)
		(setf end-angle (+ (* 2 pi) end-angle)))

	(if (or (and (>= kakudo start-angle)
				 (>= end-angle kakudo))
			(and (<= kakudo start-angle)
				 (<= kakudo end-angle)
				 (> start-angle new-end-angle)
				 (<= kakudo new-end-angle)))
		T
	  nil)
|#
    (if (<= start-angle kakudo end-angle)
		T
	  (if (> start-angle end-angle) ;; $@=*N;3QEY$N$[$&$,>.$5$$(J
		  (if (or (<= start-angle kakudo (* 2 pi))
				  (<= 0.0 kakudo end-angle))
			  T
			nil)
		nil)
	  )

	))

;;; $@BJ1_5Z$SBJ1_8L$N8!:w4X?t(J
(defun point-ellipse-selection-p (event-x event-y xys x-hankei y-hankei
										 st-a end-a line-width &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore args)
		   (integer event-x event-y x-hankei y-hankei t-a end-a line-width)
		   (cons xys))
   (let* ((center-x (car xys))
		  (center-y (second xys))
		  (dx (- event-x center-x))
		  (dy (- event-y center-y))
		  (x-h (float (/ x-hankei 2)))
		  (y-h (float (/ y-hankei 2)))
		  (dis (sqrt (+ (* dx dx) (* dy dy))))
		  (rr (float (/ (* x-h y-h dis) 
						(sqrt (+ (* y-h y-h dx dx)
						  (* x-h x-h dy dy))))))
		  (new-width (/ line-width 2)))

;(format t "rr:~a dis:~a  x-hankei:~a y-hankei:~a ~%" rr dis x-hankei y-hankei)

		 (if (and (<= (- rr new-width) dis)
				  (>= (+ rr new-width) dis))
			 (if (not (and (= st-a 0) (= end-a 23040)))
				 (if (arc-point-selection 
					  center-x center-y st-a end-a event-x event-y)
					 T
				   nil)
			   T)
		   nil)
		 ))

(defun yy-protocol-41-pr (no xys width height theta1 theta2 lwidth op 
							 color dashing)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-41 no (car xys) (second xys)
				  width height theta1 theta2 lwidth op color dashing))



;;; $@EI$j$D$V$7BJ1_5Z$SBJ1_8L$N8!:w4X?t(J
(defun point-ellipse-selection-fill (event-x event-y xys x-hankei y-hankei
									 st-a end-a &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore args))
   (let* ((center-x (car xys))
		  (center-y (second xys))
		  (dx (- event-x center-x))
		  (dy (- event-y center-y))
		  (x-h (float (/ x-hankei 2)))
		  (y-h (float (/ y-hankei 2)))
		  (dis (sqrt (+ (* dx dx) (* dy dy))))
		  (rr (float (/ (* x-h y-h dis) 
						(sqrt (+ (* y-h y-h dx dx)
								 (* x-h x-h dy dy)))))))
	 	 (if (>= rr dis)
			 (if (not (and (= st-a 0) (= end-a 23040)))
				 (if (arc-point-selection 
					  center-x center-y st-a end-a event-x event-y)
					 T
				   nil)
			   T)
		   nil)
		 ))


(defun yy-protocol-42-pr (no xys width height theta1 theta2 op color pattern
							 arc_mode)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-42 no (car xys) (second xys)
				  width height theta1 theta2 op color pattern arc_mode))

  
;;; $@1_OH$N8!:w4X?t(J
(defun point-circle-selection (event-x event-y xys hankei
										 line-width &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore args))
   (let* ((max-hankei (+ hankei
                         (float (/ line-width 2))))
          (min-hankei (- hankei
                         (float (/ line-width 2))))
          (kyori (sqrt
                  (+ (* (- (car xys) event-x)
                        (- (car xys) event-x))
                     (* (- (second xys) event-y)
                        (- (second xys) event-y))))))

	 (if (and (<= min-hankei kyori)
			  (>= max-hankei kyori))
		 T
	   nil)))

(defun yy-protocol-22-pr (no xys radius width op color dashing)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-22 no (car xys) (second xys)
				   radius width op color dashing))



;;; $@1_8L$NOH$NA*Br4X?t(J 
(defun point-arc-selection (event-x event-y xys hankei
							   st-a end-a line-width &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore args))
  (if (point-circle-selection event-x event-y xys hankei line-width)
	  (if (arc-point-selection 
		   (car xys) (second xys) st-a end-a event-x event-y)
		  T
		nil)
	nil))

(defun yy-protocol-25-pr (no xys radius theta1 theta2 width op color dashing)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-25 no (car xys) (second xys)
				  radius theta1 theta2 width op color dashing))



;;; $@EI$j$D$V$71_$N8!:w4X?t(J
(defun point-fill-circle-selection (event-x event-y xys hankei
										 &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore args))
  (let ((kyori (sqrt
				(+ (* (- (car xys) event-x)
					  (- (car xys) event-x))
				   (* (- (second xys) event-y)
					  (- (second xys) event-y))))))

	 (if (>= hankei kyori)
		 T
	   nil)))


(defun yy-protocol-29-pr (no xys radius op color pattern)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-29 no (car xys) (second xys) radius op color pattern))


;;; $@EI$j$D$V$71_8L$NA*Br4X?t(J 
(defun point-fill-arc-selection (event-x event-y xys hankei
								 st-a end-a &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore args))
  (if (point-fill-circle-selection event-x event-y xys hankei)
	  (if (arc-point-selection 
		   (car xys) (second xys) st-a end-a event-x event-y)
		  T
		nil)
	nil))

(defun yy-protocol-30-pr (no xys radius theta1 theta2 op color 
							 pattern a-moded)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-30 no (car xys) (second xys)
				  radius theta1 theta2 op color pattern a-moded))


;;; $@2#=q$-J8;zNs$NA*Br4X?t(J
(defun point-normal-string-selection (event-x event-y xys 
											  op color-no font-no string w)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore op color-no font-no string))
  (point-line-selection event-x event-y xys w))


(defun yy-protocol-31-pr (no xys  op color-no font-no string &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore args))
  (yy-protocol-31 no (car xys) (second xys)
				  op color-no font-no string))


;;; $@<P$a=q$-MQJ8;zNs$NA*Br4X?t(J
(defun point-angle-string-selection (event-x event-y xys 
									 op color-no font-no xx yy theta string w)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore op color-no font-no xx yy theta string))
  (point-line-selection event-x event-y xys w))

(defun yy-protocol-44-pr (no xys op color-no font-no xx yy theta 
							 string &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore args))
  (yy-protocol-44 no (car xys) (second xys)
				  op color-no font-no xx yy theta string))


;;; $@<P$a=q$-MQJ8;zNs$NA*Br4X?t(J
(defun point-tate-string-selection (event-x event-y xys 
									 op color-no font-no string w)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore op color-no font-no string))
  (point-line-selection event-x event-y xys w))

(defun yy-protocol-43-pr (no xys op color-no font-no string &rest args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore args))
  (yy-protocol-43 no (car xys) (second xys)
				  op color-no font-no string))


;;; $@%W%l%<%s%F!<%7%g%sMQ$N:BI8$KJQ99$9$k(J
(defun make-new-point-for-present (point-list left bottom wxs wys)
  (declare 
   #-CMU
   (inline decf cddr car second)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
	
  (do ((xy point-list (cddr xy)))
	  ((null xy))
	  (setf (car xy) (- (+ (car xy) wxs) left)
			(second xy) (- (+ (second xy) wys) bottom)))

  point-list)

;;; $@%W%l%<%s%F!<%7%g%s$N%F%j%H%j$,@8@.$5$l$?8e$G!"(J
;;; $@IA2h4X?t$r8F$S=P$9(J
;;; $@$3$N4X?t$O!"%F%j%H%j$N@8@.$N8e(J
(defun  first-draw-in-presentation (root-parent wxs wys)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (draw-method-list (tno presentation-territory-no)) root-parent
   (with-region-slots 
	(left bottom) root-parent
	(dolist
	  (item draw-method-list)
	  (setf (car (second (second item)))
		(make-new-point-for-present (car (second (second item)))
					    left bottom  wxs wys)
		(car (second (car item))) tno)
	  (apply (car (car item)) (second (car item))))
     )))


(defun until-root-presentation (present)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (slot-value present `parent-presentation)
	  (until-root-presentation
	   (slot-value present 'parent-presentation))
	present))

;;;;;;;;; Internal function ;;;;;;;;;;;;;;;;;;;;

;;; $@%W%l%<%s%H$9$k%j!<%8%g%s$N=i4|2=(J
(defun  init-present-region (parent wx wy)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (t parent)
		   (integer wx wy))

  (when (slot-value parent 'draw-method-list)
		(shift-region-position parent wx wy))
  
  (dolist (child (slot-value parent 'child-present-list))
	  (if (slot-value child 'child-present-list)
	      (region-union-no-copy
	       parent
	       (init-present-region child wx wy))
	    (when (slot-value child 'draw-method-list)
		  (region-union-no-copy
		   parent
		   (shift-region-position child wx wy)))
	    )
	  )
  parent)

(defun make-splite-territory (ins stream)
  ;; $@%W%l%<%s%F!<%7%g%s$N%j!<%8%g%s$N%7%U%H(J
;  (shift-region-position ins (world-x-start stream)
	;					 (world-y-start stream))
  (with-region-slots
    (left bottom width height) ins

    (if (= width 0) 
	(setf width 1))

    (if (= height 0)
	(setf height 2))

	(if (or (< width 0) (< height 0))
		(setf left 0 bottom 0 width 1 height 1))

    (setf (presentation-territory-no ins)
	  (with-object-make-territory  
	    ins :x left :y bottom 
	    :width width :height height
	    :parent (parent-territory-no stream)
	    :drawable T :transparent T))
    )
  ;; $@%$%Y%s%H%^%9%/$N0l;~Dd;_(J
  (yy-protocol-72 (presentation-territory-no ins) 0))

(defun set-up-presentation-object (ins)
  (declare (special *mouse-right-1* *mouse-left-1* *mouse-in* *mouse-out*))
  (setf
    ;; $@0lDj;~4V$NDd;_$G5/F0$9$k%a%=%C%I(J
;    (right-button-down-1-method ins) 'presentation-kakunin
   (mouse-cursor-wait-method  ins) 'presentation-kakunin
   (left-button-down-1-method ins)  'presentation-ok
   (mouse-cursor-in-method ins) 'presentation-in
   (mouse-cursor-out-method ins) 'presentation-out
   (event-mask ins) (logior  *mouse-right-1* *mouse-left-1*
							 *mouse-in* *mouse-out*)
   (get 'presentation-kakunin 'single-process) t
   (get 'presentation-ok 'single-process) t
   (get 'presentation-in 'single-process) t
   (get 'presentation-out 'single-process) t))

;;; $@JQ7AA0$N(Jroot $@$N(Jleft bottom $@$r5-21(J
(defun store-old-left-bottom (ob stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
  	       (ignore ob stream))
  )
#|
  (let ((root (until-root-presentation ob)))
	(with-slots 
	 ((old old-root-left-bottom)) stream
	 (with-region-slots 
	  (left bottom) root
	  (setf (car old) left
			(second old) bottom) 
			(slot-value root 'work-draw-method) 
			(slot-value root 'draw-method-list)))))
|#

;;; $@?^7A$NJQ99A0=hM}(J
(defun before-reshape (ob stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  ;; $@IA2h%j!<%8%g%s$N=i4|2=!!(J
  (with-region-slots
	 (left bottom right top) ob
	 (setf left 99999 bottom 99999
		   right -99999 top -99999))

  (setf (slot-value stream 'drawing-region) ob
	(slot-value stream 'presentation-instance) ob
	(slot-value ob 'draw-method-list) nil)
  )

;;; $@%W%l%<%s%H$5$l$F$$$k3($NJQ998e$N(J
;;; $@%j!<%8%g%s$N@_Dj(J
(defun shape-all-region (parent)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (dolist (child (slot-value parent 'child-present-list))
		  (if (slot-value child 'child-present-list)
			  (region-union-no-copy
			   parent
			   (shape-all-region child))
			(when (slot-value child 'draw-method-list)
				  (region-union-no-copy
				   parent child))
			)
		  )
  parent)


;;; $@%W%l%<%s%F!<%7%g%sMQ$N:BI8$KJQ99$9$k(J
(defun change-point-for-present (point-list sax say)
  (declare 
   #-CMU
   (inline decf cddr car second)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (do ((xy point-list (cddr xy)))
	  ((null xy))
	  (setf (car xy) (- (car xy) sax)
			(second xy) (- (second xy) say)))
  point-list)


;;; $@:FI=<(@_Dj(J
;;; $@%k!<%H$+$iDs6!$5$F$$$kA4$F$NIA2h$KBP$7$F9T$J$&(J
(defun change-draw-all (root left bottom tno wxs wys)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (make-draw-method-after-shape root left bottom tno wxs wys))


;;; $@:FI=<($N$?$a$N@_Dj(J
(defun make-draw-method-after-shape (root left bottom tno wxs wys)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (draw-method-list) root
	 (dolist (item draw-method-list)
	     (setf (car (second (second item)))
	 	       (make-new-point-for-present 
			   	      (car (second (second item)))
				       left bottom wxs wys)
   			    (car (second (car item))) tno))
   	))

;; $@:FI=<((J   	
(defun redraw-presentation (root)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
  	(draw-method-list) root
	(dolist (item draw-method-list)
		 (apply (car (car item)) (second (car item))))
		 ))

(defun after-reshape (ob stream &optional (redraw t))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *total-send* *total-put-byte*))
  (let* ((root (until-root-presentation ob))
	 (tno (slot-value root 'presentation-territory-no)))

	(with-slots
	 ((wxs world-x-start) (wys world-y-start)) stream
	 (shift-region-position root wxs wys)
	 ;; $@Bg$-$5$N@_Dj(J
	 (shape-all-region root)
	 ;; $@:FIA2h(J
	 (when 	  
	  redraw
	  ;; $@IA2h$NJQ99(J
	  (with-region-slots
	   (left bottom width height) root
		(make-draw-method-after-shape root left bottom tno wxs wys)
	   (with-protocol
		(setf *total-send* T
			  *total-put-byte* 0)
		(if (slot-value root 'draw-method-list)
			(yy-protocol-4 tno left bottom width height 0 0)
		  (yy-protocol-4 tno 0 0 1 1 0 0))
		(redraw-presentation root)
		(total-protocol-send-no-check)
		)))
	 )))

;;; 
(defun collect-and-int-all (parent)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (dolist 
   (item (collect-all-children parent))
   (with-region-slots
	(left bottom right top) item
	(setf left 99999 bottom 99999	right -99999 top -99999))

   (setf (slot-value item 'draw-method-list) nil)))


;;; $@?FA4%j%7%'!<%W$N=i4|2=(J
(defun shape-all-init (parent stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (collect-and-int-all parent)
  (setf (slot-value stream 'presentation-instance) parent
	(slot-value stream 'drawing-region) parent
	(slot-value stream 'present-redraw-all) T)
  )

;;; $@?FA4%j%7%'!<%W$N=*N;=hM}(J
(defun shape-all-end (parent stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *total-send* *total-put-byte*))
  (with-slots 
   (world-x-start world-y-start) stream
   (init-present-region parent world-x-start world-y-start)

   (with-region-slots
	(left bottom width height) parent

	(with-protocol
	 (setf *total-send* T
		   *total-put-byte* 0)
	 (if (slot-value parent 'draw-method-list)
		 (yy-protocol-4 (presentation-territory-no parent)
						left bottom width height 0 0)
	   (yy-protocol-4 (presentation-territory-no parent)
					  0 0 1 1 0 0))
	 (first-draw-in-presentation parent world-x-start world-y-start)
	 (total-protocol-send-no-check)
	 ))))

(defun calcu-min-max (region ret)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (t region ret))
  (with-region-slots
   (left bottom right top) region
   (if (<= left (car ret))
	   (setf (car ret) left))
   (if (<= bottom (second ret))
	   (setf (second ret) bottom))
   (if (>= right (third ret))
	   (setf (third ret) right))
   (if (>= top (fourth ret))
	   (setf (fourth ret) top))))

(defun child-max-region (regions ret)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (cond
   ((listp regions)
	(dolist 
	 (item regions)
	 (when (slot-value item 'child-present-list)
		   (child-max-region (slot-value item 'child-present-list) ret))
	 (calcu-min-max item ret)))
	(t
	 (calcu-min-max regions ret)))
  )

(defun max-size-region (root-region)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((ret (list 99999 999999 -999999 -9999999)))

	(child-max-region (slot-value root-region 'child-present-list) ret)

	(calcu-min-max root-region ret)

	(values (car ret) (second ret) (- (third ret) (car ret)) 
			(- (fourth ret) (second ret))))
  )


;;; End of File


