;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; edit-text-macro.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.4 92/04/21 by t.kosaka

(in-package :yy)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%&%#%s%I%&>e$NJ8;zNsJT=8MQ$N%^%/%m(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; object-list $@$N9=B$(J 
;;; (string-list x y direction              ;; $@>o$KMxMQ$9$k(J 
;;;    (line-feed font left-margin right-margin  ;; $@%F%-%9%H4D6-(J
;;;       top-margin bottom-margin truncate-width trucate-height)
;;;    (matrix cordinate world-height x-scale y-scale)   ;; $@:BI87O4D6-(J
;;;  color                       
;;;  region1 region2          ;; $@%j!<%8%g%s(J
;;;  start-x start-y moji-no stream real-x real-y)

;;; $@%0%i%U%#%C%/%H%i%s%9%U%)!<%`%^%H%j%C%/%9$NAm>N4X?t(J (XY $@MQ(J)
;;; $@CM$r(Jtruncate$@$9$k(J
(defgeneric transform-by-matrix-xy-int (x y matrix)
  (:method ((x integer) (y integer) 
			(matrix graphic-transform-matrix-exec))
   (let* ((list (step-slots matrix))
		  (x-time (matrix-x-time matrix))
		  (y-time (matrix-y-time matrix))
		  (new-x (* (+ (* x (car list))
					   (* y (second list)))
					x-time))
		  (new-y (* (+ (* x (third list))
					   (* y (fourth list)))
					y-time)))
	 (values (round new-x) (round new-y))
#|
		   (x-scale-f (* x-time (car list)))
		   (y-scale-f (* y-time (third list))))
	  (format t "stx - x: ~a x: ~a y: ~a ~%" (- x stx)
			  (+ new-x  (* x-scale-f (- x stx)))
			  (+ new-y  (* y-scale-f (- x stx))))
	  (values (round (+ new-x (* x-scale-f (- x stx))))
			  (round (+ new-y (* y-scale-f (- x stx)))))
|#
	  )
	)
  (:method 
   ((x integer) (y integer) 
	(matrix graphic-transform-matrix-non))
   (let ((new-x (round x)) (new-y (round y)))
	 (values new-x new-y)))
  )


;;; $@:BI87OJQ49$H2sE>9TNs$r2C$($?(J $@JT=8%*%V%8%'%/%HMQ(J
(defmacro with-translate-transform-xy-edit  ((new-x new-y) object x y
                                       &rest body)
  `(let ((,new-x 0)
		 (,new-y 0))
     (multiple-value-setq 
	  (,new-x ,new-y)
	  (transform-by-matrix-xy-int
	   ,x ,y 
	   (car (sixth ,object))))
	 (setf ,new-y (translate-coordinate-y 
				   (second (sixth ,object))
				   (truncate ,new-y) (third (sixth ,object)))
		   ,new-x (truncate ,new-x))
	   ,@body))


;;; $@:BI87OJQ49$r2C$($?(J $@JT=8%*%V%8%'%/%HMQ(J
(defmacro translate-xy-edit  (y object)
  `(translate-coordinate-y 
	(second (sixth ,object))
	(truncate ,y) (third (sixth ,object))))

;;; $@:BI8JQ499TNs$N;03Q4X?tCM$H!"G\N($G$+$1;;$r$9$k%9%1!<%k$r%;%C%H$9$k(J
(defgeneric initialize-object-matrix (matrix object)
  (:method ((matrix graphic-transform-matrix-exec)
			object)
		   (let* ((item-list (step-slots matrix))
				  (x-scale-f (* (matrix-x-time matrix) (car item-list)))
				  (y-scale-f (* (matrix-y-time matrix) (third item-list))))
			 (setf (sixth object)
				   (append (sixth object)
						   (list x-scale-f y-scale-f)))
			 ))
  (:method ((matrix graphic-transform-matrix-non)
			object)
		   (setf (sixth object) 
				 (append (sixth object)
						 (list 1.0 0.0))))
  )


;;; $@JT=8BP>]$N%U%)%s$H(J
(defmacro edit-font (object)
  `(second (fifth ,object)))

;;; $@JT=8BP>]$NJ8;zNs%j%9%H(J
(defmacro edit-string-list (object)
  `(car ,object))

;;; $@JT=8BP>]$N%+!<%=%k0LCV(JX
(defmacro edit-position-x (object)
  `(second ,object))

;;;$@JT=8BP>]$N%+!<%=%k0LCV(JY
(defmacro edit-position-y (object)
  `(third ,object))

;;; $@JT=8BP>]$NJ8;zJ}8~(J 
(defmacro edit-direction (object)
  `(fourth ,object))

;;; $@JT=8BP>]$N?'%3!<%I(J
(defmacro edit-color (object)
  `(seventh ,object))

;;; $@JT=8BP>]$N:n6H%j!<%8%g%s(J1
(defmacro edit-region1 (object)
  `(eighth ,object))

;;; $@JT=8BP>]$N:n6H%j!<%8%g%s(J2
(defmacro edit-region2 (object)
  `(ninth ,object))

;;; $@JT=8BP>]$N3+;O%+!<%=%k0LCV(JX
(defmacro edit-start-x (object)
  `(tenth ,object))

;;;$@JT=8BP>]$N3+;O%+!<%=%k0LCV(JY
(defmacro edit-start-y (object)
  `(nth 10 ,object))

;;;$@JT=8BP>]$N2sE>9TNs(J
(defmacro edit-matrix (object)
  `(car (sixth ,object)))

;;;$@JT=8BP>]$N8=:_$NJ8;z$N0LCV(J
(defmacro edit-index (object)
  `(nth 11 ,object))

;;;$@JT=8BP>]$N%9%H%j!<%`(J
(defmacro edit-stream (object)
  `(nth 12 ,object))

;;; $@2sE>9TNs$r$+$1$?0LCV(J(X)
(defmacro real-char-x (object)
  `(nth 13 ,object))

;;; $@2sE>9TNs$r$+$1$?0LCV(J(Y)
(defmacro real-char-y (object)
  `(nth 14 ,object))

;;; $@JT=8%*%V%8%'%/%H$N%F%-%9%HI=<(>pJs$NJ,2r(J
(defun replace-atom-state-edit (atom args ob)
  (dolist
   (one-item args)
   (if (listp one-item)
       (case (second one-item)
			 (line-feed
			  (if (eq atom (car one-item))
				  (return (list 'car ob))))
			 (font
			  (if (eq atom (car one-item))
				  (return (list 'second ob))))
			 (left-margin
			  (if (eq atom (car one-item))
				  (return (list 'third ob))))
			 (right-margin
			  (if (eq atom (car one-item))
				  (return (list 'fourth ob))))
			 (top-margin
			  (if (eq atom (car one-item))
				  (return (list 'fifth ob))))
			 (bottom-margin
			  (if (eq atom (car one-item))
				  (return (list 'sixth ob))))
			 (truncate-width
			  (if (eq atom (car one-item))
				  (return (list 'seventh ob))))
			 (truncate-height
			  (if (eq atom (car one-item))
				  (return (list 'eighth ob))))
			 )
	 (case one-item
		   (line-feed
			(if (eq atom one-item)
				(return (list 'car ob))))
		   (font
			(if (eq atom one-item)
				(return (list 'second ob))))
		   (left-margin
			(if (eq atom one-item)
				(return (list 'third ob))))
		   (right-margin
			(if (eq atom one-item)
				(return (list 'fourth ob))))
		   (top-margin
			(if (eq atom one-item)
				(return (list 'fifth ob))))
		   (bottom-margin
			(if (eq atom one-item)
				(return (list 'sixth ob))))
		   (truncate-width
			(if (eq atom one-item)
				(return (list 'seventh ob))))
		   (truncate-height
			(if (eq atom one-item)
				(return (list 'eighth ob))))
		  ))))

(defun until-atom-state-edit (atom ob args)
  (if (listp atom)
      (mapcar #'(lambda (x) (until-atom-state-edit x ob args)) atom)
    (let ((ret (replace-atom-state-edit atom args ob)))
      (if ret
	  ret
	atom))))

;;; (stream x y direction              ;; $@>o$KMxMQ$9$k(J 
;;;    (line-feed font left-margin right-margin  ;; $@%F%-%9%H4D6-(J
;;;       top-margin bottom-margin truncate-width trucate-height)
;;; $@JT=8%*%V%8%'%/%H$N%F%-%9%HI=<(4D6-$N<h$j=P$7(J
(defmacro with-edit-slots ((&rest args) ob &body body)
  (let ((internal (gentemp)))
    `(let ((,internal (fifth ,ob)))
       ,.(mapcar #'(lambda (x) (until-atom-state-edit x internal args))
		 body))))




