;;; -*- Mode: LISP; Package: YY-GEO; Syntax: Common-Lisp; Base: 10 -*-

(in-package :yy-geo)


;;; Modify Model Object Function

(defgeneric extrude (face vector)
  #-CMU
  (declare (values 3d-Object))
  )

(defgeneric collapse (face)
  #-CMU
  (declare (values 3d-Object))
  )

(defgeneric lift-edge (face edge vector)
  #-CMU
  (declare (values new-edge))
  )

;;; Move 
(defgeneric move (object vector-or-matrix &optional redraw-edge-only)
  #-CMU
  (declare (values Object))
  )

(defgeneric move-vertex (vertex vector-or-matrix)
  #-CMU
  (declare (values vertex))
  )

(defgeneric add-depend-view-object (view-vertex view-object)
  )
(defgeneric redraw-viewed-object (viewed-object)
  )

(defgeneric reset-already-redraw (viewed-object)
  )
(defgeneric redraw-vertex-with-depends (view-vertex &optional edge-only)
  )
(defgeneric redraw-with-depends (viewed-object &optional edge-only)
  )
(defgeneric get-view-object (view object)
  )
(defgeneric delete-view-object (view object)
  )


;;; Function Inteface for get object
(defgeneric get-body (stream sequence-number)
  #-CMU
  (declare (values body))
  )

(defgeneric get-polyhedron (stream sequence-number)
  #-CMU
  (declare (values polyhedron))
  )

(defgeneric get-object (polyhedron type sequence-number)
  #-CMU
  (declare (values object))
  )

(defgeneric accept-object-from-view (stream type)
  #-CMU
  (declare (values object))
  )


;;; Modify Object

(defgeneric changed-object (object)
  )

(defgeneric remove-object (object)
  )

;;;(defgeneric add-view
;;;(defgeneric add-cube
(defgeneric kill (geometory object))


;;; GEOMETORY TOP WINDOW

(defgeneric display (geometory object-or-view))
(defgeneric erase (geometory object-or-view))