;;; -*- Mode: LISP; Package: YY-GEO; Syntax: Common-Lisp; Base: 10 -*-

(in-package :yy-geo)

(defvar *geo-switchs*
	'((0 0 "Delete"		define-delete-object-methods  *r-color*)
	  (1 0 "Visible"	define-change-visible-methods *g-color*)
	  (2 0 "Clear"  	define-clear-methods)
	  (3 0 "Kill View"      define-kill-view-methods      *r-color*)
	  (3 1 "Add View"       define-add-view-methods       *b-color*)
	  (0 1 "Cube"		define-add-cube-methods       *b-color*)
	  (1 1 "Cylinder"       define-add-cylinder-methods   *m-color*)
	  (2 1 "Sphere"		define-add-sphere-methods     *m-color*)
	  ))

(defun define-add-cube-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'add-cube-internal
	  (yy::button2-method switch)   'add-cube-internal)))

(defun define-add-cylinder-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'add-cylinder-internal
	  (yy::button2-method switch)   'add-cylinder-internal)))

(defun define-add-sphere-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'add-sphere-internal
	  (yy::button2-method switch)   'add-sphere-internal)))

(defun define-delete-object-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'delete-object-internal
	  (yy::button2-method switch)   'delete-object-internal)))

(defun define-change-visible-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'change-visible-internal
	  (yy::button2-method switch)   'change-visible-internal)))

(defun define-add-view-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'add-view-internal
	  (yy::button2-method switch)   'add-view-internal)))

(defun define-kill-view-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'kill-view-internal
	  (yy::button2-method switch)   'kill-view-internal)))


(defmethod add-cube-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-switch-default-look (switch)
    (let ((bt (yy::mouse-state-button-state mouse-state))
	  (size 100))
      (when (not (zerop (logand yy::*mouse-left-1* bt)))
	(setf size (* size 1.0)))
      (when (not (zerop (logand yy::*mouse-middle-1* bt)))
	(setf size (* size 1.5)))
      (when (not (zerop (logand yy::*mouse-right-1* bt)))
	(setf size (* size 2.0)))
      (when (or (not (zerop (logand yy::*control* bt)))
		(not (zerop (logand yy::*meta*    bt)))
		(not (zerop (logand yy::*shift*   bt))))
	(setf size (/ size)))

      (when (not (zerop (logand yy::*mouse-left-2* bt)))
	(setf size (/ size 10.0)))
      (when (not (zerop (logand yy::*mouse-middle-2* bt)))
	(setf size (/ size 5.0)))
      (when (not (zerop (logand yy::*mouse-right-2* bt)))
	(setf size (/ size 2.0)))
      (yy::draw-prompt (format nil "Make Cube Size is ~a" SIZE))
      (with-slots ((window yy::object-parent)) switch
	(with-slots (superior) window
	  (add-cube superior size))))))

(defmethod add-cylinder-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-switch-default-look (switch)
    (let ((bt (yy::mouse-state-button-state mouse-state))
	  (size 100))
      (when (not (zerop (logand yy::*mouse-left-1* bt)))
	(setf size (* size 1.0)))
      (when (not (zerop (logand yy::*mouse-middle-1* bt)))
	(setf size (* size 1.5)))
      (when (not (zerop (logand yy::*mouse-right-1* bt)))
	(setf size (* size 2.0)))
      (when (or (not (zerop (logand yy::*control* bt)))
		(not (zerop (logand yy::*meta*    bt)))
		(not (zerop (logand yy::*shift*   bt))))
	(setf size (/ size)))

      (when (not (zerop (logand yy::*mouse-left-2* bt)))
	(setf size (/ size 10.0)))
      (when (not (zerop (logand yy::*mouse-middle-2* bt)))
	(setf size (/ size 5.0)))
      (when (not (zerop (logand yy::*mouse-right-2* bt)))
	(setf size (/ size 2.0)))
      (yy::draw-prompt (format nil "Make Cylinder Size is ~a" SIZE))
      (with-slots ((window yy::object-parent)) switch
	(with-slots (superior) window
	  (add-cylinder superior size))))))

(defmethod add-sphere-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-switch-default-look (switch)
    (let ((bt (yy::mouse-state-button-state mouse-state))
	  (size 100))
      (when (not (zerop (logand yy::*mouse-left-1* bt)))
	(setf size (* size 1.0)))
      (when (not (zerop (logand yy::*mouse-middle-1* bt)))
	(setf size (* size 1.5)))
      (when (not (zerop (logand yy::*mouse-right-1* bt)))
	(setf size (* size 2.0)))
      (when (or (not (zerop (logand yy::*control* bt)))
		(not (zerop (logand yy::*meta*    bt)))
		(not (zerop (logand yy::*shift*   bt))))
	(setf size (/ size)))

      (when (not (zerop (logand yy::*mouse-left-2* bt)))
	(setf size (/ size 10.0)))
      (when (not (zerop (logand yy::*mouse-middle-2* bt)))
	(setf size (/ size 5.0)))
      (when (not (zerop (logand yy::*mouse-right-2* bt)))
	(setf size (/ size 2.0)))
      (yy::draw-prompt (format nil "Make Sphere Size is ~a" SIZE))
      (with-slots ((window yy::object-parent)) switch
	(with-slots (superior) window
	  (add-sphere superior size))))))

(defmethod delete-object-internal ((switch switch-with-title) state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore state))
  (with-switch-default-look (switch)
    (with-slots ((window yy::object-parent)) switch
      (with-slots (superior) window
	(yy::draw-prompt "Delete Object")
	(let ((object (yy::accept 'object window)))
	  (when object
	    (kill superior object)
	    (yy::draw-prompt (format nil "Delete ~a" object))))))))

(defmethod change-visible-internal ((switch switch-with-title) state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore state))
  (with-switch-default-look (switch)
    (with-slots ((window yy::object-parent)) switch
      (with-slots (superior) window
	(yy::draw-prompt "Change Visible")
	(let ((object (yy::accept 'object window)))
	  (when object
	    (with-slots (visible-p view-objects) object
	      (setf visible-p (null visible-p))
	      (dolist (view-object view-objects)
		(redraw-view-solid view-object visible-p))
	      (change-display superior object) 
	      (yy::draw-prompt (format nil "Change Visible ~a" visible-p)))))))))


(defmethod add-view-internal ((switch switch-with-title) state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore state))
  (with-switch-default-look (switch)
    (with-slots ((window yy::object-parent)) switch
      (yy::draw-prompt "Creating New View")
      (with-slots (superior) window
	(let ((View (add-view superior)))
	  (yy::draw-prompt (format nil "add View ~a" View)))))))

(defmethod kill-view-internal ((switch switch-with-title) state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore state))
  (with-switch-default-look (switch)
    (with-slots ((window yy::object-parent)) switch
      (yy::draw-prompt "Killing View")
      (let ((view (yy::accept 'viewer window)))
	(when view
	  (with-slots (superior) window
	    (kill superior view))
	  (yy::draw-prompt (format nil "kill View ~a" view)))))))
